"""
Paths and version constants for ovirt-log-collector
"""

import os

PACKAGE_NAME = "ovirt-log-collector"
PACKAGE_VERSION = "3.4.5"

FILE_PG_PASS = "/usr/local/etc/ovirt-engine/.pgpass"
ENGINE_DEFAULTS = "/usr/local/share/conf/engine.conf.defaults"
ENGINE_CONF = "/usr/local/etc/ovirt-engine/engine.conf"

ENGINE_SERVICE_DEFAULTS = os.path.join(
    '/usr/local/share',
    'ovirt-engine',
    'services',
    'ovirt-engine',
    'ovirt-engine.conf'
)

ENGINE_DWH_SERVICE_DEFAULTS = os.path.join(
    '/usr/local/share',
    'ovirt-engine-dwh',
    'services',
    'ovirt-engine-dwhd',
    'ovirt-engine-dwhd.conf'
)

DEFAULT_CA_PEM = "/usr/local/etc/pki/ovirt-engine/ca.pem"
DEFAULT_SSH_KEY = "/usr/local/etc/pki/ovirt-engine/keys/engine_id_rsa"
DEFAULT_CONFIGURATION_FILE = "/usr/local/etc/ovirt-engine/logcollector.conf"
DEFAULT_LOG_DIR = os.path.join(
    '/usr/local/var',
    'log',
    'ovirt-engine',
    PACKAGE_NAME,
)
LOG_PREFIX = PACKAGE_NAME
