# Packages names
%global vdsm_name vdsm
%global vdsm_bootstrap vdsm-bootstrap
%global vdsm_reg vdsm-reg

# Required users and groups
%global vdsm_user vdsm
%global vdsm_group kvm
%global qemu_user qemu
%global qemu_group qemu
%global snlk_group sanlock
%global snlk_user sanlock
%global cdrom_group cdrom

# Upstream git release
# % global vdsm_release gf2f6683
# % global vdsm_relvtag .git%{vdsm_release}
# % global vdsm_relttag -%{vdsm_release}

# Fedora official build
%global fedora_koji_build 1
%global with_hooks 1

# Default to skipping autoreconf.  Distros can change just this one line
# (or provide a command-line override) if they backport any patches that
# touch configure.ac or Makefile.am.
%{!?enable_autotools:%define enable_autotools 1}

# Required paths
%if 0%{?fedora} >= 18
%global _polkitdir %{_datadir}/polkit-1/rules.d
%else
%global _polkitdir %{_localstatedir}/lib/polkit-1/localauthority/10-vendor.d
%endif

%if 0%{?fedora} >= 18 || 0%{?rhel} >= 6
%global with_gluster 1
%endif

%if ! 0%{?rhel}
%global with_vhostmd 1
%endif

%if 0%{?fedora} >= 15 || 0%{?rhel} >= 7
%global with_systemd 1
%endif

%if 0%{?fedora} >= 18
%global with_systemd_macros 1
%global with_tmpfiles_macro 1
%endif

Name:           %{vdsm_name}
Version:        4.14.8.1
Release:        0%{?dist}%{?extra_release}
Summary:        Virtual Desktop Server Manager

Group:          Applications/System
License:        GPLv2+
Url:            http://www.ovirt.org/wiki/Vdsm
# The source for this package was pulled from upstream's vcs.
# Use the following commands to generate the tarball:
#  git clone http://gerrit.ovirt.org/p/vdsm
#  cd vdsm
#  git reset --hard {vdsm_release}
#  ./autogen.sh --system
#  make VERSION={version}-{vdsm_release} dist
Source0:        %{vdsm_name}-%{version}%{?vdsm_relttag}.tar.gz

BuildRoot:      %{_tmppath}/%{name}-%{version}-%{release}-root-%(%{__id_u} -n)

BuildRequires: gcc
BuildRequires: python
BuildRequires: python-devel
BuildRequires: python-nose
BuildRequires: python-netaddr
BuildRequires: rpm-build

# BuildRequires needed by the tests during the build
BuildRequires: dosfstools
BuildRequires: psmisc
BuildRequires: python-ethtool
BuildRequires: python-inotify
BuildRequires: python-pthreading
BuildRequires: python-cpopen >= 1.3
BuildRequires: rpm-python
BuildRequires: libnl
BuildRequires: libselinux-python
BuildRequires: libvirt-python
BuildRequires: genisoimage
BuildRequires: openssl
BuildRequires: m2crypto
%ifarch x86_64
BuildRequires: python-dmidecode
%endif
%if 0%{?rhel} == 6
BuildRequires: python-argparse
BuildRequires: python-ordereddict
%endif

# Autotools BuildRequires
%if 0%{?enable_autotools}
BuildRequires: autoconf
BuildRequires: automake
BuildRequires: gettext-devel
BuildRequires: libtool
%endif

%if !0%{?rhel}
BuildRequires: pyflakes
BuildRequires: python-pep8
%endif

%if 0%{?with_systemd}
BuildRequires: systemd-units
%endif

Requires: ethtool
Requires: which
Requires: sudo >= 1.7.3
Requires: logrotate
Requires: rsyslog
Requires: xz
Requires: ntp
Requires: iproute
Requires: python-netaddr
Requires: python-inotify
Requires: python-argparse
Requires: python-cpopen >= 1.3
Requires: python-ethtool >= 0.6-3
Requires: %{name}-python-zombiereaper = %{version}-%{release}
Requires: rpm-python
Requires: nfs-utils
Requires: m2crypto
Requires: libguestfs-tools-c
Requires: libnl
Requires: %{name}-xmlrpc = %{version}-%{release}
Requires: mom >= 0.3.2-3

%ifarch x86_64
Requires: python-dmidecode
Requires: dmidecode
%endif

%if 0%{?rhel} >= 7 || 0%{?fedora} >= 18
Requires: libvirt-daemon >= 1.0.2-1
Requires: libvirt-daemon-config-nwfilter
Requires: libvirt-daemon-driver-network
Requires: libvirt-daemon-driver-nwfilter
Requires: libvirt-daemon-driver-qemu
%else
%if 0%{?rhel}
Requires: libvirt >= 0.10.2-29.el6_5.4
%else
Requires: libvirt >= 1.0.2-1
%endif
%endif
Requires: libvirt-python, libvirt-lock-sanlock, libvirt-client

# iscsi-intiator versions
%if 0%{?rhel}
%if 0%{?rhel} >= 7
Requires: iscsi-initiator-utils
%else
Requires: iscsi-initiator-utils >= 6.2.0.872-15
%endif # rhel 7
%else # fedora
Requires: iscsi-initiator-utils >= 6.2.0.873-3
%endif

Requires: sanlock >= 2.8, sanlock-python

%if 0%{?rhel}
Requires: python-ethtool >= 0.6-3
%if 0%{?rhel} >= 7
ExclusiveArch:  x86_64
Requires: device-mapper-multipath
Requires: e2fsprogs
Requires: fence-agents-all
Requires: lvm2
Requires: python
Requires: policycoreutils-python
Requires: python-pthreading >= 0.1.2
Requires: qemu-kvm
Requires: qemu-img
Requires: selinux-policy-targeted
%else
Requires: python
# Update the qemu-kvm requires when block_stream will be included
Requires: qemu-kvm >= 2:0.12.1.2-2.295.el6_3.4
Requires: qemu-img >= 2:0.12.1.2-2.295.el6_3.4
Requires: device-mapper-multipath >= 0.4.9-52
Requires: e2fsprogs >= 1.41.12-11
Requires: fence-agents
Requires: kernel >= 2.6.32-279.9.1
Requires: initscripts >= 9.03.31-2.el6_3.1
Requires: policycoreutils >= 2.0.83-19.30
Requires: policycoreutils-python >= 2.0.83-19.30
Requires: python-pthreading
Requires: selinux-policy-targeted >= 3.7.19-195.el6_4.13
Requires: lvm2 >= 2.02.95-10.el6_3.2
Requires: logrotate < 3.8.0
%endif
%else
%if 0%{?fedora} >= 19
Requires: python-pthreading >= 0.1.2
Requires: fence-agents-all
Requires: kernel >= 3.11.3-201
%else
Requires: python-pthreading
Requires: fence-agents
Requires: kernel >= 3.6
%endif
# Subprocess and thread bug was found on python 2.7.2
Requires: python >= 2.7.3
Requires: qemu-kvm >= 2:0.15.0-4
Requires: qemu-img >= 2:0.15.0-4
Requires: python-ethtool >= 0.8-1
%if 0%{?fedora} >= 18
Requires: initscripts >= 9.42.2-1
%endif
Requires: device-mapper-multipath >= 0.4.9-18
Requires: e2fsprogs >= 1.41.14
Requires: policycoreutils-python
Requires: sed >= 4.2.1-10
Requires: ed
Requires: lvm2 >= 2.02.95

%if 0%{?fedora} >= 18
%if 0%{?fedora} >= 19
Requires: selinux-policy-targeted >= 3.12.1-71
%else
Requires: selinux-policy-targeted >= 3.11.1-103
%endif
# In order to avoid a policycoreutils bug (rhbz 889698) when selinux is
# disabled we now require the version 2.1.13-55 (or newer) of Fedora.
Requires: policycoreutils >= 2.1.13-55
Requires: systemd >= 197-1.fc18.2
%endif

%endif

# GlusterFS client-side RPMs needed for Gluster SD
%if 0%{?with_gluster}
Requires: glusterfs >= 3.4.2
Requires: glusterfs-cli
Requires: glusterfs-api
Requires: glusterfs-fuse
Requires: glusterfs-rdma
%endif

Requires: psmisc >= 22.6-15
Requires: bridge-utils
Requires: sos
Requires: tree
Requires: dosfstools
Requires: genisoimage
Requires: libselinux-python
Requires: %{name}-python = %{version}-%{release}
Requires: pyparted

Requires(post): /usr/sbin/saslpasswd2

%if 0%{?fedora} && 0%{?fedora} >= 21
Requires(post): hostname
%else
Requires(post): /bin/hostname
%endif

Requires(post): policycoreutils-python
Requires(preun): policycoreutils-python

%description
The VDSM service is required by a Virtualization Manager to manage the
Linux hosts. VDSM manages and monitors the host's storage, memory and
networks as well as virtual machine creation, other host administration
tasks, statistics gathering, and log collection.

%package cli
Summary:        VDSM command line interface
BuildArch:      noarch

Requires: %{name}-python = %{version}-%{release}
Requires: %{name}-xmlrpc = %{version}-%{release}

%description cli
Call VDSM commands from the command line. Used for testing and debugging.

%package xmlrpc
Summary:        VDSM xmlrpc API
BuildArch:      noarch

Requires: %{name}-python = %{version}-%{release}


%description xmlrpc
An XMLRPC interface for interacting with vdsmd. Primary control interface for
ovirt-engine and vdsClient.

%package api
Summary:        VDSM API definition
BuildArch:      noarch

%description api
Provides the VDSM API schema and documentation.

%package jsonrpc
Summary:        VDSM API Server
BuildArch:      noarch

Requires: %{name}-python = %{version}-%{release}
Requires: %{name}-api = %{version}-%{release}
%if 0%{?rhel} == 6
Requires: python-ordereddict
%endif

%description jsonrpc
A Json-based RPC interface that serves as the protocol for libvdsm.

%package yajsonrpc
Summary:        JSON RPC server and client implementation
BuildArch:      noarch

Requires:       python >= 2.6

%description yajsonrpc
A JSON RPC server and client implementation.

%package python-zombiereaper
Summary:        Collects zombie processes automatically
BuildArch:      noarch

Requires:       python >= 2.6

%description python-zombiereaper
Collects zombie processes automatically so you don't have to

%package bootstrap
Summary:        VDSM bootstrapping package
BuildArch:      noarch

%description bootstrap
VDSM bootstrapping package. Used for delivering the bootstrap code onto the
Virtualization Manager.

%package reg
Summary:        VDSM registration package
BuildArch:      noarch

Requires: %{name} = %{version}-%{release}
Requires: m2crypto
Requires: openssl

%description reg
VDSM registration package. Used to register a Linux host to a Virtualization
Manager.

%package python
Summary:        VDSM python libraries
Requires:       %{name}-python-zombiereaper = %{version}-%{release}
Requires:       python-cpopen >= 1.2.3-5

%description python
Shared libraries between the various VDSM packages.

%package debug-plugin
Summary:        VDSM Debug Plugin
Requires:       %{name}
Requires:       %{name}-xmlrpc = %{version}-%{release}
BuildArch:      noarch

%description debug-plugin
Used by the trained monkeys at Red Hat to insert chaos and mayhem in to VDSM.

%package tests
Summary:        VDSM Test Suite
Requires:       %{name} = %{version}-%{release}
Requires:       dracut
Requires:       python-nose
BuildArch:      noarch

%description tests
A test suite for verifying the functionality of a running vdsm instance

%package hook-checkimages
Summary:        Qcow2 disk image format check hook for VDSM
BuildArch:      noarch
Requires:       %{name}

%description hook-checkimages
VDSM hook used to perform consistency check on a qcow2 format disk image
using the QEMU disk image utility.

%if 0%{?with_vhostmd}
%package hook-vhostmd
Summary:        VDSM hook set for interaction with vhostmd
Requires:       vhostmd
BuildArch:      noarch

%description hook-vhostmd
VDSM hook to use vhostmd per VM according to Virtualization Manager requests.
%endif

%package hook-faqemu
Summary:        Fake qemu process for VDSM quality assurance
BuildArch:      noarch
Requires:       %{name}

%description hook-faqemu
VDSM hook used for testing VDSM with multiple fake virtual machines without
running real guests.
To enable this hook on your host, set vars.fake_kvm_support=True in your
/etc/vdsm/vdsm.conf before adding the host to ovirt-Engine.

%package hook-directlun
Summary:        Direct LUN support for VDSM
BuildArch:      noarch

%description hook-directlun
VDSM hook enable user to add storage LUN for VDSM
without the sharing and storage handling of VDSM.

%package hook-macspoof
Summary:        Disables MAC spoofing filtering
BuildArch:      noarch

%description hook-macspoof
VDSM hooks which allow to disable mac spoof filtering
either on all the of the VM's interfaces or on
specific vnics.

%package hook-extnet
Summary:        Force a vNIC to connect to a specific libvirt network
BuildArch:      noarch
Requires:       %{name} = %{version}-%{release}

%description hook-extnet
VDSM hook which allows to connect a vNIC to a libvirt network that is managed
outside of oVirt, such as an openvswitch network.

%package hook-fileinject
Summary:        Allow uploading file to VMs disk
BuildArch:      noarch
Requires:       python-libguestfs

%description hook-fileinject
Hook is getting target file name and its content and
create that file in target machine.

%package hook-floppy
Summary:        Allow adding floppy to VM
BuildArch:      noarch

%description hook-floppy
Allow adding floppy to VM

%package hook-hostusb
Summary:        Allow attaching USB device from host
BuildArch:      noarch
Requires:       usbutils

%description hook-hostusb
Hook is getting vendor and product id of USB device
disconnect it from host and attach it to VM

%package hook-hugepages
Summary:        Huge pages enable user to handle VM with 2048KB page files.
BuildArch:      noarch

%description hook-hugepages
Hook is getting number of huge pages reserve them for the VM,
and enable user to handle VM with 2048KB page files.

%package hook-isolatedprivatevlan
Summary:        Isolated network environment for VMs
BuildArch:      noarch

%description hook-isolatedprivatevlan
limit VM traffic to a specific gateway by its mac address,
hook prevent VM from spoofing its mac or  ip address
by using <filterref filter='clean-traffic'/> libvirt filter
and by adding custom filter: isolatedprivatevlan-vdsm.xml

%package hook-nestedvt
Summary:        Nested Virtualization support for VDSM
BuildArch:      noarch

%description hook-nestedvt
If the nested virtualization is enabled in your kvm module
this hook will expose it to the guests.

%package hook-numa
Summary:        NUMA support for VDSM
BuildArch:      noarch

%description hook-numa
Hooks is getting number/rage of NUMA nodes and NUMA mode,
and update the VM xml.

%package hook-openstacknet
Summary:        OpenStack Network vNICs support for VDSM
BuildArch:      noarch

%description hook-openstacknet
Hook for OpenStack Network vNICs.

%package hook-pincpu
Summary:        Hook pin VM so specific CPUs
BuildArch:      noarch

%description hook-pincpu
pincpu is hook for VDSM.
pincpu enable to pin virtual machine to a specific CPUs.

%package hook-promisc
Summary:        Network interface promiscuous mode support for VDSM
BuildArch:      noarch

%description hook-promisc
VDSM promiscuous mode let user define a VM interface that will capture
all network traffic.

%package hook-qemucmdline
Summary:        QEMU cmdline hook for VDSM
BuildArch:      noarch
Requires:       %{name}

%description hook-qemucmdline
Provides support for injecting QEMU cmdline via VDSM hook.
It exploits libvirt's qemu:commandline facility available in the
qemu xml namespace.

%package hook-qos
Summary:        QoS network in/out traffic support for VDSM
BuildArch:      noarch

%description hook-qos
Hook adds QoS in/out traffic to VMs interfaces

%package hook-scratchpad
Summary:        One time disk creation for VDSM
BuildArch:      noarch

%description hook-scratchpad
scratchpad hook for VDSM
Hook creates a disk for a VM onetime usage,
the disk will be erased when the VM destroyed.
VM cannot be migrated when using scratchpad hook

%package hook-smbios
Summary:        Adding custom smbios entries to libvirt domain via VDSM
BuildArch:      noarch

%description hook-smbios
Adding custom smbios entries to libvirt domain via VDSM
such as: vendor, version, date and release

%package hook-sriov
Summary:        sr-iov support for VDSM
%if 0%{?rhel} >= 7 || 0%{?fedora} >= 18
Requires:       libvirt-daemon-driver-nodedev
%endif
BuildArch:      noarch

%description hook-sriov
sr-iov hook enable to add virtual functions exposed by the device
directly to a virtual machine.

%package hook-vmfex
Summary:        vmfex support for VDSM
BuildArch:      noarch
Conflicts:      hook-vmfex-dev

%description hook-vmfex
Hook for vmfex.

%package hook-vmfex-dev
Summary:        VM-FEX vNIC support for VDSM
BuildArch:      noarch
Requires:       %{name} = %{version}-%{release}
Conflicts:      hook-vmfex

%description hook-vmfex-dev
Allows to use custom device properties to connect a guest vNIC to a host
VM-FEX Virtual Function (SR-IOV with macvtap mode).

%package hook-vmdisk
Summary:        External disk support for VDSM
BuildArch:      noarch

%description hook-vmdisk
Hook adds additional disk image for a VM (raw or qcow2)

%if 0%{?with_gluster}
%package gluster
Summary:        Gluster Plugin for VDSM
BuildArch:      noarch

Requires: %{name} = %{version}-%{release}
Requires: glusterfs-server
Requires: python-magic

%description gluster
Gluster plugin enables VDSM to serve Gluster functionalities.
%endif

%prep
%setup -q
%if 0%{?rhel} == 6
sed -i '/ su /d' vdsm/vdsm-logrotate.conf.in
%endif

%build
%if 0%{?enable_autotools}
autoreconf -if
%endif
%configure %{?with_hooks:--enable-hooks}
make
# Setting software_version and software_revision in dsaversion.py
baserelease=`echo "%{release}" | sed 's/\([0-9]\+\(\.[0-9]\+\)\?\).*/\1/'`
baseversion=`echo "%{version}" | sed 's/\([0-9]\+\(\.[0-9]\+\)\?\).*/\1/'`
rawversion=%{version}-%{release}
sed -i -e 's/^software_version =.*/software_version = "'"${baseversion}"'"/' \
       -e 's/^raw_version_revision =.*/raw_version_revision = "'"${rawversion}"'"/' \
       -e 's/^software_revision =.*/software_revision = "'"${baserelease}"'"/' vdsm/dsaversion.py

%install
rm -rf %{buildroot}
make DESTDIR=%{buildroot} install

# Creating VDSM logs in this session to avoid rpmbuild
# complain during the build
install -dDm 0755 %{buildroot}/var/log/vdsm
touch %{buildroot}/var/log/vdsm/{metadata.log,mom.log,supervdsm.log,vdsm.log}

# Install the respawn utility
install -Dm 0755 init/sysvinit/respawn \
                 %{buildroot}%{_datadir}/%{vdsm_name}/respawn

# Install the lvm rules
install -Dm 0644 vdsm/storage/vdsm-lvm.rules \
                 %{buildroot}/lib/udev/rules.d/12-vdsm-lvm.rules

install -Dm 0644 vdsm/limits.conf \
                 %{buildroot}/etc/security/limits.d/99-vdsm.conf

%if 0%{?with_systemd}
install -Dm 0755 init/systemd/systemd-vdsmd %{buildroot}/lib/systemd/systemd-vdsmd
install -Dm 0644 init/systemd/vdsmd.service %{buildroot}%{_unitdir}/vdsmd.service
install -Dm 0644 init/systemd/supervdsmd.service %{buildroot}%{_unitdir}/supervdsmd.service

install -Dm 0755 vdsm_reg/vdsm-reg.init \
                 %{buildroot}/lib/systemd/systemd-vdsm-reg
install -Dm 0644 vdsm_reg/vdsm-reg.service \
                 %{buildroot}%{_unitdir}/vdsm-reg.service
install -Dm 0644 vdsm/vdsm-modules-load.d.conf \
                 %{buildroot}%{_sysconfdir}/modules-load.d/vdsm.conf
%else
# Install the SysV init scripts
install -Dm 0755 init/sysvinit/vdsmd.init %{buildroot}%{_initrddir}/vdsmd
install -Dm 0755 init/sysvinit/supervdsmd.init %{buildroot}%{_initrddir}/supervdsmd

install -Dm 0755 vdsm_reg/vdsm-reg.init %{buildroot}%{_initrddir}/vdsm-reg
%endif

%if 0%{?with_tmpfiles_macro}
install -Dm 0644 init/systemd/vdsm-tmpfiles.d.conf \
                 %{buildroot}%{_tmpfilesdir}/%{vdsm_name}.conf
%endif

%if 0%{?rhel}
# This is not commonplace, but we want /var/log/core to be a world-writable
# dropbox for core dumps
install -dDm 1777 %{buildroot}%{_localstatedir}/log/core
%endif

# Install the polkit for libvirt
%if 0%{?fedora} >= 18 || 0%{?rhel} >= 7
install -Dm 0644 vdsm/vdsm-libvirt-access.rules \
                 %{buildroot}%{_polkitdir}/10-vdsm-libvirt-access.rules
%else
install -Dm 0644 vdsm/vdsm-libvirt-access.pkla \
                 %{buildroot}%{_polkitdir}/10-vdsm-libvirt-access.pkla
%endif

%check
# Disabling the nose tests until they'll all succeed in koji.
# make check is failing on F-18+ due to pep8 issues. See RHBZ # 837014
# make check NOSE_EXCLUDE=".*"

%clean
rm -rf %{buildroot}

%pre
# Force standard locale behavior (English)
export LC_ALL=C

/usr/bin/getent passwd %{vdsm_user} >/dev/null || \
    /usr/sbin/useradd -r -u 36 -g %{vdsm_group} -d /var/lib/vdsm \
        -s /sbin/nologin -c "Node Virtualization Manager" %{vdsm_user}
/usr/sbin/usermod -a -G %{qemu_group},%{snlk_group} %{vdsm_user}
/usr/sbin/usermod -a -G %{cdrom_group} %{qemu_user}

%post
%{_bindir}/vdsm-tool configure --module sanlock --force
%{_bindir}/vdsm-tool sebool-config || :
# set the vdsm "secret" password for libvirt
%{_bindir}/vdsm-tool set-saslpasswd

# After vdsm install we should create the logs files.
# In the install session we create it but since we use
# the ghost macro (in files session) the files are not included
touch /var/log/vdsm/{metadata.log,mom.log,supervdsm.log,vdsm.log}
chmod 0644 /var/log/vdsm/{metadata.log,mom.log,supervdsm.log,vdsm.log}
chown vdsm:kvm /var/log/vdsm/{metadata.log,mom.log,vdsm.log}
chown root:root /var/log/vdsm/supervdsm.log

# Have moved vdsm section in /etc/sysctl.conf to /etc/sysctl.d/vdsm.conf.
# So Remove them if it is played with /etc/sysctl.conf.
if grep -q "# VDSM section begin" /etc/sysctl.conf; then
    /bin/sed -i '/# VDSM section begin/,/# VDSM section end/d' \
        /etc/sysctl.conf
fi

# hack until we replace core dump with abrt
if /usr/sbin/selinuxenabled; then
    /usr/sbin/semanage fcontext -a -t virt_cache_t '/var/log/core(/.*)?'
fi
/sbin/restorecon -R /var/log/core >/dev/null 2>&1
# hack until we replace core dump with abrt

%if ! 0%{?with_systemd}
if [ "$1" -eq 1 ] ; then
    /sbin/chkconfig --add vdsmd
    /sbin/chkconfig --add supervdsmd
fi
%else
/bin/systemctl restart systemd-modules-load.service >/dev/null 2>&1 || :
if [ "$1" -eq 1 ] ; then
    /bin/systemctl enable vdsmd.service >/dev/null 2>&1 || :
    /bin/systemctl enable supervdsmd.service >/dev/null 2>&1 || :
fi
/bin/systemctl daemon-reload >/dev/null 2>&1 || :
exit 0
%endif

%preun
if [ "$1" -eq 0 ]; then
        start_conf_section="## beginning of configuration section by vdsm"
        end_conf_section="## end of configuration section by vdsm"
        by_vdsm="by vdsm"

        /bin/sed -i -e "/${start_conf_section}/,/${end_conf_section}/d" \
                    -e "/${by_vdsm}/d" \
               %{_sysconfdir}/libvirt/libvirtd.conf \
               %{_sysconfdir}/logrotate.d/libvirtd \
               %{_sysconfdir}/libvirt/qemu.conf \
               %{_sysconfdir}/sysconfig/libvirtd \
               %{_sysconfdir}/sysctl.conf \
               %{_sysconfdir}/libvirt/qemu-sanlock.conf

        # Restoring backuped logrotate.d/libvirtd
        /bin/sed -i -e 's/# VDSM backup//' %{_sysconfdir}/logrotate.d/libvirtd
fi

%if ! 0%{?with_systemd}
if [ "$1" -eq 0 ]
then
    /sbin/service vdsmd stop > /dev/null 2>&1 || :
    /sbin/chkconfig --del vdsmd
    /sbin/service supervdsmd stop > /dev/null 2>&1 || :
    /sbin/chkconfig --del supervdsmd

    /bin/sed -i '/# VDSM section begin/,/# VDSM section end/d' \
        /etc/sysctl.conf

    %{_bindir}/vdsm-tool sebool-unconfig || :

    /usr/sbin/saslpasswd2 -p -a libvirt -d vdsm@ovirt

    if /sbin/initctl status libvirtd >/dev/null 2>/dev/null ; then
        /sbin/initctl stop libvirtd  >/dev/null 2>/dev/null
        rm -f /etc/init/libvirtd.conf

        /sbin/chkconfig libvirtd on
        /sbin/service libvirtd start >/dev/null
    fi
fi
%else
%if 0%{?with_systemd_macros}
%systemd_preun vdsmd.service
%systemd_preun supervdsmd.service
%else
if [ "$1" -eq 0 ]; then
    /bin/systemctl --no-reload disable vdsmd.service > /dev/null 2>&1 || :
    /bin/systemctl --no-reload disable supervdsmd.service > /dev/null 2>&1 || :
    /bin/systemctl stop vdsmd.service > /dev/null 2>&1 || :
    /bin/systemctl stop supervdsmd.service > /dev/null 2>&1 || :
fi
exit 0
%endif
%endif

%postun
if [ "$1" -ge 1 ]; then
    supervdsmd_start_required='no'
    vdsmd_start_required='no'

    # Both vdsm and supervdsm should be managed here and must be restarted if
    # ran before (code might changed)
    if %{_bindir}/vdsm-tool service-status vdsmd >/dev/null 2>&1; then
        %{_bindir}/vdsm-tool service-stop vdsmd >/dev/null 2>&1 || :
        vdsmd_start_required='yes'
    fi
    if %{_bindir}/vdsm-tool service-status supervdsmd >/dev/null 2>&1; then
        %{_bindir}/vdsm-tool service-stop supervdsmd >/dev/null 2>&1 || :
        supervdsmd_start_required='yes'
    fi

    if ! %{_bindir}/vdsm-tool is-configured --module libvirt >/dev/null 2>&1;
    then
        if ! %{_bindir}/vdsm-tool configure --module libvirt --force \
                >/dev/null 2>&1; then
            # fallback to vdsmd reconfigure api - This change may be removed
            # when vdsm won't support any downgrade\upgrade to versions that
            # don't include vdsm-tool configure api (vdsm <= 3.3)
            for f in '/lib/systemd/systemd-vdsmd' '/etc/init.d/vdsmd'; do
                if [ -f "${f}" ]; then
                    "${f}" reconfigure >/dev/null 2>&1 || :
                fi
            done
        fi
    fi

    if [ "${supervdsmd_start_required}" = 'yes' ]; then
        %{_bindir}/vdsm-tool service-start supervdsmd >/dev/null 2>&1 || :
    fi
    if [ "${vdsmd_start_required}" = 'yes' ]; then
        %{_bindir}/vdsm-tool service-start vdsmd >/dev/null 2>&1 || :
    fi
fi
exit 0

%if 0%{?rhel} == 6
# In el6, We configure libvirt to use upstart without the libvirt.rpm's
# awareness. Thus, we must stop/restart libvirt ourselves when the
# libvirt.rpm is removed/upgraded.
%triggerun -- libvirt
if [ "$2" -eq "0" ]; then
    /sbin/initctl stop libvirtd > /dev/null 2>&1 || :
fi

%triggerpostun -- libvirt
if [ "$2" -ge "1" ]; then
    /sbin/initctl restart libvirtd > /dev/null 2>&1 || :
fi
%endif

%post reg
%if ! 0%{?with_systemd}
if [ "$1" -eq 1 ] ; then
    /sbin/chkconfig --add vdsm-reg
fi
%else
%if 0%{?with_systemd_macros}
%systemd_post vdsm-reg.service
%else
if [ "$1" -eq 1 ] ; then
    /bin/systemctl enable vdsm-reg.service >/dev/null 2>&1 || :
    /bin/systemctl daemon-reload >/dev/null 2>&1 || :
fi
exit 0
%endif
%endif

%preun reg
%if ! 0%{?with_systemd}
if [ "$1" -eq 0 ]
then
    /sbin/service vdsm-reg stop > /dev/null 2>&1 || :
    /sbin/chkconfig --del vdsm-reg
fi
%else
%if 0%{?with_systemd_macros}
%systemd_preun vdsm-reg.service
%else
if [ "$1" -eq 0 ]; then
    /bin/systemctl --no-reload disable vdsm-reg.service > /dev/null 2>&1 || :
    /bin/systemctl stop vdsm-reg.service > /dev/null 2>&1 || :
fi
exit 0
%endif
%endif

%files
%defattr(-, root, root, -)
%doc COPYING README lib/vdsm/vdsm.conf.sample
%if 0%{?with_systemd}
/lib/systemd/systemd-vdsmd
%{_unitdir}/vdsmd.service
%{_unitdir}/supervdsmd.service
%else
%{_initrddir}/vdsmd
%{_initrddir}/supervdsmd
%endif

%dir %attr(-, %{vdsm_user}, %{vdsm_group}) /rhev/data-center
%ghost %config %attr(0644, %{vdsm_user}, %{vdsm_group}) /var/log/vdsm/metadata.log
%ghost %config %attr(0644, %{vdsm_user}, %{vdsm_group}) /var/log/vdsm/mom.log
%ghost %config %attr(0644, root, root) /var/log/vdsm/supervdsm.log
%ghost %config %attr(0644, %{vdsm_user}, %{vdsm_group}) /var/log/vdsm/vdsm.log
%ghost %dir %attr(-, %{vdsm_user}, %{vdsm_group}) /rhev/data-center/hsm-tasks
%ghost %dir %attr(-, %{vdsm_user}, %{vdsm_group}) /rhev/data-center/mnt
%dir %{_libexecdir}/%{vdsm_name}
%dir %{_sysconfdir}/%{vdsm_name}
%dir %{_sysconfdir}/%{vdsm_name}/mom.d
%dir %{_datadir}/%{vdsm_name}
%dir %{_datadir}/%{vdsm_name}/netconf
%dir %{_datadir}/%{vdsm_name}/storage
%dir %{_datadir}/%{vdsm_name}/storage/imageRepository
%{_datadir}/%{vdsm_name}/alignmentScan.py*
%{_datadir}/%{vdsm_name}/blkid.py*
%{_datadir}/%{vdsm_name}/caps.py*
%{_datadir}/%{vdsm_name}/clientIF.py*
%{_datadir}/%{vdsm_name}/daemonAdapter
%{_datadir}/%{vdsm_name}/dmidecodeUtil.py*
%{_datadir}/%{vdsm_name}/API.py*
%{_datadir}/%{vdsm_name}/hooking.py*
%{_datadir}/%{vdsm_name}/hooks.py*
%{_datadir}/%{vdsm_name}/lsblk.py*
%{_datadir}/%{vdsm_name}/md_utils.py*
%{_datadir}/%{vdsm_name}/mk_sysprep_floppy
%{_datadir}/%{vdsm_name}/parted_utils.py*
%{_datadir}/%{vdsm_name}/mkimage.py*
%{_datadir}/%{vdsm_name}/ppc64HardwareInfo.py*
%{_datadir}/%{vdsm_name}/sourceRoute.py*
%{_datadir}/%{vdsm_name}/sourceRouteThread.py*
%{_datadir}/%{vdsm_name}/supervdsm.py*
%{_datadir}/%{vdsm_name}/supervdsmServer
%{_datadir}/%{vdsm_name}/vmChannels.py*
%{_datadir}/%{vdsm_name}/tc.py*
%{_datadir}/%{vdsm_name}/vdsm
%{_datadir}/%{vdsm_name}/vdsm-restore-net-config
%{_datadir}/%{vdsm_name}/vdsm-store-net-config
%{_datadir}/%{vdsm_name}/vm.py*

%config(noreplace) %{_sysconfdir}/%{vdsm_name}/vdsm.conf
%config(noreplace) %{_sysconfdir}/%{vdsm_name}/logger.conf
%config(noreplace) %{_sysconfdir}/%{vdsm_name}/svdsm.logger.conf
%config(noreplace) %{_sysconfdir}/%{vdsm_name}/upgrade.logger.conf
%config(noreplace) %{_sysconfdir}/%{vdsm_name}/mom.conf
%config(noreplace) %{_sysconfdir}/%{vdsm_name}/mom.d/*.policy
%config(noreplace) %{_sysconfdir}/logrotate.d/vdsm
%config(noreplace) %{_sysconfdir}/rwtab.d/vdsm
%config(noreplace) %{_sysconfdir}/sysctl.d/vdsm.conf
%if 0%{?with_systemd}
%config(noreplace) %{_sysconfdir}/modules-load.d/vdsm.conf
%endif
%if 0%{?with_tmpfiles_macro}
%config(noreplace) %{_tmpfilesdir}/%{vdsm_name}.conf
%endif
%{_sysconfdir}/dhcp/dhclient.d/sourceRoute.sh
%{_sysconfdir}/sudoers.d/50_vdsm
%{_sysconfdir}/cron.hourly/vdsm-logrotate
%{_sysconfdir}/cron.d/vdsm-libvirt-logrotate
%{_datadir}/%{vdsm_name}/guestIF.py*
%{_datadir}/%{vdsm_name}/logUtils.py*
%{_datadir}/%{vdsm_name}/dsaversion.py*
%{_libexecdir}/%{vdsm_name}/curl-img-wrap
%{_libexecdir}/%{vdsm_name}/persist-vdsm-hooks
%{_libexecdir}/%{vdsm_name}/unpersist-vdsm-hook
%{_libexecdir}/%{vdsm_name}/ovirt_functions.sh
%{_libexecdir}/%{vdsm_name}/vdsm-gencerts.sh
%{_libexecdir}/%{vdsm_name}/vdsmd_init_common.sh
%{_datadir}/%{vdsm_name}/storage/__init__.py*
%{_datadir}/%{vdsm_name}/storage/blockSD.py*
%{_datadir}/%{vdsm_name}/storage/blockVolume.py*
%{_datadir}/%{vdsm_name}/storage/curlImgWrap.py*
%{_datadir}/%{vdsm_name}/storage/devicemapper.py*
%{_datadir}/%{vdsm_name}/storage/dispatcher.py*
%{_datadir}/%{vdsm_name}/storage/domainMonitor.py*
%{_datadir}/%{vdsm_name}/storage/fileSD.py*
%{_datadir}/%{vdsm_name}/storage/fileUtils.py*
%{_datadir}/%{vdsm_name}/storage/fileVolume.py*
%{_datadir}/%{vdsm_name}/storage/fuser.py*
%{_datadir}/%{vdsm_name}/storage/glusterSD.py*
%{_datadir}/%{vdsm_name}/storage/glusterVolume.py*
%{_datadir}/%{vdsm_name}/storage/hba.py*
%{_datadir}/%{vdsm_name}/storage/hsm.py*
%{_datadir}/%{vdsm_name}/storage/image.py*
%{_datadir}/%{vdsm_name}/storage/imageSharing.py*
%{_datadir}/%{vdsm_name}/storage/iscsiadm.py*
%{_datadir}/%{vdsm_name}/storage/iscsi.py*
%{_datadir}/%{vdsm_name}/storage/localFsSD.py*
%{_datadir}/%{vdsm_name}/storage/lvm.env
%{_datadir}/%{vdsm_name}/storage/lvm.py*
%{_datadir}/%{vdsm_name}/storage/misc.py*
%{_datadir}/%{vdsm_name}/storage/mount.py*
%{_datadir}/%{vdsm_name}/storage/multipath.py*
%{_datadir}/%{vdsm_name}/storage/nfsSD.py*
%{_datadir}/%{vdsm_name}/storage/outOfProcess.py*
%{_datadir}/%{vdsm_name}/storage/persistentDict.py*
%{_datadir}/%{vdsm_name}/storage/resourceFactories.py*
%{_datadir}/%{vdsm_name}/storage/remoteFileHandler.py*
%{_datadir}/%{vdsm_name}/storage/resourceManager.py*
%{_datadir}/%{vdsm_name}/storage/clusterlock.py*
%{_datadir}/%{vdsm_name}/storage/sdc.py*
%{_datadir}/%{vdsm_name}/storage/sd.py*
%{_datadir}/%{vdsm_name}/storage/securable.py*
%{_datadir}/%{vdsm_name}/storage/sp.py*
%{_datadir}/%{vdsm_name}/storage/spbackends.py*
%{_datadir}/%{vdsm_name}/storage/storageConstants.py*
%{_datadir}/%{vdsm_name}/storage/storage_exception.py*
%{_datadir}/%{vdsm_name}/storage/storage_mailbox.py*
%{_datadir}/%{vdsm_name}/storage/storageServer.py*
%{_datadir}/%{vdsm_name}/storage/sync.py*
%{_datadir}/%{vdsm_name}/storage/taskManager.py*
%{_datadir}/%{vdsm_name}/storage/task.py*
%{_datadir}/%{vdsm_name}/storage/threadLocal.py*
%{_datadir}/%{vdsm_name}/storage/threadPool.py*
%{_datadir}/%{vdsm_name}/storage/volume.py*
%{_datadir}/%{vdsm_name}/storage/imageRepository/__init__.py*
%{_datadir}/%{vdsm_name}/storage/imageRepository/formatConverter.py*
%{_libexecdir}/%{vdsm_name}/safelease
%{_libexecdir}/%{vdsm_name}/spmprotect.sh
%{_libexecdir}/%{vdsm_name}/spmstop.sh
%dir %{_libexecdir}/%{vdsm_name}/hooks
%dir %{_libexecdir}/%{vdsm_name}/hooks/before_device_create
%dir %{_libexecdir}/%{vdsm_name}/hooks/after_device_create
%dir %{_libexecdir}/%{vdsm_name}/hooks/before_device_destroy
%dir %{_libexecdir}/%{vdsm_name}/hooks/after_device_destroy
%dir %{_libexecdir}/%{vdsm_name}/hooks/before_vm_start
%dir %{_libexecdir}/%{vdsm_name}/hooks/after_vm_start
%dir %{_libexecdir}/%{vdsm_name}/hooks/before_vm_cont
%dir %{_libexecdir}/%{vdsm_name}/hooks/after_vm_cont
%dir %{_libexecdir}/%{vdsm_name}/hooks/before_vm_pause
%dir %{_libexecdir}/%{vdsm_name}/hooks/after_vm_pause
%dir %{_libexecdir}/%{vdsm_name}/hooks/before_vm_hibernate
%dir %{_libexecdir}/%{vdsm_name}/hooks/after_vm_hibernate
%dir %{_libexecdir}/%{vdsm_name}/hooks/before_vm_dehibernate
%dir %{_libexecdir}/%{vdsm_name}/hooks/after_vm_dehibernate
%dir %{_libexecdir}/%{vdsm_name}/hooks/before_device_migrate_source
%dir %{_libexecdir}/%{vdsm_name}/hooks/after_device_migrate_source
%dir %{_libexecdir}/%{vdsm_name}/hooks/before_device_migrate_destination
%dir %{_libexecdir}/%{vdsm_name}/hooks/after_device_migrate_destination
%dir %{_libexecdir}/%{vdsm_name}/hooks/before_vm_migrate_source
%dir %{_libexecdir}/%{vdsm_name}/hooks/after_vm_migrate_source
%dir %{_libexecdir}/%{vdsm_name}/hooks/before_vm_migrate_destination
%dir %{_libexecdir}/%{vdsm_name}/hooks/after_vm_migrate_destination
%dir %{_libexecdir}/%{vdsm_name}/hooks/before_vm_destroy
%dir %{_libexecdir}/%{vdsm_name}/hooks/after_vm_destroy
%dir %{_libexecdir}/%{vdsm_name}/hooks/before_vm_set_ticket
%dir %{_libexecdir}/%{vdsm_name}/hooks/after_vm_set_ticket
%dir %{_libexecdir}/%{vdsm_name}/hooks/before_update_device
%dir %{_libexecdir}/%{vdsm_name}/hooks/after_update_device
%dir %{_libexecdir}/%{vdsm_name}/hooks/after_update_device_fail
%dir %{_libexecdir}/%{vdsm_name}/hooks/before_nic_hotplug
%dir %{_libexecdir}/%{vdsm_name}/hooks/after_nic_hotplug
%dir %{_libexecdir}/%{vdsm_name}/hooks/before_nic_hotunplug
%dir %{_libexecdir}/%{vdsm_name}/hooks/after_nic_hotunplug
%dir %{_libexecdir}/%{vdsm_name}/hooks/after_nic_hotplug_fail
%dir %{_libexecdir}/%{vdsm_name}/hooks/after_nic_hotunplug_fail
%dir %{_libexecdir}/%{vdsm_name}/hooks/before_disk_hotplug
%dir %{_libexecdir}/%{vdsm_name}/hooks/after_disk_hotplug
%dir %{_libexecdir}/%{vdsm_name}/hooks/before_disk_hotunplug
%dir %{_libexecdir}/%{vdsm_name}/hooks/after_disk_hotunplug
%dir %{_libexecdir}/%{vdsm_name}/hooks/before_vdsm_start
%dir %{_libexecdir}/%{vdsm_name}/hooks/after_vdsm_stop
%dir %{_libexecdir}/%{vdsm_name}/hooks/before_network_setup
%dir %{_libexecdir}/%{vdsm_name}/hooks/after_network_setup
%dir %{_libexecdir}/%{vdsm_name}/hooks/before_set_num_of_cpus
%dir %{_libexecdir}/%{vdsm_name}/hooks/after_set_num_of_cpus
%{_datadir}/%{vdsm_name}/addNetwork
%{_datadir}/%{vdsm_name}/configNetwork.py*
%{_datadir}/%{vdsm_name}/delNetwork
%{_datadir}/%{vdsm_name}/dumpStorageTable.py*
%{_datadir}/%{vdsm_name}/get-conf-item
%{_datadir}/%{vdsm_name}/kaxmlrpclib.py*
%{_datadir}/%{vdsm_name}/ksm.py*
%{_datadir}/%{vdsm_name}/momIF.py*
%{_datadir}/%{vdsm_name}/netconf/__init__.py*
%{_datadir}/%{vdsm_name}/netconf/dhclient.py*
%{_datadir}/%{vdsm_name}/netconf/ifcfg.py*
%{_datadir}/%{vdsm_name}/netconf/libvirtCfg.py*
%{_datadir}/%{vdsm_name}/netconf/iproute2.py*
%{_datadir}/%{vdsm_name}/neterrors.py*
%{_datadir}/%{vdsm_name}/netmodels.py*
%{_datadir}/%{vdsm_name}/respawn
%{_datadir}/%{vdsm_name}/sampling.py*
%{_datadir}/%{vdsm_name}/set-conf-item
%if 0%{?with_gluster}
%dir %{_datadir}/%{vdsm_name}/gluster
%{_datadir}/%{vdsm_name}/gluster/__init__.py*
%{_datadir}/%{vdsm_name}/gluster/cli.py*
%{_datadir}/%{vdsm_name}/gluster/exception.py*
%{_datadir}/%{vdsm_name}/gluster/hostname.py*
%else
%exclude %{_datadir}/%{vdsm_name}/gluster/*
%endif
%{python_sitelib}/sos/plugins/vdsm.py*
/lib/udev/rules.d/12-vdsm-lvm.rules
/etc/security/limits.d/99-vdsm.conf
%{_mandir}/man8/vdsmd.8*
%if 0%{?rhel}
%dir %{_localstatedir}/log/core
%endif
%if 0%{?fedora} >= 18 || 0%{?rhel} >= 7
%{_polkitdir}/10-vdsm-libvirt-access.rules
%else
%{_polkitdir}/10-vdsm-libvirt-access.pkla
%endif

%defattr(-, %{vdsm_user}, %{qemu_group}, -)
%dir %{_localstatedir}/lib/libvirt/qemu/channels

%defattr(-, %{vdsm_user}, %{vdsm_group}, -)
%dir %{_sysconfdir}/pki/%{vdsm_name}
%dir %{_sysconfdir}/pki/%{vdsm_name}/keys
%dir %{_sysconfdir}/pki/%{vdsm_name}/certs
%dir %{_sysconfdir}/pki/%{vdsm_name}/libvirt-spice
%config(noreplace) %{_sysconfdir}/pki/%{vdsm_name}/keys/libvirt_password
%dir %{_localstatedir}/lib/%{vdsm_name}
%dir %{_localstatedir}/lib/%{vdsm_name}/netconfback
%dir %{_localstatedir}/lib/%{vdsm_name}/persistence
%dir %{_localstatedir}/lib/%{vdsm_name}/upgrade
%dir %{_localstatedir}/run/%{vdsm_name}
%dir %{_localstatedir}/run/%{vdsm_name}/sourceRoutes
%dir %{_localstatedir}/run/%{vdsm_name}/trackedInterfaces
%ghost %dir %{_localstatedir}/run/%{vdsm_name}/payload
%dir %{_localstatedir}/log/%{vdsm_name}
%dir %{_localstatedir}/log/%{vdsm_name}/backup

%files python
%defattr(-, root, root, -)
%{_bindir}/vdsm-tool
%dir %{python_sitearch}/%{vdsm_name}
%dir %{python_sitearch}/%{vdsm_name}/tool
%{python_sitearch}/%{vdsm_name}/__init__.py*
%{python_sitearch}/%{vdsm_name}/config.py*
%{python_sitearch}/%{vdsm_name}/constants.py*
%{python_sitearch}/%{vdsm_name}/define.py*
%{python_sitearch}/%{vdsm_name}/exception.py*
%{python_sitearch}/%{vdsm_name}/ipwrapper.py*
%{python_sitearch}/%{vdsm_name}/libvirtconnection.py*
%{python_sitearch}/%{vdsm_name}/netinfo.py*
%{python_sitearch}/%{vdsm_name}/netlink.py*
%{python_sitearch}/%{vdsm_name}/qemuImg.py*
%{python_sitearch}/%{vdsm_name}/SecureXMLRPCServer.py*
%{python_sitearch}/%{vdsm_name}/netconfpersistence.py*
%{python_sitearch}/%{vdsm_name}/utils.py*
%{python_sitearch}/%{vdsm_name}/vdscli.py*
%{python_sitearch}/%{vdsm_name}/tool/__init__.py*
%if 0%{?with_systemd}
%exclude %{python_sitearch}/%{vdsm_name}/tool/load_needed_modules.py*
%else
%{python_sitearch}/%{vdsm_name}/tool/load_needed_modules.py*
%endif
%{python_sitearch}/%{vdsm_name}/tool/dummybr.py*
%{python_sitearch}/%{vdsm_name}/tool/nwfilter.py*
%{python_sitearch}/%{vdsm_name}/tool/configurator.py*
%{_libexecdir}/%{vdsm_name}/libvirt_configure.sh
%{python_sitearch}/%{vdsm_name}/tool/passwd.py*
%{python_sitearch}/%{vdsm_name}/tool/restore_nets.py*
%{python_sitearch}/%{vdsm_name}/tool/seboolsetup.py*
%{python_sitearch}/%{vdsm_name}/tool/service.py*
%{python_sitearch}/%{vdsm_name}/tool/transient.py*
%{python_sitearch}/%{vdsm_name}/tool/unified_persistence.py*
%{python_sitearch}/%{vdsm_name}/tool/upgrade.py*
%{python_sitearch}/%{vdsm_name}/tool/upgrade_300_networks.py*
%{python_sitearch}/%{vdsm_name}/tool/validate_ovirt_certs.py*
%{python_sitearch}/%{vdsm_name}/tool/vdsm-id.py*

%files tests
%doc %{_datadir}/%{vdsm_name}/tests/README
%defattr(-, root, root, -)
%dir %{_datadir}/%{vdsm_name}/tests
%dir %{_datadir}/%{vdsm_name}/tests/functional
%{_datadir}/%{vdsm_name}/tests/*.py*
%{_datadir}/%{vdsm_name}/tests/cpu_info.out
%{_datadir}/%{vdsm_name}/tests/caps_libvirt_intel_E5649.out
%{_datadir}/%{vdsm_name}/tests/caps_libvirt_amd_6274.out
%{_datadir}/%{vdsm_name}/tests/caps_libvirt_intel_E31220.out
%{_datadir}/%{vdsm_name}/tests/caps_lscpu_ppc64_1_4_4.out
%{_datadir}/%{vdsm_name}/tests/caps_lscpu_ppc64_2_4_8.out
%{_datadir}/%{vdsm_name}/tests/glob_1c60971a-8647-44ac-ae33-6520887f8843.out
%{_datadir}/%{vdsm_name}/tests/lvs_3386c6f2-926f-42c4-839c-38287fac8998.out
%{_datadir}/%{vdsm_name}/tests/mem_info.out
%{_datadir}/%{vdsm_name}/tests/netmaskconversions
%{_datadir}/%{vdsm_name}/tests/run_tests.sh
%{_datadir}/%{vdsm_name}/tests/tc_filter_show.out
%{_datadir}/%{vdsm_name}/tests/glusterVolumeProfileInfo.xml
%{_datadir}/%{vdsm_name}/tests/glusterVolumeProfileInfoNfs.xml
%{_datadir}/%{vdsm_name}/tests/glusterVolumeRebalanceStatus.xml
%{_datadir}/%{vdsm_name}/tests/glusterVolumeRemoveBricksStatus.xml
%{_datadir}/%{vdsm_name}/tests/glusterVolumeTasks.xml
%{_datadir}/%{vdsm_name}/tests/functional/*.py*
%{_datadir}/%{vdsm_name}/tests/functional/*.policy

%files hook-openstacknet
%defattr(-, root, root, -)
%{_sysconfdir}/sudoers.d/50_vdsm_hook_openstacknet
%{_libexecdir}/%{vdsm_name}/hooks/after_device_create/50_openstacknet
%{_libexecdir}/%{vdsm_name}/hooks/after_device_create/openstacknet_utils.py*
%{_libexecdir}/%{vdsm_name}/hooks/after_device_destroy/50_openstacknet
%{_libexecdir}/%{vdsm_name}/hooks/after_device_destroy/openstacknet_utils.py*
%{_libexecdir}/%{vdsm_name}/hooks/after_device_migrate_destination/50_openstacknet
%{_libexecdir}/%{vdsm_name}/hooks/after_device_migrate_destination/openstacknet_utils.py*
%{_libexecdir}/%{vdsm_name}/hooks/after_nic_hotplug/50_openstacknet
%{_libexecdir}/%{vdsm_name}/hooks/after_nic_hotplug/openstacknet_utils.py*
%{_libexecdir}/%{vdsm_name}/hooks/after_nic_hotunplug/50_openstacknet
%{_libexecdir}/%{vdsm_name}/hooks/after_nic_hotunplug/openstacknet_utils.py*
%{_libexecdir}/%{vdsm_name}/hooks/before_device_create/50_openstacknet
%{_libexecdir}/%{vdsm_name}/hooks/before_device_create/openstacknet_utils.py*
%{_libexecdir}/%{vdsm_name}/hooks/before_nic_hotplug/50_openstacknet
%{_libexecdir}/%{vdsm_name}/hooks/before_nic_hotplug/openstacknet_utils.py*

%if 0%{?with_vhostmd}
%files hook-vhostmd
%defattr(-, root, root, -)
%doc COPYING
%{_sysconfdir}/sudoers.d/50_vdsm_hook_vhostmd
%{_libexecdir}/%{vdsm_name}/hooks/before_vm_start/50_vhostmd
%{_libexecdir}/%{vdsm_name}/hooks/before_vm_migrate_destination/50_vhostmd
%{_libexecdir}/%{vdsm_name}/hooks/before_vm_dehibernate/50_vhostmd
%{_libexecdir}/%{vdsm_name}/hooks/after_vm_destroy/50_vhostmd
%else
%exclude %{_sysconfdir}/sudoers.d/50_vdsm_hook_vhostmd
%exclude %{_libexecdir}/%{vdsm_name}/hooks/before_vm_start/50_vhostmd
%exclude %{_libexecdir}/%{vdsm_name}/hooks/before_vm_migrate_destination/50_vhostmd
%exclude %{_libexecdir}/%{vdsm_name}/hooks/before_vm_dehibernate/50_vhostmd
%exclude %{_libexecdir}/%{vdsm_name}/hooks/after_vm_destroy/50_vhostmd
%endif

%files hook-qemucmdline
%defattr(-, root, root, -)
%doc COPYING
%{_libexecdir}/%{vdsm_name}/hooks/before_vm_start/50_qemucmdline

%if 0%{?with_hooks}
%files hook-checkimages
%defattr(-, root, root, -)
%{_libexecdir}/%{vdsm_name}/hooks/before_vm_start/60_checkimages

%files hook-directlun
%defattr(-, root, root, -)
%{_sysconfdir}/sudoers.d/50_vdsm_hook_directlun
%{_libexecdir}/%{vdsm_name}/hooks/before_vm_start/50_directlun
%{_libexecdir}/%{vdsm_name}/hooks/after_vm_destroy/50_directlun
%{_libexecdir}/%{vdsm_name}/hooks/before_vm_migrate_destination/50_directlun

%files hook-fileinject
%defattr(-, root, root, -)
%{_libexecdir}/%{vdsm_name}/hooks/before_vm_start/50_fileinject

%files hook-floppy
%defattr(-, root, root, -)
%{_libexecdir}/%{vdsm_name}/hooks/before_vm_start/50_floppy
%{_libexecdir}/%{vdsm_name}/hooks/before_vm_migrate_source/50_floppy

%files hook-hostusb
%defattr(-, root, root, -)
%{_sysconfdir}/sudoers.d/50_vdsm_hook_hostusb
%{_libexecdir}/%{vdsm_name}/hooks/before_vm_start/50_hostusb
%{_libexecdir}/%{vdsm_name}/hooks/before_vm_migrate_source/50_hostusb
%{_libexecdir}/%{vdsm_name}/hooks/after_vm_destroy/50_hostusb

%files hook-hugepages
%defattr(-, root, root, -)
%{_sysconfdir}/sudoers.d/50_vdsm_hook_hugepages
%{_libexecdir}/%{vdsm_name}/hooks/before_vm_start/50_hugepages
%{_libexecdir}/%{vdsm_name}/hooks/before_vm_migrate_destination/50_hugepages
%{_libexecdir}/%{vdsm_name}/hooks/after_vm_destroy/50_hugepages

%files hook-isolatedprivatevlan
%defattr(-, root, root, -)
%{_libexecdir}/%{vdsm_name}/hooks/before_vm_start/50_isolatedprivatevlan
%config(noreplace) %{_sysconfdir}/libvirt/nwfilter/isolatedprivatevlan-vdsm.xml

%files hook-macspoof
%defattr(-, root, root, -)
%{_libexecdir}/%{vdsm_name}/hooks/before_vm_start/50_macspoof
%{_libexecdir}/%{vdsm_name}/hooks/before_device_create/50_macspoof
%{_libexecdir}/%{vdsm_name}/hooks/before_nic_hotplug/50_macspoof

%files hook-extnet
%defattr(-, root, root, -)
%{_libexecdir}/%{vdsm_name}/hooks/before_device_create/50_extnet
%{_libexecdir}/%{vdsm_name}/hooks/before_nic_hotplug/50_extnet

%files hook-nestedvt
%defattr(-, root, root, -)
%{_sysconfdir}/modprobe.d/vdsm-nestedvt.conf
%{_libexecdir}/%{vdsm_name}/hooks/before_vm_start/50_nestedvt

%files hook-numa
%defattr(-, root, root, -)
%{_libexecdir}/%{vdsm_name}/hooks/before_vm_start/50_numa

%files hook-pincpu
%defattr(-, root, root, -)
%{_libexecdir}/%{vdsm_name}/hooks/before_vm_start/50_pincpu

%files hook-promisc
%defattr(-, root, root, -)
%{_sysconfdir}/sudoers.d/50_vdsm_hook_promisc
%{_libexecdir}/%{vdsm_name}/hooks/after_vm_start/50_promisc
%{_libexecdir}/%{vdsm_name}/hooks/before_vm_destroy/50_promisc

%files hook-qos
%defattr(-, root, root, -)
%{_libexecdir}/%{vdsm_name}/hooks/before_vm_start/50_qos

%files hook-scratchpad
%defattr(-, root, root, -)
%{_libexecdir}/%{vdsm_name}/hooks/before_vm_start/50_scratchpad
%{_libexecdir}/%{vdsm_name}/hooks/before_vm_migrate_source/50_scratchpad
%{_libexecdir}/%{vdsm_name}/hooks/after_vm_destroy/50_scratchpad

%files hook-smbios
%defattr(-, root, root, -)
%{_libexecdir}/%{vdsm_name}/hooks/before_vm_start/50_smbios

%files hook-sriov
%defattr(-, root, root, -)
%{_sysconfdir}/sudoers.d/50_vdsm_hook_sriov
%{_libexecdir}/%{vdsm_name}/hooks/before_vm_start/50_sriov
%{_libexecdir}/%{vdsm_name}/hooks/after_vm_destroy/50_sriov
%{_libexecdir}/%{vdsm_name}/hooks/before_vm_migrate_source/50_sriov

%files hook-vmdisk
%defattr(-, root, root, -)
%{_libexecdir}/%{vdsm_name}/hooks/before_vm_start/50_vmdisk

%files hook-vmfex
%defattr(-, root, root, -)
%{_libexecdir}/%{vdsm_name}/hooks/before_vm_migrate_destination/50_vmfex
%{_libexecdir}/%{vdsm_name}/hooks/before_vm_start/50_vmfex

%files hook-vmfex-dev
%defattr(-, root, root, -)
%{_libexecdir}/%{vdsm_name}/hooks/before_device_create/50_vmfex
%{_libexecdir}/%{vdsm_name}/hooks/before_device_migrate_destination/50_vmfex
%{_libexecdir}/%{vdsm_name}/hooks/before_nic_hotplug/50_vmfex
%endif

%files debug-plugin
%defattr(-, root, root, -)
%{_datadir}/%{vdsm_name}/vdsmDebugPlugin.py*
%{_datadir}/%{vdsm_name}/debugPluginClient.py*

%files cli
%defattr(-, root, root, -)
%doc COPYING
%{_bindir}/vdsClient
%{_datadir}/%{vdsm_name}/vdsClient.py*
%{_datadir}/%{vdsm_name}/vdsClientGluster.py*
%{_sysconfdir}/bash_completion.d/vdsClient
%{_mandir}/man1/vdsClient.1*

%files xmlrpc
%defattr(-, root, root, -)
%dir %{_datadir}/%{vdsm_name}
%{_datadir}/%{vdsm_name}/BindingXMLRPC.py*

%files api
%doc vdsm_api/vdsm-api.html
%{_datadir}/%{vdsm_name}/vdsmapi-schema.json
%{python_sitelib}/vdsmapi.py*

%files jsonrpc
%{_datadir}/%{vdsm_name}/BindingJsonRpc.py*
%{_datadir}/%{vdsm_name}/Bridge.py*

%files yajsonrpc
%dir %{python_sitelib}/yajsonrpc
%{python_sitelib}/yajsonrpc/__init__.py*
%{python_sitelib}/yajsonrpc/asyncoreReactor.py*
%{python_sitelib}/yajsonrpc/protonReactor.py*
%{python_sitelib}/yajsonrpc/client.py*

%files python-zombiereaper
%{python_sitelib}/zombiereaper/__init__.py*

%files bootstrap
%defattr(-, root, root, -)
%doc COPYING
%{_datadir}/%{vdsm_bootstrap}

%files reg
%defattr(-, root, root, -)
%doc COPYING
%dir %{_sysconfdir}/%{vdsm_reg}
%dir %{_datadir}/%{vdsm_reg}
%config(noreplace) %{_sysconfdir}/logrotate.d/vdsm-reg
%config(noreplace) %{_sysconfdir}/%{vdsm_reg}/vdsm-reg.conf
%config(noreplace) %{_sysconfdir}/%{vdsm_reg}/logger.conf
%ghost %dir /data
%ghost %dir %attr(0775, root, root) /data/updates
%if 0%{?with_systemd}
/lib/systemd/systemd-vdsm-reg
%{_unitdir}/vdsm-reg.service
%else
%{_initrddir}/vdsm-reg
%endif
%{_datadir}/%{vdsm_reg}/vdsm-reg-setup
%{_datadir}/%{vdsm_reg}/vdsm-complete
%{_datadir}/%{vdsm_reg}/vdsm-gen-cert
%{_datadir}/%{vdsm_reg}/vdsm-upgrade
%{_datadir}/%{vdsm_reg}/config.py*
%{_datadir}/%{vdsm_reg}/deployUtil.py*
%attr(0755, -, -) %{_datadir}/%{vdsm_reg}/register-to-engine.py*
%{_datadir}/%{vdsm_reg}/createDaemon.py*
%{python_sitelib}/ovirt_config_setup/engine.py*
%{_datadir}/%{vdsm_reg}/save-config
%{_sysconfdir}/ovirt-config-boot.d/vdsm-config
%{_sysconfdir}/ovirt-commandline.d/vdsm-reg
%{_sysconfdir}/cron.hourly/vdsm-reg-logrotate
%{_mandir}/man8/vdsm-reg.8*

%defattr(-, %{vdsm_user}, %{vdsm_group},-)
%dir %{_var}/log/%{vdsm_reg}

%files hook-faqemu
%defattr(-, root, root, -)
%doc COPYING
%{_libexecdir}/%{vdsm_name}/hooks/before_vm_start/10_faqemu

%if 0%{?with_gluster}
%files gluster
%defattr(-, root, root, -)
%dir %{_datadir}/%{vdsm_name}/gluster
%doc COPYING
%{_datadir}/%{vdsm_name}/gluster/api.py*
%{_datadir}/%{vdsm_name}/gluster/vdsmapi-gluster-schema.json
%{_datadir}/%{vdsm_name}/gluster/hooks.py*
%{_datadir}/%{vdsm_name}/gluster/services.py*
%{_datadir}/%{vdsm_name}/gluster/tasks.py*
%endif

%changelog
* Wed May 07 2014 Douglas Schilling Landgraf <dougsland@redhat.com> - 4.14.8.1-0
- vdsm tag 4.14.8

* Thu Apr 24 2014 Douglas Schilling Landgraf <dougsland@redhat.com> - 4.14.7-0
- vdsm tag 4.14.7-0

* Tue Mar 25 2014 Douglas Schilling Landgraf <dougsland@redhat.com> - 4.14.6-0
- vdsm tag 4.14.6-0

* Sun Mar 09 2014 Yaniv Bronhaim <ybronhei@redhat.com> - 4.14.5-0
- Adding patches until 4.14.5 tag
- Urgent fix for 4.14.4 that included http-1.1 support for python 2.6 -
xmlrpc: [Fix] Use correct base class for parsing request

* Mon Feb 10 2014 Douglas Schilling Landgraf <dougsland@redhat.com> - 4.14.2-0
- vdsm 4.14.2-0

* Thu Feb 06 2014 Yaniv Bronhaim <ybronhei@redhat.com - 4.14.1-4
- Adding configure sanlock on force

* Wed Feb 05 2014 Douglas Schilling Landgraf <dougsland@redhat.com> - 4.14.1-3
- execCmd with sudo=root raise require tty fault when running as root
- sysvinit: Ensure that iscsid is started (BZ#1056948)
- Add missing libnl buildrequires dependency
- vdsm.spec: vdsm-python requires python-cpopen
- netconfig: set ETHTOOL_OPTS when a NIC goes up (BZ#1059680)
- sos: plugin should ignore /var/run/vdsm/storage
- vdsm.spec: vdsm should own vdsm.log (BZ#1055153)
- vdsm.spec: own metadata supervdsm mom logs (BZ#1055153)
- spec: do not remove vdsm logs when pkg removed (BZ#1055153)
- gluster: add host uuid in volume status
- gluster: interpret and use correct xml elements
- gluster: adopt xml changes of rebalance and remove-brick status
- vm: do not pause during refreshVolume (BZ#889097)
- spec: vdsm pkg for EL distro must include pkla (BZ#1060524)

* Tue Jan 21 2014 Douglas Schilling Landgraf <dougsland@redhat.com> - 4.14.1-2
- vdsm.spec: Add BuildRequires to python-argparse

* Mon Jan 20 2014 Douglas Schilling Landgraf <dougsland@redhat.com> - 4.14.1-1
- Rebuild 4.14.1 from ovirt-3.4

* Mon Jan 20 2014 Douglas Schilling Landgraf <dougsland@redhat.com> - 4.14.1-0
- Build 4.14.1-0

* Mon Jan 13 2014 Yaniv Bronhaim <ybronhei@redhat.com> - 4.13.3-1
- Reverting iscsi changes that caused a regression by importing
zombieReaper package which was not backported

* Mon Jan 13 2014 Yaniv Bronhaim <ybronhei@redhat.com> - 4.13.3
- spec: bumping iscsi-initiator-utils requirement
- removing redundant check-local from storage makefile
- Adding exception handling in external threads
- fix bridgeless broken network deletion
- gluster api fix
- fix log issues - Changed BrokerLink log level to prevent log flooding
- sampling: make HostStatsThread a daemon thread
- bugfix - BindingXMLRpc - Return lastClientIface for current connection
- vm: Bring back missing before_device_migrate_source hook call
- update NIC: having no custom properies is valid
- prepareVolumePath payload misdetection fix
- fileSD: Fix image deletion on gluster domain
- vm: Update domains list for disks attached to vm after LSM
- prepareVolumePath correct path handling for cdrom

* Wed Dec 11 2013 Yaniv Bronhaim <ybronhei@redhat.com> - 4.13.2-1
- fix cpopen obsolete loop
- fix threadPool refs
- mom policy fixes
- restorecon hack in spec file
- domainMonitor fixed last check flow

* Tue Dec 10 2013 Yaniv Bronhaim <ybronhei@redhat.com> - 4.13.2-0
- Bumping minor version due to recent merge of ovirt-3.3 patches

* Thu Nov 28 2013 Yaniv Bronhaim <ybronhei@redhat.com> - 4.13.0-14
- Adding update patches from branch ovirt-3.3
- Declaring ovirt-3.3.2 patchsets scope in spec which declares all the merged
new patches

* Tue Nov 12 2013 Douglas Schilling Landgraf <dougsland@redhat.com> - 4.13.0-11
- update from branch ovirt-3.3 which include:
  upgrade-fix-v3ResetMetaVolSize-argument
  lvm-Do-not-use-udev-cache-for-obtaining-device-list
  Fix-ballooning-rules-for-computing-the-minimum-avail
  Avoid-M2Crypto-races
  spec-declare-we-provide-an-existing-python-cpopen
  configuring-selinux-allowing-qemu-kvm-to-generate-co

* Tue Nov 12 2013 Douglas Schilling Landgraf <dougsland@redhat.com> - 4.13.0-10
- Fix requires on post for hostname.

* Tue Nov 05 2013 Douglas Schilling Landgraf <dougsland@redhat.com> - 4.13.0-9
- Build 4.13.0-9 from branch ovirt-3.3

* Wed Oct 30 2013 Cole Robinson <crobinso@redhat.com> - 4.12.1-5
- Fix broken hostname dep on rawhide

* Thu Oct 10 2013 Douglas Schilling Landgraf <dougsland@redhat.com> 4.12.1-4
- remoteFileHandler: Add create exclusive option for truncateFile (BZ#979193)
- oop: improve safety for truncateFile

* Tue Oct 08 2013 Douglas Schilling Landgraf <dougsland@redhat.com> 4.12.1-3
- vm.Vm._getUnderlyingDriveInfo: extract path of gluster disks (BZ#1007980)
- Require libvirt that allows vmUpdateDevice (BZ#1001001)
- imageSharing: return proper size in httpGetSize
- vdsmd.init: Add service-is-managed in shutdown_conflicting_srv (BZ#1006842)

* Tue Sep 10 2013 Federico Simoncelli <fsimonce@redhat.com> 4.12.1-2
- systemd init: no need to stop conflicting services (BZ#999664)

* Tue Aug 27 2013 Federico Simoncelli <fsimonce@redhat.com> 4.12.1-1
- update to 4.12.1

* Thu Aug 22 2013 Federico Simoncelli <fsimonce@redhat.com> 4.12.0-2
- Fix GlusterFS RPM dep to support GlusterFS SD (BZ#988299)

* Tue Aug 13 2013 Federico Simoncelli <fsimonce@redhat.com> 4.12.0-1
- update to 4.12.0 final release
- mom: Require latest mom
- Mark ksmtuned as conflicting service in the init file
- spec: vdsm-hook-sriov on el6 should not require
- Crash fix for migrations that involve devices with no aliases (BZ#988065)
- vdsm: Always retrieve alias for Balloon and Console (BZ#988065)
- vdsm: Fix regression introduced by refactoring (BZ#985735)
- VDSM now writes its version number in VDSM-generated
- Bump requires version of selinux-policy-targeted
- vdsm_reg: fix ovirt_node without default bridge (BZ#988990)
- Source Route script now checks that the DHCP response (BZ#994600)
- Management network is now kept in main routing table (BZ#984028)
- Only remove dhcp source routing if the removal reason (BZ#995142)
- image: use successor volume size when merging

* Sun Aug 04 2013 Fedora Release Engineering <rel-eng@lists.fedoraproject.org> - 4.12.0-0.2.rc3
- Rebuilt for https://fedoraproject.org/wiki/Fedora_20_Mass_Rebuild

* Tue Jul 23 2013 Federico Simoncelli <fsimonce@redhat.com> 4.12.0-0.1.rc3
- update to vdsm-4.12.0-rc3

* Wed Jul 10 2013 Douglas Schilling Landgraf <dougsland@redhat.com> 4.10.3-18
- vdsm.spec: update python-pthreading 
- service: make iscsid a systemd dependency

* Tue Jun 4 2013 Douglas Schilling Landgraf <dougsland@redhat.com> 4.10.3-17
- Makefile.am: ignore false positive pyflakes lvm.py
- Deactivate libvirtVM.Drives()
- vdsm: fix Vm cleanup routine
- Support teardownVolumePath(None)

* Tue Apr 23 2013 Federico Simoncelli <fsimonce@redhat.com> 4.10.3-16
- Don't user sudo in fuser
- svdsm: fix fuser import in supervdsmServer
- Removing vdsm configuration when removing vdsm service
- Seperating supervdsm log to supervdsm.log file
- vdsm.spec: Adding with_systemd macro
- spec: use the fedora systemd macros
- spec: enable gluster upstream and on fedora 19

* Tue Apr  9 2013 Federico Simoncelli <fsimonce@redhat.com> 4.10.3-15
- fix the patches backported to ovirt-3.2
- resync the fedora spec file with the upstream one

* Mon Apr  8 2013 Federico Simoncelli <fsimonce@redhat.com> 4.10.3-14
- fix storage.fuser
- Bump up libvirt version to fix network linking.

* Wed Apr 3 2013 Douglas Schilling Landgraf <dougsland@redhat.com> 4.10.3-13
- Temporarily deactivate Gluster sub-package.

* Tue Mar 26 2013 Douglas Schilling Landgraf <dougsland@redhat.com> 4.10.3-12
- Applying direct to spec the fence-agents changes and removing the patch.

* Mon Mar 25 2013 Douglas Schilling Landgraf <dougsland@redhat.com> 4.10.3-11
- adapt vdsm.spec to new fence-agents package name.

* Thu Mar 14 2013 Federico Simoncelli <fsimonce@redhat.com> 4.10.3-10
- gluster: Handling Attribute error in Python 2.6
- bootstrap: remove glusterfs packages
- gluster: set glusterfs dependency version
- Do not delete the template when zeroing a dependant

* Wed Feb 27 2013 Federico Simoncelli <fsimonce@redhat.com> 4.10.3-9
- packaging: add load_needed_modules.py.in
- tool: _enable_bond_dev: reopen bonding_masters per bond

* Tue Feb 19 2013 Federico Simoncelli <fsimonce@redhat.com> 4.10.3-8
- configNet: allow delete/update of devices with no ifcfg (#906383)
- Requires policycoreutils-2.1.13-55 to avoid another
- After fail to connect to supervdsm more than 3 time

* Thu Feb 14 2013 Federico Simoncelli <fsimonce@redhat.com> 4.10.3-7
- Fedora 18: require a newer udev (applied properly to the fedora specfile)

* Wed Jan 30 2013 Federico Simoncelli <fsimonce@redhat.com> 4.10.3-6
- Explicitly shutdown  m2crypto socket
- spec: require policycoreutils and skip sebool errors
- spec: requires selinux-policy to avoid selinux failure
- vdsmd.service: require either ntpd or chronyd
- isRunning didn't check local variable before reading
- udev: Race fix- load and trigger dev rule (#891300)
- Change scsi_id command path to be configured at runtime (#886087)
- upgrade: force upgrade to v2 before upgrading to v3 (#893184)
- misc: rename safelease to clusterlock
- domain: select the cluster lock using makeClusterLock
- clusterlock: add the local locking implementation (#877715)
- upgrade: catch MetaDataKeyNotFoundError when preparing
- vdsm.spec: Require openssl (#905728)
- Fedora 18: require a newer udev
- fix sloppy backport of safelease rename
- removing the use of zombie reaper from supervdsm

* Fri Jan 18 2013 Douglas Schilling Landgraf <dougsland@redhat.com> 4.10.3-5
- Searching for both py and pyc file to start super vdsm
- adding getHardwareInfo API to vdsm

* Tue Jan 15 2013 Douglas Schilling Landgraf <dougsland@redhat.com> 4.10.3-4
- python-ordereddict only for rhel more then 7
- dont require python ordereddict on fedora
- BuildRequires python-pthreading

* Wed Jan 02 2013 Federico Simoncelli <fsimonce@redhat.com> 4.10.3-3
- caps.py: osversion() validate OVIRT
- restarting libvirtd didn't work over allinone setup
- Integrate Smartcard support

* Thu Dec 27 2012 Federico Simoncelli <fsimonce@redhat.com> 4.10.3-2
- api: Report CPU thread info in getVdsCapabilities
- schema: Missing comment for new VmDeviceType
- schema: Fix schema for VM.updateDevice

* Wed Dec 12 2012 Federico Simoncelli <fsimonce@redhat.com> 4.10.3-1
- vdsm-4.10.3

* Mon Nov 5 2012 Douglas Schilling Landgraf <dougsland@redhat.com> 4.10.1-100.gf2f6683
- vdsm-4.10.1-100-gf2f6683

* Wed Oct 31 2012 Douglas Schilling Landgraf <dougsland@redhat.com> 4.10.1-1
- vdsm-4.10.1
- merged vdsm.spec from f17 with last upstream vdsm.spec

* Wed Oct 24 2012 Federico Simoncelli <fsimonce@redhat.com> 4.10.0-12
- configure selinux for sanlock on nfs

* Sat Oct 20 2012 Peter Robinson <pbrobinson@fedoraproject.org> 4.10.0-11
- Merge F17 changes into F18+ and disable make check due to pep8 issues
- Add pyparted dependency

* Thu Oct  4 2012 Federico Simoncelli <fsimonce@redhat.com> 4.10.0-10
- BZ#845660 Use buffer size in multiplies of the recommended transfer size

* Mon Sep 24 2012 Federico Simoncelli <fsimonce@redhat.com> 4.10.0-9
- BZ#845660 Use the recommended alignment instead of using pagesize

* Tue Sep 11 2012 Federico Simoncelli <fsimonce@redhat.com> 4.10.0-8
- add the autotools support

* Fri Aug 17 2012 Federico Simoncelli <fsimonce@redhat.com> 4.10.0-7
- enable all the vdsm hooks

* Wed Aug  1 2012 Federico Simoncelli <fsimonce@redhat.com> 4.10.0-6
- BZ#842948: deployUtil - safely remove bridge

* Tue Jul 17 2012 Federico Simoncelli <fsimonce@redhat.com> 4.10.0-5
- configNet: atomicBackup: remove new files upon restore
- configNet: clear up atomicBackup arg
- Remove redundant 'explicitBonding' parameter from setupNetworks
- BZ#837054 - Do not detach network from the bond during bond resize
- BZ#836954 - Allow to break bond and create a new network on its interface in single action.
- BZ#837443: remove bridge before add VDSM bridge
- BZ#837443: removeVlan() drop/remove interface
- configNetwork: fix NetInfo call
- BZ#837443: replace the netinfo import
- BZ#837443: removeBridge() drop/remove interface
- ovirt_functions: fix elif statement
- BZ#838097 _addNetworkValidation: do not explode if STP/DNS1 option passed
- BZ#832199: move selinux from init to spec
- bump libvirt version to fix readonly lease unsupported issue

* Fri Jun 29 2012 Federico Simoncelli <fsimonce@redhat.com> 4.10.0-4
- deployUtil: use os.uname instead of /bin/uname
- deployUtil: slightly saner kernel version comparison
- BZ#835784 - Allow to create a network on top of existing bond in additional
  to create a new bond and network
- BZ#833119 - Allow to create VLANed network on top of existing bond
- BZ#833803 - Avoid bond breaking after network detach
- Handle bond properly if connectivity check fail.
- BZ#806555 having /etc/ovirt-node-* means it is a node

* Tue Jun 26 2012 Federico Simoncelli <fsimonce@redhat.com> 4.10.0-3
- BZ#832577: node can't be approved
- BZ#824298 fix typo in keyword argument exc_info

* Wed Jun 20 2012 Federico Simoncelli <fsimonce@redhat.com> 4.10.0-2
- deployUtil.yumFind: rename and simplify semantics
- drop deployUtil.yumSearch
- deployUtil.yumSearchVersion: compare versions sanely
- Iterates over delete candidates networks only once
- 'options' translation in setupNetworks is not relevant
- Minor optimization for delNetwork
- Don't ignore bridgeless networks in ifaceUsers
- Minor optimization for addNetwork
- Use already known iface in addNetwork
- Use proper MTU on bonding when add network
- Add bridge on top of VLAN if exists
- BZ#830485 - Add netConfigDirty bit to getVdsCaps report
- remove flag skipLibvirt
- BZ#826873 - Allow to change bond without network attached to it
- BZ#830486 - Allow to change network according the diffs from previous state
- BZ#826467 - Allow to remove bond and attach network to NIC
- Related to BZ#826873 - Allow to create bond without network

* Mon Jun 11 2012 Federico Simoncelli <fsimonce@redhat.com> 4.10.0-1
- vdsm-4.10.0

* Mon Jun  4 2012 Federico Simoncelli <fsimonce@redhat.com> 4.9.6-2.gite952471
- BZ#822158 Report version-release in a short format

* Mon Jun  4 2012 Federico Simoncelli <fsimonce@redhat.com> 4.9.6-1.gite952471
- vdsm-4.9.6-ge952471

* Mon May 28 2012 Federico Simoncelli <fsimonce@redhat.com> 4.9.6-0.git1b07249
- vdsm-4.9.6-g1b07249

* Tue Feb 28 2012 Dan Kenigsberg <danken@redhat.com> - 4.9.4-0.gb3642e5
- vdsm-4.9.4-0.gb3642e5

* Wed Jan 25 2012 Dan Kenigsberg <danken@redhat.com> - 4.9.3.2-0
- vdsm-4.9.3.2
- Reverts "BZ#773666 - Fix HSM flows should not change rw permissions."

* Mon Jan 16 2012 Federico Simoncelli <fsimonce@redhat.com> - 4.9.3.1-0
- vdsm-4.9.3.1

* Fri Jan 13 2012 Dan Kenigsberg <danken@redhat.com> - 4.9.2-1.git1d7b929
- vdsm-4.9.2-g1d7b929

* Tue Jan 10 2012 Federico Simoncelli <fsimonce@redhat.com> - 4.9.2-0.git951b41d
- vdsm-4.9.2-g951b41d

* Fri Dec 02 2011 Federico Simoncelli <fsimonce@redhat.com> - 4.9.1-2.git931a43e
- add the revision control comments to the specfile

* Wed Nov 30 2011 Federico Simoncelli <fsimonce@redhat.com> - 4.9.1-1.git6ee166c
- require iscsi-initiator-utils >= 6.2.0.872-14 bz442980
- fix the rpmlint errors

* Wed Oct 12 2011 Federico Simoncelli <fsimonce@redhat.com> - 4.9.0-0
- Initial upstream release

* Thu Nov 02 2006 Simon Grinberg <simong@qumranet.com> -  0.0-1
- Initial build
