#
# Licensed to the Apache Software Foundation (ASF) under one or more
# contributor license agreements.  See the NOTICE file distributed with
# this work for additional information regarding copyright ownership.
# The ASF licenses this file to You under the Apache License, Version 2.0
# (the "License"); you may not use this file except in compliance with
# the License.  You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

%global		package_version 3.5.1
%global		package_name ovirt-log-collector

Summary:	Log Collector for oVirt Engine
Name:		%{package_name}
Version:	3.5.1
Release:	1%{?release_suffix}%{?dist}
License:	ASL 2.0
URL:		http://www.ovirt.org
Source:		http://resources.ovirt.org/pub/ovirt-3.5/src/%{package_name}/%{package_name}-%{package_version}.tar.gz

BuildRoot:	%{_tmppath}/%{name}-%{version}-%{release}-root-%(%{__id_u} -n)
BuildArch:	noarch
Requires:	python
Requires:	python-dateutil
Requires:	python-lxml
Requires:	ovirt-engine-sdk-python >= 3.5.1.0
Requires:	ovirt-engine-lib
Requires:	logrotate
Requires:	openssh-clients

%if 0%{?fedora} || 0%{?rhel} >= 7
Requires:	sos >= 3.1-1.1
%else
Requires:	sos < 3
%endif

BuildRequires:	python2-devel
BuildRequires:	gettext

%if 0%{?fedora} || 0%{?rhel} >= 7
BuildRequires:	sos >= 3
%else
BuildRequires:	sos < 3
%endif



%description
Log Collector tool for oVirt Engine

%prep
%setup -q -n %{package_name}-%{package_version}

%build
%configure \
	--docdir="%{_docdir}/%{package_name}-%{version}" \
	--disable-python-syntax-check
make %{?_smp_mflags}

%install
rm -rf "%{buildroot}"
make %{?_smp_mflags} install DESTDIR="%{buildroot}"


%files
%doc AUTHORS
%doc COPYING
%dir %{_localstatedir}/log/ovirt-engine/%{package_name}
%dir %{_sysconfdir}/ovirt-engine/logcollector.conf.d
%config(noreplace) %{_sysconfdir}/ovirt-engine/logcollector.conf
%config(noreplace) %{_sysconfdir}/logrotate.d/%{package_name}
%{python_sitelib}/ovirt_log_collector/

%if 0%{?rhel}
%if 0%{?rhel} < 7
%{python_sitelib}/sos/plugins/*.py*
%endif
%endif


%{_bindir}/engine-log-collector
%{_mandir}/man8/*

%changelog
* Mon Jan 19 2015 Sandro Bonazzola <sbonazzo@redhat.com> - 3.5.1-1
- 3.5.1-1

* Fri Sep 19 2014 Sandro Bonazzola <sbonazzo@redhat.com> - 3.5.1-0.0.master
- 3.5.1-0.0.master

* Fri Sep 19 2014 Sandro Bonazzola <sbonazzo@redhat.com> - 3.5.0-1
- 3.5.0-1

* Fri Jul 11 2014 Sandro Bonazzola <sbonazzo@redhat.com> - 3.5.0-0.1.master
- 3.5.0-0.1.master

* Fri Jan 17 2014 Sandro Bonazzola <sbonazzo@redhat.com> - 3.5.0-0.0.master
- 3.5.0-0.0.master
