#
# Licensed to the Apache Software Foundation (ASF) under one or more
# contributor license agreements.  See the NOTICE file distributed with
# this work for additional information regarding copyright ownership.
# The ASF licenses this file to You under the Apache License, Version 2.0
# (the "License"); you may not use this file except in compliance with
# the License.  You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

%if 0%{?rhel} && 0%{?rhel} <= 6
%{!?__python2: %global __python2 /usr/bin/python2}
%{!?python2_sitelib: %global python2_sitelib %(%{__python2} -c "from distutils.sysconfig import get_python_lib; print(get_python_lib())")}
%{!?python2_sitearch: %global python2_sitearch %(%{__python2} -c "from distutils.sysconfig import get_python_lib; print(get_python_lib(1))")}
%endif

%global		package_version 3.6.1
%global		package_name ovirt-image-uploader
# Required users and groups
%global		vdsm_user vdsm
%global		vdsm_group kvm

Summary:	Image Uploader for oVirt Engine
Name:		%{package_name}
Version:	3.6.1
Release:	1%{?release_suffix}%{?dist}
License:	ASL 2.0
URL:		http://www.ovirt.org
Source0:	http://resources.ovirt.org/pub/ovirt-3.6/src/%{package_name}/%{package_name}-%{package_version}.tar.gz

BuildRoot:	%{_tmppath}/%{name}-%{version}-%{release}
BuildArch:	noarch
Requires:	python
Requires:	python-lxml
Requires(pre):	shadow-utils
Requires:	ovirt-engine-sdk-python >= 3.6.0.2
Requires:	logrotate
BuildRequires:	gettext
BuildRequires:	python2-devel
BuildRequires:	python-lxml

%description
Image Uploader tool for oVirt Engine

%prep
%setup -q -n %{package_name}-%{package_version}

%build
%configure \
	--docdir="%{_docdir}/%{package_name}-%{version}" \
	--disable-python-syntax-check

make %{?_smp_mflags}

%check
make check

%pre
getent group %{vdsm_group} >/dev/null || \
	LC_ALL=C groupadd -g 36 -r %{vdsm_group}
getent passwd %{vdsm_user} >/dev/null || \
	LC_ALL=C useradd -r -u 36 -g %{vdsm_group} -d / \
		-s /sbin/nologin -c "Node Virtualization Manager" %{vdsm_user}

%install
rm -rf "%{buildroot}"
make %{?_smp_mflags} install DESTDIR="%{buildroot}"

%files
%doc AUTHORS
%doc COPYING
%dir %{_localstatedir}/log/ovirt-engine/%{package_name}
%dir %{_sysconfdir}/ovirt-engine/imageuploader.conf.d
%attr(0640, -, -) %config(noreplace) %{_sysconfdir}/ovirt-engine/imageuploader.conf
%config(noreplace) %{_sysconfdir}/logrotate.d/%{package_name}
%{python2_sitelib}/ovirt_image_uploader/*.py*
%{python2_sitelib}/ovirt_image_uploader/ovf/*.py*
%{_bindir}/engine-image-uploader
%{_mandir}/man8/*

%changelog
* Tue Aug 23 2016 Sandro Bonazzola <sbonazzo@redhat.com> - 3.6.1-1
- 3.6.1-1

* Tue Oct  6 2015 Sandro Bonazzola <sbonazzo@redhat.com> - 3.6.1-0.0.master
- 3.6.1-0.0.master

* Tue Sep 22 2015 Sandro Bonazzola <sbonazzo@redhat.com> - 3.6.0-1
- 3.6.0-1

* Thu Dec 18 2014 Sandro Bonazzola <sbonazzo@redhat.com> - 3.6.0-0.0.master
- 3.6.0-0.0.master
