#
# ovirt-release -- repo files for oVirt projects
# Copyright (C) 2015 Red Hat, Inc.
#
# This library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public
# License as published by the Free Software Foundation; either
# version 2.1 of the License, or (at your option) any later version.
#
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public
# License along with this library; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
#

%global	package_version 002
%global	package_name ovirt-release36
%global	ovirt_version 3.6
%global	ovirt_yum_repo http://resources.ovirt.org
%global	ovirt_repo_path_normal /pub/yum-repo/mirrorlist-ovirt-3.6-snapshot-
%global	ovirt_repo_path_static /pub/yum-repo/mirrorlist-ovirt-3.6-snapshot-static-
%global	repo_url_key mirrorlist


Name:		%{package_name}
Version:	002
Release:	2%{?release_suffix}
Summary:	oVirt repository configuration
Group:		System Environment/Base

License:	ASL 2.0
URL:		http://www.ovirt.org
Source0:	http://resources.ovirt.org/pub/src/%{package_name}/%{package_name}-%{package_version}.tar.gz
Source1:	http://resources.ovirt.org/pub/keys/RPM-GPG-ovirt

BuildRoot:	%{_tmppath}/%{name}-%{version}-%{release}
BuildArch:	noarch

BuildRequires:	automake
BuildRequires:	autoconf
Requires:	system-release
Requires:	tar

%description
This package contains the yum configuration for oVirt repositories

%package snapshot
Summary:	oVirt snapshot repository configuration
Group:		System Environment/Base
Requires:	%{package_name}


%description snapshot
This package contains the yum configuration for oVirt snapshot repositories


%prep
%setup -q -n "%{package_name}-%{package_version}"

%build
%configure \
	--with-ovirt-yum-repo=%{ovirt_yum_repo} \
	--with-repo-url-key=%{repo_url_key} \
	--with-repo-path-normal=%{ovirt_repo_path_normal} \
	--with-repo-path-static=%{ovirt_repo_path_static}
make "%{?_smp_mflags}"


%install
rm -rf "%{buildroot}"
%make_install
#Allow ghost files
install -d 755 "%{buildroot}%{_sysconfdir}/yum.repos.d"
install -d "%{buildroot}%{_sysconfdir}/pki/rpm-gpg"
install -m 644 "%{SOURCE1}" "%{buildroot}%{_sysconfdir}/pki/rpm-gpg/RPM-GPG-ovirt-%{ovirt_version}"
touch "%{buildroot}%{_sysconfdir}/yum.repos.d/ovirt-%{ovirt_version}.repo"
touch "%{buildroot}%{_sysconfdir}/yum.repos.d/ovirt-%{ovirt_version}-snapshot.repo"
touch "%{buildroot}%{_sysconfdir}/yum.repos.d/ovirt-%{ovirt_version}-dependencies.repo"

%post

# Adjust repos as per dist and version
DIST=fc
#Fedora is good for both Fedora and Generic (and probably other based on Fedora)
#Handling EL exception only (for now)
DISTVER="$(rpm --eval "%%dist"|cut -c2-)"
if rpm --eval "%%dist" | grep -qFi 'el'; then
    DIST=el
fi

if [[ "${DISTVER}" == "el6" ]]; then
    install -m 644 "%{_datadir}/%{package_name}/ovirt-el6-deps.repo" "%{_sysconfdir}/yum.repos.d/ovirt-%{ovirt_version}-dependencies.repo"
elif [[ "${DISTVER::3}" == "el7" ]] ; then
    # On some systems [el7_1], take only 3 1st chars: ${var::3}
    install -m 644 "%{_datadir}/%{package_name}/ovirt-el7-deps.repo" "%{_sysconfdir}/yum.repos.d/ovirt-%{ovirt_version}-dependencies.repo"
elif [[ "${DISTVER}" == "fc21" ]]; then
    install -m 644 "%{_datadir}/%{package_name}/ovirt-f21-deps.repo" "%{_sysconfdir}/yum.repos.d/ovirt-%{ovirt_version}-dependencies.repo"
elif [[ "${DISTVER}" == "fc22" ]]; then
    install -m 644 "%{_datadir}/%{package_name}/ovirt-f22-deps.repo" "%{_sysconfdir}/yum.repos.d/ovirt-%{ovirt_version}-dependencies.repo"
elif [[ "${DISTVER}" == "fc23" ]]; then
    install -m 644 "%{_datadir}/%{package_name}/ovirt-f23-deps.repo" "%{_sysconfdir}/yum.repos.d/ovirt-%{ovirt_version}-dependencies.repo"
fi

sed \
    -e "s/@DIST@/${DIST}/g; s/@URLKEY@/%{repo_url_key}/g" \
    <"%{_datadir}/%{package_name}/ovirt.repo" > "%{_sysconfdir}/yum.repos.d/ovirt-%{ovirt_version}.repo"

%post snapshot

# Adjust repos as per dist and version
DIST=fc
#Fedora is good for both Fedora and Generic (and probably other based on Fedora)
#Handling EL exception only (for now)
DISTVER="$(rpm --eval "%%dist"|cut -c2-)"
if rpm --eval "%%dist" | grep -qFi 'el'; then
    DIST=el
fi

sed \
    -e "s/@DIST@/${DIST}/g; s/@URLKEY@/%{repo_url_key}/g" \
    <"%{_datadir}/%{package_name}/ovirt-snapshot.repo" > "%{_sysconfdir}/yum.repos.d/ovirt-%{ovirt_version}-snapshot.repo"


%files
%defattr(-,root,root,-)
%{_datadir}/%{package_name}/
%{_sysconfdir}/pki/rpm-gpg/RPM-GPG-ovirt-%{ovirt_version}
# We do not know what distribution we are installed at,
# we copy the actual files at post, but still wants this package to own them.
# ghost in this case solves that issue
%ghost %config(noreplace) %{_sysconfdir}/yum.repos.d/ovirt-%{ovirt_version}.repo
%ghost %config(noreplace) %{_sysconfdir}/yum.repos.d/ovirt-%{ovirt_version}-dependencies.repo

%files snapshot
%defattr(-,root,root,-)
%ghost %config(noreplace) %{_sysconfdir}/yum.repos.d/ovirt-%{ovirt_version}-snapshot.repo


%changelog
* Wed Nov 11 2015 Sandro Bonazzola <sbonazzo@redhat.com> - 002-2
- Allow ovirt-guest-agent sub packages to be installed from EPEL

* Tue Nov 10 2015 Sandro Bonazzola <sbonazzo@redhat.com> - 002-1
- Updated Gluster repositories GPG key URL
- Added Fedora 23

* Wed Nov  4 2015 Sandro Bonazzola <sbonazzo@redhat.com> - 001-2
- oVirt 3.6.0 GA release

* Thu Oct 29 2015 Sandro Bonazzola <sbonazzo@redhat.com> - 001-1
- 001-1

* Wed Sep  2 2015 Sandro Bonazzola <sbonazzo@redhat.com> - 001-0.5.beta
- Fixed post section for snapshot sub-package

* Thu Jul  9 2015 Sandro Bonazzola <sbonazzo@redhat.com> - 001-0.4.beta
- Dropped Fedora 20
- Added nightly snapshot repositories

* Thu Jul  9 2015 Sandro Bonazzola <sbonazzo@redhat.com> - 001-0.3.alpha
- Added pyxattr and userspace-rcu to EPEL 6 repository for Gluster 3.7.2

* Fri May 22 2015 Sandro Bonazzola <sbonazzo@redhat.com> - 001-0.2.alpha
- Drop Gluster 3.7 Nightly repository since 3.7.0 GA is available
- Add VirtIO-Win Stable repository

* Tue May  5 2015 Sandro Bonazzola <sbonazzo@redhat.com> - 001-0.1.alpha
- Initial packaging for oVirt 3.6.0 First Alpha release
