/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.j2ee;

import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.checks.j2ee.EntityBeanCheck;
import com.puppycrawl.tools.checkstyle.checks.j2ee.EntityBeanMethodChecker;
import com.puppycrawl.tools.checkstyle.checks.j2ee.Utils;

public class ContainerManagedMethodChecker
extends EntityBeanMethodChecker {
    public ContainerManagedMethodChecker(EntityBeanCheck aCheck) {
        super(aCheck);
    }

    public void checkMethod(DetailAST aMethodAST) {
        super.checkMethod(aMethodAST);
        DetailAST nameAST = aMethodAST.findFirstToken(58);
        String name = nameAST.getText();
        if (name.startsWith("ejbSelect")) {
            this.checkSelectMethod(aMethodAST);
        }
    }

    protected void checkSelectMethod(DetailAST aMethodAST) {
        if (!Utils.isPublic(aMethodAST)) {
            this.log(aMethodAST, "nonpublic.bean", new Object[]{"Method"});
        }
        if (!Utils.isAbstract(aMethodAST)) {
            this.log(aMethodAST, "nonabstract.bean", new Object[]{"Method"});
        }
        this.checkThrows(aMethodAST, "javax.ejb.FinderException");
    }

    protected void checkCreateMethod(DetailAST aMethodAST) {
        super.checkCreateMethod(aMethodAST);
        this.checkThrows(aMethodAST, "javax.ejb.CreateException");
    }
}

