#
# vdsm-jsonrpc-java - vdsm json rpc
# Copyright (C) 2013 Red Hat, Inc.
#
# This library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public
# License as published by the Free Software Foundation; either
# version 2.1 of the License, or (at your option) any later version.
#
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public
# License along with this library; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
#

%global		package_version 1.1.6
%global		package_maven_version 1.1.6
# Version 1.9 of jackson currently no available for rhel or centos

%if 0%{?fedora:1}
%global	_use_maven 1
%global	_use_mockito 1
%global	jackson_deps_available 1
%endif
%if 0%{?rhel:1}
%if %{rhel} >= 7
%global	_mvn_opts -Pno-test
%global	_use_maven 1
%global	_use_mockito 0
%global	jackson_deps_available 1
%else
%global	_use_maven 0
%global	_use_repolib 1
%global	maven2brewrepodir %{_javadir}/repository.jboss.com/maven2-brew/dummy
%global	jackson_deps_available 0
%endif
%endif

Summary:	oVirt JsonRpc java client (%{name})
Name:		vdsm-jsonrpc-java
Version:	1.1.6
Release:	1%{?release_suffix}%{?dist}
License:	LGPLv2+
URL:		http://www.ovirt.org
Source:		http://resources.ovirt.org/pub/ovirt-3.5-snapshot/src/%{name}/%{name}-%{package_version}.tar.gz
Group:		Development/Libraries

BuildRoot:	%{_tmppath}/%{name}-%{version}-%{release}-root-%(%{__id_u} -n)
BuildArch:	noarch


%if 0%{?rhel}
%if 0%{?rhel} >= 7
BuildRequires:	java-devel >= 1.7.0
%else
BuildRequires:	java7-devel
%endif
%endif
%if 0%{?fedora}
BuildRequires:	java-devel >= 1.7.0
%endif

Requires:	java-openjdk >= 1.7.0

BuildRequires:	slf4j >= 1.7.0
Requires:	slf4j >= 1.7.0

%if %{_use_maven}
BuildRequires:	jackson
BuildRequires:	junit
BuildRequires:	maven-compiler-plugin
BuildRequires:	maven-enforcer-plugin
BuildRequires:	maven-install-plugin
BuildRequires:	maven-jar-plugin
BuildRequires:	maven-javadoc-plugin
BuildRequires:	maven-local
BuildRequires:	maven-source-plugin
BuildRequires:	maven-surefire-provider-junit
%if %{_use_mockito}
BuildRequires:	mockito
%endif
Requires:	jackson
%else
BuildRequires:	junit4
# Package not in rhel. it is only build time, at this point (until rhel-7) we can accept that
# BuildRequires:	mockito
%if %{jackson_deps_available}
BuildRequires:	codehaus-jackson-core-asl
BuildRequires:	codehaus-jackson-mapper-asl
Requires:	jackson >= 1.9
%endif
%endif

%description
vdsm jsonrpc java

%if %{_use_maven}
%package javadoc
Summary:	Javadocs for %{name}
Group:		Documentation

%description javadoc
This package contains the API documentation for %{name}.
%endif

%if 0%{?_use_repolib:1}
%package repolib
Summary:	%{name} maven repo
%description repolib
%{name} maven repo
%endif

%prep
%setup -q -n %{name}-%{package_version}

%build
%if %{_use_maven}
%global conf --with-maven --disable-java-build
%else
%if !%{jackson_deps_available}
%global conf --with-maven --enable-java-build
%else
%global conf \\\
	JACKSON_CORE_ASL=$(build-classpath codehaus-jackson/jackson-core-asl) \\\
	JACKSON_MAPPER_ASL=$(build-classpath codehaus-jackson/jackson-mapper-asl) \\\
	SLF4J_JAR=$(build-classpath slf4j) \\\
	JAVAC=/usr/lib/jvm/java-1.7.0/bin/javac \\\
	JAR=/usr/lib/jvm/java-1.7.0/bin/jar \\\
	%{?null}
%endif
%endif
%configure %{?conf}
make %{?_smp_mflags}

%if %{_use_maven}
%mvn_build -- %{?_mvn_opts}
%endif

%install
%if 0%{?_use_repolib:1}
rm -rf "%{buildroot}"
%endif
make %{?_smp_mflags} install DESTDIR="%{buildroot}"

%if %{_use_maven}
%mvn_install
%else
install -d "%{buildroot}%{_javadir}/%{name}"
FILE=$(ls -1 target/%{name}-client*.jar | grep -v source | grep -v javadoc | xargs -n 1 basename)
install target/$FILE %{buildroot}%{_javadir}/%{name}
ln -s $FILE %{buildroot}%{_javadir}/%{name}/%{name}-client.jar
%endif

%if 0%{?_use_repolib:1}
install -d "%{buildroot}%{maven2brewrepodir}/root"
install -d "%{buildroot}%{maven2brewrepodir}/%{name}"
cp pom.xml "%{buildroot}%{maven2brewrepodir}/root/root-%{package_maven_version}.pom"
cp "%{buildroot}%{_javadir}/%{name}/%{name}-client.jar" "%{buildroot}%{maven2brewrepodir}/%{name}/%{name}-client-%{package_maven_version}.jar"
cp client/pom.xml "%{buildroot}%{maven2brewrepodir}/%{name}/%{name}-client-%{package_maven_version}.pom"
%endif

%if %{_use_maven}
%files -f .mfiles
%dir %{_javadir}/%{name}
%else
%files
%dir %{_javadir}/%{name}
%{_javadir}/%{name}/%{name}*.jar
%endif

%if %{_use_maven}
%files javadoc -f .mfiles-javadoc
%endif

%if 0%{?_use_repolib:1}
%files repolib
%{maven2brewrepodir}/
%endif

%changelog
* Fri Jan 8 2016 Piotr Kliczewski <pkliczew@redhat.com> 1.1.6-1
- scheduled tasks do not check whether a channel is there
- i/o thread blocked during connection

* Thu Sep 24 2015 Piotr Kliczewski <pkliczew@redhat.com> 1.1.5-1
- Releasing for RC

* Wed Jun 10 2015 Piotr Kliczewski <pkliczew@redhat.com> 1.1.2-1
- Introduced new queue for events

* Mon Apr 20 2015 Piotr Kliczewski <pkliczew@redhat.com> 1.1.1
- Introduction of Events

* Tue Apr 7 2015 Piotr Kliczewski <pkliczew@redhat.com> 1.1.0
- Initial release for 3.6
