#
# ovirt-engine-setup -- oVirt Live
# Copyright (C) 2015-2016 Red Hat, Inc.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

# See: https://fedoraproject.org/wiki/Changes/UnversionedDocdirs
%{!?_pkgdocdir: %global _pkgdocdir %{_docdir}/%{name}-%{version}}

%global         package_version 4.0.0

Name:           ovirt-engine-setup-plugin-live
Version:        4.0.0
Release:        1%{?release_suffix}%{?dist}
Summary:        oVirt Live Setup Plugins
License:        ASL 2.0
URL:            http://www.ovirt.org
Source0:        http://resources.ovirt.org/pub/src/%{name}/%{name}-%{package_version}.tar.gz
BuildArch:      noarch

Requires:       ovirt-engine >= %{version}
Requires:       ovirt-engine-setup-plugin-ovirt-engine >= %{version}
Requires:       ovirt-engine-sdk-python >= 3.6.3.0

Requires:       gettext
Requires:       openssh-server
Requires:       ovirt-host-deploy >= 1.5.0

%description
oVirt Live Setup Plugins

%prep
%setup -q -n %{name}-%{package_version}

%build
%configure \
        --docdir="%{_pkgdocdir}"
        %{?conf}
make %{?_smp_mflags}

%install
%make_install

%files
%{_datadir}/ovirt-engine/firewalld/ovirt-engine/ovirt-aio.xml.in
%{_datadir}/ovirt-engine/setup/ovirt_engine_setup/ovirt_live/
%{_datadir}/ovirt-engine/setup/plugins/ovirt-engine-setup/ovirt-engine/all-in-one/
%{_datadir}/ovirt-engine/setup/plugins/ovirt-engine-setup/ovirt-engine/ovirt_live/
%config %{_sysconfdir}/ovirt-host-deploy.conf.d/10-packaging-aio.conf
%config %{_sysconfdir}/ovirt-host-deploy.conf.d/50-offline-packager.conf


%doc README.md
# See https://fedoraproject.org/wiki/Changes/Use_license_macro_in_RPMs_for_packages_in_Cloud_Image
%license COPYING NOTICE


%changelog
* Tue May 31 2016 Sandro Bonazzola <sbonazzo@redhat.com> - 4.0.0-1
- 4.0.0-1

* Wed Dec 23 2015 Sandro Bonazzola <sbonazzo@redhat.com> - 4.0.0-0.0.master
- Bump version to 4.0.0

* Fri Jul 31 2015 Sandro Bonazzola <sbonazzo@redhat.com> - 3.6.0-0.0.master
- Initial packaging
