/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.internal.xml;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.ovirt.api.metamodel.runtime.xml.XmlReader;
import org.ovirt.engine.sdk4.internal.containers.DnsContainer;
import org.ovirt.engine.sdk4.internal.xml.XmlHostReader;
import org.ovirt.engine.sdk4.types.Dns;

public class XmlDnsReader {
    public static Dns readOne(XmlReader reader) {
        if (!reader.forward()) {
            return null;
        }
        DnsContainer object = new DnsContainer();
        reader.next();
        block10: while (reader.forward()) {
            String name;
            switch (name = reader.getLocalName()) {
                case "search_domains": {
                    object.searchDomains(XmlHostReader.readMany(reader));
                    continue block10;
                }
                case "servers": {
                    object.servers(XmlHostReader.readMany(reader));
                    continue block10;
                }
                case "link": {
                    XmlDnsReader.readLink(reader, object);
                    continue block10;
                }
            }
            reader.skip();
        }
        reader.next();
        return object;
    }

    public static Iterator<Dns> iterateMany(final XmlReader reader) {
        return new Iterator<Dns>(){
            private boolean first = true;

            @Override
            public void remove() {
            }

            @Override
            public boolean hasNext() {
                if (this.first) {
                    if (!reader.forward()) {
                        return false;
                    }
                    reader.next();
                    this.first = false;
                }
                if (!reader.forward()) {
                    reader.next();
                    return false;
                }
                return true;
            }

            @Override
            public Dns next() {
                Dns next = XmlDnsReader.readOne(reader);
                if (next == null) {
                    throw new NoSuchElementException();
                }
                return next;
            }
        };
    }

    public static List<Dns> readMany(XmlReader reader) {
        ArrayList<Dns> list = new ArrayList<Dns>();
        Iterator<Dns> iterator = XmlDnsReader.iterateMany(reader);
        while (iterator.hasNext()) {
            list.add(iterator.next());
        }
        return list;
    }

    private static void readLink(XmlReader reader, DnsContainer object) {
        String rel = null;
        String href = null;
        block8: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String attrName = reader.getAttributeLocalName(i);
            String attrVal = reader.getAttributeValue(i);
            switch (attrName) {
                case "href": {
                    href = attrVal;
                    continue block8;
                }
                case "rel": {
                    rel = attrVal;
                    continue block8;
                }
                default: {
                    reader.skip();
                }
            }
        }
        reader.skip();
    }
}

