/*
Copyright (c) 2015 Red Hat, Inc.
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package org.ovirt.engine.sdk4.internal.containers;

import java.util.List;
import org.ovirt.engine.sdk4.types.ClusterLevel;
import org.ovirt.engine.sdk4.types.CpuType;
import org.ovirt.engine.sdk4.types.Permit;

public class ClusterLevelContainer extends IdentifiedContainer implements ClusterLevel {
    private List<CpuType> cpuTypes;
    private List<Permit> permits;
    
    public List<CpuType> cpuTypes() {
        return makeUnmodifiableList(cpuTypes);
    }
    
    public void cpuTypes(List<CpuType> newCpuTypes) {
        cpuTypes = makeArrayList(newCpuTypes);
    }
    
    public boolean cpuTypesPresent() {
        return cpuTypes != null && !cpuTypes.isEmpty();
    }
    
    public List<Permit> permits() {
        return makeUnmodifiableList(permits);
    }
    
    public void permits(List<Permit> newPermits) {
        permits = makeArrayList(newPermits);
    }
    
    public boolean permitsPresent() {
        return permits != null && !permits.isEmpty();
    }
    
}
