/*
Copyright (c) 2015 Red Hat, Inc.
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package org.ovirt.engine.sdk4.services;

import java.io.IOException;
import java.math.BigInteger;
import java.util.List;
import org.ovirt.engine.sdk4.Request;
import org.ovirt.engine.sdk4.Response;
import org.ovirt.engine.sdk4.Service;
import org.ovirt.engine.sdk4.builders.NicBuilder;
import org.ovirt.engine.sdk4.types.Nic;

public interface VmNicsService extends Service {
    /**
     * Adds a NIC to the virtual machine.
     * 
     * The following example adds a network interface named `mynic` using `virtio` and the `ovirtmgmt` network to the
     * virtual machine.
     * 
     * [source]
     * ----
     * POST /ovirt-engine/api/vms/123/nics
     * ----
     * 
     * [source,xml]
     * ----
     * <nic>
     *   <interface>virtio</interface>
     *   <name>mynic</name>
     *   <network>
     *     <name>ovirtmgmt</name>
     *   </network>
     * </nic>
     * ----
     * 
     * The following example sends that request using `curl`:
     * 
     * [source,bash]
     * ----
     * curl \
     * --request POST \
     * --header "Version: 4" \
     * --header "Content-Type: application/xml" \
     * --header "Accept: application/xml" \
     * --user "admin@internal:mypassword" \
     * --cacert /etc/pki/ovirt-engine/ca.pem \
     * --data '
     * <nic>
     *   <name>mynic</name>
     *   <network>
     *     <name>ovirtmgmt</name>
     *   </network>
     * </nic>
     * ' \
     * https://myengine.example.com/ovirt-engine/api/vms/123/nics
     * ----
     * 
     * [IMPORTANT]
     * ====
     * The hotplugging feature only supports virtual machine operating systems with hotplugging operations.
     * Example operating systems include:
     * 
     * - Red Hat Enterprise Linux 6
     * - Red Hat Enterprise Linux 5
     * - Windows Server 2008 and
     * - Windows Server 2003
     * ====
     */
    public interface AddRequest extends Request<AddRequest, AddResponse> {
        AddRequest nic(Nic nic);
        AddRequest nic(NicBuilder nic);
    }
    
    /**
     * Adds a NIC to the virtual machine.
     * 
     * The following example adds a network interface named `mynic` using `virtio` and the `ovirtmgmt` network to the
     * virtual machine.
     * 
     * [source]
     * ----
     * POST /ovirt-engine/api/vms/123/nics
     * ----
     * 
     * [source,xml]
     * ----
     * <nic>
     *   <interface>virtio</interface>
     *   <name>mynic</name>
     *   <network>
     *     <name>ovirtmgmt</name>
     *   </network>
     * </nic>
     * ----
     * 
     * The following example sends that request using `curl`:
     * 
     * [source,bash]
     * ----
     * curl \
     * --request POST \
     * --header "Version: 4" \
     * --header "Content-Type: application/xml" \
     * --header "Accept: application/xml" \
     * --user "admin@internal:mypassword" \
     * --cacert /etc/pki/ovirt-engine/ca.pem \
     * --data '
     * <nic>
     *   <name>mynic</name>
     *   <network>
     *     <name>ovirtmgmt</name>
     *   </network>
     * </nic>
     * ' \
     * https://myengine.example.com/ovirt-engine/api/vms/123/nics
     * ----
     * 
     * [IMPORTANT]
     * ====
     * The hotplugging feature only supports virtual machine operating systems with hotplugging operations.
     * Example operating systems include:
     * 
     * - Red Hat Enterprise Linux 6
     * - Red Hat Enterprise Linux 5
     * - Windows Server 2008 and
     * - Windows Server 2003
     * ====
     */
    public interface AddResponse extends Response {
        Nic nic();
    }
    
    /**
     * Adds a NIC to the virtual machine.
     * 
     * The following example adds a network interface named `mynic` using `virtio` and the `ovirtmgmt` network to the
     * virtual machine.
     * 
     * [source]
     * ----
     * POST /ovirt-engine/api/vms/123/nics
     * ----
     * 
     * [source,xml]
     * ----
     * <nic>
     *   <interface>virtio</interface>
     *   <name>mynic</name>
     *   <network>
     *     <name>ovirtmgmt</name>
     *   </network>
     * </nic>
     * ----
     * 
     * The following example sends that request using `curl`:
     * 
     * [source,bash]
     * ----
     * curl \
     * --request POST \
     * --header "Version: 4" \
     * --header "Content-Type: application/xml" \
     * --header "Accept: application/xml" \
     * --user "admin@internal:mypassword" \
     * --cacert /etc/pki/ovirt-engine/ca.pem \
     * --data '
     * <nic>
     *   <name>mynic</name>
     *   <network>
     *     <name>ovirtmgmt</name>
     *   </network>
     * </nic>
     * ' \
     * https://myengine.example.com/ovirt-engine/api/vms/123/nics
     * ----
     * 
     * [IMPORTANT]
     * ====
     * The hotplugging feature only supports virtual machine operating systems with hotplugging operations.
     * Example operating systems include:
     * 
     * - Red Hat Enterprise Linux 6
     * - Red Hat Enterprise Linux 5
     * - Windows Server 2008 and
     * - Windows Server 2003
     * ====
     */
    AddRequest add();
    
    public interface ListRequest extends Request<ListRequest, ListResponse> {
        /**
         * Sets the maximum number of NICs to return. If not specified all the NICs are returned.
         */
        ListRequest max(Integer max);
        /**
         * Sets the maximum number of NICs to return. If not specified all the NICs are returned.
         */
        ListRequest max(Long max);
        /**
         * Sets the maximum number of NICs to return. If not specified all the NICs are returned.
         */
        ListRequest max(BigInteger max);
    }
    
    public interface ListResponse extends Response {
        List<Nic> nics();
    }
    
    ListRequest list();
    
    VmNicService nicService(String id);
    /**
     * Service locator method, returns individual service on which the URI is dispatched.
     */
    Service service(String path);
}

