/*
Copyright (c) 2015 Red Hat, Inc.
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package org.ovirt.engine.sdk4.internal.containers;

import java.lang.String;
import java.math.BigInteger;
import org.ovirt.engine.sdk4.types.AgentConfiguration;
import org.ovirt.engine.sdk4.types.MessageBrokerType;

public class AgentConfigurationContainer extends Container implements AgentConfiguration {
    private String address;
    private MessageBrokerType brokerType;
    private String networkMappings;
    private String password;
    private BigInteger port;
    private String username;
    
    public String address() {
        return address;
    }
    
    public void address(String newAddress) {
        address = newAddress;
    }
    
    public boolean addressPresent() {
        return address != null;
    }
    
    public MessageBrokerType brokerType() {
        return brokerType;
    }
    
    public void brokerType(MessageBrokerType newBrokerType) {
        brokerType = newBrokerType;
    }
    
    public boolean brokerTypePresent() {
        return brokerType != null;
    }
    
    public String networkMappings() {
        return networkMappings;
    }
    
    public void networkMappings(String newNetworkMappings) {
        networkMappings = newNetworkMappings;
    }
    
    public boolean networkMappingsPresent() {
        return networkMappings != null;
    }
    
    public String password() {
        return password;
    }
    
    public void password(String newPassword) {
        password = newPassword;
    }
    
    public boolean passwordPresent() {
        return password != null;
    }
    
    public BigInteger port() {
        return port;
    }
    
    public void port(BigInteger newPort) {
        port = newPort;
    }
    
    public boolean portPresent() {
        return port != null;
    }
    
    public String username() {
        return username;
    }
    
    public void username(String newUsername) {
        username = newUsername;
    }
    
    public boolean usernamePresent() {
        return username != null;
    }
    
}
