/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.internal.xml;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.ovirt.api.metamodel.runtime.xml.XmlReader;
import org.ovirt.engine.sdk4.internal.containers.ExternalDiscoveredHostContainer;
import org.ovirt.engine.sdk4.internal.xml.XmlExternalHostProviderReader;
import org.ovirt.engine.sdk4.types.ExternalDiscoveredHost;

public class XmlExternalDiscoveredHostReader {
    public static ExternalDiscoveredHost readOne(XmlReader reader) {
        String name;
        if (!reader.forward()) {
            return null;
        }
        ExternalDiscoveredHostContainer object = new ExternalDiscoveredHostContainer();
        block30: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            name = reader.getAttributeLocalName(i);
            String image = reader.getAttributeValue(i);
            switch (name) {
                case "href": {
                    object.href(image);
                    continue block30;
                }
                case "id": {
                    object.id(image);
                    continue block30;
                }
            }
        }
        ArrayList<String[]> links = new ArrayList<String[]>();
        reader.next();
        block31: while (reader.forward()) {
            switch (name = reader.getLocalName()) {
                case "comment": {
                    object.comment(reader.readString());
                    continue block31;
                }
                case "description": {
                    object.description(reader.readString());
                    continue block31;
                }
                case "external_host_provider": {
                    object.externalHostProvider(XmlExternalHostProviderReader.readOne(reader));
                    continue block31;
                }
                case "ip": {
                    object.ip(reader.readString());
                    continue block31;
                }
                case "last_report": {
                    object.lastReport(reader.readString());
                    continue block31;
                }
                case "mac": {
                    object.mac(reader.readString());
                    continue block31;
                }
                case "name": {
                    object.name(reader.readString());
                    continue block31;
                }
                case "subnet_name": {
                    object.subnetName(reader.readString());
                    continue block31;
                }
                case "link": {
                    String rel = reader.getAttributeValue("rel");
                    String href = reader.getAttributeValue("href");
                    if (rel != null && href != null) {
                        links.add(new String[]{rel, href});
                    }
                    reader.next();
                    continue block31;
                }
            }
            reader.skip();
        }
        if (links != null) {
            for (String[] link : links) {
                XmlExternalDiscoveredHostReader.processLink(object, link);
            }
        }
        reader.next();
        return object;
    }

    public static Iterator<ExternalDiscoveredHost> iterateMany(final XmlReader reader) {
        return new Iterator<ExternalDiscoveredHost>(){
            private boolean first = true;

            @Override
            public void remove() {
            }

            @Override
            public boolean hasNext() {
                if (this.first) {
                    if (!reader.forward()) {
                        return false;
                    }
                    reader.next();
                    this.first = false;
                }
                if (!reader.forward()) {
                    reader.next();
                    return false;
                }
                return true;
            }

            @Override
            public ExternalDiscoveredHost next() {
                ExternalDiscoveredHost next = XmlExternalDiscoveredHostReader.readOne(reader);
                if (next == null) {
                    throw new NoSuchElementException();
                }
                return next;
            }
        };
    }

    public static List<ExternalDiscoveredHost> readMany(XmlReader reader) {
        ArrayList<ExternalDiscoveredHost> list = new ArrayList<ExternalDiscoveredHost>();
        Iterator<ExternalDiscoveredHost> iterator = XmlExternalDiscoveredHostReader.iterateMany(reader);
        while (iterator.hasNext()) {
            list.add(iterator.next());
        }
        return list;
    }

    private static void processLink(ExternalDiscoveredHostContainer object, String[] link) {
    }
}

