/*
Copyright (c) 2015 Red Hat, Inc.
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package org.ovirt.engine.sdk4.services;

import java.io.IOException;
import org.ovirt.engine.sdk4.Request;
import org.ovirt.engine.sdk4.Response;
import org.ovirt.engine.sdk4.Service;
import org.ovirt.engine.sdk4.builders.NetworkBuilder;
import org.ovirt.engine.sdk4.types.Network;

/**
 * A service to manage a specific cluster network.
 */
public interface ClusterNetworkService extends Service {
    /**
     * Retrieves the cluster network details.
     */
    public interface GetRequest extends Request<GetRequest, GetResponse> {
    }
    
    /**
     * Retrieves the cluster network details.
     */
    public interface GetResponse extends Response {
        /**
         * The cluster network.
         */
        Network network();
    }
    
    /**
     * Retrieves the cluster network details.
     */
    GetRequest get();
    
    /**
     * Unassigns the network from a cluster.
     */
    public interface RemoveRequest extends Request<RemoveRequest, RemoveResponse> {
    }
    
    /**
     * Unassigns the network from a cluster.
     */
    public interface RemoveResponse extends Response {
    }
    
    /**
     * Unassigns the network from a cluster.
     */
    RemoveRequest remove();
    
    /**
     * Updates the network in the cluster.
     */
    public interface UpdateRequest extends Request<UpdateRequest, UpdateResponse> {
        UpdateRequest network(Network network);
        /**
         * The cluster network.
         */
        UpdateRequest network(NetworkBuilder network);
    }
    
    /**
     * Updates the network in the cluster.
     */
    public interface UpdateResponse extends Response {
        /**
         * The cluster network.
         */
        Network network();
    }
    
    /**
     * Updates the network in the cluster.
     */
    UpdateRequest update();
    
    /**
     * Service locator method, returns individual service on which the URI is dispatched.
     */
    Service service(String path);
}

