#
# CUSTOMIZATION-BEGIN
#
# ovirt_build_extra_flags
#
# CUSTOMIZATION-END
#

#
# rpm does not support override
# nor modify of variables
#
%if %{?_ovirt_build_extra_flags:1}%{?ovirt_build_extra_flags:1}0
%global EXTRA_BUILD_FLAGS %{?_ovirt_build_extra_flags:%{_ovirt_build_extra_flags}}%{?ovirt_build_extra_flags: %{ovirt_build_extra_flags}}
%endif

%if 0%{?fedora}
%global ovirt_install_systemd 1
%global ovirt_install_systemv 0
%global commons_collections apache-commons-collections
%global dom4j dom4j
%endif

%if 0%{?rhel}
%if 0%{?rhel} >= 7
%global ovirt_install_systemd 1
%global ovirt_install_systemv 0
%global commons_collections apache-commons-collections
%global dom4j dom4j
%else
%global ovirt_install_systemd 0
%global ovirt_install_systemv 1
%global commons_collections commons-collections
%if 0%{?centos}
%global dom4j dom4j
%else
%global dom4j dom4j-eap6
%endif
%endif
%endif

%global product_name Data warehouse package for oVirt Virtualization Suite
%global product_description oVirt virtualization manager data warehouse

%global engine_gid 108
%global engine_group ovirt
%global engine_uid 108
%global engine_user ovirt

# Macro to create an user:
#
# %1 user name
# %2 user id
# %3 primary group name
# %4 primary group id
# %5 description
# %6 home directory
#
%global _ovirt_create_user() \
getent group %3 >/dev/null || groupadd -r -g %4 %3; \
getent passwd %1 >/dev/null || useradd -r -u %2 -g %3 -c %5 -s /sbin/nologin -d %6 %1

%global ovirt_create_user_engine \
%_ovirt_create_user %{engine_user} %{engine_uid} %{engine_group} %{engine_gid} "%{ovirt_user_description}" %{engine_state}

%global make_common_opts \\\
	-j1 \\\
	BUILD_VALIDATION=0 \\\
	PACKAGE_NAME=%{name} \\\
	RPM_VERSION=%{version} \\\
	RPM_RELEASE=%{release} \\\
	LOCALSTATE_DIR=%{_localstatedir} \\\
	PREFIX=%{_prefix} \\\
	SYSCONF_DIR=%{_sysconfdir} \\\
	BIN_DIR=%{_bindir} \\\
	DATAROOT_DIR=%{_datadir} \\\
	MAN_DIR=%{_mandir} \\\
	DOC_DIR=%{_docdir} \\\
	PYTHON=%{__python} \\\
	PYTHON_DIR=%{python_sitelib} \\\
	JAVA_DIR=%{_javadir} \\\
	PKG_USER=%{engine_user} \\\
	PKG_GROUP=%{engine_group} \\\
	%{?EXTRA_BUILD_FLAGS:EXTRA_BUILD_FLAGS="%{EXTRA_BUILD_FLAGS}"}

Name:		ovirt-engine-dwh
Version:	4.1.6
Release:	1%{?release_suffix}%{?dist}
License:	LGPLv2 and ASL 2.0
Summary:	%{product_name}
Group:		Virtualization/Management
URL:		http://www.ovirt.org
BuildArch:	noarch
Source:		http://resources.ovirt.org/pub/src/ovirt-engine-dwh/ovirt-engine-dwh-4.1.6.tar.gz

BuildRequires:  java-1.8.0-openjdk-devel >= 1:1.8.0
BuildRequires:	%{commons_collections}
BuildRequires:	%{dom4j}
BuildRequires:	ant
BuildRequires:	jpackage-utils
BuildRequires:	make

%if %{ovirt_install_systemd}
BuildRequires:	systemd
%endif

Requires:	%{commons_collections}
Requires:	%{dom4j}
Requires:	%{name}-setup >= %{version}-%{release}
Requires:	java-openjdk >= 1:1.8.0
Requires:	jpackage-utils
Requires:	logrotate
Requires:	postgresql-jdbc
Requires:	postgresql-server >= 8.4.7

%description
The %{product_description} package provides
the ETL process and DB scripts to create a historic database API.
Enables SQL BI reports creation for management and monitoring.

%if %{ovirt_install_systemd}
Requires(post):		systemd
Requires(preun):	systemd
Requires(postun):	systemd
%endif

%package setup
Summary:	%{product_name} setup
Group:		Virtualization/Management
Requires:	ovirt-engine-setup-plugin-ovirt-engine-common
Requires:	ovirt-setup-lib
Requires:	%{name} >= 3.6.0
BuildRequires:	python

%description setup
%{product_description} setup package.

%prep
%setup -c -q

%build
make %{make_common_opts}

%install
rm -fr "%{buildroot}"

make %{make_common_opts} install DESTDIR=%{buildroot}

# Compile python files
%{__python} -m compileall -f -q -d / "%{buildroot}"
%{__python} -O -m compileall -f -q -d / "%{buildroot}"

#
# /var creation
#
install -dm 755 "%{buildroot}/%{_localstatedir}/lib/ovirt-engine-dwh"
install -dm 755 "%{buildroot}/%{_localstatedir}/log/ovirt-engine-dwh"

#
# Move jars to destribution location
#
install -dm 755 "%{buildroot}%{_javadir}/ovirt-engine-dwh"
while read lib_path; do
	java_path="%{_javadir}/ovirt-engine-dwh/$(basename "${lib_path}")"
	mv "%{buildroot}/${lib_path}" "%{buildroot}/${java_path}"
	ln -s "${java_path}" "%{buildroot}${lib_path}"
done << __EOF__
%{_datadir}/ovirt-engine-dwh/lib/advancedPersistentLookupLib.jar
%{_datadir}/ovirt-engine-dwh/lib/etltermination.jar
%{_datadir}/ovirt-engine-dwh/lib/historyETL.jar
%{_datadir}/ovirt-engine-dwh/lib/routines.jar
__EOF__

# Needed for compatibility if package is different than the directory structure
%if "%{name}" != "ovirt-engine-dwh"
ln -s "ovirt-engine-dwh" "%{buildroot}%{_javadir}/ovirt-engine-dwh/../%{name}"
%endif

#
# Register services
#
%if %{ovirt_install_systemd}
install -dm 755 "%{buildroot}%{_unitdir}"
cp "%{buildroot}%{_datadir}/ovirt-engine-dwh/services/ovirt-engine-dwhd/ovirt-engine-dwhd.systemd" "%{buildroot}%{_unitdir}/ovirt-engine-dwhd.service"
%endif

%if %{ovirt_install_systemv}
install -dm 755 "%{buildroot}%{_sysconfdir}/cron.hourly"
cp "%{buildroot}%{_datadir}/ovirt-engine-dwh/services/ovirt-engine-dwhd/ovirt_engine_dwh_watchdog.cron" "%{buildroot}%{_sysconfdir}/cron.hourly"
install -dm 755 "%{buildroot}%{_initddir}"
cp "%{buildroot}%{_datadir}/ovirt-engine-dwh/services/ovirt-engine-dwhd/ovirt-engine-dwhd.sysv" "%{buildroot}%{_initddir}/ovirt-engine-dwhd"
%endif

# backward compatibly (pre-3.4.0)
# perserve old configuration
install -d "%{buildroot}%{_sysconfdir}/ovirt-engine/ovirt-engine-dwh"
touch "%{buildroot}%{_sysconfdir}/ovirt-engine/ovirt-engine-dwh/Default.properties"

%pre
%ovirt_create_user_engine

%post
%if %{ovirt_install_systemv}
chkconfig --add ovirt-engine-dwhd
%endif
%if %{ovirt_install_systemd}
%systemd_post ovirt-engine-dwhd.service
%endif

%preun
%if %{ovirt_install_systemv}
if [ "$1" -eq 0 ]; then
	service ovirt-engine-dwhd stop > /dev/null 2>&1 || true
	chkconfig --del ovirt-engine-dwhd
fi
%endif
%if %{ovirt_install_systemd}
%systemd_preun ovirt-engine-dwhd.service
%endif

%postun
%if %{ovirt_install_systemd}
%systemd_postun ovirt-engine-dwhd.service
%endif

%files

%ghost %config(noreplace) %{_sysconfdir}/ovirt-engine/ovirt-engine-dwh/Default.properties
%config(noreplace) %{_sysconfdir}/logrotate.d/ovirt-engine-dwhd
%dir %attr(-, %{engine_user}, %{engine_group}) %{_localstatedir}/lib/ovirt-engine-dwh/
%dir %attr(-, %{engine_user}, %{engine_group}) %{_localstatedir}/log/ovirt-engine-dwh/
%dir %{_sysconfdir}/ovirt-engine-dwh
%{_datadir}/ovirt-engine-dwh/
%{_javadir}/ovirt-engine-dwh/
%{_sysconfdir}/ovirt-engine-dwh/ovirt-engine-dwhd.conf.d/
%{_localstatedir}/lib/ovirt-engine-dwh/backups/

%if "%{name}" != "ovirt-engine-dwh"
%{_javadir}/%{name}
%endif

%if %{ovirt_install_systemd}
%{_unitdir}/ovirt-engine-dwhd.service
%endif
%if %{ovirt_install_systemv}
%config %{_sysconfdir}/cron.hourly/ovirt_engine_dwh_watchdog.cron
%{_initddir}/ovirt-engine-dwhd
%endif

%files setup
%{_datadir}/ovirt-engine/setup/ovirt_engine_setup/dwh/
%{_datadir}/ovirt-engine/setup/plugins/*/ovirt-engine-dwh/

%changelog
* Tue Aug 29 2017 Shirly Radco <sradco@redhat.com> - 4.1.6
Fixed issues:
- Bug 1482043 - update vm template name length

* Tue Mar 21 2017 Shirly Radco <sradco@redhat.com> - 4.1.1
Fixed issues:
- Bug 1404812 - update dwh stop process
- Bug 1371111 - heartbeat error message interval

* Tue Jan 17 2017 Shirly Radco <sradco@redhat.com> - 4.1.0
Fixed issues:
- Bug 1408652 -  Update default mem heap values

* Wed Dec 21 2016 Shirly Radco <sradco@redhat.com> - 4.1.0
Fixed issues:
- Bug 1399162 - Fixed firstSync updating process
- Bug 1398944 - updated users collection
- Bug 1364062 - setup: Notify to restart remote engine
- Bug 1263785 - setup: Remove constants duplication
- Bug 1365427 - setup: Configure scale only on new database
- Bug 1366900 - spec: Allow upgrade directly from 3.6
- Bug 1349309 - lower sampling interval
- Bug 1332892 - setup: Do not write db password to answerfile if provisioning
- Bug 1347281 - dropped all history database foreign keys
- Bug 1347996 - added index to vm disks usage tables


* Tue May 31 2016 Shirly Radco <sradco@redhat.com> - 4.0.0
Fixed issues:
- Bug 1338495 - remove collection of vm_disk_interface
- Bug 1302598 - added over_time views to simplify use
- Bug 1324440 - Added log message - Application Settings
- Bug 1328805 - Allow choosing scale
- Bug 1318665 - Copy db creds to engine
- Bug 1328860 - Move DBTransaction to common

* Thu Apr 21 2016 Shirly Radco <sradco@redhat.com> - 4.0.0
Fixed issues:
- Bug 1302611 - spec: Require java 8
- Bug 1318665 - setup: Note that dwh is required
- Bug 1300328 - removed collection of dc statistics
- Bug 1321517 - changed the limit in  DeleteTimekeeping job
- Bug 1285788 - enabled logging of dwh ETL process in debug mode
- Bug 1323605 - removed collection of vm_disks_map
- Bug 1302611 - rebase to talend open studio 6.1.1
- Bug 1312638 - removed dwh views up to 3.6
- Bug 1311149 - change vds_groups to cluster

* Mon Dec 21 2015 Shirly Radco <sradco@redhat.com> - 3.6.2
Fixed issues:
- Bug 1286441 - restoring connection to postgres for audit_log and dwh_history_timekeeping.
- Bug 1289983 - engine_db_timekeeping fix for rename

* Tue Nov 24 2015 Shirly Radco <sradco@redhat.com> - 3.6.1
Fixed issues:
- Bug 1193318 - Fix Data Warehouse service name

* Wed Sep 02 2015 Yaniv Dary <ydary@redhat.com> - 3.6.0
oVirt 3.6 Beta 4 release.

Fixed issues:
- Bug 1254003 - removed fk that cause deadlock occasionally

* Wed Aug 12 2015 Yaniv Dary <ydary@redhat.com> - 3.6.0
Fixed issue:
- Bug 1233193 - ETL service sampling error -
  RuntimeException: Child job running failed

* Tue Aug 11 2015 Yaniv Dary <ydary@redhat.com> - 3.6.0
Fixed issues:
- Bug 1195395 - ETL service aggregation to hourly tables is
  failing due to NullPointerException for specific timezones
  due to the way the ETL interprets the timezone
- Bug 1231691 - Update cached/buffered memory to bigint

* Mon Sep 15 2014 Shirly Radco <sradco@redhat.com> - 3.5.0
Fixed issues:
- Refixed updated statistics history_id to bigint (#1121994)

* Sun Sep 07 2014 Shirly Radco <sradco@redhat.com> - 3.5.0
Fixed issues:
- updated runTime from engine db (#1133608)
- Prevent more than one dwh per engine (#1118350)
- updated etl to check valid installation (#1118350)

* Tue Aug 26 2014 Shirly Radco <sradco@redhat.com> - 3.5.0
Fixed issues:
- updated statistics history_id to bigint (#1121994)

* Sun Aug 10 2014 Shirly Radco <sradco@redhat.com> - 3.5.0
Fixed issues:
- add dwh to versionlock

* Tue Aug 05 2014 Shirly Radco <sradco@redhat.com> - 3.5.0
Fixed issues:
- fixed etl-update users delete date (#1124458)

* Mon Aug 04 2014 Shirly Radco <sradco@redhat.com> - 3.5.0
Fixed issues:
- updated insert_calendar_table_values script

* Sun Jul 13 2014 Shirly Radco <sradco@redhat.com> - 3.5.0
Fixed issues:
- test only config file db password (#1094016)
- filter engine db password
- fixed users external_id type due to engine change (#1113193)
- Allow dwh on separate host (#1080997)
- remove dependency loop in setup
- reorg the per component directory
- split of engine-setup-plugin

* Thu Jun 5 2014 Shirly Radco <sradco@redhat.com> - 3.5.0
Fixed issues:
- Force a minimal ETL version (#1059283)
- sync users data for user usage tables (#1091687)
- update user and system cpu usage percent (#1078897)
- Fixed sleep time for delete/aggregations (#1086389)
- Change Fields "Network Name" to "Logical Network Name" (#891073)
- Do not fail on errors while restoring permissions (#1073471)
- use db creds from answer file (#1094016)
- engine-setup check remote database is empty (#1056528)

* Sun Mar 30 2014 Yaniv Dary <ydary@redhat.com> - 3.4.1
Fixed issues:
- io.StringIO needs unicode (See releated BZ #1079911)
- fixed generated code issue (#1076902)

* Mon Mar 24 2014 Yaniv Dary <ydary@redhat.com> - 3.4.0-2
Fixed issues:
- move connect to database library (#1067058)
- suppress password based on env key (#1072476)
- align manual instructions with defaults (#1067548)
- 'Install' is now 'Configure' in DWH/Reports questions (#1064876)
- updated ksm_shared_memory_percent to mb (#1076902)
- preserve custom db users permissions on upgrade (#1073471)
- read legacy config with trivial parser (#1079911)

* Wed Feb 12 2014 Yaniv Dary <ydary@redhat.com> - 3.4.0-1
3.4.0 GA release.

Fixed issues:
1070757 - support postgres user length within schema version
1065730 - No option to setup with diffrrent name as it looks for upstream packages names always

* Wed Feb 12 2014 Yaniv Dary <ydary@redhat.com> - 3.4.0
Features added:
967350/1058012 - port dwh installer to otopi
1030466 - ovirt-engine-dwh-setup should stored values provided in interactive setup in the answer file
1023754 - add trigger to stop etl connection via engine db value
1052383 - collect the "created_by" field of a VM into it's configuration history
848410 - alternate method for service shutdown

Fixed issues:
1057239 - dwh-setup fails because of unexpected output in login shell without reasonable error message

* Thu Jan 09 2014 Yaniv Dary <ydary@redhat.com> - 3.3
Refixed issue:
- fix ugprade with remote db (#1046676)

* Thu Jan 02 2014 Yaniv Dary <ydary@redhat.com> - 3.3
Fixed issues:
- Backup before doing any changes to the database (#1046679\1046676)
- Fixed remote install setup (#1045846\1047392\1045855)

* Wed Dec 18 2013 Yaniv Dary <ydary@redhat.com> - 3.3
Fixed issues:
- detect existing DB in remote flows (#1026947)
- correctly configure Default.properties (#1026947)
- handle answerfile correctly (#1040029)
- do not create db md5 files in production (#1043951)
- rename config values to match engine convention (#1043951)
- remove 10-setup-database-dwh.conf from package (#1043951)
- rename /etc/ovirt-engine-dwh/engine-dwh.conf.d->/etc/ovirt-engine-dwh/ovirt-engine-dwhd.conf.d (#1043951)
- Pass full log path to database schema creation script (#1040026)

* Wed Dec 11 2013 Yaniv Dary <ydary@redhat.com> - 3.3
Fixed issues:
- Adds COPYING.csv to conform to 3.3 manifest
- add read user validation for alphanumeric chars (#1037861)

* Tue Nov 26 2013 Yaniv Dary <ydary@redhat.com> - 3.3
Fixed issue:
- update postgres service restart functionality (#1029969)

* Sun Nov 24 2013 Yaniv Dary <ydary@redhat.com> - 3.3
Fixed issues:
- Setup now sets correct umask for execution.
- Fixed test on postgres status (#1029969).

* Thu Nov 21 2013 Yaniv Dary <ydary@redhat.com> - 3.3
Fixed issues:
- added a test on postgres status (#1029969)
- update log permissions on service start (#1031992)

* Wed Nov 13 2013 Yaniv Dary <ydary@redhat.com> - 3.3
Fixed issue:
update Makefile and spec to include DB settings (#1026089)

* Sun Nov 10 2013 Yaniv Dary <ydary@redhat.com> - 3.3
Changes in setup:
- fixed function of database user creation (#1027894)
- removed unneeded chown that causes error on service actions
- improve dwhd service handling (#1022550)
- fix DB detection and owner from previous versions (#1015859)

* Wed Nov 06 2013 Yaniv Dary <ydary@redhat.com> - 3.3
Add answer file use in setup (#1025336)

* Thu Oct 31 2013 Yaniv Dary <ydary@redhat.com> - 3.3
Changed the db dict get method (#1024792)

* Tue Oct 29 2013 Yaniv Dary <ydary@redhat.com> - 3.3
Resynced db creation scripts.
Also fixed issues:
- Added clear instructions for creating remote DB (#1021560)

* Wed Oct 23 2013 Yaniv Dary <ydary@redhat.com> - 3.3
Fixed issues:
853955 - There should be no exception shown to a user when running setup with non root user
1019741 - installation - size of the detected DB should be in MB
1019758 - installation - misleading message

* Tue Oct 15 2013 Yaniv Dary <ydary@redhat.com> - 3.3
Fixed issues:
- update discovery of JAVA_HOME (#1019178)
- fixed etl error when hosts are non-responsive (#1008370)
- run dwh service as an ovirt user (#772001)
- fixed issue with many ips in vm users table (#1016968)
- run readonly user creation with non-empty user (#1008562)
- added systemd handling to common_utils (#1011544)
- validating read-only user before creation (#1006948)

* Tue Oct 08 2013 Yaniv Dary <ydary@redhat.com> - 3.3
Fixed setup issues:
- added welcome message (#1011542)
- stop and notify if setup is not run as root (#853955)
- save configuration immediately as available (#1006950)

* Tue Oct 01 2013 Yaniv Dary <ydary@redhat.com> - 3.3
Fixed postgres.conf handling (#1014031)

* Tue Sep 24 2013 Yaniv Dary <ydary@redhat.com> - 3.3
Added OS info sync to enum table (#985346)

* Mon Sep 16 2013 Yaniv Dary <ydary@redhat.com> - 3.3
Added missing column to 3.3 views.

* Mon Sep 09 2013 Yaniv Dary <ydary@redhat.com> - 3.3
Fixed verious installation issues with engine otopi setup.
Setup now works in clean local\remote setup of 3.3.

* Tue Aug 13 2013 Yaniv Dary <ydary@redhat.com> - 3.3
Added feature:
- boolean on logged in vm guest user

* Thu Aug 08 2013 Yaniv Dary <ydary@redhat.com> - 3.3
Fixed two setup issues:
- 990095 - packaging: setup: updated read-only user permissions
- 991760 - packaging: setup: call psql with correct env
Also:
- resynced the create db scripts
- made several changes to vm disks tables

* Wed Jul 31 2013 Yaniv Dary <ydary@redhat.com> - 3.3
Fixed verious setup issues:
- 990124 - fixed password handling for configuration
- 988045 - fixed pg_hba handling
- 988298 - updated 'su' utility location
- fixed failuare to create engine dwh db because of locale

* Thu Jul 25 2013 Yaniv Dary <ydary@redhat.com> - 3.3
Fixed issues:
883120 - [RFE] Ability to associate VMs with a pool in the engine and DWH
987517 - DWH - some vms don't sync

* Tue Jul 09 2013 Yaniv Dary <ydary@redhat.com> - 3.3
Fixed issue:
- 970543 - ovirt-engine-dwh-setup doesn't support option --help

* Thu Jun 13 2013 Yaniv Dary <ydary@redhat.com> - 3.2.1
Refixed issue:
- fixed issue with enum strings insertion (#952418)

* Wed Jun 12 2013 Yaniv Dary <ydary@redhat.com> - 3.2.1
Fixed issues:
- fixed issue with enum strings insertion (#952418)
- added missing enum keys for OS (#966437)

* Wed May 08 2013 Yaniv Dary <ydary@redhat.com> - 3.2.0
Fixed issue:
953148 - ETL does not populate the dwh db.

* Thu Mar 21 2013 Yaniv Dary <ydary@redhat.com> - 3.2.0
Updated manifest file and localization files.

Fixed issues:
913384 - Upgrade - Error Can't start the ovirt-engine-dwhd service (Upgrade from si25.4 to si27.1)
921445 - Update manifest file for 3.2

* Thu Mar 07 2013 Yaniv Dary <ydary@redhat.com> - 3.2.0
Reverted:
913384 - Upgrade - Error Can't start the ovirt-engine-dwhd service (Upgrade from si25.4 to si27.1)

Change on the engine side caused engine DB deadlock of nested transactions attempting to update the same
record. Without that change this patch will not work.

* Wed Mar 06 2013 Yaniv Dary <ydary@redhat.com> - 3.2.0
Refixed issue:
902028 - Table audit_log - No Logs in table for an exception (Blocks DNS using iptables)

Fixed issue:
913384 - Upgrade - Error Can't start the ovirt-engine-dwhd service (Upgrade from si25.4 to si27.1)

* Wed Feb 13 2013 Yaniv Dary <ydary@redhat.com> - 3.2.0
Fixed issue:
902028 - Table audit_log - No Logs in table for an exception (Blocks DNS using iptables)

* Tue Feb 05 2013 Yaniv Dary <ydary@redhat.com> - 3.2.0
Fixed issues:
- 892278 - [ovirt-engine-dwh] dwh-setup fails.
- 894716 - History DB - No Statisitics in hourly and daily tables

* Wed Jan 02 2013 Yaniv Dary <ydary@redhat.com> - 3.2.0
Fixed issues:
- 846272 - PRD32 - RFE - Add storage domains status in the History DB
- 885640 - remove is_auto_suspend field
- 889755 - Service - Add "pid" string in /etc/init.d/ovirt-engine-dwhd service message [TEXT]

* Thu Dec 27 2012 Yaniv Dary <ydary@redhat.com> - 3.2.0
- Added 3.2 views.
- Added user statistics usage tables and aggregation.
- Moved to Talend DI 5.1.2 code generation.

* Thu Nov 15 2012 Yaniv Dary <ydary@redhat.com> - 3.1.0
Fixed bugs:
876227 - upgrade - dwh upgrade doesn't rename the old DB
876240 - upgrade - Reports doesnt work after upgrade (IC is empty and reports doesnt execute)
876242 - upgrade - dwh service fails to start (java.lang.ClassNotFoundException:)

* Sun Nov 04 2012 Yaniv Dary <ydary@redhat.com> - 3.1.0
Updated DWH ENUM localization

* Tue Oct 23 2012 Yaniv Dary <ydary@redhat.com> - 3.1.0
Bugs fixed:
800372 - vm system cpu usage is always 0.
840866 - History DB - View v3_1_host_hourly_history_view shows 61 minutes instead of 60 minutes (Column minutes_in_status)
866492 - Duplicate rows in Views


* Tue Oct 09 2012 Yaniv Dary <ydary@redhat.com> - 3.1.0
- Added upgrade flow from 3.0 to 3.1.
- The host mac address field is extended to 59 so it could store
  InfiniBand HCA mac address.

Bugs Fixed:
823397 - Extend host mac address to support IB HCA
858569 - Replace JBoss service name with ovirt-engine

* Tue Sep 04 2012 Yaniv Dary <ydary@redhat.com> - 3.1.0
Bugs Fixed:
841217  - History DB - Incorrect column name fqn_or_ip in View v3_1_host_configuration_view

* Tue Aug 28 2012 Yaniv Dary <ydary@redhat.com> - 3.1.0
Bugs Fixed:
851833  - [ovirt-dwh] - ETL - Fails to connect to oVirt Engine Portal

* Tue Aug 21 2012 Yaniv Dary <ydary@redhat.com> - 3.1.0
Bugs Fixed:
850330 - Setup fails on missing file
781979 - ETL copies the templates images as disks
844667 - Remote DB - DWH Setup fails to upgrade remote history DB

* Mon Jul 16 2012 Yaniv Dary <ydary@redhat.com> - 3.1.0
bug fixed:
838292 - logrotate - DWH Log is not log-rotating correctly
840273 - Views v3_x_vm_disk_samples_history_view are empty
840283 - Views v3_x_vm_device_history_view are empty

* Wed Jul 04 2012 Yaniv Dary <ydary@redhat.com> - 3.1.0
bug fixed:
834869 - Installer - Failed to create history DB

* Fri Apr 20 2012 Yaniv Dary <ydary@redhat.com> - 3.1.0
Changed from 3.0 release:
- Project was renamed to ovirt-engine-dwh
- DB was renamed to ovirt_engine_history
- Added 3.1 API views.
- Added vm devices history (deprecated vm disks map).
- Added floating disks history.
- Added engine up status check. Samples only collected when engine is up.
- Added pushing audit log events in case of etl start\stop and error.
- Added a watch dog.
- Added new columns to the API.

bugs fixed:
728768  - [History] - Missing ENUM values for USB policy in vm configuration.
755865  - Ad Hoc - missing enum for "VM disk storage type" (3) in report
756405  - command support in 'ja_JP-UTF-8' environment
766636  - postgreSQL locks the CPU on 100%
768721  - Need to update ETL generated code.
768755  - ETL copies duplicate entries of all hosts every hour.
770644  - history: Unable to create a database with a MINUS sign in its name
781470  - Stored Procedure dbo.dwh_history_aggregate_level fails to execute successfully
781979  - ETL copies the templates images as disks
783197  - When moving the database from one time zone to another many reports stop working.
817519  - [ovirt-dwh] - jbossas cannot start (ETL occupies port 8080)
772925  - RFE - ETL service start/stop should be logged in oVirt event log and send a notification by mail
772916  - RFE - ovirt-etl should have a WatchDog
770679  - [ovirt-dwh] - Cannot Create the ovirt_history database using the create_db.sh script
749664  - Store number of CPU sockets
749663  - Store CPU speed in Megahertz
817756  - [ovirt-dwh] - oVirt-ETL log should be under /var/log/ovirt-engine
783787  - [ovirt-etl] - Sample History - Saves data in host_samples_history_table/View for more then 48H

* Thu Apr 19 2012 Yaniv Dary <ydary@redhat.com> - 3.0.0-1.fc16
- Added packaging to dwh
