#
# ovirt-host-deploy -- ovirt host deployer
# Copyright (C) 2012-2016 Red Hat, Inc.
#
# This library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public
# License as published by the Free Software Foundation; either
# version 2.1 of the License, or (at your option) any later version.
#
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public
# License along with this library; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
#

%global		package_version 1.6.4
%global		package_maven_version 1.6.1
%global		ovirt_host_deploy_root %{_datadir}/%{name}/interface-3

%global _use_maven 1
%global _use_repolib 0
%global maven2brewrepodir %{_javadir}/repository.jboss.com/maven2-brew/dummy

Summary:	oVirt host deploy tool
Name:		ovirt-host-deploy
Version:	1.6.4
Release:	1%{?release_suffix}%{?dist}
License:	LGPLv2+
URL:		http://www.ovirt.org
Source:		http://resources.ovirt.org/pub/src/%{name}/%{name}-%{package_version}.tar.gz
Group:		Applications/System

BuildArch:	noarch

Requires:	otopi
Requires:	python

BuildRequires:	java-devel
BuildRequires:	gettext >= 0.18.2
BuildRequires:	otopi-devtools
BuildRequires:	python2-devel

%if %{_use_maven}
BuildRequires:	javapackages-tools
BuildRequires:	maven-compiler-plugin
BuildRequires:	maven-enforcer-plugin
BuildRequires:	maven-install-plugin
BuildRequires:	maven-jar-plugin
BuildRequires:	maven-javadoc-plugin
BuildRequires:	maven-source-plugin
BuildRequires:	maven-local
BuildRequires:	sonatype-oss-parent
%endif

%description
Host deployment tool for oVirt project.

%package java
Summary:	%{name} java support
Requires:	%{name} = %{version}-%{release}
Requires:	java
Requires:	otopi-java

%description java
java libraries.

%if %{_use_maven}
%package javadoc
Summary:	Javadocs for %{name}
Group:		Documentation

%description javadoc
This package contains the API documentation for %{name}.
%endif

%if %{_use_repolib}
%package repolib
Summary:	%{name} maven repo
%description repolib
%{name} maven repo
%endif

%prep
%setup -q -n %{name}-%{package_version}

%build
%if %{_use_maven}
%global conf --disable-java-sdk-compile
%endif
%configure \
	--docdir="%{_docdir}/%{name}-%{version}" \
	--disable-python-syntax-check \
	--enable-java-sdk \
	--with-local-version="%{name}-%{version}-%{release}" \
	%{?conf}
make %{?_smp_mflags}

%if %{_use_maven}
cd src/java
%mvn_build
cd ../..
%endif

%install
make %{?_smp_mflags} install DESTDIR="%{buildroot}"

%if %{_use_maven}
cd src/java
%mvn_install
cd ../..
%else
install -d "%{buildroot}%{_javadir}/%{name}"
install target/%{name}-%{package_maven_version}.jar %{buildroot}%{_javadir}/%{name}
ln -s %{name}-%{package_maven_version}.jar %{buildroot}%{_javadir}/%{name}/%{name}.jar
cat > src/java/.mfiles << __EOF__
%{_javadir}/%{name}/
__EOF__
%endif

%if %{_use_repolib}
install -d "%{buildroot}%{maven2brewrepodir}"
cp "%{buildroot}%{_javadir}/%{name}/%{name}.jar" "%{buildroot}%{maven2brewrepodir}/%{name}-%{package_maven_version}.jar"
cp src/java/pom.xml "%{buildroot}%{maven2brewrepodir}/%{name}-%{package_maven_version}.pom"
%endif

install -d -m 755 "%{buildroot}%{_sysconfdir}/%{name}.conf.d"
%find_lang %{name}

%files -f %{name}.lang
%dir %{_datadir}/%{name}
%dir %{_datadir}/%{name}/plugins
%dir %{_sysconfdir}/%{name}.conf.d
%dir %{ovirt_host_deploy_root}
%dir %{ovirt_host_deploy_root}/pythonlib
%doc AUTHORS
%license COPYING
%doc README
%doc README.environment
%{_datadir}/%{name}/plugins/ovirt-host-common/
%{_datadir}/%{name}/plugins/ovirt-host-deploy/
%{_datadir}/%{name}/plugins/ovirt-host-mgmt/
%{_datadir}/otopi/plugins/ovirt-host-common
%{_datadir}/otopi/plugins/ovirt-host-deploy
%{_datadir}/otopi/plugins/ovirt-host-mgmt
%{_sbindir}/ovirt-host-deploy
%{_sbindir}/ovirt-host-mgmt
%{ovirt_host_deploy_root}/.bundled
%{ovirt_host_deploy_root}/otopi
%{ovirt_host_deploy_root}/otopi-plugins
%{ovirt_host_deploy_root}/ovirt-host-deploy
%{ovirt_host_deploy_root}/ovirt-host-mgmt
%{ovirt_host_deploy_root}/pythonlib/otopi
%{ovirt_host_deploy_root}/pythonlib/ovirt_host_deploy
%{ovirt_host_deploy_root}/pythonlib/ovirt_host_mgmt
%{ovirt_host_deploy_root}/setup
%{python_sitelib}/ovirt_host_deploy/
%{python_sitelib}/ovirt_host_mgmt/

%files java -f src/java/.mfiles

%if %{_use_maven}
%files javadoc -f src/java/.mfiles-javadoc
%endif

%if %{_use_repolib}
%files repolib
%{maven2brewrepodir}/
%endif

%changelog
* Wed May  3 2017 Yedidyah Bar David <didi@redhat.com> - 1.6.4-1
- Release.

* Tue Mar  7 2017 Sandro Bonazzola <sbonazzo@redhat.com> - 1.6.3-1
- Release.

* Thu Mar  2 2017 Yedidyah Bar David <didi@redhat.com> - 1.6.2-1
- Release.

* Tue Feb 21 2017 Yedidyah Bar David <didi@redhat.com> - 1.6.1-1
- Release.

* Fri Jan 13 2017 Sandro Bonazzola <sbonazzo@redhat.com> - 1.6.0-1
- Release.

* Wed Sep 28 2016 Sandro Bonazzola <sbonazzo@redhat.com> - 1.5.3-1
- Release.

* Tue Aug 30 2016 Sandro Bonazzola <sbonazzo@redhat.com> - 1.5.2-1
- Release.

* Tue Jul 12 2016 Sandro Bonazzola <sbonazzo@redhat.com> - 1.5.1-1
- Release.

* Tue May 31 2016 Sandro Bonazzola <sbonazzo@redhat.com> - 1.5.0-1
- Release.

* Thu Oct 15 2015 Alon Bar-Lev <alonbl@redhat.com> - 1.4.0-1
- Release.

* Thu Jan 15 2015 Alon Bar-Lev <alonbl@redhat.com> - 1.3.1-1
- Release.

* Mon Oct 6 2014 Alon Bar-Lev <alonbl@redhat.com> - 1.3.0-1
- Release.

* Fri May 2 2014 Alon Bar-Lev <alonbl@redhat.com> - 1.2.1-1
- Release.

* Tue Mar 18 2014 Alon Bar-Lev <alonbl@redhat.com> - 1.2.0-1
- Release.

* Mon Jan 20 2014 Alon Bar-Lev <alonbl@redhat.com> - 1.2.0-0.1.beta
- Beta.

* Mon Aug 26 2013 Alon Bar-Lev <alonbl@redhat.com> - 1.1.0-1
- Release.

* Thu Feb 14 2013 Alon Bar-Lev <alonbl@redhat.com> - 1.0.0-1
- Release.

* Sat Oct 13 2012 Alon Bar-Lev <alonbl@redhat.com> - 1.0.0-0.1_beta
- Initial add.
