# Used for rpm-packaging of pre-bundled application with already resolved JS dependencies
%global _ovirtwebuidir %{_datarootdir}/ovirt-web-ui
%global _ovirt_engine_conf %{_datarootdir}/ovirt-engine/services/ovirt-engine/ovirt-engine.conf
%global _ovirt_engine_ear_application_xml %{_datarootdir}/ovirt-engine/engine.ear/META-INF/application.xml
%global product oVirt

%global use_rhev %( test -z @RHEV@ && echo 1 || echo 0)
%define debug_package %{nil}

## %global source_basename ovirt-web-ui-1.3.8
%global source_basename ovirt-web-ui

Name:           ovirt-web-ui
Version:        1.3.8
Release:        2%{?release_suffix}%{?checkout}%{?dist}
Summary:        VM Portal for %{product}
License:        ASL 2.0
URL:            https://github.com/oVirt/ovirt-web-ui
Source0:        https://github.com/oVirt/ovirt-web-ui/archive/%{source_basename}-1.3.8.tar.gz

BuildArch: noarch

# Keep ovirt-engine-{nodejs|nodejs-modules|yarn} at particular version unless tested on higher
BuildRequires: ovirt-engine-nodejs = 8.0.0
BuildRequires: ovirt-engine-yarn = 0.24.4

BuildRequires: ovirt-engine-nodejs-modules >= 1.5.4

%description
This package provides new VM Portal for %{product}, so far as technical preview.

%prep
# Use the ovirt-engine nodejs installation
# export PATH="%{_datadir}/ovirt-engine-nodejs/bin:${PATH}"

%setup -q -n"%{source_basename}-%{version}"
rpm -qa | grep ovirt-engine-nodejs
source /usr/share/ovirt-engine-nodejs-modules/setup-env.sh

%build
export PATH="%{_datadir}/ovirt-engine-nodejs/bin:%{_datadir}/ovirt-engine-yarn/bin:${PATH}"
%configure
export PATH="./node_modules/.bin:${PATH}"
make

%install
make install DESTDIR=%{buildroot}

%files
%doc README.md 
%license LICENSE
%{_ovirtwebuidir}
%{_datarootdir}/ovirt-engine/ovirt-web-ui.war
%{_sysconfdir}/ovirt-engine/engine.conf.d/50-ovirt-web-ui.conf
%{_sysconfdir}/ovirt-web-ui/branding/00-ovirt.brand

%changelog
* Thu Apr 12 2018 Marek Libra <mlibra@redhat.com> - 1.3.8-2
- Adjust min memory while editing memory - https://github.com/oVirt/ovirt-web-ui/pull/538
- Fixed the VmDisks sort - https://github.com/oVirt/ovirt-web-ui/pull/547
- All HTTP methods use proper 'Filter' header - https://github.com/oVirt/ovirt-web-ui/pull/550
- Fix: Avoid VM IDs in VMS navigation item list - https://github.com/oVirt/ovirt-web-ui/pull/540
- Fixed disk sorting - https://github.com/oVirt/ovirt-web-ui/pull/547
- Fixed error by deleting disk - https://github.com/oVirt/ovirt-web-ui/pull/551
- Add warning for Boot menu - https://github.com/oVirt/ovirt-web-ui/pull/560
- Fix Cloud-Init switch - https://github.com/oVirt/ovirt-web-ui/pull/559
- Fixed align of Delete buttons for Disks - https://github.com/oVirt/ovirt-web-ui/pull/553
- additional smaller UI enhancements

* Mon Mar 26 2018 Marek Libra <mlibra@redhat.com> - 1.3.7-2
- VM networks editation - https://github.com/oVirt/ovirt-web-ui/pull/517
- VM disks editation - https://github.com/oVirt/ovirt-web-ui/pull/523
- ssh dialog UI fix - https://github.com/oVirt/ovirt-web-ui/pull/519
- cloud-init VM name fix - https://github.com/oVirt/ovirt-web-ui/pull/528
- minor UI fixes
- Translations updated

* Wed Feb 28 2018 Marek Libra <mlibra@redhat.com> - 1.3.6
- VM detail landing after refresh fixed (https://github.com/oVirt/ovirt-web-ui/pull/497)
- Dialog for SSH keys fixed (https://github.com/oVirt/ovirt-web-ui/pull/464)
- Basic cloud-init support (https://github.com/oVirt/ovirt-web-ui/pull/498)
- CD removed from New VM dialog (https://github.com/oVirt/ovirt-web-ui/pull/496)
- Boot menu configuration added (https://github.com/oVirt/ovirt-web-ui/pull/493)
- Console re-connect fixed for warning message (https://github.com/oVirt/ovirt-web-ui/pull/483)
- Tooltips fixed (https://github.com/oVirt/ovirt-web-ui/pull/469)
- Close button navigates to previous page (https://github.com/oVirt/ovirt-web-ui/pull/482)
- Broken grid fixed for pools (https://github.com/oVirt/ovirt-web-ui/pull/473)
- Flow type check fix (https://github.com/oVirt/ovirt-web-ui/pull/470)
- Fix label in CTRL+ALT+DEL option (https://github.com/oVirt/ovirt-web-ui/pull/484)
- Change logo link to home page URL (https://github.com/oVirt/ovirt-web-ui/pull/474)
- Translations updated

* Wed Jan 24 2018 Marek Libra <mlibra@redhat.com> - 1.3.5
- Translations updated
- Fix for page reload - https://github.com/oVirt/ovirt-web-ui/pull/465
- Fix for pool removal - https://github.com/oVirt/ovirt-web-ui/issues/446
- Fix for infinite scroller - https://github.com/oVirt/ovirt-web-ui/pull/459


* Thu Nov 30 2017 Marek Libra <mlibra@redhat.com> - 1.3.4
- Fix for headless VMs - https://github.com/oVirt/ovirt-web-ui/pull/444
- Updated translations

* Tue Nov 28 2017 Marek Libra <mlibra@redhat.com> - 1.3.3
- Minor UI fixes and improvements
- Fix frozen "Loading" msg - https://github.com/oVirt/ovirt-web-ui/pull/430
- Fix of sorting of VMs in left vertical panel - https://github.com/oVirt/ovirt-web-ui/pull/428
- Fix in locale recognition - https://github.com/oVirt/ovirt-web-ui/pull/438
- Use of translated messages from API - https://github.com/oVirt/ovirt-web-ui/pull/131

* Tue Nov 14 2017 Marek Libra <mlibra@redhat.com> - 1.3.2
- fix of scrollbar on Webkit browsers

* Mon Nov 13 2017 Marek Libra <mlibra@redhat.com> - 1.3.1
- verbose warning in console - https://github.com/oVirt/ovirt-web-ui/issues/376
- scrolling of popups - https://github.com/oVirt/ovirt-web-ui/issues/394
- no autologout - https://github.com/oVirt/ovirt-web-ui/issues/308
- Make use of "AlwaysFilterResultsForWebUi" engine configuration parameter - https://github.com/oVirt/ovirt-web-ui/issues/317
- fix empty name in Create VM dialog - https://github.com/oVirt/ovirt-web-ui/issues/365
- select boxes are left-alligned - https://github.com/oVirt/ovirt-web-ui/issues/370
- allow empty memory/cpu - https://github.com/oVirt/ovirt-web-ui/issues/369
- docker image fixed - https://github.com/oVirt/ovirt-web-ui/issues/304
- HTML IDs added for automated testing
- Minor UI fixes
- translations updated

* Mon Oct 30 2017 Marek Libra <mlibra@redhat.com> - 1.3.0
- BnB (Brand new Branding) - alligned witth ovirt-engine
- Smartcard Enabled option
- SSH public key
- Gust OS names as labels
- i18n improvements, first tranlsations
- multiple fixes and minor UI enhancements


* Wed Aug 16 2017 Marek Libra <mlibra@redhat.com> - 1.2.1
- noarch rpm
- minor fixes, runtime dependencies generally updated
- usb-filter in .vv file
- basics for internationalization, but translation missing

* Wed Aug 2 2017 Marek Libra <mlibra@redhat.com> - 1.2.0
- branding
- infinite scroller for VMS list
- Change CD function
- "Runs on Host" - hyperlink to the host running particular VM
- "Loading ..." indicator of background activity
- "Pending Changes" tag rendered when NEXT_RUN configuration exists
- VM Type
- error messages improved
- fixed setting of VM icon
- multiple additional functional & UI fixes

* Tue Jun 20 2017 Marek Libra <mlibra@redhat.com> - 1.1.0
- Navigation via list of VMs to see details simplified
- Component for VM's Disks redesigned
- Context-based help
- Support for RDP graphics consoles
- ESC key used as back-button
- multiple UI fixes and improvements
- Configuration of graphics console added

* Fri Jun 2 2017 Marek Libra <mlibra@redhat.com> - 1.0.0
- "Door effect" removed, replaced by standard patternfly design
- User Messages are not closed automatically
- Check "Console in use" added
* Mon May 15 2017 Marek Libra <mlibra@redhat.com> - 0.2.2
- Minor fixes for pools
* Mon May 15 2017 Marek Libra <mlibra@redhat.com> - 0.2.1
- React and Redux updated to latest version
* Fri May 12 2017 Marek Libra <mlibra@redhat.com> - 0.2.0
- Add/Edit VM Dialog
- Autoconnect and Console options
- VM Pools
- the Remove VM action
- confirmation dialog improved
- functionality and UI fixes
* Wed Apr 19 2017 Marek Libra <mlibra@redhat.com> - 0.1.4
- Confirmation component
- About dialog
- UI fixes
- docker builds
- stability fixes
* Wed Apr 12 2017 Marek Libra <mlibra@redhat.com> - 0.1.3
- UI fixes
- docker builds
- oVirt API version check
- About dialog
* Mon Feb 20 2017 Marek Libra <mlibra@redhat.com> - 0.1.2
- Minor UI fixes, npm replaced by yarn
* Fri Dec 16 2016 Marek Libra <mlibra@redhat.com> - 0.1.1
- Minor UI fixes, authorizedRedirect.jsp
* Mon Nov 14 2016 Marek Libra <mlibra@redhat.com> - 0.1.0
- First version, Technical Preview
