# Used for rpm-packaging of pre-bundled application with already resolved JS dependencies
%global _plugindir %{_datarootdir}/cockpit/
%global _ovirtenginedir %{_datarootdir}/ovirt-engine
%global product oVirt
%global use_rhev %( test -z  && echo 1 || echo 0)
%define debug_package %{nil}


%global source_basename cockpit-ovirt-0.13.8

Name:           cockpit-ovirt
Version:        0.13.8
Release:        1%{?release_suffix}%{?checkout}%{?dist}
Summary:        Dashboard for Cockpit based on %{product}
License:        ASL 2.0
URL:            https://gerrit.ovirt.org/gitweb?p=cockpit-ovirt.git;a=summary
Source0:        http://resources.ovirt.org/pub/src/%{name}/%{source_basename}.tar.gz


%if 0%{?rhel}
ExclusiveArch:  x86_64
%else
BuildRequires: nodejs-packaging
ExclusiveArch: %{nodejs_arches} noarch
%endif

#This is a hack for copr, but why is it needed?
BuildRequires: python
BuildRequires: ovirt-engine-nodejs
BuildRequires: ovirt-engine-nodejs-modules
BuildRequires: ovirt-engine-yarn

%package dashboard
Summary:        Dashboard for Cockpit based on %{product}
BuildArch:      noarch


Requires:       cockpit
%if "0%{?dist}" == el7
Requires:       udisks2
%else
Requires:       cockpit-storaged
%endif
Requires:       ovirt-hosted-engine-setup >= 2.3.7
Requires:       otopi >= 1.8.0

Requires:       ansible

%description
This package provides a Cockpit dashboard for use with %{product}.

%description dashboard
This package provides a Cockpit dashboard for use with %{product}.

%prep
%setup -q -n"%{source_basename}"

# Use the ovirt-engine nodejs installation
export PATH="%{_datadir}/ovirt-engine-nodejs/bin:${PATH}"
for d in dashboard ; do
  pushd .
  cd ${d}
  %{_datadir}/ovirt-engine-nodejs-modules/setup-env.sh
  popd
done

# Copy the Node.js dependencies to the local "node_modules" directory
ln -s "%{_sharedstatedir}/ovirt-engine-nodejs-modules/node_modules"
ln -s "%{_sharedstatedir}/ovirt-engine-nodejs-modules/node_modules" ./dashboard/node_modules

%build
export PATH="%{_datadir}/ovirt-engine-nodejs/bin:${PATH}"
%if 0%{?use_rhev}
%configure --with-rhev
%else
%configure
%endif  #END RHEV

export PATH="./node_modules/.bin:${PATH}"
make

%install
make install DESTDIR=%{buildroot}

# Create /var/lib/ovirt-hosted-engine-setup/cockpit
install -dm 700 %{buildroot}%{_sharedstatedir}/ovirt-hosted-engine-setup/cockpit


%files dashboard
%doc README.md
%license LICENSE
%{_plugindir}/ovirt-dashboard
%dir %attr(700, root, root) %{_sharedstatedir}/ovirt-hosted-engine-setup/cockpit

%changelog
* Wed Sep 04 2019 Gal Zaidman <gzaidman@redhat.com> - 0.13.8-1
- HE and Gdeploy fixes

* Tue Aug 27 2019 Gal Zaidman <gzaidman@redhat.com> - 0.13.7-1
- HE and Gdeploy fixes

* Wed Aug 21 2019 Gal Zaidman <gzaidman@redhat.com> - 0.13.6-1
- HE and Gdeploy fixes

* Mon Jul 22 2019 Ido Rosenzwig <irosenzw@redhat.com> - 0.13.5-1
- HE and Gdeploy fixes

* Tue Jul 09 2019 Ido Rosenzwig <irosenzw@redhat.com> - 0.13.4-1
- HE and Gdeploy fixes

* Tue Jun 25 2019 Ido Rosenzwig <irosenzw@redhat.com> - 0.13.3-1
- HE and Gdeploy fixes

* Tue Jun 11 2019 Ido Rosenzwig <irosenzw@redhat.com> - 0.13.2-1
- he fixes

* Tue May 28 2019 Ido Rosenzwig <irosenzw@redhat.com> - 0.13.1-1
- he fixes

* Tue May 21 2019 Ido Rosenzwig <irosenzw@redhat.com> - 0.13.0-1
- he and Gdeploy fixes

* Tue May 14 2019 Ido Rosenzwig <irosenzw@redhat.com> - 0.12.9-1
- he and Gdeploy fixes

* Tue Apr 16 2019 Sandro Bonazzola <sbonazzo@redhat.com> - 0.12.8-1
- Rebase on 0.12.8

* Wed Apr 03 2019 Ido Rosenzwig <irosenzw@redhat.com> - 0.12.7-1
- he and Gdeploy fixes

* Tue Mar 26 2019 Ido Rosenzwig <irosenzw@redhat.com> - 0.12.6-1
- he and Gdeploy fixes

* Tue Mar 12 2019 Ido Rosenzwig <irosenzw@redhat.com> - 0.12.5-1
- he and Gdeploy fixes

* Mon Mar 04 2019 Ido Rosenzwig <irosenzw@redhat.com> - 0.12.4-1
- he and Gdeploy fixes

* Mon Feb 25 2019 Ido Rosenzwig <irosenzw@redhat.com> - 0.12.3-1
- Fix gateway validation on HE wizard

* Fri Feb 15 2019 Sandro Bonazzola <sbonazzo@redhat.com> - 0.12.2-1
- Rebase on 0.12.2

* Tue Jan 22 2019 Simone Tiraboschi <stirabos@redhat.com> - 0.12.1-1
- he fixes

* Mon Jan 07 2019 Sandro Bonazzola <sbonazzo@redhat.com> - 0.12.0-1
- Rebase on 0.12.0 GA

* Tue Nov 20 2018 Sandro Bonazzola <sbonazzo@redhat.com> - 0.12.0-0.0.beta1
- Rebase on 0.12.0_beta1

* Fri Sep  1 2017 Sandro Bonazzola <sbonazzo@redhat.com> - 0.11.0-1
- Rebase on upstream 0.11.0

* Wed Aug  9 2017 Ryan Barry <rbarry@redhat.com> - 0.10.7-0.0.23
- More Gdeploy fixes

* Mon Jul 31 2017 Ryan Barry <rbarry@redhat.com> - 0.10.7-0.0.22
- Gdeploy fixes

* Wed Jul 05 2017 Ryan Barry <rbarry@redhat.com> - 0.10.7-0.0.21
- hosted-engine: make the page optional by checking for the hosted-engine
  binary before enabling anything
- gdeploy: re-calculate thinpoolMetadata size dynamically

* Thu Jun 15 2017 Ryan Barry <rbarry@redhat.com> - 0.10.7-0.0.20
- vdsm: fix d3 import
- gdeploy: add qemu user to gluster group
- gdeploy: move multipath-disable before brick creation

* Wed Jun 07 2017 Ryan Barry <rbarry@redhat.com> - 0.10.7-0.0.19
- gdeploy: use chrony instead of ntpd
- gdeploy: disable repos when deploying

* Thu May 04 2017 Sandro Bonazzola <sbonazzo@redhat.com> - 0.10.7-0.0.18
- gdeploy: calculate arbiter brick size
- gdeploy: restart glusterd instead of start.
- gdeploy: calculate thinpoolMetadata size dynamically.
- gdeploy: Add option disable repos while generating gdeploy config file
- gdeploy: Remove text message when mount point is empty
- gdeploy: include gdeploy multipath disable script
* Fri Apr 14 2017 Ryan Barry <rbarry@redhat.com> - 0.10.7-0.0.17
- Unset confirm_otopi after passing
* Thu Mar 23 2017 Ryan Barry <rbarry@redhat.com> - 0.10.7-0.0.15
- Add hostnames to brick_dir in gluster config
* Wed Mar 08 2017 Sandro Bonazzola <sbonazzo@redhat.com> - 0.10.7-0.0.14
- Various gdeploy fixes
* Thu Mar 02 2017 Ryan Barry <rbarry@redhat.com> - 0.10.7-0.0.13
- Fix a misnamed variable
* Wed Mar 01 2017 Ryan Barry <rbarry@redhat.com> - 0.10.7-0.0.12
- Various gdeploy fixes
* Wed Feb 15 2017 Ryan Barry <rbarry@redhat.com> - 0.10.7-0.0.11
- Various gdeploy fixes
* Wed Feb 15 2017 Ryan Barry <rbarry@redhat.com> - 0.10.7-0.0.10
- Add a prompt for GPG keys for hosted engine setup
* Wed Feb 15 2017 Ryan Barry <rbarry@redhat.com> - 0.10.7-0.0.9
- Use yarn to build
* Thu Feb 09 2017 Ryan Barry <rbarry@redhat.com> - 0.10.7-0.0.8
- Pull in missed patches
* Wed Jan 25 2017 Ryan Barry <rbarry@redhat.com> - 0.10.7-0.0.7
- gdeploy fixes
- Don't prompt for a password in Firefox during HE setup
- Block HE setup if the host is already registered
* Wed Jan 25 2017 Ryan Barry <rbarry@redhat.com> - 0.10.7-0.0.6
- gdeploy fixes
* Mon Jan 23 2017 Ryan Barry <rbarry@redhat.com> - 0.10.7-0.0.5
- Disable uiplugin again
* Mon Jan 23 2017 Ryan Barry <rbarry@redhat.com> - 0.10.7-0.0.4
- Disable node dashboard on non-node systems
- Some vdsm fixes
* Wed Jan 04 2017 Ryan Barry <rbarry@redhat.com> - 0.10.7-0.0.3
- Fix syntax in dashboard helper
* Tue Jan 03 2017 Ryan Barry <rbarry@redhat.com> - 0.10.7-0.0.2
- gdeploy bug fixes
* Wed Dec 21 2016 Ryan Barry <rbarry@redhat.com> - 0.10.7-0.0.1
- gdeploy bug fixes
* Wed Dec 21 2016 Ryan Barry <rbarry@redhat.com> - 0.10.7-0.0.0
- Add gdeploy to hosted engine
* Tue Dec 20 2016 Ryan Barry <rbarry@redhat.com> - 0.10.6-1.4.3
- Keep all of the hosted-engine output
* Fri Nov 4 2016 Ryan Barry <rbarry@redhat.com> - 0.10.6-1.4.2
- Fix a regression with the last patch where the password was
  shown in plaintext
* Mon Oct 24 2016 Ryan Barry <rbarry@redhat.com> - 0.10.6-1.4.1
- Be smarter about the password check in hosted-engine setup
* Wed Aug 10 2016 Ryan Barry <rbarry@redhat.com> - 0.10.6-1.3.6
- Don't include the cockpit metapackage on RHEL
* Wed Jul 27 2016 Ryan Barry <rbarry@redhat.com> - 0.10.6-1.3.2
- UX improvements
* Fri Jul 1 2016 Ryan Barry <rbarry@redhat.com> - 0.10.6
- Run hosted-engine setup as a superuser if sudo is available
- Rename the dashboard so branding isn't needed
- UX improvements
* Thu Jun 16 2016 Marek Libra <mlibra@redhat.com> - 0.10.5
- UI improvements
* Wed Jun 08 2016 Marek Libra <mlibra@redhat.com> - 0.10.4
- UI bugfixes and minor usability improvements
* Tue Jun 07 2016 Ryan Barry <rbarry@redhat.com> - 0.10.3
- Update the otopi parser
* Tue Jun 07 2016 Ryan Barry <rbarry@redhat.com> - 0.10
- Add a hosted engine status pae
- Add cancellation buttons for hosted engine
- Catch abnormal exits
* Wed May 18 2016 Ryan Barry <rbarry@redhat.com> - 0.9
- Add links to other parts of cockpit on the dashboard
- Add the ability to show the host SSH key to the dashboard
- Terminate hosted engine setup when the page is exited
- Mask some fields in hosted engine setup
* Wed May 04 2016 Marek Libra <mlibra@redhat.com> - 0.8
- Remove debuginfo package
* Wed May 04 2016 Marek Libra <mlibra@redhat.com> - 0.8
- Remove debuginfo package
* Thu Apr 28 2016 Marek Libra <mlibra@redhat.com> - 0.7
- Add Webadmin Cockpit UI Plugin
* Mon Apr 25 2016 Marek Libra <mlibra@redhat.com> - 0.6
- Add vdsm VM Management
* Fri Apr 08 2016 Ryan Barry <rbarry@redhat.com> - 0.5
- Add node-dashboard
* Tue Mar 22 2016 Ryan Barry <rbarry@redhat.com> - 0.4
- Add node-dashboard
* Fri Mar 18 2016 Marek Libra <rbarry@redhat.com> - 0.3
- Update packaging to match upstream standards
- Convert to autotools
* Fri Mar 11 2016 Marek Libra <mlibra@redhat.com> - 0.2
* Thu Mar 03 2016 Marek Libra <mlibra@redhat.com> - 0.1
- Initial packaging

