# Used for rpm-packaging of pre-bundled application with already resolved JS dependencies
%global _plugindir %{_datarootdir}/cockpit/
%global _ovirtenginedir %{_datarootdir}/ovirt-engine
%global product oVirt
%global use_rhev %( test -z oVirt && echo 1 || echo 0)
%define debug_package %{nil}


%global source_basename cockpit-ovirt-0.14.14

Name:           cockpit-ovirt
Version:        0.14.14
Release:        1%{?release_suffix}%{?checkout}%{?dist}
Summary:        Dashboard for Cockpit based on %{product}
License:        ASL 2.0
URL:            https://gerrit.ovirt.org/gitweb?p=cockpit-ovirt.git;a=summary
Source0:        http://resources.ovirt.org/pub/src/%{name}/%{source_basename}.tar.gz


%if 0%{?rhel}
ExclusiveArch:  x86_64
%else
BuildRequires: nodejs-packaging
ExclusiveArch: %{nodejs_arches} noarch
%endif

%if 0%{?fedora} >= 30
# On Fedora npm is not required anymore from nodejs
BuildRequires: npm
%endif
BuildRequires: nodejs

# ovirt-engine-nodejs-modules >= 2.0.19 includes yarn.
BuildRequires: ovirt-engine-nodejs-modules >= 2.0.19

%if 0%{?enable_autotools}
BuildRequires:	autoconf
BuildRequires:	automake
BuildRequires:	gettext-devel
%endif

%package dashboard
Summary:        Dashboard for Cockpit based on %{product}
BuildArch:      noarch


Requires:       cockpit
Requires:       cockpit-storaged
Requires:       ovirt-hosted-engine-setup >= 2.4.7
Requires:       otopi >= 1.9.0

Requires:       ansible

%description
This package provides a Cockpit dashboard for use with %{product}.

%description dashboard
This package provides a Cockpit dashboard for use with %{product}.

%prep
%setup -q -n %{source_basename}

for d in dashboard ; do
  pushd .
  cd ${d}
  %{_datadir}/ovirt-engine-nodejs-modules/setup-env.sh
  popd
done

# Copy the Node.js dependencies to the local "node_modules" directory
ln -s "%{_sharedstatedir}/ovirt-engine-nodejs-modules/node_modules"
ln -s "%{_sharedstatedir}/ovirt-engine-nodejs-modules/node_modules" ./dashboard/node_modules

%build
%if 0%{?enable_autotools}
autoreconf -ivf
%endif

%configure

export PATH="./node_modules/.bin:${PATH}"
make

%install
make install DESTDIR=%{buildroot}

# Create /var/lib/ovirt-hosted-engine-setup/cockpit
install -dm 700 %{buildroot}%{_sharedstatedir}/ovirt-hosted-engine-setup/cockpit

# Create cockpit conf file to disable inactivity timeout
mkdir -p %{buildroot}/etc/cockpit/
cat <<__EOF__ >%{buildroot}/etc/cockpit/cockpit.conf
[Session]
IdleTimeout=0
__EOF__

%files dashboard
%doc README.md
%license LICENSE
%config /etc/cockpit/cockpit.conf
%{_plugindir}/ovirt-dashboard
%dir %attr(700, root, root) %{_sharedstatedir}/ovirt-hosted-engine-setup/cockpit

%changelog
* Thu Nov 12 2020 Aviv Turgeman <aturgema@redhat.com> - 0.14.14-1
- Gluster storage deployment fixes

* Tue Nov 3 2020 Aviv Turgeman <aturgema@redhat.com> - 0.14.13-1
- Gluster storage deployment fixes

* Wed Oct 14 2020 Gal Zaidman <gzaidman@redhat.com> - 0.14.12-1
- Gluster storage deployment fixes

* Tue Aug 18 2020 Aviv Turgeman <aturgema@redhat.com> - 0.14.11-1
- Gluster storage deployment fixes

* Tue Jun 20 2020 Aviv Turgeman <aturgema@redhat.com> - 0.14.10-1
- Gluster storage deployment fixes

* Tue Jun 09 2020 Gal Zaidman <gzaidman@redhat.com> - 0.14.9-1
- Gluster storage deployment fixes

* Tue Jun 09 2020 Gal Zaidman <gzaidman@redhat.com> - 0.14.8-1
- Gluster storage deployment fixes

* Tue May 26 2020 Gal Zaidman <gzaidman@redhat.com> - 0.14.7-1
- Gluster storage deployment fixes

* Tue May 05 2020 Gal Zaidman <gzaidman@redhat.com> - 0.14.6-1
- Gluster storage deployment fixes

* Fri Apr 17 2020 Sandro Bonazzola <sbonazzo@redhat.com> - 0.14.5-1
- Gluster storage deployment fixes
- Cockpit timeout configuration fixes

* Wed Apr 08 2020 Sandro Bonazzola <sbonazzo@redhat.com> - 0.14.4-1
- Gluster storage deployment fixes

* Fri Mar 20 2020 Sandro Bonazzola <sbonazzo@redhat.com> - 0.14.3-1
- Gluster storage deployment fixes

* Wed Mar 04 2020 Gal Zaidman <gzaidman@redhat.com> - 0.14.2-1
- Gluster storage deployment fixes

* Tue Jan 21 2020 Evgeny Slutsky <eslutsky@redhat.com> - 0.14.1-1
- Gluster storage deployment fixes

* Fri Nov 22 2019 Sandro Bonazzola <sbonazzo@redhat.com> - 0.14.0-1
- Rebase on upstream 0.14.0
- Initial release on el8

