# Used for rpm-packaging of pre-bundled application with already resolved JS dependencies
%global _plugindir %{_datarootdir}/cockpit/
%global _ovirtenginedir %{_datarootdir}/ovirt-engine
%global product oVirt
%global use_rhev %( test -z  && echo 1 || echo 0)
%define debug_package %{nil}


%global source_basename cockpit-ovirt-0.14.2

Name:           cockpit-ovirt
Version:        0.14.2
Release:        1%{?release_suffix}%{?checkout}%{?dist}
Summary:        Dashboard for Cockpit based on %{product}
License:        ASL 2.0
URL:            https://gerrit.ovirt.org/gitweb?p=cockpit-ovirt.git;a=summary
Source0:        http://resources.ovirt.org/pub/src/%{name}/%{source_basename}.tar.gz


%if 0%{?rhel}
ExclusiveArch:  x86_64
%else
BuildRequires: nodejs-packaging
ExclusiveArch: %{nodejs_arches} noarch
%endif

%if 0%{?fedora} >= 30
# On Fedora npm is not required anymore from nodejs
BuildRequires: npm
%endif
%if 0%{?fedora} >= 30 || 0%{?rhel} >= 8
BuildRequires: nodejs
%else
BuildRequires: ovirt-engine-nodejs
%endif
BuildRequires: ovirt-engine-nodejs-modules
BuildRequires: ovirt-engine-yarn

%if 0%{?enable_autotools}
BuildRequires:	autoconf
BuildRequires:	automake
BuildRequires:	gettext-devel
%endif

%package dashboard
Summary:        Dashboard for Cockpit based on %{product}
BuildArch:      noarch


Requires:       cockpit
%if "0%{?dist}" == el7
Requires:       udisks2
%else
Requires:       cockpit-storaged
%endif
Requires:       ovirt-hosted-engine-setup >= 2.4.0
Requires:       otopi >= 1.8.0

Requires:       ansible

%description
This package provides a Cockpit dashboard for use with %{product}.

%description dashboard
This package provides a Cockpit dashboard for use with %{product}.

%prep
%setup -q -n %{source_basename}

%if 0%{?fedora} >= 30 || 0%{?rhel} >= 8
# Use system nodejs
%else
# Use the ovirt-engine nodejs installation
export PATH="%{_datadir}/ovirt-engine-nodejs/bin:${PATH}"
%endif
for d in dashboard ; do
  pushd .
  cd ${d}
  %{_datadir}/ovirt-engine-nodejs-modules/setup-env.sh
  popd
done

# Copy the Node.js dependencies to the local "node_modules" directory
ln -s "%{_sharedstatedir}/ovirt-engine-nodejs-modules/node_modules"
ln -s "%{_sharedstatedir}/ovirt-engine-nodejs-modules/node_modules" ./dashboard/node_modules

%build
%if 0%{?enable_autotools}
autoreconf -ivf
%endif

%if 0%{?fedora} >= 30 || 0%{?rhel} >= 8
# Use system nodejs
%else
# Use the ovirt-engine nodejs installation
export PATH="%{_datadir}/ovirt-engine-nodejs/bin:${PATH}"
%endif

%if 0%{?use_rhev}
%configure --with-rhev
%else
%configure
%endif  #END RHEV

export PATH="./node_modules/.bin:${PATH}"
make

%install
make install DESTDIR=%{buildroot}

# Create /var/lib/ovirt-hosted-engine-setup/cockpit
install -dm 700 %{buildroot}%{_sharedstatedir}/ovirt-hosted-engine-setup/cockpit


%files dashboard
%doc README.md
%license LICENSE
%{_plugindir}/ovirt-dashboard
%dir %attr(700, root, root) %{_sharedstatedir}/ovirt-hosted-engine-setup/cockpit

%changelog
* Wed Mar 04 2020 Gal Zaidman <gzaidman@redhat.com> - 0.14.2-1
- Gluster storage deployment fixes

* Tue Jan 21 2020 Evgeny Slutsky <eslutsky@redhat.com> - 0.14.1-1
- Gluster storage deployment fixes

* Fri Nov 22 2019 Sandro Bonazzola <sbonazzo@redhat.com> - 0.14.0-1
- Rebase on upstream 0.14.0
- Initial release on el8

