/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.builders;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.ovirt.engine.sdk4.builders.DataCenterBuilder;
import org.ovirt.engine.sdk4.builders.NetworkBuilder;
import org.ovirt.engine.sdk4.builders.StorageConnectionBuilder;
import org.ovirt.engine.sdk4.internal.containers.IscsiBondContainer;
import org.ovirt.engine.sdk4.types.DataCenter;
import org.ovirt.engine.sdk4.types.IscsiBond;
import org.ovirt.engine.sdk4.types.Network;
import org.ovirt.engine.sdk4.types.StorageConnection;

public class IscsiBondBuilder {
    private String comment;
    private DataCenter dataCenter;
    private String description;
    private String href;
    private String id;
    private String name;
    private List<Network> networks;
    private List<StorageConnection> storageConnections;

    public IscsiBondBuilder comment(String newComment) {
        this.comment = newComment;
        return this;
    }

    public IscsiBondBuilder dataCenter(DataCenter newDataCenter) {
        this.dataCenter = newDataCenter;
        return this;
    }

    public IscsiBondBuilder dataCenter(DataCenterBuilder newDataCenter) {
        this.dataCenter = newDataCenter == null ? null : newDataCenter.build();
        return this;
    }

    public IscsiBondBuilder description(String newDescription) {
        this.description = newDescription;
        return this;
    }

    public IscsiBondBuilder href(String newHref) {
        this.href = newHref;
        return this;
    }

    public IscsiBondBuilder id(String newId) {
        this.id = newId;
        return this;
    }

    public IscsiBondBuilder name(String newName) {
        this.name = newName;
        return this;
    }

    public IscsiBondBuilder networks(List<Network> newNetworks) {
        if (newNetworks != null) {
            if (this.networks == null) {
                this.networks = new ArrayList<Network>(newNetworks);
            } else {
                this.networks.addAll(newNetworks);
            }
        }
        return this;
    }

    public IscsiBondBuilder networks(Network ... newNetworks) {
        if (newNetworks != null) {
            if (this.networks == null) {
                this.networks = new ArrayList<Network>(newNetworks.length);
            }
            Collections.addAll(this.networks, newNetworks);
        }
        return this;
    }

    public IscsiBondBuilder networks(NetworkBuilder ... newNetworks) {
        if (newNetworks != null) {
            if (this.networks == null) {
                this.networks = new ArrayList<Network>(newNetworks.length);
            }
            for (NetworkBuilder builder : newNetworks) {
                this.networks.add(builder.build());
            }
        }
        return this;
    }

    public IscsiBondBuilder storageConnections(List<StorageConnection> newStorageConnections) {
        if (newStorageConnections != null) {
            if (this.storageConnections == null) {
                this.storageConnections = new ArrayList<StorageConnection>(newStorageConnections);
            } else {
                this.storageConnections.addAll(newStorageConnections);
            }
        }
        return this;
    }

    public IscsiBondBuilder storageConnections(StorageConnection ... newStorageConnections) {
        if (newStorageConnections != null) {
            if (this.storageConnections == null) {
                this.storageConnections = new ArrayList<StorageConnection>(newStorageConnections.length);
            }
            Collections.addAll(this.storageConnections, newStorageConnections);
        }
        return this;
    }

    public IscsiBondBuilder storageConnections(StorageConnectionBuilder ... newStorageConnections) {
        if (newStorageConnections != null) {
            if (this.storageConnections == null) {
                this.storageConnections = new ArrayList<StorageConnection>(newStorageConnections.length);
            }
            for (StorageConnectionBuilder builder : newStorageConnections) {
                this.storageConnections.add(builder.build());
            }
        }
        return this;
    }

    public IscsiBond build() {
        IscsiBondContainer container = new IscsiBondContainer();
        container.comment(this.comment);
        container.dataCenter(this.dataCenter);
        container.description(this.description);
        container.href(this.href);
        container.id(this.id);
        container.name(this.name);
        container.networks(this.networks);
        container.storageConnections(this.storageConnections);
        return container;
    }
}

