/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.internal.services;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.util.EntityUtils;
import org.ovirt.api.metamodel.runtime.xml.XmlReader;
import org.ovirt.api.metamodel.runtime.xml.XmlWriter;
import org.ovirt.engine.sdk4.BaseRequest;
import org.ovirt.engine.sdk4.Error;
import org.ovirt.engine.sdk4.Service;
import org.ovirt.engine.sdk4.builders.NetworkBuilder;
import org.ovirt.engine.sdk4.internal.HttpConnection;
import org.ovirt.engine.sdk4.internal.services.ServiceImpl;
import org.ovirt.engine.sdk4.internal.xml.XmlNetworkReader;
import org.ovirt.engine.sdk4.internal.xml.XmlNetworkWriter;
import org.ovirt.engine.sdk4.services.ClusterNetworkService;
import org.ovirt.engine.sdk4.types.Network;

public class ClusterNetworkServiceImpl
extends ServiceImpl
implements ClusterNetworkService {
    public ClusterNetworkServiceImpl(HttpConnection connection, String path) {
        super(connection, path);
    }

    @Override
    public ClusterNetworkService.GetRequest get() {
        return new GetRequestImpl();
    }

    @Override
    public ClusterNetworkService.RemoveRequest remove() {
        return new RemoveRequestImpl();
    }

    @Override
    public ClusterNetworkService.UpdateRequest update() {
        return new UpdateRequestImpl();
    }

    @Override
    public Service service(String path) {
        if (path == null) {
            return this;
        }
        throw new Error("The path " + path + " doesn't correspond to any service");
    }

    public String toString() {
        return "ClusterNetworkService:" + this.getPath();
    }

    private class UpdateResponseImpl
    implements ClusterNetworkService.UpdateResponse {
        private Network network;

        private UpdateResponseImpl() {
        }

        public void network(Network network) {
            this.network = network;
        }

        @Override
        public Network network() {
            return this.network;
        }
    }

    private class UpdateRequestImpl
    extends BaseRequest<ClusterNetworkService.UpdateRequest, ClusterNetworkService.UpdateResponse>
    implements ClusterNetworkService.UpdateRequest {
        private Network network;

        private UpdateRequestImpl() {
        }

        @Override
        public ClusterNetworkService.UpdateRequest network(Network network) {
            this.network = network;
            return this;
        }

        @Override
        public ClusterNetworkService.UpdateRequest network(NetworkBuilder network) {
            this.network = network.build();
            return this;
        }

        @Override
        public ClusterNetworkService.UpdateResponse send() {
            HttpResponse response;
            HttpPut request = null;
            try {
                URIBuilder uriBuilder = new URIBuilder(ClusterNetworkServiceImpl.this.getConnection().getUrl() + ClusterNetworkServiceImpl.this.getPath());
                if (this.query != null) {
                    for (Map.Entry queryParam : this.query.entrySet()) {
                        uriBuilder.addParameter((String)queryParam.getKey(), (String)queryParam.getValue());
                    }
                }
                request = new HttpPut(uriBuilder.build());
            }
            catch (URISyntaxException ex) {
                throw new Error("Failed to build URL", ex);
            }
            try (ByteArrayOutputStream output = new ByteArrayOutputStream();
                 XmlWriter xmlWriter = new XmlWriter(output, true);){
                XmlNetworkWriter.writeOne(this.network, xmlWriter);
                xmlWriter.flush();
                request.setEntity((HttpEntity)new ByteArrayEntity(output.toByteArray()));
            }
            catch (IOException ex) {
                throw new Error("Failed to parse response", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            if ((response = ClusterNetworkServiceImpl.this.getConnection().send((HttpUriRequest)request)).getStatusLine().getStatusCode() == 200) {
                try {
                    XmlReader reader = new XmlReader(response.getEntity().getContent());
                    try {
                        UpdateResponseImpl actionResponse = new UpdateResponseImpl();
                        actionResponse.network(XmlNetworkReader.readOne(reader));
                        UpdateResponseImpl updateResponseImpl = actionResponse;
                        reader.close();
                        return updateResponseImpl;
                    }
                    catch (Throwable throwable) {
                        try {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        catch (IOException ex) {
                            throw new Error("Failed to read response", ex);
                        }
                    }
                }
                finally {
                    EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                }
            }
            ClusterNetworkServiceImpl.this.checkFault(response);
            return new UpdateResponseImpl();
        }
    }

    private class RemoveResponseImpl
    implements ClusterNetworkService.RemoveResponse {
        private RemoveResponseImpl() {
        }
    }

    private class RemoveRequestImpl
    extends BaseRequest<ClusterNetworkService.RemoveRequest, ClusterNetworkService.RemoveResponse>
    implements ClusterNetworkService.RemoveRequest {
        private RemoveRequestImpl() {
        }

        @Override
        public ClusterNetworkService.RemoveResponse send() {
            HttpResponse response;
            HttpDelete request = null;
            try {
                URIBuilder uriBuilder = new URIBuilder(ClusterNetworkServiceImpl.this.getConnection().getUrl() + ClusterNetworkServiceImpl.this.getPath());
                if (this.query != null) {
                    for (Map.Entry queryParam : this.query.entrySet()) {
                        uriBuilder.addParameter((String)queryParam.getKey(), (String)queryParam.getValue());
                    }
                }
                request = new HttpDelete(uriBuilder.build());
            }
            catch (URISyntaxException ex) {
                throw new Error("Failed to build URL", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            if ((response = ClusterNetworkServiceImpl.this.getConnection().send((HttpUriRequest)request)).getStatusLine().getStatusCode() == 200) {
                EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                return new RemoveResponseImpl();
            }
            ClusterNetworkServiceImpl.this.checkFault(response);
            return new RemoveResponseImpl();
        }
    }

    private class GetResponseImpl
    implements ClusterNetworkService.GetResponse {
        private Network network;

        private GetResponseImpl() {
        }

        public void network(Network network) {
            this.network = network;
        }

        @Override
        public Network network() {
            return this.network;
        }
    }

    private class GetRequestImpl
    extends BaseRequest<ClusterNetworkService.GetRequest, ClusterNetworkService.GetResponse>
    implements ClusterNetworkService.GetRequest {
        private String follow;

        private GetRequestImpl() {
        }

        @Override
        public ClusterNetworkService.GetRequest follow(String follow) {
            this.follow = follow;
            return this;
        }

        @Override
        public ClusterNetworkService.GetResponse send() {
            HttpResponse response;
            HttpGet request = null;
            try {
                URIBuilder uriBuilder = new URIBuilder(ClusterNetworkServiceImpl.this.getConnection().getUrl() + ClusterNetworkServiceImpl.this.getPath());
                if (this.follow != null) {
                    uriBuilder.addParameter("follow", XmlWriter.renderString(this.follow));
                }
                if (this.query != null) {
                    for (Map.Entry queryParam : this.query.entrySet()) {
                        uriBuilder.addParameter((String)queryParam.getKey(), (String)queryParam.getValue());
                    }
                }
                request = new HttpGet(uriBuilder.build());
            }
            catch (URISyntaxException ex) {
                throw new Error("Failed to build URL", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            if ((response = ClusterNetworkServiceImpl.this.getConnection().send((HttpUriRequest)request)).getStatusLine().getStatusCode() == 200) {
                try {
                    XmlReader reader = new XmlReader(response.getEntity().getContent());
                    try {
                        GetResponseImpl actionResponse = new GetResponseImpl();
                        actionResponse.network(XmlNetworkReader.readOne(reader));
                        GetResponseImpl getResponseImpl = actionResponse;
                        reader.close();
                        return getResponseImpl;
                    }
                    catch (Throwable throwable) {
                        try {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        catch (IOException ex) {
                            throw new Error("Failed to read response", ex);
                        }
                    }
                }
                finally {
                    EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                }
            }
            ClusterNetworkServiceImpl.this.checkFault(response);
            return new GetResponseImpl();
        }
    }
}

