/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.internal.services;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.util.EntityUtils;
import org.ovirt.api.metamodel.runtime.xml.XmlReader;
import org.ovirt.api.metamodel.runtime.xml.XmlWriter;
import org.ovirt.engine.sdk4.BaseRequest;
import org.ovirt.engine.sdk4.Error;
import org.ovirt.engine.sdk4.Service;
import org.ovirt.engine.sdk4.builders.ActionBuilder;
import org.ovirt.engine.sdk4.internal.HttpConnection;
import org.ovirt.engine.sdk4.internal.services.ServiceImpl;
import org.ovirt.engine.sdk4.internal.services.StepsServiceImpl;
import org.ovirt.engine.sdk4.internal.xml.XmlActionWriter;
import org.ovirt.engine.sdk4.internal.xml.XmlJobReader;
import org.ovirt.engine.sdk4.services.JobService;
import org.ovirt.engine.sdk4.services.StepsService;
import org.ovirt.engine.sdk4.types.Action;
import org.ovirt.engine.sdk4.types.Job;

public class JobServiceImpl
extends ServiceImpl
implements JobService {
    public JobServiceImpl(HttpConnection connection, String path) {
        super(connection, path);
    }

    @Override
    public JobService.ClearRequest clear() {
        return new ClearRequestImpl();
    }

    @Override
    public JobService.EndRequest end() {
        return new EndRequestImpl();
    }

    @Override
    public JobService.GetRequest get() {
        return new GetRequestImpl();
    }

    @Override
    public StepsService stepsService() {
        return new StepsServiceImpl(this.getConnection(), this.getPath() + "/steps");
    }

    @Override
    public Service service(String path) {
        if (path == null) {
            return this;
        }
        if (path.equals("steps")) {
            return this.stepsService();
        }
        if (path.startsWith("steps/")) {
            return this.stepsService().service(path.substring(6));
        }
        throw new Error("The path " + path + " doesn't correspond to any service");
    }

    public String toString() {
        return "JobService:" + this.getPath();
    }

    private class GetResponseImpl
    implements JobService.GetResponse {
        private Job job;

        private GetResponseImpl() {
        }

        public void job(Job job) {
            this.job = job;
        }

        @Override
        public Job job() {
            return this.job;
        }
    }

    private class GetRequestImpl
    extends BaseRequest<JobService.GetRequest, JobService.GetResponse>
    implements JobService.GetRequest {
        private String follow;

        private GetRequestImpl() {
        }

        @Override
        public JobService.GetRequest follow(String follow) {
            this.follow = follow;
            return this;
        }

        @Override
        public JobService.GetResponse send() {
            HttpResponse response;
            HttpGet request = null;
            try {
                URIBuilder uriBuilder = new URIBuilder(JobServiceImpl.this.getConnection().getUrl() + JobServiceImpl.this.getPath());
                if (this.follow != null) {
                    uriBuilder.addParameter("follow", XmlWriter.renderString(this.follow));
                }
                if (this.query != null) {
                    for (Map.Entry queryParam : this.query.entrySet()) {
                        uriBuilder.addParameter((String)queryParam.getKey(), (String)queryParam.getValue());
                    }
                }
                request = new HttpGet(uriBuilder.build());
            }
            catch (URISyntaxException ex) {
                throw new Error("Failed to build URL", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            if ((response = JobServiceImpl.this.getConnection().send((HttpUriRequest)request)).getStatusLine().getStatusCode() == 200) {
                try {
                    XmlReader reader = new XmlReader(response.getEntity().getContent());
                    try {
                        GetResponseImpl actionResponse = new GetResponseImpl();
                        actionResponse.job(XmlJobReader.readOne(reader));
                        GetResponseImpl getResponseImpl = actionResponse;
                        reader.close();
                        return getResponseImpl;
                    }
                    catch (Throwable throwable) {
                        try {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        catch (IOException ex) {
                            throw new Error("Failed to read response", ex);
                        }
                    }
                }
                finally {
                    EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                }
            }
            JobServiceImpl.this.checkFault(response);
            return new GetResponseImpl();
        }
    }

    private class EndResponseImpl
    implements JobService.EndResponse {
        private EndResponseImpl() {
        }
    }

    private class EndRequestImpl
    extends BaseRequest<JobService.EndRequest, JobService.EndResponse>
    implements JobService.EndRequest {
        private Boolean async;
        private Boolean force;
        private Boolean succeeded;

        private EndRequestImpl() {
        }

        @Override
        public JobService.EndRequest async(Boolean async) {
            this.async = async;
            return this;
        }

        @Override
        public JobService.EndRequest force(Boolean force) {
            this.force = force;
            return this;
        }

        @Override
        public JobService.EndRequest succeeded(Boolean succeeded) {
            this.succeeded = succeeded;
            return this;
        }

        @Override
        public JobService.EndResponse send() {
            HttpPost request = new HttpPost(JobServiceImpl.this.getConnection().getUrl() + JobServiceImpl.this.getPath() + "/end");
            try (ByteArrayOutputStream output = new ByteArrayOutputStream();
                 XmlWriter xmlWriter = new XmlWriter(output, true);){
                ActionBuilder action = new ActionBuilder();
                action.async(this.async);
                action.force(this.force);
                action.succeeded(this.succeeded);
                XmlActionWriter.writeOne(action.build(), xmlWriter);
                xmlWriter.flush();
                request.setEntity((HttpEntity)new ByteArrayEntity(output.toByteArray()));
            }
            catch (IOException ex) {
                throw new Error("Failed to write request", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            HttpResponse response = JobServiceImpl.this.getConnection().send((HttpUriRequest)request);
            Action action = JobServiceImpl.this.checkAction(response);
            EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
            return new EndResponseImpl();
        }
    }

    private class ClearResponseImpl
    implements JobService.ClearResponse {
        private ClearResponseImpl() {
        }
    }

    private class ClearRequestImpl
    extends BaseRequest<JobService.ClearRequest, JobService.ClearResponse>
    implements JobService.ClearRequest {
        private Boolean async;

        private ClearRequestImpl() {
        }

        @Override
        public JobService.ClearRequest async(Boolean async) {
            this.async = async;
            return this;
        }

        @Override
        public JobService.ClearResponse send() {
            HttpPost request = new HttpPost(JobServiceImpl.this.getConnection().getUrl() + JobServiceImpl.this.getPath() + "/clear");
            try (ByteArrayOutputStream output = new ByteArrayOutputStream();
                 XmlWriter xmlWriter = new XmlWriter(output, true);){
                ActionBuilder action = new ActionBuilder();
                action.async(this.async);
                XmlActionWriter.writeOne(action.build(), xmlWriter);
                xmlWriter.flush();
                request.setEntity((HttpEntity)new ByteArrayEntity(output.toByteArray()));
            }
            catch (IOException ex) {
                throw new Error("Failed to write request", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            HttpResponse response = JobServiceImpl.this.getConnection().send((HttpUriRequest)request);
            Action action = JobServiceImpl.this.checkAction(response);
            EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
            return new ClearResponseImpl();
        }
    }
}

