/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.cellview.client;

import com.google.gwt.cell.client.Cell;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.dom.client.Document;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.EventTarget;
import com.google.gwt.dom.client.NativeEvent;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.GwtEvent;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.safehtml.shared.SafeHtml;
import com.google.gwt.safehtml.shared.SafeHtmlBuilder;
import com.google.gwt.user.cellview.client.CellBasedWidgetImpl;
import com.google.gwt.user.cellview.client.HasDataPresenter;
import com.google.gwt.user.cellview.client.HasKeyboardPagingPolicy;
import com.google.gwt.user.cellview.client.HasKeyboardSelectionPolicy;
import com.google.gwt.user.cellview.client.LoadingStateChangeEvent;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Focusable;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.user.client.ui.impl.FocusImpl;
import com.google.gwt.view.client.CellPreviewEvent;
import com.google.gwt.view.client.DefaultSelectionEventManager;
import com.google.gwt.view.client.HasData;
import com.google.gwt.view.client.HasKeyProvider;
import com.google.gwt.view.client.ProvidesKey;
import com.google.gwt.view.client.Range;
import com.google.gwt.view.client.RangeChangeEvent;
import com.google.gwt.view.client.RowCountChangeEvent;
import com.google.gwt.view.client.SelectionModel;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public abstract class AbstractHasData<T>
extends Composite
implements HasData<T>,
HasKeyProvider<T>,
Focusable,
HasKeyboardPagingPolicy {
    private static Element tmpElem;
    boolean isFocused;
    private char accessKey = '\u0000';
    private boolean isRefreshing;
    private final HasDataPresenter<T> presenter;
    private HandlerRegistration keyboardSelectionReg;
    private HandlerRegistration selectionManagerReg;
    private int tabIndex;

    static Element convertToElements(Widget widget, Element tmpElem, SafeHtml html) {
        DOM.setEventListener(tmpElem, widget);
        tmpElem.setInnerSafeHtml(html);
        DOM.setEventListener(tmpElem, null);
        return tmpElem;
    }

    static void replaceAllChildren(Widget widget, Element childContainer, SafeHtml html) {
        if (!widget.isAttached()) {
            DOM.setEventListener(widget.getElement(), widget);
        }
        childContainer.setInnerSafeHtml(CellBasedWidgetImpl.get().processHtml(html));
        if (!widget.isAttached()) {
            DOM.setEventListener(widget.getElement(), null);
        }
    }

    static void replaceChildren(Widget widget, Element childContainer, Element newChildren, int start, SafeHtml html) {
        int childCount = childContainer.getChildCount();
        Element toReplace = null;
        if (start < childCount) {
            toReplace = (Element)childContainer.getChild(start).cast();
        }
        int count = newChildren.getChildCount();
        for (int i = 0; i < count; ++i) {
            if (toReplace == null) {
                childContainer.appendChild(newChildren.getChild(0));
                continue;
            }
            Element nextSibling = toReplace.getNextSiblingElement();
            childContainer.replaceChild(newChildren.getChild(0), toReplace);
            toReplace = nextSibling;
        }
    }

    private static Element getTmpElem() {
        if (tmpElem == null) {
            tmpElem = Document.get().createDivElement();
        }
        return tmpElem;
    }

    public AbstractHasData(final Element elem, int pageSize, ProvidesKey<T> keyProvider) {
        this(new Widget(){
            {
                this.setElement(elem);
            }
        }, pageSize, keyProvider);
    }

    public AbstractHasData(Widget widget, int pageSize, ProvidesKey<T> keyProvider) {
        this.initWidget(widget);
        this.presenter = new HasDataPresenter(this, new View(this), pageSize, keyProvider);
        HashSet<String> eventTypes = new HashSet<String>();
        eventTypes.add("focus");
        eventTypes.add("blur");
        eventTypes.add("keydown");
        eventTypes.add("keyup");
        eventTypes.add("click");
        eventTypes.add("mousedown");
        CellBasedWidgetImpl.get().sinkEvents(this, eventTypes);
        this.selectionManagerReg = this.addCellPreviewHandler(DefaultSelectionEventManager.createDefaultManager());
        this.setKeyboardSelectionHandler(new DefaultKeyboardSelectionHandler(this));
    }

    @Override
    public HandlerRegistration addCellPreviewHandler(CellPreviewEvent.Handler<T> handler) {
        return this.presenter.addCellPreviewHandler(handler);
    }

    public HandlerRegistration addLoadingStateChangeHandler(LoadingStateChangeEvent.Handler handler) {
        return this.presenter.addLoadingStateChangeHandler(handler);
    }

    @Override
    public HandlerRegistration addRangeChangeHandler(RangeChangeEvent.Handler handler) {
        return this.presenter.addRangeChangeHandler(handler);
    }

    @Override
    public HandlerRegistration addRowCountChangeHandler(RowCountChangeEvent.Handler handler) {
        return this.presenter.addRowCountChangeHandler(handler);
    }

    public HandlerRegistration addRedrawHandler(RedrawEvent.Handler handler) {
        return this.addHandler(handler, RedrawEvent.TYPE);
    }

    public char getAccessKey() {
        return this.accessKey;
    }

    @Deprecated
    public T getDisplayedItem(int indexOnPage) {
        return this.getVisibleItem(indexOnPage);
    }

    @Deprecated
    public List<T> getDisplayedItems() {
        return this.getVisibleItems();
    }

    @Override
    public HasKeyboardPagingPolicy.KeyboardPagingPolicy getKeyboardPagingPolicy() {
        return this.presenter.getKeyboardPagingPolicy();
    }

    public int getKeyboardSelectedRow() {
        return this.presenter.getKeyboardSelectedRow();
    }

    @Override
    public HasKeyboardSelectionPolicy.KeyboardSelectionPolicy getKeyboardSelectionPolicy() {
        return this.presenter.getKeyboardSelectionPolicy();
    }

    @Override
    public ProvidesKey<T> getKeyProvider() {
        return this.presenter.getKeyProvider();
    }

    public final int getPageSize() {
        return this.getVisibleRange().getLength();
    }

    public final int getPageStart() {
        return this.getVisibleRange().getStart();
    }

    public Element getRowContainer() {
        this.presenter.flush();
        return this.getChildContainer();
    }

    @Override
    public int getRowCount() {
        return this.presenter.getRowCount();
    }

    @Override
    public SelectionModel<? super T> getSelectionModel() {
        return this.presenter.getSelectionModel();
    }

    @Override
    public int getTabIndex() {
        return this.tabIndex;
    }

    public Object getValueKey(T value) {
        ProvidesKey<T> keyProvider = this.getKeyProvider();
        return keyProvider == null || value == null ? value : keyProvider.getKey(value);
    }

    @Override
    public T getVisibleItem(int indexOnPage) {
        this.checkRowBounds(indexOnPage);
        return this.presenter.getVisibleItem(indexOnPage);
    }

    @Override
    public int getVisibleItemCount() {
        return this.presenter.getVisibleItemCount();
    }

    @Override
    public List<T> getVisibleItems() {
        return this.presenter.getVisibleItems();
    }

    @Override
    public Range getVisibleRange() {
        return this.presenter.getVisibleRange();
    }

    @Override
    public boolean isRowCountExact() {
        return this.presenter.isRowCountExact();
    }

    @Override
    public final void onBrowserEvent(Event event) {
        CellBasedWidgetImpl.get().onBrowserEvent(this, event);
        if (this.isRefreshing) {
            return;
        }
        EventTarget eventTarget = event.getEventTarget();
        if (!Element.is(eventTarget)) {
            return;
        }
        Element target = Element.as(eventTarget);
        if (!this.getElement().isOrHasChild(Element.as(eventTarget))) {
            return;
        }
        super.onBrowserEvent(event);
        String eventType = event.getType();
        if ("focus".equals(eventType)) {
            this.isFocused = true;
            this.onFocus();
        } else if ("blur".equals(eventType)) {
            this.isFocused = false;
            this.onBlur();
        } else if ("keydown".equals(eventType)) {
            this.isFocused = true;
        } else if ("mousedown".equals(eventType) && CellBasedWidgetImpl.get().isFocusable(Element.as(target))) {
            this.isFocused = true;
        }
        this.onBrowserEvent2(event);
    }

    public void redraw() {
        this.presenter.redraw();
    }

    public void redrawRow(int absRowIndex) {
        int relRowIndex = absRowIndex - this.getPageStart();
        this.checkRowBounds(relRowIndex);
        this.setRowData(absRowIndex, Collections.singletonList(this.getVisibleItem(relRowIndex)));
    }

    @Override
    public void setAccessKey(char key) {
        this.accessKey = key;
        this.setKeyboardSelected(this.getKeyboardSelectedRow(), true, false);
    }

    @Override
    public void setFocus(boolean focused) {
        Element elem = this.getKeyboardSelectedElement();
        if (elem != null) {
            if (focused) {
                elem.focus();
            } else {
                elem.blur();
            }
        }
    }

    @Override
    public void setKeyboardPagingPolicy(HasKeyboardPagingPolicy.KeyboardPagingPolicy policy) {
        this.presenter.setKeyboardPagingPolicy(policy);
    }

    public final void setKeyboardSelectedRow(int row) {
        this.setKeyboardSelectedRow(row, true);
    }

    public void setKeyboardSelectedRow(int row, boolean stealFocus) {
        this.presenter.setKeyboardSelectedRow(row, stealFocus, true);
    }

    public void setKeyboardSelectionHandler(CellPreviewEvent.Handler<T> keyboardSelectionReg) {
        if (this.keyboardSelectionReg != null) {
            this.keyboardSelectionReg.removeHandler();
            this.keyboardSelectionReg = null;
        }
        if (keyboardSelectionReg != null) {
            this.keyboardSelectionReg = this.addCellPreviewHandler(keyboardSelectionReg);
        }
    }

    @Override
    public void setKeyboardSelectionPolicy(HasKeyboardSelectionPolicy.KeyboardSelectionPolicy policy) {
        this.presenter.setKeyboardSelectionPolicy(policy);
    }

    public final void setPageSize(int pageSize) {
        this.setVisibleRange(this.getPageStart(), pageSize);
    }

    public final void setPageStart(int pageStart) {
        this.setVisibleRange(pageStart, this.getPageSize());
    }

    @Override
    public final void setRowCount(int count) {
        this.setRowCount(count, true);
    }

    @Override
    public void setRowCount(int size, boolean isExact) {
        this.presenter.setRowCount(size, isExact);
    }

    public final void setRowData(List<? extends T> values) {
        this.setRowCount(values.size());
        this.setVisibleRange(0, values.size());
        this.setRowData(0, values);
    }

    @Override
    public void setRowData(int start, List<? extends T> values) {
        this.presenter.setRowData(start, values);
    }

    @Override
    public void setSelectionModel(SelectionModel<? super T> selectionModel) {
        this.presenter.setSelectionModel(selectionModel);
    }

    public void setSelectionModel(SelectionModel<? super T> selectionModel, CellPreviewEvent.Handler<T> selectionEventManager) {
        if (this.selectionManagerReg != null) {
            this.selectionManagerReg.removeHandler();
            this.selectionManagerReg = null;
        }
        if (selectionEventManager != null) {
            this.selectionManagerReg = this.addCellPreviewHandler(selectionEventManager);
        }
        this.setSelectionModel(selectionModel);
    }

    @Override
    public void setTabIndex(int index) {
        this.tabIndex = index;
        this.setKeyboardSelected(this.getKeyboardSelectedRow(), true, false);
    }

    @Override
    public final void setVisibleRange(int start, int length) {
        this.setVisibleRange(new Range(start, length));
    }

    @Override
    public void setVisibleRange(Range range) {
        this.presenter.setVisibleRange(range);
    }

    @Override
    public void setVisibleRangeAndClearData(Range range, boolean forceRangeChangeEvent) {
        this.presenter.setVisibleRangeAndClearData(range, forceRangeChangeEvent);
    }

    protected boolean cellConsumesEventType(Cell<?> cell, String eventType) {
        Set<String> consumedEvents = cell.getConsumedEvents();
        return consumedEvents != null && consumedEvents.contains(eventType);
    }

    protected void checkRowBounds(int row) {
        if (!this.isRowWithinBounds(row)) {
            throw new IndexOutOfBoundsException("Row index: " + row + ", Row size: " + this.getRowCount());
        }
    }

    protected Element convertToElements(SafeHtml html) {
        return AbstractHasData.convertToElements(this, AbstractHasData.getTmpElem(), html);
    }

    protected abstract boolean dependsOnSelection();

    protected abstract Element getChildContainer();

    protected Element getChildElement(int index) {
        Element childContainer = this.getChildContainer();
        int childCount = childContainer.getChildCount();
        return index < childCount ? (Element)childContainer.getChild(index).cast() : null;
    }

    protected abstract Element getKeyboardSelectedElement();

    protected abstract boolean isKeyboardNavigationSuppressed();

    protected boolean isRowWithinBounds(int row) {
        return row >= 0 && row < this.presenter.getVisibleItemCount();
    }

    protected void onBlur() {
    }

    protected void onBrowserEvent2(Event event) {
    }

    protected void onFocus() {
    }

    protected void onLoadingStateChanged(LoadingStateChangeEvent.LoadingState state) {
        this.fireEvent(new LoadingStateChangeEvent(state));
    }

    @Override
    protected void onUnload() {
        this.isFocused = false;
        super.onUnload();
    }

    protected abstract void renderRowValues(SafeHtmlBuilder var1, List<T> var2, int var3, SelectionModel<? super T> var4) throws UnsupportedOperationException;

    protected void replaceAllChildren(List<T> values, SafeHtml html) {
        AbstractHasData.replaceAllChildren(this, this.getChildContainer(), html);
    }

    protected void replaceChildren(List<T> values, int start, SafeHtml html) {
        Element newChildren = this.convertToElements(html);
        AbstractHasData.replaceChildren(this, this.getChildContainer(), newChildren, start, html);
    }

    protected abstract boolean resetFocusOnCell();

    protected void setFocusable(Element elem, boolean focusable) {
        if (focusable) {
            FocusImpl focusImpl = FocusImpl.getFocusImplForWidget();
            focusImpl.setTabIndex(elem, this.getTabIndex());
            if (this.accessKey != '\u0000') {
                focusImpl.setAccessKey(elem, this.accessKey);
            }
        } else {
            elem.setTabIndex(-1);
            elem.removeAttribute("tabIndex");
            elem.removeAttribute("accessKey");
        }
    }

    protected abstract void setKeyboardSelected(int var1, boolean var2, boolean var3);

    @Deprecated
    protected void setSelected(Element elem, boolean selected) {
    }

    final HandlerRegistration addValueChangeHandler(ValueChangeHandler<List<T>> handler) {
        return this.addHandler(handler, ValueChangeEvent.getType());
    }

    native void adopt(Widget var1);

    native void doAttach(Widget var1);

    native void doDetach(Widget var1);

    HasDataPresenter<T> getPresenter() {
        return this.presenter;
    }

    void showOrHide(Element element, boolean show) {
        if (element == null) {
            return;
        }
        if (show) {
            element.getStyle().clearDisplay();
        } else {
            element.getStyle().setDisplay(Style.Display.NONE);
        }
    }

    private static class View<T>
    implements HasDataPresenter.View<T> {
        private final AbstractHasData<T> hasData;
        private boolean wasFocused;

        public View(AbstractHasData<T> hasData) {
            this.hasData = hasData;
        }

        @Override
        public <H extends EventHandler> HandlerRegistration addHandler(H handler, GwtEvent.Type<H> type) {
            return this.hasData.addHandler(handler, type);
        }

        @Override
        public void replaceAllChildren(List<T> values, SelectionModel<? super T> selectionModel, boolean stealFocus) {
            SafeHtml html = this.renderRowValues(values, this.hasData.getPageStart(), selectionModel);
            this.wasFocused = this.hasData.isFocused = this.hasData.isFocused || stealFocus;
            ((AbstractHasData)this.hasData).isRefreshing = true;
            this.hasData.replaceAllChildren(values, html);
            ((AbstractHasData)this.hasData).isRefreshing = false;
            Element elem = this.hasData.getKeyboardSelectedElement();
            if (elem != null) {
                this.hasData.setFocusable(elem, true);
                if (this.hasData.isFocused) {
                    this.hasData.onFocus();
                }
            }
            this.fireValueChangeEvent();
            this.hasData.fireEvent(new RedrawEvent());
        }

        @Override
        public void replaceChildren(List<T> values, int start, SelectionModel<? super T> selectionModel, boolean stealFocus) {
            SafeHtml html = this.renderRowValues(values, this.hasData.getPageStart() + start, selectionModel);
            this.wasFocused = this.hasData.isFocused = this.hasData.isFocused || stealFocus;
            ((AbstractHasData)this.hasData).isRefreshing = true;
            this.hasData.replaceChildren(values, start, html);
            ((AbstractHasData)this.hasData).isRefreshing = false;
            Element elem = this.hasData.getKeyboardSelectedElement();
            if (elem != null) {
                this.hasData.setFocusable(elem, true);
                if (this.hasData.isFocused) {
                    this.hasData.onFocus();
                }
            }
            this.fireValueChangeEvent();
            this.hasData.fireEvent(new RedrawEvent());
        }

        @Override
        public void resetFocus() {
            if (this.wasFocused) {
                CellBasedWidgetImpl.get().resetFocus(new Scheduler.ScheduledCommand(){

                    @Override
                    public void execute() {
                        Element elem;
                        if (!hasData.resetFocusOnCell() && (elem = hasData.getKeyboardSelectedElement()) != null) {
                            elem.focus();
                        }
                    }
                });
            }
        }

        @Override
        public void setKeyboardSelected(int index, boolean seleted, boolean stealFocus) {
            this.hasData.isFocused = this.hasData.isFocused || stealFocus;
            this.hasData.setKeyboardSelected(index, seleted, stealFocus);
        }

        @Override
        public void setLoadingState(LoadingStateChangeEvent.LoadingState state) {
            ((AbstractHasData)this.hasData).isRefreshing = true;
            this.hasData.onLoadingStateChanged(state);
            ((AbstractHasData)this.hasData).isRefreshing = false;
        }

        private void fireValueChangeEvent() {
            this.hasData.fireEvent(new ValueChangeEvent<List<T>>((List)this.hasData.getVisibleItems()){});
        }

        private SafeHtml renderRowValues(List<T> values, int start, SelectionModel<? super T> selectionModel) {
            try {
                SafeHtmlBuilder sb = new SafeHtmlBuilder();
                this.hasData.renderRowValues(sb, values, start, selectionModel);
                return sb.toSafeHtml();
            }
            catch (UnsupportedOperationException e) {
                return null;
            }
        }
    }

    public static class RedrawEvent
    extends GwtEvent<Handler> {
        private static final GwtEvent.Type<Handler> TYPE = new GwtEvent.Type();

        @Override
        public GwtEvent.Type<Handler> getAssociatedType() {
            return TYPE;
        }

        @Override
        protected void dispatch(Handler handler) {
            handler.onRedraw();
        }

        public static interface Handler
        extends EventHandler {
            public void onRedraw();
        }
    }

    public static class DefaultKeyboardSelectionHandler<T>
    implements CellPreviewEvent.Handler<T> {
        private static final int PAGE_INCREMENT = 30;
        private final AbstractHasData<T> display;

        public DefaultKeyboardSelectionHandler(AbstractHasData<T> display) {
            this.display = display;
        }

        public AbstractHasData<T> getDisplay() {
            return this.display;
        }

        @Override
        public void onCellPreview(CellPreviewEvent<T> event) {
            NativeEvent nativeEvent = event.getNativeEvent();
            String eventType = event.getNativeEvent().getType();
            if ("keydown".equals(eventType) && !event.isCellEditing()) {
                switch (nativeEvent.getKeyCode()) {
                    case 40: {
                        this.nextRow();
                        this.handledEvent(event);
                        return;
                    }
                    case 38: {
                        this.prevRow();
                        this.handledEvent(event);
                        return;
                    }
                    case 34: {
                        this.nextPage();
                        this.handledEvent(event);
                        return;
                    }
                    case 33: {
                        this.prevPage();
                        this.handledEvent(event);
                        return;
                    }
                    case 36: {
                        this.home();
                        this.handledEvent(event);
                        return;
                    }
                    case 35: {
                        this.end();
                        this.handledEvent(event);
                        return;
                    }
                    case 32: {
                        this.handledEvent(event);
                        return;
                    }
                }
            } else if ("click".equals(eventType)) {
                int relRow = event.getIndex() - this.display.getPageStart();
                boolean isFocusable = false;
                Element target = Element.as(event.getNativeEvent().getEventTarget());
                isFocusable = CellBasedWidgetImpl.get().isFocusable(target);
                this.display.setKeyboardSelectedRow(relRow, !isFocusable);
            } else if ("focus".equals(eventType)) {
                int relRow = event.getIndex() - this.display.getPageStart();
                if (this.display.getKeyboardSelectedRow() != relRow) {
                    this.display.setKeyboardSelectedRow(relRow, false);
                    return;
                }
            }
        }

        void end() {
            this.setKeyboardSelectedRow(this.display.getRowCount() - 1);
        }

        void handledEvent(CellPreviewEvent<?> event) {
            event.setCanceled(true);
            event.getNativeEvent().preventDefault();
        }

        void home() {
            this.setKeyboardSelectedRow(-this.display.getPageStart());
        }

        void nextPage() {
            HasKeyboardPagingPolicy.KeyboardPagingPolicy keyboardPagingPolicy = this.display.getKeyboardPagingPolicy();
            if (HasKeyboardPagingPolicy.KeyboardPagingPolicy.CHANGE_PAGE == keyboardPagingPolicy) {
                this.setKeyboardSelectedRow(this.display.getPageSize());
            } else if (HasKeyboardPagingPolicy.KeyboardPagingPolicy.INCREASE_RANGE == keyboardPagingPolicy) {
                this.setKeyboardSelectedRow(this.display.getKeyboardSelectedRow() + 30);
            }
        }

        void nextRow() {
            this.setKeyboardSelectedRow(this.display.getKeyboardSelectedRow() + 1);
        }

        void prevPage() {
            HasKeyboardPagingPolicy.KeyboardPagingPolicy keyboardPagingPolicy = this.display.getKeyboardPagingPolicy();
            if (HasKeyboardPagingPolicy.KeyboardPagingPolicy.CHANGE_PAGE == keyboardPagingPolicy) {
                this.setKeyboardSelectedRow(-this.display.getPageSize());
            } else if (HasKeyboardPagingPolicy.KeyboardPagingPolicy.INCREASE_RANGE == keyboardPagingPolicy) {
                this.setKeyboardSelectedRow(this.display.getKeyboardSelectedRow() - 30);
            }
        }

        void prevRow() {
            this.setKeyboardSelectedRow(this.display.getKeyboardSelectedRow() - 1);
        }

        void setKeyboardSelectedRow(int row) {
            this.display.setKeyboardSelectedRow(row, true);
        }
    }
}

