package org.ovirt.engine.core.common.vdscommands;

public enum VDSCommandType {
    AddVds("org.ovirt.engine.core.vdsbroker"),
    RemoveVds("org.ovirt.engine.core.vdsbroker"),
    FenceVds("org.ovirt.engine.core.vdsbroker.vdsbroker"),
    GetStats("org.ovirt.engine.core.vdsbroker.vdsbroker"),
    GetStatsAsync("org.ovirt.engine.core.vdsbroker.vdsbroker"),
    Create("org.ovirt.engine.core.vdsbroker"),
    CreateBroker("org.ovirt.engine.core.vdsbroker.vdsbroker"),
    DestroyVm("org.ovirt.engine.core.vdsbroker"),
    RebootVm("org.ovirt.engine.core.vdsbroker"),
    RebootVmBroker("org.ovirt.engine.core.vdsbroker.vdsbroker"),
    ResetVm("org.ovirt.engine.core.vdsbroker"),
    ResetVmBroker("org.ovirt.engine.core.vdsbroker.vdsbroker"),
    Hibernate("org.ovirt.engine.core.vdsbroker"),
    HibernateBroker("org.ovirt.engine.core.vdsbroker.vdsbroker"),
    Resume("org.ovirt.engine.core.vdsbroker"),
    ResumeBroker("org.ovirt.engine.core.vdsbroker.vdsbroker"),
    Migrate("org.ovirt.engine.core.vdsbroker"),
    MigrateBroker("org.ovirt.engine.core.vdsbroker.vdsbroker"),
    MigrateStatus("org.ovirt.engine.core.vdsbroker.vdsbroker"),
    CancelMigrate("org.ovirt.engine.core.vdsbroker.vdsbroker"),
    ChangeDisk("org.ovirt.engine.core.vdsbroker.vdsbroker"),
    VmLogon("org.ovirt.engine.core.vdsbroker.vdsbroker"),
    VmLogoff("org.ovirt.engine.core.vdsbroker.vdsbroker"),
    SetVmTicket("org.ovirt.engine.core.vdsbroker.vdsbroker"),
    SetVdsStatus("org.ovirt.engine.core.vdsbroker"),
    SetVmStatus("org.ovirt.engine.core.vdsbroker"),
    IsVmDuringInitiating("org.ovirt.engine.core.vdsbroker"),
    UpdateVdsVMsCleared("org.ovirt.engine.core.vdsbroker"),
    SetSafeNetworkConfig("org.ovirt.engine.core.vdsbroker.vdsbroker"),
    ConnectStorageServer("org.ovirt.engine.core.vdsbroker.vdsbroker"),
    DisconnectStorageServer("org.ovirt.engine.core.vdsbroker.vdsbroker"),
    ConnectStoragePool("org.ovirt.engine.core.vdsbroker.vdsbroker"),
    DisconnectStoragePool("org.ovirt.engine.core.vdsbroker.vdsbroker"),
    DiscoverSendTargets("org.ovirt.engine.core.vdsbroker.vdsbroker"),
    CreateStoragePool("org.ovirt.engine.core.vdsbroker.vdsbroker"),
    CleanStorageDomainMetaData("org.ovirt.engine.core.vdsbroker.vdsbroker"),
    UpgradeStoragePool("org.ovirt.engine.core.vdsbroker.irsbroker"),
    ReconstructMaster("org.ovirt.engine.core.vdsbroker.vdsbroker"),
    SpmStart("org.ovirt.engine.core.vdsbroker.vdsbroker"),
    SpmStop("org.ovirt.engine.core.vdsbroker.vdsbroker"),
    SpmStatus("org.ovirt.engine.core.vdsbroker.vdsbroker"),
    GetHostJobs("org.ovirt.engine.core.vdsbroker.vdsbroker"),
    HSMGetAllTasksStatuses("org.ovirt.engine.core.vdsbroker.vdsbroker"),
    HSMGetTaskStatus("org.ovirt.engine.core.vdsbroker.vdsbroker"),
    HSMGetAllTasksInfo("org.ovirt.engine.core.vdsbroker.vdsbroker"),
    HSMStopTask("org.ovirt.engine.core.vdsbroker.vdsbroker"),
    HSMClearTask("org.ovirt.engine.core.vdsbroker.vdsbroker"),
    HSMRevertTask("org.ovirt.engine.core.vdsbroker.vdsbroker"),
    UpdateVmDynamicData("org.ovirt.engine.core.vdsbroker"),
    CollectVdsNetworkDataAfterInstallation("org.ovirt.engine.core.vdsbroker.vdsbroker"),
    GetVmsInfo("org.ovirt.engine.core.vdsbroker.irsbroker"),
    HSMGetStorageDomainInfo("org.ovirt.engine.core.vdsbroker.vdsbroker"),
    HSMGetStorageDomainsList("org.ovirt.engine.core.vdsbroker.vdsbroker"),
    PrepareImage("org.ovirt.engine.core.vdsbroker.vdsbroker"),
    SetVolumeLegality("org.ovirt.engine.core.vdsbroker.irsbroker"),
    TeardownImage("org.ovirt.engine.core.vdsbroker.vdsbroker"),
    CopyVolumeData("org.ovirt.engine.core.vdsbroker.vdsbroker"),
    UpdateVolume("org.ovirt.engine.core.vdsbroker.vdsbroker"),
    ColdMerge("org.ovirt.engine.core.vdsbroker.vdsbroker"),
    IsolateVolume("org.ovirt.engine.core.vdsbroker.vdsbroker"),
    WipeVolume("org.ovirt.engine.core.vdsbroker.vdsbroker"),
    DestroyImage("org.ovirt.engine.core.vdsbroker.irsbroker"),
    GetImageInfo("org.ovirt.engine.core.vdsbroker.irsbroker"),
    SetVolumeDescription("org.ovirt.engine.core.vdsbroker.irsbroker"),
    CopyImage("org.ovirt.engine.core.vdsbroker.irsbroker"),
    DownloadImage("org.ovirt.engine.core.vdsbroker.irsbroker"),
    UploadImage("org.ovirt.engine.core.vdsbroker.irsbroker"),
    CreateVolume("org.ovirt.engine.core.vdsbroker.irsbroker"),
    Merge("org.ovirt.engine.core.vdsbroker.vdsbroker"),
    ReconcileVolumeChain("org.ovirt.engine.core.vdsbroker.irsbroker"),
    RefreshVolume("org.ovirt.engine.core.vdsbroker.vdsbroker"),
    GetVolumeInfo("org.ovirt.engine.core.vdsbroker.vdsbroker"),
    GetQemuImageInfo("org.ovirt.engine.core.vdsbroker.vdsbroker"),
    SPMGetVolumeInfo("org.ovirt.engine.core.vdsbroker.irsbroker"),
    IsoPrefix("org.ovirt.engine.core.vdsbroker.vdsbroker"),
    IsoDirectory("org.ovirt.engine.core.vdsbroker.irsbroker"),
    ResetIrs("org.ovirt.engine.core.vdsbroker.irsbroker"),
    GetFileStats("org.ovirt.engine.core.vdsbroker.vdsbroker"),
    CreateStorageDomain("org.ovirt.engine.core.vdsbroker.vdsbroker"),
    ActivateStorageDomain("org.ovirt.engine.core.vdsbroker.irsbroker"),
    DeactivateStorageDomain("org.ovirt.engine.core.vdsbroker.irsbroker"),
    DetachStorageDomain("org.ovirt.engine.core.vdsbroker.irsbroker"),
    AttachStorageDomain("org.ovirt.engine.core.vdsbroker.irsbroker"),
    FormatStorageDomain("org.ovirt.engine.core.vdsbroker.vdsbroker"),
    SetStorageDomainDescription("org.ovirt.engine.core.vdsbroker.irsbroker"),
    GetStorageDomainStats("org.ovirt.engine.core.vdsbroker.vdsbroker"),
    GetStoragePoolInfo("org.ovirt.engine.core.vdsbroker.irsbroker"),
    DestroyStoragePool("org.ovirt.engine.core.vdsbroker.irsbroker"),
    DeleteImageGroup("org.ovirt.engine.core.vdsbroker.irsbroker"),
    MoveImageGroup("org.ovirt.engine.core.vdsbroker.irsbroker"),
    CloneImageGroupStructure("org.ovirt.engine.core.vdsbroker.irsbroker"),
    SyncImageGroupData("org.ovirt.engine.core.vdsbroker.irsbroker"),
    VmReplicateDiskStart("org.ovirt.engine.core.vdsbroker.vdsbroker"),
    VmReplicateDiskFinish("org.ovirt.engine.core.vdsbroker.vdsbroker"),
    GetImagesList("org.ovirt.engine.core.vdsbroker.irsbroker"),
    GetVolumesList("org.ovirt.engine.core.vdsbroker.irsbroker"),
    SparsifyImage("org.ovirt.engine.core.vdsbroker.vdsbroker"),
    AmendVolume("org.ovirt.engine.core.vdsbroker.vdsbroker"),
    SealDisks("org.ovirt.engine.core.vdsbroker.vdsbroker"),
    CreateVG("org.ovirt.engine.core.vdsbroker.vdsbroker"),
    GetVGInfo("org.ovirt.engine.core.vdsbroker.vdsbroker"),
    GetDeviceList("org.ovirt.engine.core.vdsbroker.vdsbroker"),
    GetDevicesVisibility("org.ovirt.engine.core.vdsbroker.vdsbroker"),
    SPMGetAllTasksStatuses("org.ovirt.engine.core.vdsbroker.irsbroker"),
    SPMGetAllTasksInfo("org.ovirt.engine.core.vdsbroker.irsbroker"),
    SPMStopTask("org.ovirt.engine.core.vdsbroker.irsbroker"),
    SPMClearTask("org.ovirt.engine.core.vdsbroker.irsbroker"),
    SPMRevertTask("org.ovirt.engine.core.vdsbroker.irsbroker"),
    UpdateVM("org.ovirt.engine.core.vdsbroker.irsbroker"),
    UploadStream("org.ovirt.engine.core.vdsbroker.irsbroker"),
    RetrieveImageData("org.ovirt.engine.core.vdsbroker.irsbroker"),
    RemoveVM("org.ovirt.engine.core.vdsbroker.irsbroker"),
    SpmStopOnIrs("org.ovirt.engine.core.vdsbroker.irsbroker"),
    ResetISOPath("org.ovirt.engine.core.vdsbroker.vdsbroker"),
    MarkPoolInReconstructMode("org.ovirt.engine.core.vdsbroker.irsbroker"),
    ExtendStorageDomain("org.ovirt.engine.core.vdsbroker.irsbroker"),
    ResizeStorageDomainPV("org.ovirt.engine.core.vdsbroker.irsbroker"),
    MoveStorageDomainDevice("org.ovirt.engine.core.vdsbroker.vdsbroker"),
    ReduceStorageDomain("org.ovirt.engine.core.vdsbroker.vdsbroker"),
    HotPlugDisk("org.ovirt.engine.core.vdsbroker.vdsbroker"),
    HotUnPlugDisk("org.ovirt.engine.core.vdsbroker.vdsbroker"),
    HotPlugNic("org.ovirt.engine.core.vdsbroker.vdsbroker"),
    HotUnplugNic("org.ovirt.engine.core.vdsbroker.vdsbroker"),
    Snapshot("org.ovirt.engine.core.vdsbroker.vdsbroker"),
    UpdateVmInterface("org.ovirt.engine.core.vdsbroker.vdsbroker"),
    GetHardwareInfo("org.ovirt.engine.core.vdsbroker.vdsbroker"),
    GetHardwareInfoAsync("org.ovirt.engine.core.vdsbroker.vdsbroker"),
    GetLldp("org.ovirt.engine.core.vdsbroker.vdsbroker"),
    ExtendImageSize("org.ovirt.engine.core.vdsbroker.irsbroker"),
    ReduceImage("org.ovirt.engine.core.vdsbroker.irsbroker"),
    ExtendVmDiskSize("org.ovirt.engine.core.vdsbroker.vdsbroker"),
    SetMOMPolicyParameters("org.ovirt.engine.core.vdsbroker.vdsbroker"),
    SetHaMaintenanceMode("org.ovirt.engine.core.vdsbroker.vdsbroker"),
    ConvertVm("org.ovirt.engine.core.vdsbroker.vdsbroker"),
    ConvertOva("org.ovirt.engine.core.vdsbroker.vdsbroker"),
    GetConvertedOvf("org.ovirt.engine.core.vdsbroker.vdsbroker"),
    DeleteV2VJob("org.ovirt.engine.core.vdsbroker.vdsbroker"),
    CancelConvertVm("org.ovirt.engine.core.vdsbroker.vdsbroker"),
    AddImageTicket("org.ovirt.engine.core.vdsbroker.vdsbroker"),
    RemoveImageTicket("org.ovirt.engine.core.vdsbroker.vdsbroker"),
    ExtendImageTicket("org.ovirt.engine.core.vdsbroker.vdsbroker"),
    GetImageTicket("org.ovirt.engine.core.vdsbroker.vdsbroker"),
    VerifyUntrustedVolume("org.ovirt.engine.core.vdsbroker.vdsbroker"),
    MeasureVolume("org.ovirt.engine.core.vdsbroker.vdsbroker"),
    SwitchMasterStorageDomain("org.ovirt.engine.core.vdsbroker.irsbroker"),

    // Gluster VDS commands
    CreateGlusterVolume("org.ovirt.engine.core.vdsbroker.gluster"),
    SetGlusterVolumeOption("org.ovirt.engine.core.vdsbroker.gluster"),
    ResetGlusterVolumeOptions("org.ovirt.engine.core.vdsbroker.gluster"),
    StartGlusterVolume("org.ovirt.engine.core.vdsbroker.gluster"),
    StopGlusterVolume("org.ovirt.engine.core.vdsbroker.gluster"),
    DeleteGlusterVolume("org.ovirt.engine.core.vdsbroker.gluster"),
    GetGlusterVolumeOptionsInfo("org.ovirt.engine.core.vdsbroker.gluster"),
    StartRemoveGlusterVolumeBricks("org.ovirt.engine.core.vdsbroker.gluster"),
    StopRemoveGlusterVolumeBricks("org.ovirt.engine.core.vdsbroker.gluster"),
    CommitRemoveGlusterVolumeBricks("org.ovirt.engine.core.vdsbroker.gluster"),
    StartRebalanceGlusterVolume("org.ovirt.engine.core.vdsbroker.gluster"),
    StopRebalanceGlusterVolume("org.ovirt.engine.core.vdsbroker.gluster"),
    SetupGlusterGeoRepMountBroker("org.ovirt.engine.core.vdsbroker.gluster"),
    CheckEmptyGlusterVolume("org.ovirt.engine.core.vdsbroker.gluster"),
    GetGlusterHostsPubKey("org.ovirt.engine.core.vdsbroker.gluster"),
    UpdateGlusterGeoRepKeys("org.ovirt.engine.core.vdsbroker.gluster"),
    CreateGlusterVolumeGeoRepSession("org.ovirt.engine.core.vdsbroker.gluster"),
    ResumeGeoRepSession("org.ovirt.engine.core.vdsbroker.gluster"),
    AddBricksToGlusterVolume("org.ovirt.engine.core.vdsbroker.gluster"),
    ReplaceGlusterVolumeBrick("org.ovirt.engine.core.vdsbroker.gluster"),
    StartGlusterVolumeGeoRep("org.ovirt.engine.core.vdsbroker.gluster"),
    RemoveGlusterServer("org.ovirt.engine.core.vdsbroker.gluster"),
    AddGlusterServer("org.ovirt.engine.core.vdsbroker.gluster"),
    GlusterServersList("org.ovirt.engine.core.vdsbroker.gluster"),
    StartGlusterVolumeProfile("org.ovirt.engine.core.vdsbroker.gluster"),
    StopGlusterVolumeProfile("org.ovirt.engine.core.vdsbroker.gluster"),
    PauseGlusterVolumeGeoRepSession("org.ovirt.engine.core.vdsbroker.gluster"),
    GetGlusterVolumeAdvancedDetails("org.ovirt.engine.core.vdsbroker.gluster"),
    GlusterVolumesList("org.ovirt.engine.core.vdsbroker.gluster"),
    GetGlusterVolumeHealInfo("org.ovirt.engine.core.vdsbroker.gluster"),
    GetGlusterVolumeProfileInfo("org.ovirt.engine.core.vdsbroker.gluster"),
    EnableGlusterHook("org.ovirt.engine.core.vdsbroker.gluster"),
    DisableGlusterHook("org.ovirt.engine.core.vdsbroker.gluster"),
    GlusterHooksList("org.ovirt.engine.core.vdsbroker.gluster"),
    GetGlusterHostUUID("org.ovirt.engine.core.vdsbroker.gluster"),
    GlusterServicesList("org.ovirt.engine.core.vdsbroker.gluster"),
    GetGlusterHookContent("org.ovirt.engine.core.vdsbroker.gluster"),
    UpdateGlusterHook("org.ovirt.engine.core.vdsbroker.gluster"),
    AddGlusterHook("org.ovirt.engine.core.vdsbroker.gluster"),
    RemoveGlusterHook("org.ovirt.engine.core.vdsbroker.gluster"),
    ManageGlusterService("org.ovirt.engine.core.vdsbroker.gluster"),
    GetGlusterVolumeRebalanceStatus("org.ovirt.engine.core.vdsbroker.gluster"),
    GlusterTasksList("org.ovirt.engine.core.vdsbroker.gluster"),
    GetGlusterVolumeRemoveBricksStatus("org.ovirt.engine.core.vdsbroker.gluster"),
    GetGlusterVolumeGeoRepSessionList("org.ovirt.engine.core.vdsbroker.gluster"),
    GetGlusterVolumeGeoRepSessionStatus("org.ovirt.engine.core.vdsbroker.gluster"),
    StopGlusterVolumeGeoRepSession("org.ovirt.engine.core.vdsbroker.gluster"),
    DeleteGlusterVolumeGeoRepSession("org.ovirt.engine.core.vdsbroker.gluster"),
    GetGlusterVolumeGeoRepConfigList("org.ovirt.engine.core.vdsbroker.gluster"),
    SetGlusterVolumeGeoRepConfigDefault("org.ovirt.engine.core.vdsbroker.gluster"),
    SetGlusterVolumeGeoRepConfig("org.ovirt.engine.core.vdsbroker.gluster"),
    GetGlusterVolumeSnapshotInfo("org.ovirt.engine.core.vdsbroker.gluster"),
    GetGlusterVolumeSnapshotConfigInfo("org.ovirt.engine.core.vdsbroker.gluster"),
    DeleteGlusterVolumeSnapshot("org.ovirt.engine.core.vdsbroker.gluster"),
    DeleteAllGlusterVolumeSnapshots("org.ovirt.engine.core.vdsbroker.gluster"),
    ActivateGlusterVolumeSnapshot("org.ovirt.engine.core.vdsbroker.gluster"),
    DeactivateGlusterVolumeSnapshot("org.ovirt.engine.core.vdsbroker.gluster"),
    RestoreGlusterVolumeSnapshot("org.ovirt.engine.core.vdsbroker.gluster"),
    CreateGlusterVolumeSnapshot("org.ovirt.engine.core.vdsbroker.gluster"),
    SetGlusterVolumeSnapshotConfig("org.ovirt.engine.core.vdsbroker.gluster"),
    GetStorageDeviceList("org.ovirt.engine.core.vdsbroker.gluster"),
    CreateBrick("org.ovirt.engine.core.vdsbroker.gluster"),
    OverrideGlusterVolumeSnapshotSchedule("org.ovirt.engine.core.vdsbroker.gluster"),
    GetGlusterVolumeInfo("org.ovirt.engine.core.vdsbroker.gluster"),
    StopGlusterProcesses("org.ovirt.engine.core.vdsbroker.gluster"),
    AddGlusterWebhook("org.ovirt.engine.core.vdsbroker.gluster"),
    SyncGlusterWebhook("org.ovirt.engine.core.vdsbroker.gluster"),
    DeleteGlusterWebhook("org.ovirt.engine.core.vdsbroker.gluster"),
    ResetGlusterVolumeBrick("org.ovirt.engine.core.vdsbroker.gluster"),
    GetGlusterLocalLogicalVolumeList("org.ovirt.engine.core.vdsbroker.gluster"),
    GetGlusterLocalPhysicalVolumeList("org.ovirt.engine.core.vdsbroker.gluster"),
    GetGlusterVDOVolumeList("org.ovirt.engine.core.vdsbroker.gluster"),
    SetNumberOfCpus("org.ovirt.engine.core.vdsbroker"),
    SetAmountOfMemory("org.ovirt.engine.core.vdsbroker"),
    HotUnplugMemory("org.ovirt.engine.core.vdsbroker"),
    UpdateVmPolicy("org.ovirt.engine.core.vdsbroker"),
    GetVmsFullInfoFromExternalProvider("org.ovirt.engine.core.vdsbroker.vdsbroker"),     // get a list of VMs from external provider with full data
    GetVmsNamesFromExternalProvider("org.ovirt.engine.core.vdsbroker.vdsbroker"),        // get a list of VMs from external provider with name only
    GetOvaInfo("org.ovirt.engine.core.vdsbroker.vdsbroker"),
    DumpXmls("org.ovirt.engine.core.vdsbroker.vdsbroker"),
    GetAllVmStats("org.ovirt.engine.core.vdsbroker.vdsbroker"),  // get a list of VMs with full data and statistics
    HostDevListByCaps("org.ovirt.engine.core.vdsbroker"),        // get all host devices with passthrough information
    Destroy("org.ovirt.engine.core.vdsbroker.vdsbroker"),        // Clean a DOWN VM from the vms list
    GetVmExternalData("org.ovirt.engine.core.vdsbroker.vdsbroker"),
    SetDestroyOnReboot("org.ovirt.engine.core.vdsbroker.vdsbroker"),
    HostDevChangeNumVfs("org.ovirt.engine.core.vdsbroker.vdsbroker"),
    RegisterLibvirtSecrets("org.ovirt.engine.core.vdsbroker.vdsbroker"),
    UnregisterLibvirtSecrets("org.ovirt.engine.core.vdsbroker.vdsbroker"),
    Freeze("org.ovirt.engine.core.vdsbroker.vdsbroker"),
    Thaw("org.ovirt.engine.core.vdsbroker.vdsbroker"),
    AddVmLease("org.ovirt.engine.core.vdsbroker.vdsbroker"),
    RemoveVmLease("org.ovirt.engine.core.vdsbroker.vdsbroker"),
    GetVmLeaseInfo("org.ovirt.engine.core.vdsbroker.vdsbroker"),
    HotPlugLease("org.ovirt.engine.core.vdsbroker.vdsbroker"),
    HotUnplugLease("org.ovirt.engine.core.vdsbroker.vdsbroker"),

    // Cold merge related commands
    PrepareMerge("org.ovirt.engine.core.vdsbroker.irsbroker"),
    FinalizeMerge("org.ovirt.engine.core.vdsbroker.irsbroker"),

    // Incremental Backup
    StartVmBackup("org.ovirt.engine.core.vdsbroker.vdsbroker"),
    StopVmBackup("org.ovirt.engine.core.vdsbroker.vdsbroker"),
    GetVmBackupInfo("org.ovirt.engine.core.vdsbroker.vdsbroker"),
    RedefineVmCheckpoints("org.ovirt.engine.core.vdsbroker.vdsbroker"),
    DeleteVmCheckpoints("org.ovirt.engine.core.vdsbroker.vdsbroker"),
    ListVmCheckpoints("org.ovirt.engine.core.vdsbroker.vdsbroker"),
    AddVolumeBitmap("org.ovirt.engine.core.vdsbroker.vdsbroker"),
    StartNbdServer("org.ovirt.engine.core.vdsbroker.vdsbroker"),
    StopNbdServer("org.ovirt.engine.core.vdsbroker.vdsbroker"),

    /**
     * Get Host capabilities
     */
    GetCapabilities("org.ovirt.engine.core.vdsbroker.vdsbroker"),
    GetCapabilitiesAsync("org.ovirt.engine.core.vdsbroker.vdsbroker"),

    // Managed block storage
    AttachManagedBlockStorageVolume("org.ovirt.engine.core.vdsbroker.vdsbroker"),
    DetachManagedBlockStorageVolume("org.ovirt.engine.core.vdsbroker.vdsbroker");

    String packageName;

    VDSCommandType(String packageName) {
        this.packageName = packageName;
    }

    public String getPackageName() {
        return packageName;
    }

    public int getValue() {
        return this.ordinal();
    }

    public static VDSCommandType forValue(int value) {
        return values()[value];
    }
}
