# Used for rpm-packaging of pre-bundled application with already resolved JS dependencies
%global product oVirt

%global use_rhev %( test -z @RHEV@ && echo 1 || echo 0)
%define debug_package %{nil}

%global source_basename ovirt-web-ui

Name:           ovirt-web-ui
Version:        1.6.1
Release:        1%{?release_suffix}%{?checkout}%{?dist}
Summary:        VM Portal for %{product}
License:        ASL 2.0
URL:            https://github.com/oVirt/ovirt-web-ui
Source0:        https://github.com/oVirt/ovirt-web-ui/archive/%{source_basename}-1.6.1.tar.gz

BuildArch: noarch

# nodejs-modules embeds yarn and requires nodejs
BuildRequires: ovirt-engine-nodejs-modules >= 2.0.21-1

%description
This package provides the VM Portal for %{product}.

%prep
%setup -q -n"%{source_basename}-%{version}"
rpm -qa | grep ovirt-engine-nodejs

echo "=== Workaround: 'yarn check' is recently failing on requiring webpack >= v2. Manually"
echo "=== verified that this is ok for recent code base but may be a real failure in the"
echo "=== future. Please watch carefully for other potential types of errors."
IGNORE_YARN_CHECK=1 source /usr/share/ovirt-engine-nodejs-modules/setup-env.sh

%build
export PATH="%{_datadir}/ovirt-engine-nodejs/bin:%{_datadir}/ovirt-engine-nodejs-modules/bin:${PATH}"
%configure
make

%install
make install DESTDIR=%{buildroot}

%files
%doc README.md
%license LICENSE
%{_datarootdir}/ovirt-web-ui
%{_datarootdir}/ovirt-engine/ovirt-web-ui.war
%{_sysconfdir}/ovirt-engine/engine.conf.d/50-ovirt-web-ui.conf
%{_sysconfdir}/ovirt-web-ui/branding/00-ovirt.brand

%changelog
* Mon Apr 6 2020 Sharon Gratch <sgratchk@redhat.com> - 1.6.1-1
 - fixed saving NIC with empty VNIC Profile
 - make the vm poratl more responsive for browser resizing, set minimum card widths and fixed alignments.
 - add kebob actions menu and changed Shutdown button type to default in VM's dashboard
 - disable auto log out when the "UserSessionTimeOut" config value is set to value of -1
 - tooltip Code Refactoring, including using one type of style for tooltips on CardEditButton
 - added a tooltip for the 'Disk Edit' Dialog.
 - replaced Patternfly 3 charts with Patternfly 4
 - fixed wrong html element ids for the VM and Pool
 - changed 'automation/build.repos' location for matching the STDCI V2 used by ovirt-engine-nodejs-modules
 - allowed use of alternate branding by the DEV server
 - Fixed hover texts in masthead
 - updated build to use yarn from ovirt-engine-nodejs-modules
 - hid host info from non-admin users
 - fixed Windows VM creation timezone bug such that if template/vm time zone format isn't compatible with VM OS, time zone is changed to default
 - updated autogen/automake configurations and yarn integration
 - removed 'ovirt-4.2' from STDCI release branch config
 - updated title and warning messages for 'Remove VM' confirmation modal
 - pool and pool vms redesign
 - added toast notifications for Start/Shutdown VM requests.
 - added documentation link and updated report issues url for the 'About' dialog
 - hanlded 404 errors
 - Added better handling for token expiration by redesign of the log out component and support Patternfly 4
 - refactored the user messages
 - fixed typo in pool allocated VMs tooltip message
 - changed the VM card list page so that if a VM is running then default action item is set openning the VM console
 - redesign create vm - using a new create VM Wizard.
 - Added a "full screen" mode for the webvnc console.
 - fixed a bug that the disk create modal didn't show the storage domains
 - added an external service button to the VM's action panel
 - updated branding and navbar masthead for allowing branding to continue to use the same CSS class names
 - fixed the navbar icons layout
 - fetched roles and permit at login and do entity permission to permit mapping on frontend
 - changed VM details Disks card disk sort order to sort by disk name only
 - replaced local VncConsole by patternfly VncConsole
 - fixed Pool handling and refactor VM loading bugs
 - added scrollbar to the notification menu
 - disabled the Console action on a headless VM
 - updated DEVELOPERS.md
 - updated zanata server and version
 - created script for auto checking of the translation file
 - updated translations for ovirt 4.4

* Tue Aug 27 2019 Michal Skrivanek <michal.skrivanek@redhat.com> - 1.6.0-1
 - updated translations
 - limit CD/ISO list by data center
 - improve responsiveness on small screens (mobile)
 - updated patternfly3 and js dependencies
 - added Sysprep to Details card for Windows VM

* Mon Jul 1 2019 Sharon Gratch <sgratch@redhat.com> - 1.5.3-1
 - Added check for inactivity during session and logout after expiration
 - Added NoVNC console support
 - Resolve login data load concurrency issues (allows ISOs to load at login)
 - updated translations
 - Added template filtering for VM create dialog
 - Added validation for Disk name
 - Allow adding more CPUs than the max sockets count

* Wed Mar 27 2019 Greg Sheremeta <gshereme@redhat.com> - 1.5.2-1
 - Remove edibility of a VM's template
 - Remove wrap for hostname and FQDN, add ellipsis with tooltip

* Mon Feb 18 2019 Greg Sheremeta <gshereme@redhat.com> - 1.5.1-1
 - Fixed several issues
 - updated translations

* Wed Jan 9 2019 Greg Sheremeta <gshereme@redhat.com> - 1.5.0-1
 - Redesign of VM Edit / Dashboard view complete
 - Fixed several issues

* Tue Sep 4 2018 Greg Sheremeta <gshereme@redhat.com> - 1.4.3-1
  Fixed issues:
- ux-redesign: make old Normal View the default when clicking a VM [#751](https://github.com/oVirt/ovirt-web-ui/issues/751)

* Fri Aug 17 2018 Greg Sheremeta <gshereme@redhat.com> - 1.4.2-1
  Fixed issues:
- Main > InfiniteScroll is broken [#708](https://github.com/oVirt/ovirt-web-ui/issues/708)
- dev server doesn't work without redux dev tools installed [#688](https://github.com/oVirt/ovirt-web-ui/issues/688)
- RDP button sends 'console.rdp' to the user at render time instead of onClick event time [#686](https://github.com/oVirt/ovirt-web-ui/issues/686)
- Redesign notifications [#647](https://github.com/oVirt/ovirt-web-ui/issues/647)
- cloud-init switch has no function [#642](https://github.com/oVirt/ovirt-web-ui/issues/642)
- Redesign main page [#641](https://github.com/oVirt/ovirt-web-ui/issues/641)
- ScrollPositionHistory not working [#416](https://github.com/oVirt/ovirt-web-ui/issues/416)
- Sort operating systems [#409](https://github.com/oVirt/ovirt-web-ui/issues/409)
- mobile: VMs in grid view are not all visible on mobile device [#367](https://github.com/oVirt/ovirt-web-ui/issues/367)

* Thu Aug 2 2018 Greg Sheremeta <gshereme@redhat.com> - 1.4.1-1
  Fixed issues:
  - 'failed Not found' error with Connect automatically console option bug major [#509](https://github.com/oVirt/ovirt-web-ui/issues/509)
  - reattach VmDialog's sagas to the root saga so VM edits get saved [#683](https://github.com/oVirt/ovirt-web-ui/pull/683)
  - VM edits don't save bug [#684](https://github.com/oVirt/ovirt-web-ui/issues/684)

* Mon Jul 16 2018 Marek Libra <mlibra@redhat.com> - 1.4.0-3
Fixed issues:
- web-ui about windows7 display？ [#644](https://github.com/oVirt/ovirt-web-ui/issues/644)
- Refactor About and Options dialogs [#617](https://github.com/oVirt/ovirt-web-ui/issues/617)
- No confirmation after `Esc` [#613](https://github.com/oVirt/ovirt-web-ui/issues/613)
- filter os entries by cluster [#608](https://github.com/oVirt/ovirt-web-ui/issues/608)
- fix os sorting [#607](https://github.com/oVirt/ovirt-web-ui/issues/607)
- If yarn.lock gets fully regenerated, flow will break with a bad configuration [#602](https://github.com/oVirt/ovirt-web-ui/issues/602)
- Messages option text "No messages" not proper. [#594](https://github.com/oVirt/ovirt-web-ui/issues/594)
- VM Portal does not auto refresh [#593](https://github.com/oVirt/ovirt-web-ui/issues/593)
- Edit VM 'Close' without saving fails [#592](https://github.com/oVirt/ovirt-web-ui/issues/592)
- Safari browser [#590](https://github.com/oVirt/ovirt-web-ui/issues/590)
- After reload Edit VM page, page become empty [#574](https://github.com/oVirt/ovirt-web-ui/issues/574)
- VM Snapshot management [#573](https://github.com/oVirt/ovirt-web-ui/issues/573)
- first click on vNIC profile select box item doesn't change the selected value [#571](https://github.com/oVirt/ovirt-web-ui/issues/571)
- NIC hot unplug not work [#569](https://github.com/oVirt/ovirt-web-ui/issues/569)
- Pending changes tooltip overflow [#568](https://github.com/oVirt/ovirt-web-ui/issues/568)
- After click on 'Set default Icon' every additional data of VM is disappearing  [#567](https://github.com/oVirt/ovirt-web-ui/issues/567)
- no way to boot from a network if the VM has no disk [#565](https://github.com/oVirt/ovirt-web-ui/issues/565)
- Redirect to main page after F5 on VM Detail page [#563](https://github.com/oVirt/ovirt-web-ui/issues/563)
- InfiniteScroller console warning about unique key [#562](https://github.com/oVirt/ovirt-web-ui/issues/562)
- Upgrade npm dependencies [#558](https://github.com/oVirt/ovirt-web-ui/issues/558)
- disable Boot menu switch in edit dialog when VM is running [#549](https://github.com/oVirt/ovirt-web-ui/issues/549)
- add option to force shutdown a VM [#522](https://github.com/oVirt/ovirt-web-ui/issues/522)
- Suspend button not disabled for pooled VMs [#462](https://github.com/oVirt/ovirt-web-ui/issues/462)
- 16 users limit in vm pool [#456](https://github.com/oVirt/ovirt-web-ui/issues/456)
- Toobar overlaps tooltip [#452](https://github.com/oVirt/ovirt-web-ui/issues/452)
- Top line of tooltip not visible [#434](https://github.com/oVirt/ovirt-web-ui/issues/434)
- Popup descriptions hidden in edit page [#422](https://github.com/oVirt/ovirt-web-ui/issues/422)
- no cake as VM icon [#415](https://github.com/oVirt/ovirt-web-ui/issues/415)
- Error message partially overlapped [#395](https://github.com/oVirt/ovirt-web-ui/issues/395)
- New VM name validation & requirements [#382](https://github.com/oVirt/ovirt-web-ui/issues/382)
- Move icon editing from VM detail page to VM edit page [#356](https://github.com/oVirt/ovirt-web-ui/issues/356)
- Remove small icon from edit page [#355](https://github.com/oVirt/ovirt-web-ui/issues/355)
- mobile: status and truncated description in VM grid is not clickable for mobile device [#344](https://github.com/oVirt/ovirt-web-ui/issues/344)
- and other changes not tracked via issues (see github for full list of merged PRs)

* Mon Jul 16 2018 Marek Libra <mlibra@redhat.com> - 1.4.0-2

* Mon Jun 25 2018 Marek Libra <mlibra@redhat.com> - 1.4.0
- A lot of UI fixes

* Wed Apr 25 2018 Marek Libra <mlibra@redhat.com> - 1.3.9
- fix: cluster can be in no datacenter - https://github.com/oVirt/ovirt-web-ui/pull/577
- fix: storage domain can be in multiple datacenters https://github.com/oVirt/ovirt-web-ui/pull/578

* Thu Apr 12 2018 Marek Libra <mlibra@redhat.com> - 1.3.8-2
- Adjust min memory while editing memory - https://github.com/oVirt/ovirt-web-ui/pull/538
- Fixed the VmDisks sort - https://github.com/oVirt/ovirt-web-ui/pull/547
- All HTTP methods use proper 'Filter' header - https://github.com/oVirt/ovirt-web-ui/pull/550
- Fix: Avoid VM IDs in VMS navigation item list - https://github.com/oVirt/ovirt-web-ui/pull/540
- Fixed disk sorting - https://github.com/oVirt/ovirt-web-ui/pull/547
- Fixed error by deleting disk - https://github.com/oVirt/ovirt-web-ui/pull/551
- Add warning for Boot menu - https://github.com/oVirt/ovirt-web-ui/pull/560
- Fix Cloud-Init switch - https://github.com/oVirt/ovirt-web-ui/pull/559
- Fixed align of Delete buttons for Disks - https://github.com/oVirt/ovirt-web-ui/pull/553
- additional smaller UI enhancements

* Mon Mar 26 2018 Marek Libra <mlibra@redhat.com> - 1.3.7-2
- VM networks editation - https://github.com/oVirt/ovirt-web-ui/pull/517
- VM disks editation - https://github.com/oVirt/ovirt-web-ui/pull/523
- ssh dialog UI fix - https://github.com/oVirt/ovirt-web-ui/pull/519
- cloud-init VM name fix - https://github.com/oVirt/ovirt-web-ui/pull/528
- minor UI fixes
- Translations updated

* Wed Feb 28 2018 Marek Libra <mlibra@redhat.com> - 1.3.6
- VM detail landing after refresh fixed (https://github.com/oVirt/ovirt-web-ui/pull/497)
- Dialog for SSH keys fixed (https://github.com/oVirt/ovirt-web-ui/pull/464)
- Basic cloud-init support (https://github.com/oVirt/ovirt-web-ui/pull/498)
- CD removed from New VM dialog (https://github.com/oVirt/ovirt-web-ui/pull/496)
- Boot menu configuration added (https://github.com/oVirt/ovirt-web-ui/pull/493)
- Console re-connect fixed for warning message (https://github.com/oVirt/ovirt-web-ui/pull/483)
- Tooltips fixed (https://github.com/oVirt/ovirt-web-ui/pull/469)
- Close button navigates to previous page (https://github.com/oVirt/ovirt-web-ui/pull/482)
- Broken grid fixed for pools (https://github.com/oVirt/ovirt-web-ui/pull/473)
- Flow type check fix (https://github.com/oVirt/ovirt-web-ui/pull/470)
- Fix label in CTRL+ALT+DEL option (https://github.com/oVirt/ovirt-web-ui/pull/484)
- Change logo link to home page URL (https://github.com/oVirt/ovirt-web-ui/pull/474)
- Translations updated

* Wed Jan 24 2018 Marek Libra <mlibra@redhat.com> - 1.3.5
- Translations updated
- Fix for page reload - https://github.com/oVirt/ovirt-web-ui/pull/465
- Fix for pool removal - https://github.com/oVirt/ovirt-web-ui/issues/446
- Fix for infinite scroller - https://github.com/oVirt/ovirt-web-ui/pull/459


* Thu Nov 30 2017 Marek Libra <mlibra@redhat.com> - 1.3.4
- Fix for headless VMs - https://github.com/oVirt/ovirt-web-ui/pull/444
- Updated translations

* Tue Nov 28 2017 Marek Libra <mlibra@redhat.com> - 1.3.3
- Minor UI fixes and improvements
- Fix frozen "Loading" msg - https://github.com/oVirt/ovirt-web-ui/pull/430
- Fix of sorting of VMs in left vertical panel - https://github.com/oVirt/ovirt-web-ui/pull/428
- Fix in locale recognition - https://github.com/oVirt/ovirt-web-ui/pull/438
- Use of translated messages from API - https://github.com/oVirt/ovirt-web-ui/pull/131

* Tue Nov 14 2017 Marek Libra <mlibra@redhat.com> - 1.3.2
- fix of scrollbar on Webkit browsers

* Mon Nov 13 2017 Marek Libra <mlibra@redhat.com> - 1.3.1
- verbose warning in console - https://github.com/oVirt/ovirt-web-ui/issues/376
- scrolling of popups - https://github.com/oVirt/ovirt-web-ui/issues/394
- no autologout - https://github.com/oVirt/ovirt-web-ui/issues/308
- Make use of "AlwaysFilterResultsForWebUi" engine configuration parameter - https://github.com/oVirt/ovirt-web-ui/issues/317
- fix empty name in Create VM dialog - https://github.com/oVirt/ovirt-web-ui/issues/365
- select boxes are left-alligned - https://github.com/oVirt/ovirt-web-ui/issues/370
- allow empty memory/cpu - https://github.com/oVirt/ovirt-web-ui/issues/369
- docker image fixed - https://github.com/oVirt/ovirt-web-ui/issues/304
- HTML IDs added for automated testing
- Minor UI fixes
- translations updated

* Mon Oct 30 2017 Marek Libra <mlibra@redhat.com> - 1.3.0
- BnB (Brand new Branding) - alligned witth ovirt-engine
- Smartcard Enabled option
- SSH public key
- Gust OS names as labels
- i18n improvements, first tranlsations
- multiple fixes and minor UI enhancements


* Wed Aug 16 2017 Marek Libra <mlibra@redhat.com> - 1.2.1
- noarch rpm
- minor fixes, runtime dependencies generally updated
- usb-filter in .vv file
- basics for internationalization, but translation missing

* Wed Aug 2 2017 Marek Libra <mlibra@redhat.com> - 1.2.0
- branding
- infinite scroller for VMS list
- Change CD function
- "Runs on Host" - hyperlink to the host running particular VM
- "Loading ..." indicator of background activity
- "Pending Changes" tag rendered when NEXT_RUN configuration exists
- VM Type
- error messages improved
- fixed setting of VM icon
- multiple additional functional & UI fixes

* Tue Jun 20 2017 Marek Libra <mlibra@redhat.com> - 1.1.0
- Navigation via list of VMs to see details simplified
- Component for VM's Disks redesigned
- Context-based help
- Support for RDP graphics consoles
- ESC key used as back-button
- multiple UI fixes and improvements
- Configuration of graphics console added

* Fri Jun 2 2017 Marek Libra <mlibra@redhat.com> - 1.0.0
- "Door effect" removed, replaced by standard patternfly design
- User Messages are not closed automatically
- Check "Console in use" added
* Mon May 15 2017 Marek Libra <mlibra@redhat.com> - 0.2.2
- Minor fixes for pools
* Mon May 15 2017 Marek Libra <mlibra@redhat.com> - 0.2.1
- React and Redux updated to latest version
* Fri May 12 2017 Marek Libra <mlibra@redhat.com> - 0.2.0
- Add/Edit VM Dialog
- Autoconnect and Console options
- VM Pools
- the Remove VM action
- confirmation dialog improved
- functionality and UI fixes
* Wed Apr 19 2017 Marek Libra <mlibra@redhat.com> - 0.1.4
- Confirmation component
- About dialog
- UI fixes
- docker builds
- stability fixes
* Wed Apr 12 2017 Marek Libra <mlibra@redhat.com> - 0.1.3
- UI fixes
- docker builds
- oVirt API version check
- About dialog
* Mon Feb 20 2017 Marek Libra <mlibra@redhat.com> - 0.1.2
- Minor UI fixes, npm replaced by yarn
* Fri Dec 16 2016 Marek Libra <mlibra@redhat.com> - 0.1.1
- Minor UI fixes, authorizedRedirect.jsp
* Mon Nov 14 2016 Marek Libra <mlibra@redhat.com> - 0.1.0
- First version, Technical Preview
