#
# vdsm-jsonrpc-java - vdsm json rpc
# Copyright (C) 2013-2016 Red Hat, Inc.
#
# This library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public
# License as published by the Free Software Foundation; either
# version 2.1 of the License, or (at your option) any later version.
#
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public
# License along with this library; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
#

%global	package_version 1.5.2
%global	package_maven_version 1.5.2

%global	_java_jdk_home /usr/lib/jvm/java-11-openjdk

%if 0%{?rhel} == 7
# xmvn in 3.x  version is not compatible with JDK 11, bugzilla https://bugzilla.redhat.com/show_bug.cgi?id=1761381
# due to it maven toolchain plugin is used to run xmvn with java 1.8 but use 11 for build and compilation
%global	_mvn_opts -Pno-test,toolchain -gt client/src/main/resources/toolchains.xml

%else
%global	_mvn_opts -Pno-test
%endif

Summary:	JsonRpc java client (%{name}) for oVirt
Name:		vdsm-jsonrpc-java
Version:	1.5.2
Release:	1%{?release_suffix}%{?dist}
License:	LGPLv2+
URL:		http://www.ovirt.org
Source:		http://resources.ovirt.org/pub/ovirt-master-snapshot/src/%{name}/%{name}-%{package_version}.tar.gz
Group:		Development/Libraries

BuildArch:	noarch

BuildRequires:	gcc
BuildRequires:	apache-commons-lang >= 2.6
BuildRequires:	jackson >= 1.9
BuildRequires:	java-11-openjdk-devel >= 11.0.4
BuildRequires:	slf4j >= 1.7.0
BuildRequires:	junit
BuildRequires:	mockito

%if 0%{?rhel} == 7
BuildRequires:	java-1.8.0-openjdk-headless >= 1:1.8.0
BuildRequires:	rh-maven35-javapackages-local
BuildRequires:	rh-maven35-javapackages-tools
BuildRequires:	rh-maven35-maven
BuildRequires:	rh-maven35-maven-compiler-plugin
BuildRequires:	rh-maven35-maven-enforcer-plugin
BuildRequires:	rh-maven35-maven-install-plugin
BuildRequires:	rh-maven35-maven-jar-plugin
BuildRequires:	rh-maven35-maven-javadoc
BuildRequires:	rh-maven35-maven-local
BuildRequires:	rh-maven35-maven-source-plugin
BuildRequires:	rh-maven35-maven-surefire-provider-junit
BuildRequires:	rh-maven35-maven-toolchain
BuildRequires:	rh-maven35-sonatype-oss-parent
%else
BuildRequires:	maven >= 3.5.0
BuildRequires:	maven-compiler-plugin
BuildRequires:	maven-enforcer-plugin
BuildRequires:	maven-install-plugin
BuildRequires:	maven-jar-plugin
BuildRequires:	maven-javadoc-plugin
BuildRequires:	maven-local
BuildRequires:	maven-source-plugin
BuildRequires:	maven-surefire-provider-junit
BuildRequires:	sonatype-oss-parent
%endif

Requires:	apache-commons-lang >= 2.6
Requires:	jackson >= 1.9
Requires:	java-11-openjdk-headless >= 11.0.4
Requires:	slf4j >= 1.7.0

%description
vdsm jsonrpc java

%package javadoc
Summary:	Java-docs for %{name}
Group:		Documentation

%description javadoc
This package contains the API documentation for %{name}.

%prep
%setup -q -n %{name}-%{package_version}

%build
%configure --with-maven --disable-java-build
make %{?_smp_mflags}

%if 0%{?rhel} != 7
# necessary because jdk 1.8 comes as default with xmvn
export JAVA_HOME="%{_java_jdk_home}"
%endif


%if 0%{?rhel} == 7
# xmvn bootstrap enabled because maven toolchain plugin dependency
# is not accessible even when installed as rpm (still not sure why),
# leaving it as it is because once xmvn is upgraded then toolchain can be removed
%mvn_build -b -- %{?_mvn_opts}
%else
%mvn_build -- %{?_mvn_opts}
%endif

%install
%mvn_install

%files -f .mfiles
%dir %{_javadir}/%{name}

%files javadoc -f .mfiles-javadoc

%changelog
* Mon Dec 2 2019 Artur Socha <asocha@redhat.com> 1.5.2
- Fix for rpm datadir location
- Use always maven to build project
- Use tabs character in spec file consistently

* Wed Nov 27 2019 Artur Socha <asocha@redhat.com> 1.5.1
- downstream build fix

* Tue Nov 26 2019 Artur Socha <asocha@redhat.com> 1.5.0
- migration to java 11

* Tue May 28 2019 Piotr Kliczewski <pkliczew@redhat.com> 1.4.18
- heartbeat: improve how we process

* Mon Apr 15 2019 Piotr Kliczewski <pkliczew@redhat.com> 1.4.17
- Provide default timeout to purge events

* Fri Apr 12 2019 Piotr Kliczewski <pkliczew@redhat.com> 1.4.16
- Purge old events and EventPublisher should handle exceptions

* Fri Oct 5 2018 Piotr Kliczewski <pkliczew@redhat.com> - 1.4.15-2
- packaging: spec: fix spec changelog

* Fri Sep 14 2018 Piotr Kliczewski <pkliczew@redhat.com> - 1.4.15
- All hosts stuck in connecting/not responding state until engine restarted

* Mon Jul 9 2018 Piotr Kliczewski <pkliczew@redhat.com> - 1.4.14
- Rephrase Heartbeat exceeded error message
- Log response when message not found

* Wed May 9 2018 Piotr Kliczewski <pkliczew@redhat.com> - 1.4.13
- Rephrase Heartbeat exceeded error message
- Connections shouldn't be closed after the connection to the host was recovered

* Fri Apr 13 2018 Piotr Kliczewski <pkliczew@redhat.com> - 1.4.12
- Don't retry async calls on connection error

* Fri Dec 15 2017 Piotr Kliczewski <pkliczew@redhat.com> - 1.4.11
- Heartbeat logging

* Mon Dec 4 2017 Piotr Kliczewski <pkliczew@redhat.com> - 1.4.10
- Heartbeat logging improvements

* Mon Nov 20 2017 Piotr Kliczewski <pkliczew@redhat.com> - 1.4.9
- Release host level lock faster

* Thu Oct 19 2017 Piotr Kliczewski <pkliczew@redhat.com> - 1.4.8
- host to id mapping needs to be cleared on failure

* Wed Sep 20 2017 Piotr Kliczewski <pkliczew@redhat.com> - 1.4.7
- Adding callbacks infrastructure to use non-blocking threads

* Tue Apr 11 2017 Piotr Kliczewski <pkliczew@redhat.com> - 1.4.6
- send correlation id to the server

* Mon Mar 27 2017 Piotr Kliczewski <pkliczew@redhat.com> - 1.4.5
- java exception visible in Events when upgrade check is done on recently fenced host
- packaging: spec: move to headless java

* Thu Mar 9 2017 Piotr Kliczewski <pkliczew@redhat.com> - 1.4.4
- remove end of line before command

* Wed Feb 22 2017 Piotr Kliczewski <pkliczew@redhat.com> - 1.4.3
- incomplete message BZ #1425725

* Wed Jan 18 2017 Piotr Kliczewski <pkliczew@redhat.com> - 1.4.2
- process messages one by one

* Thu Jan 12 2017 Piotr Kliczewski <pkliczew@redhat.com> - 1.4.1
- handle ssl closed status

* Mon Jan 9 2017 Piotr Kliczewski <pkliczew@redhat.com> - 1.4.0
- Make sure to match host properly
- Add cause exception upon re-throwing IOException in ReactorClient
- Frame split when using multiple hosts

* Fri Dec 2 2016 Piotr Kliczewski <pkliczew@redhat.com> - 1.3.5
- stop processing if closing

* Fri Nov 18 2016 Piotr Kliczewski <pkliczew@redhat.com> - 1.3.4
- Closing channel could take too much reactor's time

* Fri Nov 4 2016 Piotr Kliczewski <pkliczew@redhat.com> - 1.3.3
- Release for 4.1

* Wed Oct 12 2016 Piotr Kliczewski <pkliczew@redhat.com> - 1.3.2
- No reconnect during setupNetworks

* Mon Sep 5 2016 Piotr Kliczewski <pkliczew@redhat.com> - 1.3.1
- Release of 1.3.1

* Wed Jun 29 2016 Piotr Kliczewski <pkliczew@redhat.com> - 1.2.5
- wait on close

* Tue Jun 28 2016 Piotr Kliczewski <pkliczew@redhat.com> - 1.2.4
- schedule close when we reset policy

* Tue May 31 2016 Piotr Kliczewski <pkliczew@redhat.com> - 1.2.3
- Release of 1.2.3

* Mon Feb 8 2016 Piotr Kliczewski <pkliczew@redhat.com> - 1.2.1
- Initial release of 4.0

* Tue Jan 19 2016 Piotr Kliczewski <pkliczew@redhat.com> - 1.1.7-1
- Exception shouldn't be recursive

* Fri Jan 8 2016 Piotr Kliczewski <pkliczew@redhat.com> - 1.1.6-1
- scheduled tasks do not check whether a channel is there
- i/o thread blocked during connection

* Thu Sep 24 2015 Piotr Kliczewski <pkliczew@redhat.com> - 1.1.5-1
- Releasing for RC

* Wed Jul 15 2015 Piotr Kliczewski <pkliczew@redhat.com> - 1.1.4
- Update report ceritification expiration date
- Fix spelling mistake

* Sun Jul 5 2015 Piotr Kliczewski <pkliczew@redhat.com> - 1.1.3-2
- Version update

* Wed Jul 1 2015 Piotr Kliczewski <pkliczew@redhat.com> - 1.1.3-1
- Matching side effect fix
- Report certification expiration date

* Wed Jun 10 2015 Piotr Kliczewski <pkliczew@redhat.com> - 1.1.2-1
- Introduced new queue for events

* Mon Apr 20 2015 Piotr Kliczewski <pkliczew@redhat.com> - 1.1.1
- Introduction of Events

* Tue Apr 7 2015 Piotr Kliczewski <pkliczew@redhat.com> - 1.1.0
- Initial release for 3.6
