/*
Copyright (c) 2015 Red Hat, Inc.
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package org.ovirt.engine.sdk4.services;

import java.io.IOException;
import org.ovirt.engine.sdk4.Request;
import org.ovirt.engine.sdk4.Response;
import org.ovirt.engine.sdk4.Service;
import org.ovirt.engine.sdk4.types.User;

/**
 * A service to view a domain user in the system.
 */
public interface DomainUserService extends Service {
    /**
     * Gets the domain user information.
     * 
     * Usage:
     * 
     * ....
     * GET /ovirt-engine/api/domains/5678/users/1234
     * ....
     * 
     * Will return the domain user information:
     * 
     * [source,xml]
     * ----
     * <user href="/ovirt-engine/api/users/1234" id="1234">
     *   <name>admin</name>
     *   <namespace>*</namespace>
     *   <principal>admin</principal>
     *   <user_name>admin@internal-authz</user_name>
     *   <domain href="/ovirt-engine/api/domains/5678" id="5678">
     *     <name>internal-authz</name>
     *   </domain>
     *   <groups/>
     * </user>
     * ----
     */
    public interface GetRequest extends Request<GetRequest, GetResponse> {
    }
    
    /**
     * Gets the domain user information.
     * 
     * Usage:
     * 
     * ....
     * GET /ovirt-engine/api/domains/5678/users/1234
     * ....
     * 
     * Will return the domain user information:
     * 
     * [source,xml]
     * ----
     * <user href="/ovirt-engine/api/users/1234" id="1234">
     *   <name>admin</name>
     *   <namespace>*</namespace>
     *   <principal>admin</principal>
     *   <user_name>admin@internal-authz</user_name>
     *   <domain href="/ovirt-engine/api/domains/5678" id="5678">
     *     <name>internal-authz</name>
     *   </domain>
     *   <groups/>
     * </user>
     * ----
     */
    public interface GetResponse extends Response {
        /**
         * The domain user.
         */
        User user();
    }
    
    /**
     * Gets the domain user information.
     * 
     * Usage:
     * 
     * ....
     * GET /ovirt-engine/api/domains/5678/users/1234
     * ....
     * 
     * Will return the domain user information:
     * 
     * [source,xml]
     * ----
     * <user href="/ovirt-engine/api/users/1234" id="1234">
     *   <name>admin</name>
     *   <namespace>*</namespace>
     *   <principal>admin</principal>
     *   <user_name>admin@internal-authz</user_name>
     *   <domain href="/ovirt-engine/api/domains/5678" id="5678">
     *     <name>internal-authz</name>
     *   </domain>
     *   <groups/>
     * </user>
     * ----
     */
    GetRequest get();
    
    /**
     * Service locator method, returns individual service on which the URI is dispatched.
     */
    Service service(String path);
}

