/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.internal.xml;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.ovirt.api.metamodel.runtime.util.ArrayListWithHref;
import org.ovirt.api.metamodel.runtime.xml.XmlReader;
import org.ovirt.engine.sdk4.internal.containers.UserContainer;
import org.ovirt.engine.sdk4.internal.xml.XmlDomainReader;
import org.ovirt.engine.sdk4.internal.xml.XmlGroupReader;
import org.ovirt.engine.sdk4.internal.xml.XmlPermissionReader;
import org.ovirt.engine.sdk4.internal.xml.XmlRoleReader;
import org.ovirt.engine.sdk4.internal.xml.XmlSshPublicKeyReader;
import org.ovirt.engine.sdk4.internal.xml.XmlTagReader;
import org.ovirt.engine.sdk4.types.Group;
import org.ovirt.engine.sdk4.types.Permission;
import org.ovirt.engine.sdk4.types.Role;
import org.ovirt.engine.sdk4.types.SshPublicKey;
import org.ovirt.engine.sdk4.types.Tag;
import org.ovirt.engine.sdk4.types.User;

public class XmlUserReader {
    public static User readOne(XmlReader reader) {
        String name;
        if (!reader.forward()) {
            return null;
        }
        UserContainer object = new UserContainer();
        block50: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            name = reader.getAttributeLocalName(i);
            String image = reader.getAttributeValue(i);
            switch (name) {
                case "href": {
                    object.href(image);
                    continue block50;
                }
                case "id": {
                    object.id(image);
                    continue block50;
                }
            }
        }
        ArrayList<String[]> links = new ArrayList<String[]>();
        reader.next();
        block51: while (reader.forward()) {
            switch (name = reader.getLocalName()) {
                case "comment": {
                    object.comment(reader.readString());
                    continue block51;
                }
                case "department": {
                    object.department(reader.readString());
                    continue block51;
                }
                case "description": {
                    object.description(reader.readString());
                    continue block51;
                }
                case "domain": {
                    object.domain(XmlDomainReader.readOne(reader));
                    continue block51;
                }
                case "domain_entry_id": {
                    object.domainEntryId(reader.readString());
                    continue block51;
                }
                case "email": {
                    object.email(reader.readString());
                    continue block51;
                }
                case "groups": {
                    object.groups(XmlGroupReader.readMany(reader));
                    continue block51;
                }
                case "last_name": {
                    object.lastName(reader.readString());
                    continue block51;
                }
                case "logged_in": {
                    object.loggedIn(reader.readBoolean());
                    continue block51;
                }
                case "name": {
                    object.name(reader.readString());
                    continue block51;
                }
                case "namespace": {
                    object.namespace(reader.readString());
                    continue block51;
                }
                case "password": {
                    object.password(reader.readString());
                    continue block51;
                }
                case "permissions": {
                    object.permissions(XmlPermissionReader.readMany(reader));
                    continue block51;
                }
                case "principal": {
                    object.principal(reader.readString());
                    continue block51;
                }
                case "roles": {
                    object.roles(XmlRoleReader.readMany(reader));
                    continue block51;
                }
                case "ssh_public_keys": {
                    object.sshPublicKeys(XmlSshPublicKeyReader.readMany(reader));
                    continue block51;
                }
                case "tags": {
                    object.tags(XmlTagReader.readMany(reader));
                    continue block51;
                }
                case "user_name": {
                    object.userName(reader.readString());
                    continue block51;
                }
                case "link": {
                    String rel = reader.getAttributeValue("rel");
                    String href = reader.getAttributeValue("href");
                    if (rel != null && href != null) {
                        links.add(new String[]{rel, href});
                    }
                    reader.next();
                    continue block51;
                }
            }
            reader.skip();
        }
        if (links != null) {
            for (String[] link : links) {
                XmlUserReader.processLink(object, link);
            }
        }
        reader.next();
        return object;
    }

    public static Iterator<User> iterateMany(final XmlReader reader) {
        return new Iterator<User>(){
            private boolean first = true;

            @Override
            public void remove() {
            }

            @Override
            public boolean hasNext() {
                if (this.first) {
                    if (!reader.forward()) {
                        return false;
                    }
                    reader.next();
                    this.first = false;
                }
                if (!reader.forward()) {
                    reader.next();
                    return false;
                }
                return true;
            }

            @Override
            public User next() {
                User next = XmlUserReader.readOne(reader);
                if (next == null) {
                    throw new NoSuchElementException();
                }
                return next;
            }
        };
    }

    public static List<User> readMany(XmlReader reader) {
        ArrayList<User> list = new ArrayList<User>();
        Iterator<User> iterator = XmlUserReader.iterateMany(reader);
        while (iterator.hasNext()) {
            list.add(iterator.next());
        }
        return list;
    }

    private static void processLink(UserContainer object, String[] link) {
        String rel = link[0];
        String href = link[1];
        if (href != null) {
            switch (rel) {
                case "groups": {
                    ArrayListWithHref<Group> list = new ArrayListWithHref<Group>(object.groups());
                    list.href(href);
                    object.groups(list);
                    break;
                }
                case "permissions": {
                    ArrayListWithHref<Permission> list = new ArrayListWithHref<Permission>(object.permissions());
                    list.href(href);
                    object.permissions(list);
                    break;
                }
                case "roles": {
                    ArrayListWithHref<Role> list = new ArrayListWithHref<Role>(object.roles());
                    list.href(href);
                    object.roles(list);
                    break;
                }
                case "sshpublickeys": {
                    ArrayListWithHref<SshPublicKey> list = new ArrayListWithHref<SshPublicKey>(object.sshPublicKeys());
                    list.href(href);
                    object.sshPublicKeys(list);
                    break;
                }
                case "tags": {
                    ArrayListWithHref<Tag> list = new ArrayListWithHref<Tag>(object.tags());
                    list.href(href);
                    object.tags(list);
                    break;
                }
            }
        }
    }
}

