/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.internal.xml;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.ovirt.api.metamodel.runtime.xml.XmlReader;
import org.ovirt.engine.sdk4.internal.containers.ClusterLevelContainer;
import org.ovirt.engine.sdk4.internal.xml.XmlCpuTypeReader;
import org.ovirt.engine.sdk4.internal.xml.XmlPermitReader;
import org.ovirt.engine.sdk4.types.ClusterLevel;

public class XmlClusterLevelReader {
    public static ClusterLevel readOne(XmlReader reader) {
        String name;
        if (!reader.forward()) {
            return null;
        }
        ClusterLevelContainer object = new ClusterLevelContainer();
        block24: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            name = reader.getAttributeLocalName(i);
            String image = reader.getAttributeValue(i);
            switch (name) {
                case "href": {
                    object.href(image);
                    continue block24;
                }
                case "id": {
                    object.id(image);
                    continue block24;
                }
            }
        }
        ArrayList<String[]> links = new ArrayList<String[]>();
        reader.next();
        block25: while (reader.forward()) {
            switch (name = reader.getLocalName()) {
                case "comment": {
                    object.comment(reader.readString());
                    continue block25;
                }
                case "cpu_types": {
                    object.cpuTypes(XmlCpuTypeReader.readMany(reader));
                    continue block25;
                }
                case "description": {
                    object.description(reader.readString());
                    continue block25;
                }
                case "name": {
                    object.name(reader.readString());
                    continue block25;
                }
                case "permits": {
                    object.permits(XmlPermitReader.readMany(reader));
                    continue block25;
                }
                case "link": {
                    String rel = reader.getAttributeValue("rel");
                    String href = reader.getAttributeValue("href");
                    if (rel != null && href != null) {
                        links.add(new String[]{rel, href});
                    }
                    reader.skip();
                    continue block25;
                }
            }
            reader.skip();
        }
        if (links != null) {
            for (String[] link : links) {
                XmlClusterLevelReader.processLink(object, link);
            }
        }
        reader.next();
        return object;
    }

    public static Iterator<ClusterLevel> iterateMany(final XmlReader reader) {
        return new Iterator<ClusterLevel>(){
            private boolean first = true;

            @Override
            public void remove() {
            }

            @Override
            public boolean hasNext() {
                if (this.first) {
                    if (!reader.forward()) {
                        return false;
                    }
                    reader.next();
                    this.first = false;
                }
                if (!reader.forward()) {
                    reader.next();
                    return false;
                }
                return true;
            }

            @Override
            public ClusterLevel next() {
                ClusterLevel next = XmlClusterLevelReader.readOne(reader);
                if (next == null) {
                    throw new NoSuchElementException();
                }
                return next;
            }
        };
    }

    public static List<ClusterLevel> readMany(XmlReader reader) {
        ArrayList<ClusterLevel> list = new ArrayList<ClusterLevel>();
        Iterator<ClusterLevel> iterator = XmlClusterLevelReader.iterateMany(reader);
        while (iterator.hasNext()) {
            list.add(iterator.next());
        }
        return list;
    }

    private static void processLink(ClusterLevelContainer object, String[] link) {
    }
}

