/*
Copyright (c) 2015 Red Hat, Inc.
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package org.ovirt.engine.sdk4.builders;

import java.math.BigInteger;
import org.ovirt.engine.sdk4.internal.containers.MigrationBandwidthContainer;
import org.ovirt.engine.sdk4.types.MigrationBandwidth;
import org.ovirt.engine.sdk4.types.MigrationBandwidthAssignmentMethod;

public class MigrationBandwidthBuilder {
    private MigrationBandwidthAssignmentMethod assignmentMethod;
    private BigInteger customValue;
    
    public MigrationBandwidthBuilder assignmentMethod(MigrationBandwidthAssignmentMethod newAssignmentMethod) {
        assignmentMethod = newAssignmentMethod;
        return this;
    }
    
    
    public MigrationBandwidthBuilder customValue(int newCustomValue) {
        customValue = BigInteger.valueOf((long) newCustomValue);
        return this;
    }
    
    public MigrationBandwidthBuilder customValue(Integer newCustomValue) {
        if (newCustomValue == null) {
            customValue = null;
        }
        else {
            customValue = BigInteger.valueOf(newCustomValue.longValue());
        }
        return this;
    }
    
    public MigrationBandwidthBuilder customValue(long newCustomValue) {
        customValue = BigInteger.valueOf(newCustomValue);
        return this;
    }
    
    public MigrationBandwidthBuilder customValue(Long newCustomValue) {
        if (newCustomValue == null) {
            customValue = null;
        }
        else {
            customValue = BigInteger.valueOf(newCustomValue.longValue());
        }
        return this;
    }
    
    public MigrationBandwidthBuilder customValue(BigInteger newCustomValue) {
        customValue = newCustomValue;
        return this;
    }
    
    
    public MigrationBandwidth build() {
        MigrationBandwidthContainer container = new MigrationBandwidthContainer();
        container.assignmentMethod(assignmentMethod);
        container.customValue(customValue);
        return container;
    }
}
