/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.internal.containers;

import java.util.List;
import org.ovirt.engine.sdk4.internal.containers.IdentifiedContainer;
import org.ovirt.engine.sdk4.types.DiskProfile;
import org.ovirt.engine.sdk4.types.Permission;
import org.ovirt.engine.sdk4.types.Qos;
import org.ovirt.engine.sdk4.types.StorageDomain;

public class DiskProfileContainer
extends IdentifiedContainer
implements DiskProfile {
    private List<Permission> permissions;
    private Qos qos;
    private StorageDomain storageDomain;

    @Override
    public List<Permission> permissions() {
        return DiskProfileContainer.makeUnmodifiableList(this.permissions);
    }

    public void permissions(List<Permission> newPermissions) {
        this.permissions = DiskProfileContainer.makeArrayList(newPermissions);
    }

    @Override
    public boolean permissionsPresent() {
        return this.permissions != null && !this.permissions.isEmpty();
    }

    @Override
    public Qos qos() {
        return this.qos;
    }

    public void qos(Qos newQos) {
        this.qos = newQos;
    }

    @Override
    public boolean qosPresent() {
        return this.qos != null;
    }

    @Override
    public StorageDomain storageDomain() {
        return this.storageDomain;
    }

    public void storageDomain(StorageDomain newStorageDomain) {
        this.storageDomain = newStorageDomain;
    }

    @Override
    public boolean storageDomainPresent() {
        return this.storageDomain != null;
    }
}

