/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.internal.services;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.util.EntityUtils;
import org.ovirt.api.metamodel.runtime.xml.XmlReader;
import org.ovirt.api.metamodel.runtime.xml.XmlWriter;
import org.ovirt.engine.sdk4.BaseRequest;
import org.ovirt.engine.sdk4.Error;
import org.ovirt.engine.sdk4.Service;
import org.ovirt.engine.sdk4.builders.ActionBuilder;
import org.ovirt.engine.sdk4.builders.DiskBuilder;
import org.ovirt.engine.sdk4.internal.HttpConnection;
import org.ovirt.engine.sdk4.internal.services.AssignedPermissionsServiceImpl;
import org.ovirt.engine.sdk4.internal.services.MeasurableServiceImpl;
import org.ovirt.engine.sdk4.internal.services.StatisticsServiceImpl;
import org.ovirt.engine.sdk4.internal.xml.XmlActionWriter;
import org.ovirt.engine.sdk4.internal.xml.XmlDiskReader;
import org.ovirt.engine.sdk4.internal.xml.XmlDiskWriter;
import org.ovirt.engine.sdk4.services.AssignedPermissionsService;
import org.ovirt.engine.sdk4.services.StatisticsService;
import org.ovirt.engine.sdk4.services.VmDiskService;
import org.ovirt.engine.sdk4.types.Action;
import org.ovirt.engine.sdk4.types.Disk;

public class VmDiskServiceImpl
extends MeasurableServiceImpl
implements VmDiskService {
    public VmDiskServiceImpl(HttpConnection connection, String path) {
        super(connection, path);
    }

    @Override
    public VmDiskService.ActivateRequest activate() {
        return new ActivateRequestImpl();
    }

    @Override
    public VmDiskService.DeactivateRequest deactivate() {
        return new DeactivateRequestImpl();
    }

    @Override
    public VmDiskService.ExportRequest export() {
        return new ExportRequestImpl();
    }

    @Override
    public VmDiskService.GetRequest get() {
        return new GetRequestImpl();
    }

    @Override
    public VmDiskService.MoveRequest move() {
        return new MoveRequestImpl();
    }

    @Override
    public VmDiskService.ReduceRequest reduce() {
        return new ReduceRequestImpl();
    }

    @Override
    public VmDiskService.RemoveRequest remove() {
        return new RemoveRequestImpl();
    }

    @Override
    public VmDiskService.UpdateRequest update() {
        return new UpdateRequestImpl();
    }

    @Override
    public AssignedPermissionsService permissionsService() {
        return new AssignedPermissionsServiceImpl(this.getConnection(), this.getPath() + "/permissions");
    }

    @Override
    public StatisticsService statisticsService() {
        return new StatisticsServiceImpl(this.getConnection(), this.getPath() + "/statistics");
    }

    @Override
    public Service service(String path) {
        if (path == null) {
            return this;
        }
        if (path.equals("permissions")) {
            return this.permissionsService();
        }
        if (path.startsWith("permissions/")) {
            return this.permissionsService().service(path.substring(12));
        }
        if (path.equals("statistics")) {
            return this.statisticsService();
        }
        if (path.startsWith("statistics/")) {
            return this.statisticsService().service(path.substring(11));
        }
        throw new Error("The path " + path + " doesn't correspond to any service");
    }

    @Override
    public String toString() {
        return "VmDiskService:" + this.getPath();
    }

    private class UpdateResponseImpl
    implements VmDiskService.UpdateResponse {
        private Disk disk;

        private UpdateResponseImpl() {
        }

        public void disk(Disk disk) {
            this.disk = disk;
        }

        @Override
        public Disk disk() {
            return this.disk;
        }
    }

    private class UpdateRequestImpl
    extends BaseRequest<VmDiskService.UpdateRequest, VmDiskService.UpdateResponse>
    implements VmDiskService.UpdateRequest {
        private Boolean async;
        private Disk disk;

        private UpdateRequestImpl() {
        }

        @Override
        public VmDiskService.UpdateRequest async(Boolean async) {
            this.async = async;
            return this;
        }

        @Override
        public VmDiskService.UpdateRequest disk(Disk disk) {
            this.disk = disk;
            return this;
        }

        @Override
        public VmDiskService.UpdateRequest disk(DiskBuilder disk) {
            this.disk = disk.build();
            return this;
        }

        @Override
        public VmDiskService.UpdateResponse send() {
            HttpResponse response;
            HttpPut request = null;
            try {
                URIBuilder uriBuilder = new URIBuilder(VmDiskServiceImpl.this.getConnection().getUrl() + VmDiskServiceImpl.this.getPath());
                if (this.async != null) {
                    uriBuilder.addParameter("async", XmlWriter.renderBoolean(this.async));
                }
                if (this.query != null) {
                    for (Map.Entry queryParam : this.query.entrySet()) {
                        uriBuilder.addParameter((String)queryParam.getKey(), (String)queryParam.getValue());
                    }
                }
                request = new HttpPut(uriBuilder.build());
            }
            catch (URISyntaxException ex) {
                throw new Error("Failed to build URL", ex);
            }
            try (ByteArrayOutputStream output = new ByteArrayOutputStream();
                 XmlWriter xmlWriter = new XmlWriter(output, true);){
                XmlDiskWriter.writeOne(this.disk, xmlWriter);
                xmlWriter.flush();
                request.setEntity((HttpEntity)new ByteArrayEntity(output.toByteArray()));
            }
            catch (IOException ex) {
                throw new Error("Failed to parse response", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            if ((response = VmDiskServiceImpl.this.getConnection().send((HttpUriRequest)request)).getStatusLine().getStatusCode() == 200) {
                try {
                    XmlReader reader = new XmlReader(response.getEntity().getContent());
                    try {
                        UpdateResponseImpl actionResponse = new UpdateResponseImpl();
                        actionResponse.disk(XmlDiskReader.readOne(reader));
                        UpdateResponseImpl updateResponseImpl = actionResponse;
                        reader.close();
                        return updateResponseImpl;
                    }
                    catch (Throwable throwable) {
                        try {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        catch (IOException ex) {
                            throw new Error("Failed to read response", ex);
                        }
                    }
                }
                finally {
                    EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                }
            }
            VmDiskServiceImpl.this.checkFault(response);
            return new UpdateResponseImpl();
        }
    }

    private class RemoveResponseImpl
    implements VmDiskService.RemoveResponse {
        private RemoveResponseImpl() {
        }
    }

    private class RemoveRequestImpl
    extends BaseRequest<VmDiskService.RemoveRequest, VmDiskService.RemoveResponse>
    implements VmDiskService.RemoveRequest {
        private Boolean async;

        private RemoveRequestImpl() {
        }

        @Override
        public VmDiskService.RemoveRequest async(Boolean async) {
            this.async = async;
            return this;
        }

        @Override
        public VmDiskService.RemoveResponse send() {
            HttpResponse response;
            HttpDelete request = null;
            try {
                URIBuilder uriBuilder = new URIBuilder(VmDiskServiceImpl.this.getConnection().getUrl() + VmDiskServiceImpl.this.getPath());
                if (this.async != null) {
                    uriBuilder.addParameter("async", XmlWriter.renderBoolean(this.async));
                }
                if (this.query != null) {
                    for (Map.Entry queryParam : this.query.entrySet()) {
                        uriBuilder.addParameter((String)queryParam.getKey(), (String)queryParam.getValue());
                    }
                }
                request = new HttpDelete(uriBuilder.build());
            }
            catch (URISyntaxException ex) {
                throw new Error("Failed to build URL", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            if ((response = VmDiskServiceImpl.this.getConnection().send((HttpUriRequest)request)).getStatusLine().getStatusCode() == 200) {
                EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                return new RemoveResponseImpl();
            }
            VmDiskServiceImpl.this.checkFault(response);
            return new RemoveResponseImpl();
        }
    }

    private class ReduceResponseImpl
    implements VmDiskService.ReduceResponse {
        private ReduceResponseImpl() {
        }
    }

    private class ReduceRequestImpl
    extends BaseRequest<VmDiskService.ReduceRequest, VmDiskService.ReduceResponse>
    implements VmDiskService.ReduceRequest {
        private Boolean async;

        private ReduceRequestImpl() {
        }

        @Override
        public VmDiskService.ReduceRequest async(Boolean async) {
            this.async = async;
            return this;
        }

        @Override
        public VmDiskService.ReduceResponse send() {
            HttpPost request = new HttpPost(VmDiskServiceImpl.this.getConnection().getUrl() + VmDiskServiceImpl.this.getPath() + "/reduce");
            try (ByteArrayOutputStream output = new ByteArrayOutputStream();
                 XmlWriter xmlWriter = new XmlWriter(output, true);){
                ActionBuilder action = new ActionBuilder();
                action.async(this.async);
                XmlActionWriter.writeOne(action.build(), xmlWriter);
                xmlWriter.flush();
                request.setEntity((HttpEntity)new ByteArrayEntity(output.toByteArray()));
            }
            catch (IOException ex) {
                throw new Error("Failed to write request", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            HttpResponse response = VmDiskServiceImpl.this.getConnection().send((HttpUriRequest)request);
            Action action = VmDiskServiceImpl.this.checkAction(response);
            EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
            return new ReduceResponseImpl();
        }
    }

    private class MoveResponseImpl
    implements VmDiskService.MoveResponse {
        private MoveResponseImpl() {
        }
    }

    private class MoveRequestImpl
    extends BaseRequest<VmDiskService.MoveRequest, VmDiskService.MoveResponse>
    implements VmDiskService.MoveRequest {
        private Boolean async;
        private Boolean filter;

        private MoveRequestImpl() {
        }

        @Override
        public VmDiskService.MoveRequest async(Boolean async) {
            this.async = async;
            return this;
        }

        @Override
        public VmDiskService.MoveRequest filter(Boolean filter) {
            this.filter = filter;
            return this;
        }

        @Override
        public VmDiskService.MoveResponse send() {
            HttpPost request = new HttpPost(VmDiskServiceImpl.this.getConnection().getUrl() + VmDiskServiceImpl.this.getPath() + "/move");
            try (ByteArrayOutputStream output = new ByteArrayOutputStream();
                 XmlWriter xmlWriter = new XmlWriter(output, true);){
                ActionBuilder action = new ActionBuilder();
                action.async(this.async);
                action.filter(this.filter);
                XmlActionWriter.writeOne(action.build(), xmlWriter);
                xmlWriter.flush();
                request.setEntity((HttpEntity)new ByteArrayEntity(output.toByteArray()));
            }
            catch (IOException ex) {
                throw new Error("Failed to write request", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            HttpResponse response = VmDiskServiceImpl.this.getConnection().send((HttpUriRequest)request);
            Action action = VmDiskServiceImpl.this.checkAction(response);
            EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
            return new MoveResponseImpl();
        }
    }

    private class GetResponseImpl
    implements VmDiskService.GetResponse {
        private Disk disk;

        private GetResponseImpl() {
        }

        public void disk(Disk disk) {
            this.disk = disk;
        }

        @Override
        public Disk disk() {
            return this.disk;
        }
    }

    private class GetRequestImpl
    extends BaseRequest<VmDiskService.GetRequest, VmDiskService.GetResponse>
    implements VmDiskService.GetRequest {
        private String follow;

        private GetRequestImpl() {
        }

        @Override
        public VmDiskService.GetRequest follow(String follow) {
            this.follow = follow;
            return this;
        }

        @Override
        public VmDiskService.GetResponse send() {
            HttpResponse response;
            HttpGet request = null;
            try {
                URIBuilder uriBuilder = new URIBuilder(VmDiskServiceImpl.this.getConnection().getUrl() + VmDiskServiceImpl.this.getPath());
                if (this.follow != null) {
                    uriBuilder.addParameter("follow", XmlWriter.renderString(this.follow));
                }
                if (this.query != null) {
                    for (Map.Entry queryParam : this.query.entrySet()) {
                        uriBuilder.addParameter((String)queryParam.getKey(), (String)queryParam.getValue());
                    }
                }
                request = new HttpGet(uriBuilder.build());
            }
            catch (URISyntaxException ex) {
                throw new Error("Failed to build URL", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            if ((response = VmDiskServiceImpl.this.getConnection().send((HttpUriRequest)request)).getStatusLine().getStatusCode() == 200) {
                try {
                    XmlReader reader = new XmlReader(response.getEntity().getContent());
                    try {
                        GetResponseImpl actionResponse = new GetResponseImpl();
                        actionResponse.disk(XmlDiskReader.readOne(reader));
                        GetResponseImpl getResponseImpl = actionResponse;
                        reader.close();
                        return getResponseImpl;
                    }
                    catch (Throwable throwable) {
                        try {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        catch (IOException ex) {
                            throw new Error("Failed to read response", ex);
                        }
                    }
                }
                finally {
                    EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                }
            }
            VmDiskServiceImpl.this.checkFault(response);
            return new GetResponseImpl();
        }
    }

    private class ExportResponseImpl
    implements VmDiskService.ExportResponse {
        private ExportResponseImpl() {
        }
    }

    private class ExportRequestImpl
    extends BaseRequest<VmDiskService.ExportRequest, VmDiskService.ExportResponse>
    implements VmDiskService.ExportRequest {
        private Boolean async;
        private Boolean filter;

        private ExportRequestImpl() {
        }

        @Override
        public VmDiskService.ExportRequest async(Boolean async) {
            this.async = async;
            return this;
        }

        @Override
        public VmDiskService.ExportRequest filter(Boolean filter) {
            this.filter = filter;
            return this;
        }

        @Override
        public VmDiskService.ExportResponse send() {
            HttpPost request = new HttpPost(VmDiskServiceImpl.this.getConnection().getUrl() + VmDiskServiceImpl.this.getPath() + "/export");
            try (ByteArrayOutputStream output = new ByteArrayOutputStream();
                 XmlWriter xmlWriter = new XmlWriter(output, true);){
                ActionBuilder action = new ActionBuilder();
                action.async(this.async);
                action.filter(this.filter);
                XmlActionWriter.writeOne(action.build(), xmlWriter);
                xmlWriter.flush();
                request.setEntity((HttpEntity)new ByteArrayEntity(output.toByteArray()));
            }
            catch (IOException ex) {
                throw new Error("Failed to write request", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            HttpResponse response = VmDiskServiceImpl.this.getConnection().send((HttpUriRequest)request);
            Action action = VmDiskServiceImpl.this.checkAction(response);
            EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
            return new ExportResponseImpl();
        }
    }

    private class DeactivateResponseImpl
    implements VmDiskService.DeactivateResponse {
        private DeactivateResponseImpl() {
        }
    }

    private class DeactivateRequestImpl
    extends BaseRequest<VmDiskService.DeactivateRequest, VmDiskService.DeactivateResponse>
    implements VmDiskService.DeactivateRequest {
        private Boolean async;

        private DeactivateRequestImpl() {
        }

        @Override
        public VmDiskService.DeactivateRequest async(Boolean async) {
            this.async = async;
            return this;
        }

        @Override
        public VmDiskService.DeactivateResponse send() {
            HttpPost request = new HttpPost(VmDiskServiceImpl.this.getConnection().getUrl() + VmDiskServiceImpl.this.getPath() + "/deactivate");
            try (ByteArrayOutputStream output = new ByteArrayOutputStream();
                 XmlWriter xmlWriter = new XmlWriter(output, true);){
                ActionBuilder action = new ActionBuilder();
                action.async(this.async);
                XmlActionWriter.writeOne(action.build(), xmlWriter);
                xmlWriter.flush();
                request.setEntity((HttpEntity)new ByteArrayEntity(output.toByteArray()));
            }
            catch (IOException ex) {
                throw new Error("Failed to write request", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            HttpResponse response = VmDiskServiceImpl.this.getConnection().send((HttpUriRequest)request);
            Action action = VmDiskServiceImpl.this.checkAction(response);
            EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
            return new DeactivateResponseImpl();
        }
    }

    private class ActivateResponseImpl
    implements VmDiskService.ActivateResponse {
        private ActivateResponseImpl() {
        }
    }

    private class ActivateRequestImpl
    extends BaseRequest<VmDiskService.ActivateRequest, VmDiskService.ActivateResponse>
    implements VmDiskService.ActivateRequest {
        private Boolean async;

        private ActivateRequestImpl() {
        }

        @Override
        public VmDiskService.ActivateRequest async(Boolean async) {
            this.async = async;
            return this;
        }

        @Override
        public VmDiskService.ActivateResponse send() {
            HttpPost request = new HttpPost(VmDiskServiceImpl.this.getConnection().getUrl() + VmDiskServiceImpl.this.getPath() + "/activate");
            try (ByteArrayOutputStream output = new ByteArrayOutputStream();
                 XmlWriter xmlWriter = new XmlWriter(output, true);){
                ActionBuilder action = new ActionBuilder();
                action.async(this.async);
                XmlActionWriter.writeOne(action.build(), xmlWriter);
                xmlWriter.flush();
                request.setEntity((HttpEntity)new ByteArrayEntity(output.toByteArray()));
            }
            catch (IOException ex) {
                throw new Error("Failed to write request", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            HttpResponse response = VmDiskServiceImpl.this.getConnection().send((HttpUriRequest)request);
            Action action = VmDiskServiceImpl.this.checkAction(response);
            EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
            return new ActivateResponseImpl();
        }
    }
}

