/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.builders;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.ovirt.engine.sdk4.builders.AffinityLabelBuilder;
import org.ovirt.engine.sdk4.builders.AgentBuilder;
import org.ovirt.engine.sdk4.builders.CertificateBuilder;
import org.ovirt.engine.sdk4.builders.ClusterBuilder;
import org.ovirt.engine.sdk4.builders.CpuBuilder;
import org.ovirt.engine.sdk4.builders.DisplayBuilder;
import org.ovirt.engine.sdk4.builders.ExternalHostProviderBuilder;
import org.ovirt.engine.sdk4.builders.ExternalNetworkProviderConfigurationBuilder;
import org.ovirt.engine.sdk4.builders.HardwareInformationBuilder;
import org.ovirt.engine.sdk4.builders.HookBuilder;
import org.ovirt.engine.sdk4.builders.HostDeviceBuilder;
import org.ovirt.engine.sdk4.builders.HostDevicePassthroughBuilder;
import org.ovirt.engine.sdk4.builders.HostNicBuilder;
import org.ovirt.engine.sdk4.builders.HostStorageBuilder;
import org.ovirt.engine.sdk4.builders.HostedEngineBuilder;
import org.ovirt.engine.sdk4.builders.IscsiDetailsBuilder;
import org.ovirt.engine.sdk4.builders.KatelloErratumBuilder;
import org.ovirt.engine.sdk4.builders.KsmBuilder;
import org.ovirt.engine.sdk4.builders.NetworkAttachmentBuilder;
import org.ovirt.engine.sdk4.builders.NumaNodeBuilder;
import org.ovirt.engine.sdk4.builders.OperatingSystemBuilder;
import org.ovirt.engine.sdk4.builders.PermissionBuilder;
import org.ovirt.engine.sdk4.builders.PowerManagementBuilder;
import org.ovirt.engine.sdk4.builders.SeLinuxBuilder;
import org.ovirt.engine.sdk4.builders.SpmBuilder;
import org.ovirt.engine.sdk4.builders.SshBuilder;
import org.ovirt.engine.sdk4.builders.StatisticBuilder;
import org.ovirt.engine.sdk4.builders.StorageConnectionExtensionBuilder;
import org.ovirt.engine.sdk4.builders.TagBuilder;
import org.ovirt.engine.sdk4.builders.TransparentHugePagesBuilder;
import org.ovirt.engine.sdk4.builders.UnmanagedNetworkBuilder;
import org.ovirt.engine.sdk4.builders.VersionBuilder;
import org.ovirt.engine.sdk4.builders.VmSummaryBuilder;
import org.ovirt.engine.sdk4.internal.containers.HostContainer;
import org.ovirt.engine.sdk4.types.AffinityLabel;
import org.ovirt.engine.sdk4.types.Agent;
import org.ovirt.engine.sdk4.types.AutoNumaStatus;
import org.ovirt.engine.sdk4.types.Certificate;
import org.ovirt.engine.sdk4.types.Cluster;
import org.ovirt.engine.sdk4.types.Cpu;
import org.ovirt.engine.sdk4.types.Display;
import org.ovirt.engine.sdk4.types.ExternalHostProvider;
import org.ovirt.engine.sdk4.types.ExternalNetworkProviderConfiguration;
import org.ovirt.engine.sdk4.types.ExternalStatus;
import org.ovirt.engine.sdk4.types.HardwareInformation;
import org.ovirt.engine.sdk4.types.Hook;
import org.ovirt.engine.sdk4.types.Host;
import org.ovirt.engine.sdk4.types.HostDevice;
import org.ovirt.engine.sdk4.types.HostDevicePassthrough;
import org.ovirt.engine.sdk4.types.HostNic;
import org.ovirt.engine.sdk4.types.HostProtocol;
import org.ovirt.engine.sdk4.types.HostStatus;
import org.ovirt.engine.sdk4.types.HostStorage;
import org.ovirt.engine.sdk4.types.HostType;
import org.ovirt.engine.sdk4.types.HostedEngine;
import org.ovirt.engine.sdk4.types.IscsiDetails;
import org.ovirt.engine.sdk4.types.KatelloErratum;
import org.ovirt.engine.sdk4.types.KdumpStatus;
import org.ovirt.engine.sdk4.types.Ksm;
import org.ovirt.engine.sdk4.types.NetworkAttachment;
import org.ovirt.engine.sdk4.types.NumaNode;
import org.ovirt.engine.sdk4.types.OperatingSystem;
import org.ovirt.engine.sdk4.types.Permission;
import org.ovirt.engine.sdk4.types.PowerManagement;
import org.ovirt.engine.sdk4.types.SeLinux;
import org.ovirt.engine.sdk4.types.Spm;
import org.ovirt.engine.sdk4.types.Ssh;
import org.ovirt.engine.sdk4.types.Statistic;
import org.ovirt.engine.sdk4.types.StorageConnectionExtension;
import org.ovirt.engine.sdk4.types.Tag;
import org.ovirt.engine.sdk4.types.TransparentHugePages;
import org.ovirt.engine.sdk4.types.UnmanagedNetwork;
import org.ovirt.engine.sdk4.types.Version;
import org.ovirt.engine.sdk4.types.VgpuPlacement;
import org.ovirt.engine.sdk4.types.VmSummary;

public class HostBuilder {
    private String address;
    private List<AffinityLabel> affinityLabels;
    private List<Agent> agents;
    private AutoNumaStatus autoNumaStatus;
    private Certificate certificate;
    private Cluster cluster;
    private String comment;
    private Cpu cpu;
    private String description;
    private HostDevicePassthrough devicePassthrough;
    private List<HostDevice> devices;
    private Display display;
    private ExternalHostProvider externalHostProvider;
    private List<ExternalNetworkProviderConfiguration> externalNetworkProviderConfigurations;
    private ExternalStatus externalStatus;
    private HardwareInformation hardwareInformation;
    private List<Hook> hooks;
    private HostedEngine hostedEngine;
    private String href;
    private String id;
    private IscsiDetails iscsi;
    private List<KatelloErratum> katelloErrata;
    private KdumpStatus kdumpStatus;
    private Ksm ksm;
    private Version libvirtVersion;
    private BigInteger maxSchedulingMemory;
    private BigInteger memory;
    private String name;
    private List<NetworkAttachment> networkAttachments;
    private Boolean networkOperationInProgress;
    private List<HostNic> nics;
    private List<NumaNode> numaNodes;
    private Boolean numaSupported;
    private OperatingSystem os;
    private Boolean overrideIptables;
    private List<Permission> permissions;
    private BigInteger port;
    private PowerManagement powerManagement;
    private HostProtocol protocol;
    private String rootPassword;
    private SeLinux seLinux;
    private Spm spm;
    private Ssh ssh;
    private List<Statistic> statistics;
    private HostStatus status;
    private String statusDetail;
    private List<StorageConnectionExtension> storageConnectionExtensions;
    private List<HostStorage> storages;
    private VmSummary summary;
    private List<Tag> tags;
    private TransparentHugePages transparentHugePages;
    private HostType type;
    private List<UnmanagedNetwork> unmanagedNetworks;
    private Boolean updateAvailable;
    private Version version;
    private VgpuPlacement vgpuPlacement;

    public HostBuilder address(String newAddress) {
        this.address = newAddress;
        return this;
    }

    public HostBuilder affinityLabels(List<AffinityLabel> newAffinityLabels) {
        if (newAffinityLabels != null) {
            if (this.affinityLabels == null) {
                this.affinityLabels = new ArrayList<AffinityLabel>(newAffinityLabels);
            } else {
                this.affinityLabels.addAll(newAffinityLabels);
            }
        }
        return this;
    }

    public HostBuilder affinityLabels(AffinityLabel ... newAffinityLabels) {
        if (newAffinityLabels != null) {
            if (this.affinityLabels == null) {
                this.affinityLabels = new ArrayList<AffinityLabel>(newAffinityLabels.length);
            }
            Collections.addAll(this.affinityLabels, newAffinityLabels);
        }
        return this;
    }

    public HostBuilder affinityLabels(AffinityLabelBuilder ... newAffinityLabels) {
        if (newAffinityLabels != null) {
            if (this.affinityLabels == null) {
                this.affinityLabels = new ArrayList<AffinityLabel>(newAffinityLabels.length);
            }
            for (AffinityLabelBuilder builder : newAffinityLabels) {
                this.affinityLabels.add(builder.build());
            }
        }
        return this;
    }

    public HostBuilder agents(List<Agent> newAgents) {
        if (newAgents != null) {
            if (this.agents == null) {
                this.agents = new ArrayList<Agent>(newAgents);
            } else {
                this.agents.addAll(newAgents);
            }
        }
        return this;
    }

    public HostBuilder agents(Agent ... newAgents) {
        if (newAgents != null) {
            if (this.agents == null) {
                this.agents = new ArrayList<Agent>(newAgents.length);
            }
            Collections.addAll(this.agents, newAgents);
        }
        return this;
    }

    public HostBuilder agents(AgentBuilder ... newAgents) {
        if (newAgents != null) {
            if (this.agents == null) {
                this.agents = new ArrayList<Agent>(newAgents.length);
            }
            for (AgentBuilder builder : newAgents) {
                this.agents.add(builder.build());
            }
        }
        return this;
    }

    public HostBuilder autoNumaStatus(AutoNumaStatus newAutoNumaStatus) {
        this.autoNumaStatus = newAutoNumaStatus;
        return this;
    }

    public HostBuilder certificate(Certificate newCertificate) {
        this.certificate = newCertificate;
        return this;
    }

    public HostBuilder certificate(CertificateBuilder newCertificate) {
        this.certificate = newCertificate == null ? null : newCertificate.build();
        return this;
    }

    public HostBuilder cluster(Cluster newCluster) {
        this.cluster = newCluster;
        return this;
    }

    public HostBuilder cluster(ClusterBuilder newCluster) {
        this.cluster = newCluster == null ? null : newCluster.build();
        return this;
    }

    public HostBuilder comment(String newComment) {
        this.comment = newComment;
        return this;
    }

    public HostBuilder cpu(Cpu newCpu) {
        this.cpu = newCpu;
        return this;
    }

    public HostBuilder cpu(CpuBuilder newCpu) {
        this.cpu = newCpu == null ? null : newCpu.build();
        return this;
    }

    public HostBuilder description(String newDescription) {
        this.description = newDescription;
        return this;
    }

    public HostBuilder devicePassthrough(HostDevicePassthrough newDevicePassthrough) {
        this.devicePassthrough = newDevicePassthrough;
        return this;
    }

    public HostBuilder devicePassthrough(HostDevicePassthroughBuilder newDevicePassthrough) {
        this.devicePassthrough = newDevicePassthrough == null ? null : newDevicePassthrough.build();
        return this;
    }

    public HostBuilder devices(List<HostDevice> newDevices) {
        if (newDevices != null) {
            if (this.devices == null) {
                this.devices = new ArrayList<HostDevice>(newDevices);
            } else {
                this.devices.addAll(newDevices);
            }
        }
        return this;
    }

    public HostBuilder devices(HostDevice ... newDevices) {
        if (newDevices != null) {
            if (this.devices == null) {
                this.devices = new ArrayList<HostDevice>(newDevices.length);
            }
            Collections.addAll(this.devices, newDevices);
        }
        return this;
    }

    public HostBuilder devices(HostDeviceBuilder ... newDevices) {
        if (newDevices != null) {
            if (this.devices == null) {
                this.devices = new ArrayList<HostDevice>(newDevices.length);
            }
            for (HostDeviceBuilder builder : newDevices) {
                this.devices.add(builder.build());
            }
        }
        return this;
    }

    public HostBuilder display(Display newDisplay) {
        this.display = newDisplay;
        return this;
    }

    public HostBuilder display(DisplayBuilder newDisplay) {
        this.display = newDisplay == null ? null : newDisplay.build();
        return this;
    }

    public HostBuilder externalHostProvider(ExternalHostProvider newExternalHostProvider) {
        this.externalHostProvider = newExternalHostProvider;
        return this;
    }

    public HostBuilder externalHostProvider(ExternalHostProviderBuilder newExternalHostProvider) {
        this.externalHostProvider = newExternalHostProvider == null ? null : newExternalHostProvider.build();
        return this;
    }

    public HostBuilder externalNetworkProviderConfigurations(List<ExternalNetworkProviderConfiguration> newExternalNetworkProviderConfigurations) {
        if (newExternalNetworkProviderConfigurations != null) {
            if (this.externalNetworkProviderConfigurations == null) {
                this.externalNetworkProviderConfigurations = new ArrayList<ExternalNetworkProviderConfiguration>(newExternalNetworkProviderConfigurations);
            } else {
                this.externalNetworkProviderConfigurations.addAll(newExternalNetworkProviderConfigurations);
            }
        }
        return this;
    }

    public HostBuilder externalNetworkProviderConfigurations(ExternalNetworkProviderConfiguration ... newExternalNetworkProviderConfigurations) {
        if (newExternalNetworkProviderConfigurations != null) {
            if (this.externalNetworkProviderConfigurations == null) {
                this.externalNetworkProviderConfigurations = new ArrayList<ExternalNetworkProviderConfiguration>(newExternalNetworkProviderConfigurations.length);
            }
            Collections.addAll(this.externalNetworkProviderConfigurations, newExternalNetworkProviderConfigurations);
        }
        return this;
    }

    public HostBuilder externalNetworkProviderConfigurations(ExternalNetworkProviderConfigurationBuilder ... newExternalNetworkProviderConfigurations) {
        if (newExternalNetworkProviderConfigurations != null) {
            if (this.externalNetworkProviderConfigurations == null) {
                this.externalNetworkProviderConfigurations = new ArrayList<ExternalNetworkProviderConfiguration>(newExternalNetworkProviderConfigurations.length);
            }
            for (ExternalNetworkProviderConfigurationBuilder builder : newExternalNetworkProviderConfigurations) {
                this.externalNetworkProviderConfigurations.add(builder.build());
            }
        }
        return this;
    }

    public HostBuilder externalStatus(ExternalStatus newExternalStatus) {
        this.externalStatus = newExternalStatus;
        return this;
    }

    public HostBuilder hardwareInformation(HardwareInformation newHardwareInformation) {
        this.hardwareInformation = newHardwareInformation;
        return this;
    }

    public HostBuilder hardwareInformation(HardwareInformationBuilder newHardwareInformation) {
        this.hardwareInformation = newHardwareInformation == null ? null : newHardwareInformation.build();
        return this;
    }

    public HostBuilder hooks(List<Hook> newHooks) {
        if (newHooks != null) {
            if (this.hooks == null) {
                this.hooks = new ArrayList<Hook>(newHooks);
            } else {
                this.hooks.addAll(newHooks);
            }
        }
        return this;
    }

    public HostBuilder hooks(Hook ... newHooks) {
        if (newHooks != null) {
            if (this.hooks == null) {
                this.hooks = new ArrayList<Hook>(newHooks.length);
            }
            Collections.addAll(this.hooks, newHooks);
        }
        return this;
    }

    public HostBuilder hooks(HookBuilder ... newHooks) {
        if (newHooks != null) {
            if (this.hooks == null) {
                this.hooks = new ArrayList<Hook>(newHooks.length);
            }
            for (HookBuilder builder : newHooks) {
                this.hooks.add(builder.build());
            }
        }
        return this;
    }

    public HostBuilder hostedEngine(HostedEngine newHostedEngine) {
        this.hostedEngine = newHostedEngine;
        return this;
    }

    public HostBuilder hostedEngine(HostedEngineBuilder newHostedEngine) {
        this.hostedEngine = newHostedEngine == null ? null : newHostedEngine.build();
        return this;
    }

    public HostBuilder href(String newHref) {
        this.href = newHref;
        return this;
    }

    public HostBuilder id(String newId) {
        this.id = newId;
        return this;
    }

    public HostBuilder iscsi(IscsiDetails newIscsi) {
        this.iscsi = newIscsi;
        return this;
    }

    public HostBuilder iscsi(IscsiDetailsBuilder newIscsi) {
        this.iscsi = newIscsi == null ? null : newIscsi.build();
        return this;
    }

    public HostBuilder katelloErrata(List<KatelloErratum> newKatelloErrata) {
        if (newKatelloErrata != null) {
            if (this.katelloErrata == null) {
                this.katelloErrata = new ArrayList<KatelloErratum>(newKatelloErrata);
            } else {
                this.katelloErrata.addAll(newKatelloErrata);
            }
        }
        return this;
    }

    public HostBuilder katelloErrata(KatelloErratum ... newKatelloErrata) {
        if (newKatelloErrata != null) {
            if (this.katelloErrata == null) {
                this.katelloErrata = new ArrayList<KatelloErratum>(newKatelloErrata.length);
            }
            Collections.addAll(this.katelloErrata, newKatelloErrata);
        }
        return this;
    }

    public HostBuilder katelloErrata(KatelloErratumBuilder ... newKatelloErrata) {
        if (newKatelloErrata != null) {
            if (this.katelloErrata == null) {
                this.katelloErrata = new ArrayList<KatelloErratum>(newKatelloErrata.length);
            }
            for (KatelloErratumBuilder builder : newKatelloErrata) {
                this.katelloErrata.add(builder.build());
            }
        }
        return this;
    }

    public HostBuilder kdumpStatus(KdumpStatus newKdumpStatus) {
        this.kdumpStatus = newKdumpStatus;
        return this;
    }

    public HostBuilder ksm(Ksm newKsm) {
        this.ksm = newKsm;
        return this;
    }

    public HostBuilder ksm(KsmBuilder newKsm) {
        this.ksm = newKsm == null ? null : newKsm.build();
        return this;
    }

    public HostBuilder libvirtVersion(Version newLibvirtVersion) {
        this.libvirtVersion = newLibvirtVersion;
        return this;
    }

    public HostBuilder libvirtVersion(VersionBuilder newLibvirtVersion) {
        this.libvirtVersion = newLibvirtVersion == null ? null : newLibvirtVersion.build();
        return this;
    }

    public HostBuilder maxSchedulingMemory(int newMaxSchedulingMemory) {
        this.maxSchedulingMemory = BigInteger.valueOf(newMaxSchedulingMemory);
        return this;
    }

    public HostBuilder maxSchedulingMemory(Integer newMaxSchedulingMemory) {
        this.maxSchedulingMemory = newMaxSchedulingMemory == null ? null : BigInteger.valueOf(newMaxSchedulingMemory.longValue());
        return this;
    }

    public HostBuilder maxSchedulingMemory(long newMaxSchedulingMemory) {
        this.maxSchedulingMemory = BigInteger.valueOf(newMaxSchedulingMemory);
        return this;
    }

    public HostBuilder maxSchedulingMemory(Long newMaxSchedulingMemory) {
        this.maxSchedulingMemory = newMaxSchedulingMemory == null ? null : BigInteger.valueOf(newMaxSchedulingMemory);
        return this;
    }

    public HostBuilder maxSchedulingMemory(BigInteger newMaxSchedulingMemory) {
        this.maxSchedulingMemory = newMaxSchedulingMemory;
        return this;
    }

    public HostBuilder memory(int newMemory) {
        this.memory = BigInteger.valueOf(newMemory);
        return this;
    }

    public HostBuilder memory(Integer newMemory) {
        this.memory = newMemory == null ? null : BigInteger.valueOf(newMemory.longValue());
        return this;
    }

    public HostBuilder memory(long newMemory) {
        this.memory = BigInteger.valueOf(newMemory);
        return this;
    }

    public HostBuilder memory(Long newMemory) {
        this.memory = newMemory == null ? null : BigInteger.valueOf(newMemory);
        return this;
    }

    public HostBuilder memory(BigInteger newMemory) {
        this.memory = newMemory;
        return this;
    }

    public HostBuilder name(String newName) {
        this.name = newName;
        return this;
    }

    public HostBuilder networkAttachments(List<NetworkAttachment> newNetworkAttachments) {
        if (newNetworkAttachments != null) {
            if (this.networkAttachments == null) {
                this.networkAttachments = new ArrayList<NetworkAttachment>(newNetworkAttachments);
            } else {
                this.networkAttachments.addAll(newNetworkAttachments);
            }
        }
        return this;
    }

    public HostBuilder networkAttachments(NetworkAttachment ... newNetworkAttachments) {
        if (newNetworkAttachments != null) {
            if (this.networkAttachments == null) {
                this.networkAttachments = new ArrayList<NetworkAttachment>(newNetworkAttachments.length);
            }
            Collections.addAll(this.networkAttachments, newNetworkAttachments);
        }
        return this;
    }

    public HostBuilder networkAttachments(NetworkAttachmentBuilder ... newNetworkAttachments) {
        if (newNetworkAttachments != null) {
            if (this.networkAttachments == null) {
                this.networkAttachments = new ArrayList<NetworkAttachment>(newNetworkAttachments.length);
            }
            for (NetworkAttachmentBuilder builder : newNetworkAttachments) {
                this.networkAttachments.add(builder.build());
            }
        }
        return this;
    }

    public HostBuilder networkOperationInProgress(boolean newNetworkOperationInProgress) {
        this.networkOperationInProgress = newNetworkOperationInProgress;
        return this;
    }

    public HostBuilder networkOperationInProgress(Boolean newNetworkOperationInProgress) {
        this.networkOperationInProgress = newNetworkOperationInProgress;
        return this;
    }

    public HostBuilder nics(List<HostNic> newNics) {
        if (newNics != null) {
            if (this.nics == null) {
                this.nics = new ArrayList<HostNic>(newNics);
            } else {
                this.nics.addAll(newNics);
            }
        }
        return this;
    }

    public HostBuilder nics(HostNic ... newNics) {
        if (newNics != null) {
            if (this.nics == null) {
                this.nics = new ArrayList<HostNic>(newNics.length);
            }
            Collections.addAll(this.nics, newNics);
        }
        return this;
    }

    public HostBuilder nics(HostNicBuilder ... newNics) {
        if (newNics != null) {
            if (this.nics == null) {
                this.nics = new ArrayList<HostNic>(newNics.length);
            }
            for (HostNicBuilder builder : newNics) {
                this.nics.add(builder.build());
            }
        }
        return this;
    }

    public HostBuilder numaNodes(List<NumaNode> newNumaNodes) {
        if (newNumaNodes != null) {
            if (this.numaNodes == null) {
                this.numaNodes = new ArrayList<NumaNode>(newNumaNodes);
            } else {
                this.numaNodes.addAll(newNumaNodes);
            }
        }
        return this;
    }

    public HostBuilder numaNodes(NumaNode ... newNumaNodes) {
        if (newNumaNodes != null) {
            if (this.numaNodes == null) {
                this.numaNodes = new ArrayList<NumaNode>(newNumaNodes.length);
            }
            Collections.addAll(this.numaNodes, newNumaNodes);
        }
        return this;
    }

    public HostBuilder numaNodes(NumaNodeBuilder ... newNumaNodes) {
        if (newNumaNodes != null) {
            if (this.numaNodes == null) {
                this.numaNodes = new ArrayList<NumaNode>(newNumaNodes.length);
            }
            for (NumaNodeBuilder builder : newNumaNodes) {
                this.numaNodes.add(builder.build());
            }
        }
        return this;
    }

    public HostBuilder numaSupported(boolean newNumaSupported) {
        this.numaSupported = newNumaSupported;
        return this;
    }

    public HostBuilder numaSupported(Boolean newNumaSupported) {
        this.numaSupported = newNumaSupported;
        return this;
    }

    public HostBuilder os(OperatingSystem newOs) {
        this.os = newOs;
        return this;
    }

    public HostBuilder os(OperatingSystemBuilder newOs) {
        this.os = newOs == null ? null : newOs.build();
        return this;
    }

    public HostBuilder overrideIptables(boolean newOverrideIptables) {
        this.overrideIptables = newOverrideIptables;
        return this;
    }

    public HostBuilder overrideIptables(Boolean newOverrideIptables) {
        this.overrideIptables = newOverrideIptables;
        return this;
    }

    public HostBuilder permissions(List<Permission> newPermissions) {
        if (newPermissions != null) {
            if (this.permissions == null) {
                this.permissions = new ArrayList<Permission>(newPermissions);
            } else {
                this.permissions.addAll(newPermissions);
            }
        }
        return this;
    }

    public HostBuilder permissions(Permission ... newPermissions) {
        if (newPermissions != null) {
            if (this.permissions == null) {
                this.permissions = new ArrayList<Permission>(newPermissions.length);
            }
            Collections.addAll(this.permissions, newPermissions);
        }
        return this;
    }

    public HostBuilder permissions(PermissionBuilder ... newPermissions) {
        if (newPermissions != null) {
            if (this.permissions == null) {
                this.permissions = new ArrayList<Permission>(newPermissions.length);
            }
            for (PermissionBuilder builder : newPermissions) {
                this.permissions.add(builder.build());
            }
        }
        return this;
    }

    public HostBuilder port(int newPort) {
        this.port = BigInteger.valueOf(newPort);
        return this;
    }

    public HostBuilder port(Integer newPort) {
        this.port = newPort == null ? null : BigInteger.valueOf(newPort.longValue());
        return this;
    }

    public HostBuilder port(long newPort) {
        this.port = BigInteger.valueOf(newPort);
        return this;
    }

    public HostBuilder port(Long newPort) {
        this.port = newPort == null ? null : BigInteger.valueOf(newPort);
        return this;
    }

    public HostBuilder port(BigInteger newPort) {
        this.port = newPort;
        return this;
    }

    public HostBuilder powerManagement(PowerManagement newPowerManagement) {
        this.powerManagement = newPowerManagement;
        return this;
    }

    public HostBuilder powerManagement(PowerManagementBuilder newPowerManagement) {
        this.powerManagement = newPowerManagement == null ? null : newPowerManagement.build();
        return this;
    }

    public HostBuilder protocol(HostProtocol newProtocol) {
        this.protocol = newProtocol;
        return this;
    }

    public HostBuilder rootPassword(String newRootPassword) {
        this.rootPassword = newRootPassword;
        return this;
    }

    public HostBuilder seLinux(SeLinux newSeLinux) {
        this.seLinux = newSeLinux;
        return this;
    }

    public HostBuilder seLinux(SeLinuxBuilder newSeLinux) {
        this.seLinux = newSeLinux == null ? null : newSeLinux.build();
        return this;
    }

    public HostBuilder spm(Spm newSpm) {
        this.spm = newSpm;
        return this;
    }

    public HostBuilder spm(SpmBuilder newSpm) {
        this.spm = newSpm == null ? null : newSpm.build();
        return this;
    }

    public HostBuilder ssh(Ssh newSsh) {
        this.ssh = newSsh;
        return this;
    }

    public HostBuilder ssh(SshBuilder newSsh) {
        this.ssh = newSsh == null ? null : newSsh.build();
        return this;
    }

    public HostBuilder statistics(List<Statistic> newStatistics) {
        if (newStatistics != null) {
            if (this.statistics == null) {
                this.statistics = new ArrayList<Statistic>(newStatistics);
            } else {
                this.statistics.addAll(newStatistics);
            }
        }
        return this;
    }

    public HostBuilder statistics(Statistic ... newStatistics) {
        if (newStatistics != null) {
            if (this.statistics == null) {
                this.statistics = new ArrayList<Statistic>(newStatistics.length);
            }
            Collections.addAll(this.statistics, newStatistics);
        }
        return this;
    }

    public HostBuilder statistics(StatisticBuilder ... newStatistics) {
        if (newStatistics != null) {
            if (this.statistics == null) {
                this.statistics = new ArrayList<Statistic>(newStatistics.length);
            }
            for (StatisticBuilder builder : newStatistics) {
                this.statistics.add(builder.build());
            }
        }
        return this;
    }

    public HostBuilder status(HostStatus newStatus) {
        this.status = newStatus;
        return this;
    }

    public HostBuilder statusDetail(String newStatusDetail) {
        this.statusDetail = newStatusDetail;
        return this;
    }

    public HostBuilder storageConnectionExtensions(List<StorageConnectionExtension> newStorageConnectionExtensions) {
        if (newStorageConnectionExtensions != null) {
            if (this.storageConnectionExtensions == null) {
                this.storageConnectionExtensions = new ArrayList<StorageConnectionExtension>(newStorageConnectionExtensions);
            } else {
                this.storageConnectionExtensions.addAll(newStorageConnectionExtensions);
            }
        }
        return this;
    }

    public HostBuilder storageConnectionExtensions(StorageConnectionExtension ... newStorageConnectionExtensions) {
        if (newStorageConnectionExtensions != null) {
            if (this.storageConnectionExtensions == null) {
                this.storageConnectionExtensions = new ArrayList<StorageConnectionExtension>(newStorageConnectionExtensions.length);
            }
            Collections.addAll(this.storageConnectionExtensions, newStorageConnectionExtensions);
        }
        return this;
    }

    public HostBuilder storageConnectionExtensions(StorageConnectionExtensionBuilder ... newStorageConnectionExtensions) {
        if (newStorageConnectionExtensions != null) {
            if (this.storageConnectionExtensions == null) {
                this.storageConnectionExtensions = new ArrayList<StorageConnectionExtension>(newStorageConnectionExtensions.length);
            }
            for (StorageConnectionExtensionBuilder builder : newStorageConnectionExtensions) {
                this.storageConnectionExtensions.add(builder.build());
            }
        }
        return this;
    }

    public HostBuilder storages(List<HostStorage> newStorages) {
        if (newStorages != null) {
            if (this.storages == null) {
                this.storages = new ArrayList<HostStorage>(newStorages);
            } else {
                this.storages.addAll(newStorages);
            }
        }
        return this;
    }

    public HostBuilder storages(HostStorage ... newStorages) {
        if (newStorages != null) {
            if (this.storages == null) {
                this.storages = new ArrayList<HostStorage>(newStorages.length);
            }
            Collections.addAll(this.storages, newStorages);
        }
        return this;
    }

    public HostBuilder storages(HostStorageBuilder ... newStorages) {
        if (newStorages != null) {
            if (this.storages == null) {
                this.storages = new ArrayList<HostStorage>(newStorages.length);
            }
            for (HostStorageBuilder builder : newStorages) {
                this.storages.add(builder.build());
            }
        }
        return this;
    }

    public HostBuilder summary(VmSummary newSummary) {
        this.summary = newSummary;
        return this;
    }

    public HostBuilder summary(VmSummaryBuilder newSummary) {
        this.summary = newSummary == null ? null : newSummary.build();
        return this;
    }

    public HostBuilder tags(List<Tag> newTags) {
        if (newTags != null) {
            if (this.tags == null) {
                this.tags = new ArrayList<Tag>(newTags);
            } else {
                this.tags.addAll(newTags);
            }
        }
        return this;
    }

    public HostBuilder tags(Tag ... newTags) {
        if (newTags != null) {
            if (this.tags == null) {
                this.tags = new ArrayList<Tag>(newTags.length);
            }
            Collections.addAll(this.tags, newTags);
        }
        return this;
    }

    public HostBuilder tags(TagBuilder ... newTags) {
        if (newTags != null) {
            if (this.tags == null) {
                this.tags = new ArrayList<Tag>(newTags.length);
            }
            for (TagBuilder builder : newTags) {
                this.tags.add(builder.build());
            }
        }
        return this;
    }

    public HostBuilder transparentHugePages(TransparentHugePages newTransparentHugePages) {
        this.transparentHugePages = newTransparentHugePages;
        return this;
    }

    public HostBuilder transparentHugePages(TransparentHugePagesBuilder newTransparentHugePages) {
        this.transparentHugePages = newTransparentHugePages == null ? null : newTransparentHugePages.build();
        return this;
    }

    public HostBuilder type(HostType newType) {
        this.type = newType;
        return this;
    }

    public HostBuilder unmanagedNetworks(List<UnmanagedNetwork> newUnmanagedNetworks) {
        if (newUnmanagedNetworks != null) {
            if (this.unmanagedNetworks == null) {
                this.unmanagedNetworks = new ArrayList<UnmanagedNetwork>(newUnmanagedNetworks);
            } else {
                this.unmanagedNetworks.addAll(newUnmanagedNetworks);
            }
        }
        return this;
    }

    public HostBuilder unmanagedNetworks(UnmanagedNetwork ... newUnmanagedNetworks) {
        if (newUnmanagedNetworks != null) {
            if (this.unmanagedNetworks == null) {
                this.unmanagedNetworks = new ArrayList<UnmanagedNetwork>(newUnmanagedNetworks.length);
            }
            Collections.addAll(this.unmanagedNetworks, newUnmanagedNetworks);
        }
        return this;
    }

    public HostBuilder unmanagedNetworks(UnmanagedNetworkBuilder ... newUnmanagedNetworks) {
        if (newUnmanagedNetworks != null) {
            if (this.unmanagedNetworks == null) {
                this.unmanagedNetworks = new ArrayList<UnmanagedNetwork>(newUnmanagedNetworks.length);
            }
            for (UnmanagedNetworkBuilder builder : newUnmanagedNetworks) {
                this.unmanagedNetworks.add(builder.build());
            }
        }
        return this;
    }

    public HostBuilder updateAvailable(boolean newUpdateAvailable) {
        this.updateAvailable = newUpdateAvailable;
        return this;
    }

    public HostBuilder updateAvailable(Boolean newUpdateAvailable) {
        this.updateAvailable = newUpdateAvailable;
        return this;
    }

    public HostBuilder version(Version newVersion) {
        this.version = newVersion;
        return this;
    }

    public HostBuilder version(VersionBuilder newVersion) {
        this.version = newVersion == null ? null : newVersion.build();
        return this;
    }

    public HostBuilder vgpuPlacement(VgpuPlacement newVgpuPlacement) {
        this.vgpuPlacement = newVgpuPlacement;
        return this;
    }

    public Host build() {
        HostContainer container = new HostContainer();
        container.address(this.address);
        container.affinityLabels(this.affinityLabels);
        container.agents(this.agents);
        container.autoNumaStatus(this.autoNumaStatus);
        container.certificate(this.certificate);
        container.cluster(this.cluster);
        container.comment(this.comment);
        container.cpu(this.cpu);
        container.description(this.description);
        container.devicePassthrough(this.devicePassthrough);
        container.devices(this.devices);
        container.display(this.display);
        container.externalHostProvider(this.externalHostProvider);
        container.externalNetworkProviderConfigurations(this.externalNetworkProviderConfigurations);
        container.externalStatus(this.externalStatus);
        container.hardwareInformation(this.hardwareInformation);
        container.hooks(this.hooks);
        container.hostedEngine(this.hostedEngine);
        container.href(this.href);
        container.id(this.id);
        container.iscsi(this.iscsi);
        container.katelloErrata(this.katelloErrata);
        container.kdumpStatus(this.kdumpStatus);
        container.ksm(this.ksm);
        container.libvirtVersion(this.libvirtVersion);
        container.maxSchedulingMemory(this.maxSchedulingMemory);
        container.memory(this.memory);
        container.name(this.name);
        container.networkAttachments(this.networkAttachments);
        container.networkOperationInProgress(this.networkOperationInProgress);
        container.nics(this.nics);
        container.numaNodes(this.numaNodes);
        container.numaSupported(this.numaSupported);
        container.os(this.os);
        container.overrideIptables(this.overrideIptables);
        container.permissions(this.permissions);
        container.port(this.port);
        container.powerManagement(this.powerManagement);
        container.protocol(this.protocol);
        container.rootPassword(this.rootPassword);
        container.seLinux(this.seLinux);
        container.spm(this.spm);
        container.ssh(this.ssh);
        container.statistics(this.statistics);
        container.status(this.status);
        container.statusDetail(this.statusDetail);
        container.storageConnectionExtensions(this.storageConnectionExtensions);
        container.storages(this.storages);
        container.summary(this.summary);
        container.tags(this.tags);
        container.transparentHugePages(this.transparentHugePages);
        container.type(this.type);
        container.unmanagedNetworks(this.unmanagedNetworks);
        container.updateAvailable(this.updateAvailable);
        container.version(this.version);
        container.vgpuPlacement(this.vgpuPlacement);
        return container;
    }
}

