/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.internal.services;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.util.EntityUtils;
import org.ovirt.api.metamodel.runtime.xml.XmlReader;
import org.ovirt.api.metamodel.runtime.xml.XmlWriter;
import org.ovirt.engine.sdk4.BaseRequest;
import org.ovirt.engine.sdk4.Error;
import org.ovirt.engine.sdk4.Service;
import org.ovirt.engine.sdk4.builders.OpenStackVolumeProviderBuilder;
import org.ovirt.engine.sdk4.internal.HttpConnection;
import org.ovirt.engine.sdk4.internal.services.OpenstackVolumeProviderServiceImpl;
import org.ovirt.engine.sdk4.internal.services.ServiceImpl;
import org.ovirt.engine.sdk4.internal.xml.XmlOpenStackVolumeProviderReader;
import org.ovirt.engine.sdk4.internal.xml.XmlOpenStackVolumeProviderWriter;
import org.ovirt.engine.sdk4.services.OpenstackVolumeProviderService;
import org.ovirt.engine.sdk4.services.OpenstackVolumeProvidersService;
import org.ovirt.engine.sdk4.types.OpenStackVolumeProvider;

public class OpenstackVolumeProvidersServiceImpl
extends ServiceImpl
implements OpenstackVolumeProvidersService {
    public OpenstackVolumeProvidersServiceImpl(HttpConnection connection, String path) {
        super(connection, path);
    }

    @Override
    public OpenstackVolumeProvidersService.AddRequest add() {
        return new AddRequestImpl();
    }

    @Override
    public OpenstackVolumeProvidersService.ListRequest list() {
        return new ListRequestImpl();
    }

    @Override
    public OpenstackVolumeProviderService providerService(String id) {
        return new OpenstackVolumeProviderServiceImpl(this.getConnection(), this.getPath() + "/" + id);
    }

    @Override
    public Service service(String path) {
        if (path == null) {
            return this;
        }
        int index = path.indexOf(47);
        if (index == -1) {
            return this.providerService(path);
        }
        return this.providerService(path.substring(0, index)).service(path.substring(index + 1));
    }

    public String toString() {
        return "OpenstackVolumeProvidersService:" + this.getPath();
    }

    private class ListResponseImpl
    implements OpenstackVolumeProvidersService.ListResponse {
        private List<OpenStackVolumeProvider> providers;

        private ListResponseImpl() {
        }

        public void providers(List<OpenStackVolumeProvider> providers) {
            this.providers = providers;
        }

        @Override
        public List<OpenStackVolumeProvider> providers() {
            return this.providers;
        }
    }

    private class ListRequestImpl
    extends BaseRequest<OpenstackVolumeProvidersService.ListRequest, OpenstackVolumeProvidersService.ListResponse>
    implements OpenstackVolumeProvidersService.ListRequest {
        private String follow;
        private BigInteger max;
        private String search;

        private ListRequestImpl() {
        }

        @Override
        public OpenstackVolumeProvidersService.ListRequest follow(String follow) {
            this.follow = follow;
            return this;
        }

        @Override
        public OpenstackVolumeProvidersService.ListRequest max(BigInteger max) {
            this.max = max;
            return this;
        }

        @Override
        public OpenstackVolumeProvidersService.ListRequest max(Integer max) {
            this.max = BigInteger.valueOf(max.intValue());
            return this;
        }

        @Override
        public OpenstackVolumeProvidersService.ListRequest max(Long max) {
            this.max = BigInteger.valueOf(max);
            return this;
        }

        @Override
        public OpenstackVolumeProvidersService.ListRequest search(String search) {
            this.search = search;
            return this;
        }

        @Override
        public OpenstackVolumeProvidersService.ListResponse send() {
            HttpResponse response;
            HttpGet request = null;
            try {
                URIBuilder uriBuilder = new URIBuilder(OpenstackVolumeProvidersServiceImpl.this.getConnection().getUrl() + OpenstackVolumeProvidersServiceImpl.this.getPath());
                if (this.follow != null) {
                    uriBuilder.addParameter("follow", XmlWriter.renderString(this.follow));
                }
                if (this.max != null) {
                    uriBuilder.addParameter("max", XmlWriter.renderInteger(this.max));
                }
                if (this.search != null) {
                    uriBuilder.addParameter("search", XmlWriter.renderString(this.search));
                }
                if (this.query != null) {
                    for (Map.Entry queryParam : this.query.entrySet()) {
                        uriBuilder.addParameter((String)queryParam.getKey(), (String)queryParam.getValue());
                    }
                }
                request = new HttpGet(uriBuilder.build());
            }
            catch (URISyntaxException ex) {
                throw new Error("Failed to build URL", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            if ((response = OpenstackVolumeProvidersServiceImpl.this.getConnection().send((HttpUriRequest)request)).getStatusLine().getStatusCode() == 200) {
                try {
                    XmlReader reader = new XmlReader(response.getEntity().getContent());
                    try {
                        ListResponseImpl actionResponse = new ListResponseImpl();
                        actionResponse.providers(XmlOpenStackVolumeProviderReader.readMany(reader));
                        ListResponseImpl listResponseImpl = actionResponse;
                        reader.close();
                        return listResponseImpl;
                    }
                    catch (Throwable throwable) {
                        try {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        catch (IOException ex) {
                            throw new Error("Failed to read response", ex);
                        }
                    }
                }
                finally {
                    EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                }
            }
            OpenstackVolumeProvidersServiceImpl.this.checkFault(response);
            return new ListResponseImpl();
        }
    }

    private class AddResponseImpl
    implements OpenstackVolumeProvidersService.AddResponse {
        private OpenStackVolumeProvider provider;

        private AddResponseImpl() {
        }

        public void provider(OpenStackVolumeProvider provider) {
            this.provider = provider;
        }

        @Override
        public OpenStackVolumeProvider provider() {
            return this.provider;
        }
    }

    private class AddRequestImpl
    extends BaseRequest<OpenstackVolumeProvidersService.AddRequest, OpenstackVolumeProvidersService.AddResponse>
    implements OpenstackVolumeProvidersService.AddRequest {
        private OpenStackVolumeProvider provider;

        private AddRequestImpl() {
        }

        @Override
        public OpenstackVolumeProvidersService.AddRequest provider(OpenStackVolumeProvider provider) {
            this.provider = provider;
            return this;
        }

        @Override
        public OpenstackVolumeProvidersService.AddRequest provider(OpenStackVolumeProviderBuilder provider) {
            this.provider = provider.build();
            return this;
        }

        @Override
        public OpenstackVolumeProvidersService.AddResponse send() {
            HttpResponse response;
            HttpPost request = null;
            try {
                URIBuilder uriBuilder = new URIBuilder(OpenstackVolumeProvidersServiceImpl.this.getConnection().getUrl() + OpenstackVolumeProvidersServiceImpl.this.getPath());
                if (this.query != null) {
                    for (Map.Entry queryParam : this.query.entrySet()) {
                        uriBuilder.addParameter((String)queryParam.getKey(), (String)queryParam.getValue());
                    }
                }
                request = new HttpPost(uriBuilder.build());
            }
            catch (URISyntaxException ex) {
                throw new Error("Failed to build URL", ex);
            }
            try (ByteArrayOutputStream output = new ByteArrayOutputStream();
                 XmlWriter xmlWriter = new XmlWriter(output, true);){
                XmlOpenStackVolumeProviderWriter.writeOne(this.provider, xmlWriter);
                xmlWriter.flush();
                request.setEntity((HttpEntity)new ByteArrayEntity(output.toByteArray()));
            }
            catch (IOException ex) {
                throw new Error("Failed to parse response", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            if ((response = OpenstackVolumeProvidersServiceImpl.this.getConnection().send((HttpUriRequest)request)).getStatusLine().getStatusCode() == 200 || response.getStatusLine().getStatusCode() == 201 || response.getStatusLine().getStatusCode() == 202) {
                try {
                    XmlReader reader = new XmlReader(response.getEntity().getContent());
                    try {
                        AddResponseImpl actionResponse = new AddResponseImpl();
                        actionResponse.provider(XmlOpenStackVolumeProviderReader.readOne(reader));
                        AddResponseImpl addResponseImpl = actionResponse;
                        reader.close();
                        return addResponseImpl;
                    }
                    catch (Throwable throwable) {
                        try {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        catch (IOException ex) {
                            throw new Error("Failed to read response", ex);
                        }
                    }
                }
                finally {
                    EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                }
            }
            OpenstackVolumeProvidersServiceImpl.this.checkFault(response);
            return new AddResponseImpl();
        }
    }
}

