/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.internal.services;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.util.EntityUtils;
import org.ovirt.api.metamodel.runtime.xml.XmlReader;
import org.ovirt.api.metamodel.runtime.xml.XmlWriter;
import org.ovirt.engine.sdk4.BaseRequest;
import org.ovirt.engine.sdk4.Error;
import org.ovirt.engine.sdk4.Service;
import org.ovirt.engine.sdk4.builders.ActionBuilder;
import org.ovirt.engine.sdk4.builders.HostBuilder;
import org.ovirt.engine.sdk4.builders.StorageDomainBuilder;
import org.ovirt.engine.sdk4.builders.TemplateBuilder;
import org.ovirt.engine.sdk4.internal.HttpConnection;
import org.ovirt.engine.sdk4.internal.services.AssignedPermissionsServiceImpl;
import org.ovirt.engine.sdk4.internal.services.AssignedTagsServiceImpl;
import org.ovirt.engine.sdk4.internal.services.ServiceImpl;
import org.ovirt.engine.sdk4.internal.services.TemplateCdromsServiceImpl;
import org.ovirt.engine.sdk4.internal.services.TemplateDiskAttachmentsServiceImpl;
import org.ovirt.engine.sdk4.internal.services.TemplateGraphicsConsolesServiceImpl;
import org.ovirt.engine.sdk4.internal.services.TemplateNicsServiceImpl;
import org.ovirt.engine.sdk4.internal.services.TemplateWatchdogsServiceImpl;
import org.ovirt.engine.sdk4.internal.xml.XmlActionWriter;
import org.ovirt.engine.sdk4.internal.xml.XmlTemplateReader;
import org.ovirt.engine.sdk4.internal.xml.XmlTemplateWriter;
import org.ovirt.engine.sdk4.services.AssignedPermissionsService;
import org.ovirt.engine.sdk4.services.AssignedTagsService;
import org.ovirt.engine.sdk4.services.TemplateCdromsService;
import org.ovirt.engine.sdk4.services.TemplateDiskAttachmentsService;
import org.ovirt.engine.sdk4.services.TemplateGraphicsConsolesService;
import org.ovirt.engine.sdk4.services.TemplateNicsService;
import org.ovirt.engine.sdk4.services.TemplateService;
import org.ovirt.engine.sdk4.services.TemplateWatchdogsService;
import org.ovirt.engine.sdk4.types.Action;
import org.ovirt.engine.sdk4.types.Host;
import org.ovirt.engine.sdk4.types.StorageDomain;
import org.ovirt.engine.sdk4.types.Template;

public class TemplateServiceImpl
extends ServiceImpl
implements TemplateService {
    public TemplateServiceImpl(HttpConnection connection, String path) {
        super(connection, path);
    }

    @Override
    public TemplateService.ExportRequest export() {
        return new ExportRequestImpl();
    }

    @Override
    public TemplateService.GetRequest get() {
        return new GetRequestImpl();
    }

    @Override
    public TemplateService.RemoveRequest remove() {
        return new RemoveRequestImpl();
    }

    @Override
    public TemplateService.ExportToExportDomainRequest exportToExportDomain() {
        return new ExportToExportDomainRequestImpl();
    }

    @Override
    public TemplateService.ExportToPathOnHostRequest exportToPathOnHost() {
        return new ExportToPathOnHostRequestImpl();
    }

    @Override
    public TemplateService.UpdateRequest update() {
        return new UpdateRequestImpl();
    }

    @Override
    public TemplateCdromsService cdromsService() {
        return new TemplateCdromsServiceImpl(this.getConnection(), this.getPath() + "/cdroms");
    }

    @Override
    public TemplateDiskAttachmentsService diskAttachmentsService() {
        return new TemplateDiskAttachmentsServiceImpl(this.getConnection(), this.getPath() + "/diskattachments");
    }

    @Override
    public TemplateGraphicsConsolesService graphicsConsolesService() {
        return new TemplateGraphicsConsolesServiceImpl(this.getConnection(), this.getPath() + "/graphicsconsoles");
    }

    @Override
    public TemplateNicsService nicsService() {
        return new TemplateNicsServiceImpl(this.getConnection(), this.getPath() + "/nics");
    }

    @Override
    public AssignedPermissionsService permissionsService() {
        return new AssignedPermissionsServiceImpl(this.getConnection(), this.getPath() + "/permissions");
    }

    @Override
    public AssignedTagsService tagsService() {
        return new AssignedTagsServiceImpl(this.getConnection(), this.getPath() + "/tags");
    }

    @Override
    public TemplateWatchdogsService watchdogsService() {
        return new TemplateWatchdogsServiceImpl(this.getConnection(), this.getPath() + "/watchdogs");
    }

    @Override
    public Service service(String path) {
        if (path == null) {
            return this;
        }
        if (path.equals("cdroms")) {
            return this.cdromsService();
        }
        if (path.startsWith("cdroms/")) {
            return this.cdromsService().service(path.substring(7));
        }
        if (path.equals("diskattachments")) {
            return this.diskAttachmentsService();
        }
        if (path.startsWith("diskattachments/")) {
            return this.diskAttachmentsService().service(path.substring(16));
        }
        if (path.equals("graphicsconsoles")) {
            return this.graphicsConsolesService();
        }
        if (path.startsWith("graphicsconsoles/")) {
            return this.graphicsConsolesService().service(path.substring(17));
        }
        if (path.equals("nics")) {
            return this.nicsService();
        }
        if (path.startsWith("nics/")) {
            return this.nicsService().service(path.substring(5));
        }
        if (path.equals("permissions")) {
            return this.permissionsService();
        }
        if (path.startsWith("permissions/")) {
            return this.permissionsService().service(path.substring(12));
        }
        if (path.equals("tags")) {
            return this.tagsService();
        }
        if (path.startsWith("tags/")) {
            return this.tagsService().service(path.substring(5));
        }
        if (path.equals("watchdogs")) {
            return this.watchdogsService();
        }
        if (path.startsWith("watchdogs/")) {
            return this.watchdogsService().service(path.substring(10));
        }
        throw new Error("The path " + path + " doesn't correspond to any service");
    }

    public String toString() {
        return "TemplateService:" + this.getPath();
    }

    private class UpdateResponseImpl
    implements TemplateService.UpdateResponse {
        private Template template;

        private UpdateResponseImpl() {
        }

        public void template(Template template) {
            this.template = template;
        }

        @Override
        public Template template() {
            return this.template;
        }
    }

    private class UpdateRequestImpl
    extends BaseRequest<TemplateService.UpdateRequest, TemplateService.UpdateResponse>
    implements TemplateService.UpdateRequest {
        private Boolean async;
        private Template template;

        private UpdateRequestImpl() {
        }

        @Override
        public TemplateService.UpdateRequest async(Boolean async) {
            this.async = async;
            return this;
        }

        @Override
        public TemplateService.UpdateRequest template(Template template) {
            this.template = template;
            return this;
        }

        @Override
        public TemplateService.UpdateRequest template(TemplateBuilder template) {
            this.template = template.build();
            return this;
        }

        @Override
        public TemplateService.UpdateResponse send() {
            HttpResponse response;
            HttpPut request = null;
            try {
                URIBuilder uriBuilder = new URIBuilder(TemplateServiceImpl.this.getConnection().getUrl() + TemplateServiceImpl.this.getPath());
                if (this.async != null) {
                    uriBuilder.addParameter("async", XmlWriter.renderBoolean(this.async));
                }
                if (this.query != null) {
                    for (Map.Entry queryParam : this.query.entrySet()) {
                        uriBuilder.addParameter((String)queryParam.getKey(), (String)queryParam.getValue());
                    }
                }
                request = new HttpPut(uriBuilder.build());
            }
            catch (URISyntaxException ex) {
                throw new Error("Failed to build URL", ex);
            }
            try (ByteArrayOutputStream output = new ByteArrayOutputStream();
                 XmlWriter xmlWriter = new XmlWriter(output, true);){
                XmlTemplateWriter.writeOne(this.template, xmlWriter);
                xmlWriter.flush();
                request.setEntity((HttpEntity)new ByteArrayEntity(output.toByteArray()));
            }
            catch (IOException ex) {
                throw new Error("Failed to parse response", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            if ((response = TemplateServiceImpl.this.getConnection().send((HttpUriRequest)request)).getStatusLine().getStatusCode() == 200) {
                try {
                    XmlReader reader = new XmlReader(response.getEntity().getContent());
                    try {
                        UpdateResponseImpl actionResponse = new UpdateResponseImpl();
                        actionResponse.template(XmlTemplateReader.readOne(reader));
                        UpdateResponseImpl updateResponseImpl = actionResponse;
                        reader.close();
                        return updateResponseImpl;
                    }
                    catch (Throwable throwable) {
                        try {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        catch (IOException ex) {
                            throw new Error("Failed to read response", ex);
                        }
                    }
                }
                finally {
                    EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                }
            }
            TemplateServiceImpl.this.checkFault(response);
            return new UpdateResponseImpl();
        }
    }

    private class ExportToPathOnHostResponseImpl
    implements TemplateService.ExportToPathOnHostResponse {
        private ExportToPathOnHostResponseImpl() {
        }
    }

    private class ExportToPathOnHostRequestImpl
    extends BaseRequest<TemplateService.ExportToPathOnHostRequest, TemplateService.ExportToPathOnHostResponse>
    implements TemplateService.ExportToPathOnHostRequest {
        private String directory;
        private Boolean exclusive;
        private String filename;
        private Host host;
        private StorageDomain storageDomain;

        private ExportToPathOnHostRequestImpl() {
        }

        @Override
        public TemplateService.ExportToPathOnHostRequest directory(String directory) {
            this.directory = directory;
            return this;
        }

        @Override
        public TemplateService.ExportToPathOnHostRequest exclusive(Boolean exclusive) {
            this.exclusive = exclusive;
            return this;
        }

        @Override
        public TemplateService.ExportToPathOnHostRequest filename(String filename) {
            this.filename = filename;
            return this;
        }

        @Override
        public TemplateService.ExportToPathOnHostRequest host(Host host) {
            this.host = host;
            return this;
        }

        @Override
        public TemplateService.ExportToPathOnHostRequest host(HostBuilder host) {
            this.host = host.build();
            return this;
        }

        @Override
        public TemplateService.ExportToPathOnHostRequest storageDomain(StorageDomain storageDomain) {
            this.storageDomain = storageDomain;
            return this;
        }

        @Override
        public TemplateService.ExportToPathOnHostRequest storageDomain(StorageDomainBuilder storageDomain) {
            this.storageDomain = storageDomain.build();
            return this;
        }

        @Override
        public TemplateService.ExportToPathOnHostResponse send() {
            HttpPost request = new HttpPost(TemplateServiceImpl.this.getConnection().getUrl() + TemplateServiceImpl.this.getPath() + "/export");
            try (ByteArrayOutputStream output = new ByteArrayOutputStream();
                 XmlWriter xmlWriter = new XmlWriter(output, true);){
                ActionBuilder action = new ActionBuilder();
                action.directory(this.directory);
                action.exclusive(this.exclusive);
                action.filename(this.filename);
                action.host(this.host);
                action.storageDomain(this.storageDomain);
                XmlActionWriter.writeOne(action.build(), xmlWriter);
                xmlWriter.flush();
                request.setEntity((HttpEntity)new ByteArrayEntity(output.toByteArray()));
            }
            catch (IOException ex) {
                throw new Error("Failed to write request", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            HttpResponse response = TemplateServiceImpl.this.getConnection().send((HttpUriRequest)request);
            Action action = TemplateServiceImpl.this.checkAction(response);
            EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
            return new ExportToPathOnHostResponseImpl();
        }
    }

    private class ExportToExportDomainResponseImpl
    implements TemplateService.ExportToExportDomainResponse {
        private ExportToExportDomainResponseImpl() {
        }
    }

    private class ExportToExportDomainRequestImpl
    extends BaseRequest<TemplateService.ExportToExportDomainRequest, TemplateService.ExportToExportDomainResponse>
    implements TemplateService.ExportToExportDomainRequest {
        private Boolean exclusive;
        private StorageDomain storageDomain;

        private ExportToExportDomainRequestImpl() {
        }

        @Override
        public TemplateService.ExportToExportDomainRequest exclusive(Boolean exclusive) {
            this.exclusive = exclusive;
            return this;
        }

        @Override
        public TemplateService.ExportToExportDomainRequest storageDomain(StorageDomain storageDomain) {
            this.storageDomain = storageDomain;
            return this;
        }

        @Override
        public TemplateService.ExportToExportDomainRequest storageDomain(StorageDomainBuilder storageDomain) {
            this.storageDomain = storageDomain.build();
            return this;
        }

        @Override
        public TemplateService.ExportToExportDomainResponse send() {
            HttpPost request = new HttpPost(TemplateServiceImpl.this.getConnection().getUrl() + TemplateServiceImpl.this.getPath() + "/export");
            try (ByteArrayOutputStream output = new ByteArrayOutputStream();
                 XmlWriter xmlWriter = new XmlWriter(output, true);){
                ActionBuilder action = new ActionBuilder();
                action.exclusive(this.exclusive);
                action.storageDomain(this.storageDomain);
                XmlActionWriter.writeOne(action.build(), xmlWriter);
                xmlWriter.flush();
                request.setEntity((HttpEntity)new ByteArrayEntity(output.toByteArray()));
            }
            catch (IOException ex) {
                throw new Error("Failed to write request", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            HttpResponse response = TemplateServiceImpl.this.getConnection().send((HttpUriRequest)request);
            Action action = TemplateServiceImpl.this.checkAction(response);
            EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
            return new ExportToExportDomainResponseImpl();
        }
    }

    private class RemoveResponseImpl
    implements TemplateService.RemoveResponse {
        private RemoveResponseImpl() {
        }
    }

    private class RemoveRequestImpl
    extends BaseRequest<TemplateService.RemoveRequest, TemplateService.RemoveResponse>
    implements TemplateService.RemoveRequest {
        private Boolean async;

        private RemoveRequestImpl() {
        }

        @Override
        public TemplateService.RemoveRequest async(Boolean async) {
            this.async = async;
            return this;
        }

        @Override
        public TemplateService.RemoveResponse send() {
            HttpResponse response;
            HttpDelete request = null;
            try {
                URIBuilder uriBuilder = new URIBuilder(TemplateServiceImpl.this.getConnection().getUrl() + TemplateServiceImpl.this.getPath());
                if (this.async != null) {
                    uriBuilder.addParameter("async", XmlWriter.renderBoolean(this.async));
                }
                if (this.query != null) {
                    for (Map.Entry queryParam : this.query.entrySet()) {
                        uriBuilder.addParameter((String)queryParam.getKey(), (String)queryParam.getValue());
                    }
                }
                request = new HttpDelete(uriBuilder.build());
            }
            catch (URISyntaxException ex) {
                throw new Error("Failed to build URL", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            if ((response = TemplateServiceImpl.this.getConnection().send((HttpUriRequest)request)).getStatusLine().getStatusCode() == 200) {
                EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                return new RemoveResponseImpl();
            }
            TemplateServiceImpl.this.checkFault(response);
            return new RemoveResponseImpl();
        }
    }

    private class GetResponseImpl
    implements TemplateService.GetResponse {
        private Template template;

        private GetResponseImpl() {
        }

        public void template(Template template) {
            this.template = template;
        }

        @Override
        public Template template() {
            return this.template;
        }
    }

    private class GetRequestImpl
    extends BaseRequest<TemplateService.GetRequest, TemplateService.GetResponse>
    implements TemplateService.GetRequest {
        private Boolean filter;
        private String follow;

        private GetRequestImpl() {
        }

        @Override
        public TemplateService.GetRequest filter(Boolean filter) {
            this.filter = filter;
            return this;
        }

        @Override
        public TemplateService.GetRequest follow(String follow) {
            this.follow = follow;
            return this;
        }

        @Override
        public TemplateService.GetResponse send() {
            HttpResponse response;
            HttpGet request = null;
            try {
                URIBuilder uriBuilder = new URIBuilder(TemplateServiceImpl.this.getConnection().getUrl() + TemplateServiceImpl.this.getPath());
                if (this.filter != null) {
                    uriBuilder.addParameter("filter", XmlWriter.renderBoolean(this.filter));
                }
                if (this.follow != null) {
                    uriBuilder.addParameter("follow", XmlWriter.renderString(this.follow));
                }
                if (this.query != null) {
                    for (Map.Entry queryParam : this.query.entrySet()) {
                        uriBuilder.addParameter((String)queryParam.getKey(), (String)queryParam.getValue());
                    }
                }
                request = new HttpGet(uriBuilder.build());
            }
            catch (URISyntaxException ex) {
                throw new Error("Failed to build URL", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            if ((response = TemplateServiceImpl.this.getConnection().send((HttpUriRequest)request)).getStatusLine().getStatusCode() == 200) {
                try {
                    XmlReader reader = new XmlReader(response.getEntity().getContent());
                    try {
                        GetResponseImpl actionResponse = new GetResponseImpl();
                        actionResponse.template(XmlTemplateReader.readOne(reader));
                        GetResponseImpl getResponseImpl = actionResponse;
                        reader.close();
                        return getResponseImpl;
                    }
                    catch (Throwable throwable) {
                        try {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        catch (IOException ex) {
                            throw new Error("Failed to read response", ex);
                        }
                    }
                }
                finally {
                    EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                }
            }
            TemplateServiceImpl.this.checkFault(response);
            return new GetResponseImpl();
        }
    }

    private class ExportResponseImpl
    implements TemplateService.ExportResponse {
        private ExportResponseImpl() {
        }
    }

    private class ExportRequestImpl
    extends BaseRequest<TemplateService.ExportRequest, TemplateService.ExportResponse>
    implements TemplateService.ExportRequest {
        private Boolean exclusive;
        private StorageDomain storageDomain;

        private ExportRequestImpl() {
        }

        @Override
        public TemplateService.ExportRequest exclusive(Boolean exclusive) {
            this.exclusive = exclusive;
            return this;
        }

        @Override
        public TemplateService.ExportRequest storageDomain(StorageDomain storageDomain) {
            this.storageDomain = storageDomain;
            return this;
        }

        @Override
        public TemplateService.ExportRequest storageDomain(StorageDomainBuilder storageDomain) {
            this.storageDomain = storageDomain.build();
            return this;
        }

        @Override
        public TemplateService.ExportResponse send() {
            HttpPost request = new HttpPost(TemplateServiceImpl.this.getConnection().getUrl() + TemplateServiceImpl.this.getPath() + "/export");
            try (ByteArrayOutputStream output = new ByteArrayOutputStream();
                 XmlWriter xmlWriter = new XmlWriter(output, true);){
                ActionBuilder action = new ActionBuilder();
                action.exclusive(this.exclusive);
                action.storageDomain(this.storageDomain);
                XmlActionWriter.writeOne(action.build(), xmlWriter);
                xmlWriter.flush();
                request.setEntity((HttpEntity)new ByteArrayEntity(output.toByteArray()));
            }
            catch (IOException ex) {
                throw new Error("Failed to write request", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            HttpResponse response = TemplateServiceImpl.this.getConnection().send((HttpUriRequest)request);
            Action action = TemplateServiceImpl.this.checkAction(response);
            EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
            return new ExportResponseImpl();
        }
    }
}

