/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.internal.services;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.util.EntityUtils;
import org.ovirt.api.metamodel.runtime.xml.XmlReader;
import org.ovirt.api.metamodel.runtime.xml.XmlWriter;
import org.ovirt.engine.sdk4.BaseRequest;
import org.ovirt.engine.sdk4.Error;
import org.ovirt.engine.sdk4.Service;
import org.ovirt.engine.sdk4.builders.ImageTransferBuilder;
import org.ovirt.engine.sdk4.internal.HttpConnection;
import org.ovirt.engine.sdk4.internal.services.ImageTransferServiceImpl;
import org.ovirt.engine.sdk4.internal.services.ServiceImpl;
import org.ovirt.engine.sdk4.internal.xml.XmlImageTransferReader;
import org.ovirt.engine.sdk4.internal.xml.XmlImageTransferWriter;
import org.ovirt.engine.sdk4.services.ImageTransferService;
import org.ovirt.engine.sdk4.services.ImageTransfersService;
import org.ovirt.engine.sdk4.types.ImageTransfer;

public class ImageTransfersServiceImpl
extends ServiceImpl
implements ImageTransfersService {
    public ImageTransfersServiceImpl(HttpConnection connection, String path) {
        super(connection, path);
    }

    @Override
    public ImageTransfersService.AddRequest add() {
        return new AddRequestImpl();
    }

    @Override
    public ImageTransfersService.AddForDiskRequest addForDisk() {
        return new AddForDiskRequestImpl();
    }

    @Override
    public ImageTransfersService.AddForImageRequest addForImage() {
        return new AddForImageRequestImpl();
    }

    @Override
    public ImageTransfersService.AddForSnapshotRequest addForSnapshot() {
        return new AddForSnapshotRequestImpl();
    }

    @Override
    public ImageTransfersService.ListRequest list() {
        return new ListRequestImpl();
    }

    @Override
    public ImageTransferService imageTransferService(String id) {
        return new ImageTransferServiceImpl(this.getConnection(), this.getPath() + "/" + id);
    }

    @Override
    public Service service(String path) {
        if (path == null) {
            return this;
        }
        int index = path.indexOf(47);
        if (index == -1) {
            return this.imageTransferService(path);
        }
        return this.imageTransferService(path.substring(0, index)).service(path.substring(index + 1));
    }

    public String toString() {
        return "ImageTransfersService:" + this.getPath();
    }

    private class ListResponseImpl
    implements ImageTransfersService.ListResponse {
        private List<ImageTransfer> imageTransfer;

        private ListResponseImpl() {
        }

        public void imageTransfer(List<ImageTransfer> imageTransfer) {
            this.imageTransfer = imageTransfer;
        }

        @Override
        public List<ImageTransfer> imageTransfer() {
            return this.imageTransfer;
        }
    }

    private class ListRequestImpl
    extends BaseRequest<ImageTransfersService.ListRequest, ImageTransfersService.ListResponse>
    implements ImageTransfersService.ListRequest {
        private String follow;

        private ListRequestImpl() {
        }

        @Override
        public ImageTransfersService.ListRequest follow(String follow) {
            this.follow = follow;
            return this;
        }

        @Override
        public ImageTransfersService.ListResponse send() {
            HttpResponse response;
            HttpGet request = null;
            try {
                URIBuilder uriBuilder = new URIBuilder(ImageTransfersServiceImpl.this.getConnection().getUrl() + ImageTransfersServiceImpl.this.getPath());
                if (this.follow != null) {
                    uriBuilder.addParameter("follow", XmlWriter.renderString(this.follow));
                }
                if (this.query != null) {
                    for (Map.Entry queryParam : this.query.entrySet()) {
                        uriBuilder.addParameter((String)queryParam.getKey(), (String)queryParam.getValue());
                    }
                }
                request = new HttpGet(uriBuilder.build());
            }
            catch (URISyntaxException ex) {
                throw new Error("Failed to build URL", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            if ((response = ImageTransfersServiceImpl.this.getConnection().send((HttpUriRequest)request)).getStatusLine().getStatusCode() == 200) {
                try {
                    XmlReader reader = new XmlReader(response.getEntity().getContent());
                    try {
                        ListResponseImpl actionResponse = new ListResponseImpl();
                        actionResponse.imageTransfer(XmlImageTransferReader.readMany(reader));
                        ListResponseImpl listResponseImpl = actionResponse;
                        reader.close();
                        return listResponseImpl;
                    }
                    catch (Throwable throwable) {
                        try {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        catch (IOException ex) {
                            throw new Error("Failed to read response", ex);
                        }
                    }
                }
                finally {
                    EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                }
            }
            ImageTransfersServiceImpl.this.checkFault(response);
            return new ListResponseImpl();
        }
    }

    private class AddForSnapshotResponseImpl
    implements ImageTransfersService.AddForSnapshotResponse {
        private ImageTransfer imageTransfer;

        private AddForSnapshotResponseImpl() {
        }

        public void imageTransfer(ImageTransfer imageTransfer) {
            this.imageTransfer = imageTransfer;
        }

        @Override
        public ImageTransfer imageTransfer() {
            return this.imageTransfer;
        }
    }

    private class AddForSnapshotRequestImpl
    extends BaseRequest<ImageTransfersService.AddForSnapshotRequest, ImageTransfersService.AddForSnapshotResponse>
    implements ImageTransfersService.AddForSnapshotRequest {
        private ImageTransfer imageTransfer;

        private AddForSnapshotRequestImpl() {
        }

        @Override
        public ImageTransfersService.AddForSnapshotRequest imageTransfer(ImageTransfer imageTransfer) {
            this.imageTransfer = imageTransfer;
            return this;
        }

        @Override
        public ImageTransfersService.AddForSnapshotRequest imageTransfer(ImageTransferBuilder imageTransfer) {
            this.imageTransfer = imageTransfer.build();
            return this;
        }

        @Override
        public ImageTransfersService.AddForSnapshotResponse send() {
            HttpResponse response;
            HttpPost request = null;
            try {
                URIBuilder uriBuilder = new URIBuilder(ImageTransfersServiceImpl.this.getConnection().getUrl() + ImageTransfersServiceImpl.this.getPath());
                if (this.query != null) {
                    for (Map.Entry queryParam : this.query.entrySet()) {
                        uriBuilder.addParameter((String)queryParam.getKey(), (String)queryParam.getValue());
                    }
                }
                request = new HttpPost(uriBuilder.build());
            }
            catch (URISyntaxException ex) {
                throw new Error("Failed to build URL", ex);
            }
            try (ByteArrayOutputStream output = new ByteArrayOutputStream();
                 XmlWriter xmlWriter = new XmlWriter(output, true);){
                XmlImageTransferWriter.writeOne(this.imageTransfer, xmlWriter);
                xmlWriter.flush();
                request.setEntity((HttpEntity)new ByteArrayEntity(output.toByteArray()));
            }
            catch (IOException ex) {
                throw new Error("Failed to parse response", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            if ((response = ImageTransfersServiceImpl.this.getConnection().send((HttpUriRequest)request)).getStatusLine().getStatusCode() == 200 || response.getStatusLine().getStatusCode() == 201 || response.getStatusLine().getStatusCode() == 202) {
                try {
                    XmlReader reader = new XmlReader(response.getEntity().getContent());
                    try {
                        AddForSnapshotResponseImpl actionResponse = new AddForSnapshotResponseImpl();
                        actionResponse.imageTransfer(XmlImageTransferReader.readOne(reader));
                        AddForSnapshotResponseImpl addForSnapshotResponseImpl = actionResponse;
                        reader.close();
                        return addForSnapshotResponseImpl;
                    }
                    catch (Throwable throwable) {
                        try {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        catch (IOException ex) {
                            throw new Error("Failed to read response", ex);
                        }
                    }
                }
                finally {
                    EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                }
            }
            ImageTransfersServiceImpl.this.checkFault(response);
            return new AddForSnapshotResponseImpl();
        }
    }

    private class AddForImageResponseImpl
    implements ImageTransfersService.AddForImageResponse {
        private ImageTransfer imageTransfer;

        private AddForImageResponseImpl() {
        }

        public void imageTransfer(ImageTransfer imageTransfer) {
            this.imageTransfer = imageTransfer;
        }

        @Override
        public ImageTransfer imageTransfer() {
            return this.imageTransfer;
        }
    }

    private class AddForImageRequestImpl
    extends BaseRequest<ImageTransfersService.AddForImageRequest, ImageTransfersService.AddForImageResponse>
    implements ImageTransfersService.AddForImageRequest {
        private ImageTransfer imageTransfer;

        private AddForImageRequestImpl() {
        }

        @Override
        public ImageTransfersService.AddForImageRequest imageTransfer(ImageTransfer imageTransfer) {
            this.imageTransfer = imageTransfer;
            return this;
        }

        @Override
        public ImageTransfersService.AddForImageRequest imageTransfer(ImageTransferBuilder imageTransfer) {
            this.imageTransfer = imageTransfer.build();
            return this;
        }

        @Override
        public ImageTransfersService.AddForImageResponse send() {
            HttpResponse response;
            HttpPost request = null;
            try {
                URIBuilder uriBuilder = new URIBuilder(ImageTransfersServiceImpl.this.getConnection().getUrl() + ImageTransfersServiceImpl.this.getPath());
                if (this.query != null) {
                    for (Map.Entry queryParam : this.query.entrySet()) {
                        uriBuilder.addParameter((String)queryParam.getKey(), (String)queryParam.getValue());
                    }
                }
                request = new HttpPost(uriBuilder.build());
            }
            catch (URISyntaxException ex) {
                throw new Error("Failed to build URL", ex);
            }
            try (ByteArrayOutputStream output = new ByteArrayOutputStream();
                 XmlWriter xmlWriter = new XmlWriter(output, true);){
                XmlImageTransferWriter.writeOne(this.imageTransfer, xmlWriter);
                xmlWriter.flush();
                request.setEntity((HttpEntity)new ByteArrayEntity(output.toByteArray()));
            }
            catch (IOException ex) {
                throw new Error("Failed to parse response", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            if ((response = ImageTransfersServiceImpl.this.getConnection().send((HttpUriRequest)request)).getStatusLine().getStatusCode() == 200 || response.getStatusLine().getStatusCode() == 201 || response.getStatusLine().getStatusCode() == 202) {
                try {
                    XmlReader reader = new XmlReader(response.getEntity().getContent());
                    try {
                        AddForImageResponseImpl actionResponse = new AddForImageResponseImpl();
                        actionResponse.imageTransfer(XmlImageTransferReader.readOne(reader));
                        AddForImageResponseImpl addForImageResponseImpl = actionResponse;
                        reader.close();
                        return addForImageResponseImpl;
                    }
                    catch (Throwable throwable) {
                        try {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        catch (IOException ex) {
                            throw new Error("Failed to read response", ex);
                        }
                    }
                }
                finally {
                    EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                }
            }
            ImageTransfersServiceImpl.this.checkFault(response);
            return new AddForImageResponseImpl();
        }
    }

    private class AddForDiskResponseImpl
    implements ImageTransfersService.AddForDiskResponse {
        private ImageTransfer imageTransfer;

        private AddForDiskResponseImpl() {
        }

        public void imageTransfer(ImageTransfer imageTransfer) {
            this.imageTransfer = imageTransfer;
        }

        @Override
        public ImageTransfer imageTransfer() {
            return this.imageTransfer;
        }
    }

    private class AddForDiskRequestImpl
    extends BaseRequest<ImageTransfersService.AddForDiskRequest, ImageTransfersService.AddForDiskResponse>
    implements ImageTransfersService.AddForDiskRequest {
        private ImageTransfer imageTransfer;

        private AddForDiskRequestImpl() {
        }

        @Override
        public ImageTransfersService.AddForDiskRequest imageTransfer(ImageTransfer imageTransfer) {
            this.imageTransfer = imageTransfer;
            return this;
        }

        @Override
        public ImageTransfersService.AddForDiskRequest imageTransfer(ImageTransferBuilder imageTransfer) {
            this.imageTransfer = imageTransfer.build();
            return this;
        }

        @Override
        public ImageTransfersService.AddForDiskResponse send() {
            HttpResponse response;
            HttpPost request = null;
            try {
                URIBuilder uriBuilder = new URIBuilder(ImageTransfersServiceImpl.this.getConnection().getUrl() + ImageTransfersServiceImpl.this.getPath());
                if (this.query != null) {
                    for (Map.Entry queryParam : this.query.entrySet()) {
                        uriBuilder.addParameter((String)queryParam.getKey(), (String)queryParam.getValue());
                    }
                }
                request = new HttpPost(uriBuilder.build());
            }
            catch (URISyntaxException ex) {
                throw new Error("Failed to build URL", ex);
            }
            try (ByteArrayOutputStream output = new ByteArrayOutputStream();
                 XmlWriter xmlWriter = new XmlWriter(output, true);){
                XmlImageTransferWriter.writeOne(this.imageTransfer, xmlWriter);
                xmlWriter.flush();
                request.setEntity((HttpEntity)new ByteArrayEntity(output.toByteArray()));
            }
            catch (IOException ex) {
                throw new Error("Failed to parse response", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            if ((response = ImageTransfersServiceImpl.this.getConnection().send((HttpUriRequest)request)).getStatusLine().getStatusCode() == 200 || response.getStatusLine().getStatusCode() == 201 || response.getStatusLine().getStatusCode() == 202) {
                try {
                    XmlReader reader = new XmlReader(response.getEntity().getContent());
                    try {
                        AddForDiskResponseImpl actionResponse = new AddForDiskResponseImpl();
                        actionResponse.imageTransfer(XmlImageTransferReader.readOne(reader));
                        AddForDiskResponseImpl addForDiskResponseImpl = actionResponse;
                        reader.close();
                        return addForDiskResponseImpl;
                    }
                    catch (Throwable throwable) {
                        try {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        catch (IOException ex) {
                            throw new Error("Failed to read response", ex);
                        }
                    }
                }
                finally {
                    EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                }
            }
            ImageTransfersServiceImpl.this.checkFault(response);
            return new AddForDiskResponseImpl();
        }
    }

    private class AddResponseImpl
    implements ImageTransfersService.AddResponse {
        private ImageTransfer imageTransfer;

        private AddResponseImpl() {
        }

        public void imageTransfer(ImageTransfer imageTransfer) {
            this.imageTransfer = imageTransfer;
        }

        @Override
        public ImageTransfer imageTransfer() {
            return this.imageTransfer;
        }
    }

    private class AddRequestImpl
    extends BaseRequest<ImageTransfersService.AddRequest, ImageTransfersService.AddResponse>
    implements ImageTransfersService.AddRequest {
        private ImageTransfer imageTransfer;

        private AddRequestImpl() {
        }

        @Override
        public ImageTransfersService.AddRequest imageTransfer(ImageTransfer imageTransfer) {
            this.imageTransfer = imageTransfer;
            return this;
        }

        @Override
        public ImageTransfersService.AddRequest imageTransfer(ImageTransferBuilder imageTransfer) {
            this.imageTransfer = imageTransfer.build();
            return this;
        }

        @Override
        public ImageTransfersService.AddResponse send() {
            HttpResponse response;
            HttpPost request = null;
            try {
                URIBuilder uriBuilder = new URIBuilder(ImageTransfersServiceImpl.this.getConnection().getUrl() + ImageTransfersServiceImpl.this.getPath());
                if (this.query != null) {
                    for (Map.Entry queryParam : this.query.entrySet()) {
                        uriBuilder.addParameter((String)queryParam.getKey(), (String)queryParam.getValue());
                    }
                }
                request = new HttpPost(uriBuilder.build());
            }
            catch (URISyntaxException ex) {
                throw new Error("Failed to build URL", ex);
            }
            try (ByteArrayOutputStream output = new ByteArrayOutputStream();
                 XmlWriter xmlWriter = new XmlWriter(output, true);){
                XmlImageTransferWriter.writeOne(this.imageTransfer, xmlWriter);
                xmlWriter.flush();
                request.setEntity((HttpEntity)new ByteArrayEntity(output.toByteArray()));
            }
            catch (IOException ex) {
                throw new Error("Failed to parse response", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            if ((response = ImageTransfersServiceImpl.this.getConnection().send((HttpUriRequest)request)).getStatusLine().getStatusCode() == 200 || response.getStatusLine().getStatusCode() == 201 || response.getStatusLine().getStatusCode() == 202) {
                try {
                    XmlReader reader = new XmlReader(response.getEntity().getContent());
                    try {
                        AddResponseImpl actionResponse = new AddResponseImpl();
                        actionResponse.imageTransfer(XmlImageTransferReader.readOne(reader));
                        AddResponseImpl addResponseImpl = actionResponse;
                        reader.close();
                        return addResponseImpl;
                    }
                    catch (Throwable throwable) {
                        try {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        catch (IOException ex) {
                            throw new Error("Failed to read response", ex);
                        }
                    }
                }
                finally {
                    EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                }
            }
            ImageTransfersServiceImpl.this.checkFault(response);
            return new AddResponseImpl();
        }
    }
}

