/*
Copyright (c) 2015 Red Hat, Inc.
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package org.ovirt.engine.sdk4.internal.containers;

import java.lang.String;
import java.math.BigInteger;
import org.ovirt.engine.sdk4.types.Template;
import org.ovirt.engine.sdk4.types.TemplateVersion;

public class TemplateVersionContainer extends Container implements TemplateVersion {
    private String versionName;
    private BigInteger versionNumber;
    private Template baseTemplate;
    
    public String versionName() {
        return versionName;
    }
    
    public void versionName(String newVersionName) {
        versionName = newVersionName;
    }
    
    public boolean versionNamePresent() {
        return versionName != null;
    }
    
    public BigInteger versionNumber() {
        return versionNumber;
    }
    
    public Byte versionNumberAsByte() {
        return asByte("TemplateVersion", "versionNumber", versionNumber);
    }
    
    public Short versionNumberAsShort() {
        return asShort("TemplateVersion", "versionNumber", versionNumber);
    }
    
    public Integer versionNumberAsInteger() {
        return asInteger("TemplateVersion", "versionNumber", versionNumber);
    }
    
    public Long versionNumberAsLong() {
        return asLong("TemplateVersion", "versionNumber", versionNumber);
    }
    
    public void versionNumber(BigInteger newVersionNumber) {
        versionNumber = newVersionNumber;
    }
    
    public boolean versionNumberPresent() {
        return versionNumber != null;
    }
    
    public Template baseTemplate() {
        return baseTemplate;
    }
    
    public void baseTemplate(Template newBaseTemplate) {
        baseTemplate = newBaseTemplate;
    }
    
    public boolean baseTemplatePresent() {
        return baseTemplate != null;
    }
    
}
