%global rolename engine-setup
%global roleprefix ovirt.
%global roleprefix_legacy_uppercase oVirt.
%global ansible_roles_dir ansible/roles

Name: ovirt-ansible-engine-setup
Summary: Ansible role to install required packages for oVirt Engine deployment, generate answerfile and run engine-setup with it.
Version: 1.2.2
Release: 1%{?release_suffix}%{?dist}
Source0: http://resources.ovirt.org/pub/src/ovirt-ansible-engine-setup/ovirt-ansible-engine-setup-1.2.2.tar.gz
License: ASL 2.0
Group:          Virtualization/Management
BuildArch:      noarch
Url:            http://www.ovirt.org

Requires: ansible >= 2.9.0

%description
This Ansible role installs required packages for oVirt Engine deployment,
generates answerfile and runs engine-setup with it.

%pretrans -p <lua>
-- Remove the legacy directory before installing the symlink. This is known issue in RPM:
-- https://fedoraproject.org/wiki/Packaging:Directory_Replacement
path_uppercase = "%{_datadir}/%{ansible_roles_dir}/%{roleprefix_legacy_uppercase}%{rolename}"

st = posix.stat(path_uppercase)
if st and st.type == "directory" then
  os.execute('rm -rf "'..path_uppercase..'"')
end

%prep
%setup -c -q

%build

%install
export PKG_DATA_DIR_ORIG=%{_datadir}/%{ansible_roles_dir}/%{roleprefix}%{rolename}
export PKG_DATA_DIR=%{buildroot}$PKG_DATA_DIR_ORIG
export PKG_DOC_DIR=%{buildroot}%{_pkgdocdir}
export ROLENAME_LEGACY_UPPERCASE=%{buildroot}%{_datadir}/%{ansible_roles_dir}/%{roleprefix_legacy_uppercase}%{rolename}
sh build.sh install

%files
%{_datadir}/%{ansible_roles_dir}/%{roleprefix}%{rolename}
%{_datadir}/%{ansible_roles_dir}/%{roleprefix_legacy_uppercase}%{rolename}

%doc README.md
%doc examples/

%license LICENSE

%changelog
* Tue Mar 3 2020 Martin Necas <mnecas@redhat.com> - 1.2.2-1
- Add apache config.

* Mon Dec 2 2019 Martin Necas <mnecas@redhat.com> - 1.2.1-1
- Add build for el8.

* Mon Nov 25 2019 Martin Necas <mnecas@redhat.com> - 1.2.0-1
- Bump ansible to version 2.9.0.

* Tue Mar 12 2019 Ondra Machacek <omachace@redhat.com> - 1.1.9-1
- Avoid warnings on ansible 2.8.
- Added new answer for cinderlib.
- Change answer to yes in answerfile.

* Fri Feb 22 2019 Ondra Machacek <omachace@redhat.com> - 1.1.8-1
- Get ready for delegate_to.
- Add wait_running_tasks option for upgrade.

* Wed Jan 16 2019 Ondra Machacek <omachace@redhat.com> - 1.1.7-1
- Add option to perform upgrade.

* Fri Nov 30 2018 Ondra Machacek <omachace@redhat.com> - 1.1.6-1
- Require Ansible 2.7.2.
- Support ovirt.engine-setup name.
- update_only has an effect only if state is latest.
- Fix command for update ovirt*setup*.
- Add answerfiles for 4.3.

* Thu Oct 04 2018 Ondra Machacek <omachace@redhat.com> - 1.1.5-1
- Add vacuum option when upgrading.

* Fri Aug 31 2018 Ondra Machacek <omachace@redhat.com> - 1.1.4-1
- Set false as default for ovirt_engine_setup_use_remote_answer_file.

* Thu Aug 30 2018 Ondra Machacek <omachace@redhat.com> - 1.1.3-1
- Add '--offline' option.
- Add answerfile-path-on-remote option.
- Require Ansible 2.5.

* Wed Apr 11 2018 Ondra Machacek <omachace@redhat.com> - 1.1.2-1
- Change ovirt_engine_setup_product_type parameter.

* Thu Apr 5 2018 Ondra Machacek <omachace@redhat.com> - 1.1.1-1
- Remove 3.6 and 4.0 from supported versions of this role.

* Thu Dec 07 2017 Katerina Koukiou <kkoukiou@redhat.com> - 1.1.0-1
- Initial release
