/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk.decorators;

import java.io.IOException;
import java.util.List;
import java.util.UUID;
import org.apache.http.Header;
import org.apache.http.client.ClientProtocolException;
import org.ovirt.engine.sdk.common.CollectionDecorator;
import org.ovirt.engine.sdk.decorators.Cluster;
import org.ovirt.engine.sdk.decorators.ClusterGlusterHook;
import org.ovirt.engine.sdk.entities.GlusterHook;
import org.ovirt.engine.sdk.entities.GlusterHooks;
import org.ovirt.engine.sdk.exceptions.ServerException;
import org.ovirt.engine.sdk.utils.HttpHeaderBuilder;
import org.ovirt.engine.sdk.utils.UrlBuilder;
import org.ovirt.engine.sdk.web.HttpProxyBroker;
import org.ovirt.engine.sdk.web.UrlParameterType;

public class ClusterGlusterHooks
extends CollectionDecorator<GlusterHook, GlusterHooks, ClusterGlusterHook> {
    private Cluster parent;

    public ClusterGlusterHooks(HttpProxyBroker proxy, Cluster parent) {
        super(proxy, "glusterhooks");
        this.parent = parent;
    }

    @Override
    public List<ClusterGlusterHook> list() throws ClientProtocolException, ServerException, IOException {
        String url = this.parent.getHref() + "/" + this.getName();
        return this.list(url, GlusterHooks.class, ClusterGlusterHook.class);
    }

    @Override
    public ClusterGlusterHook get(UUID id) throws ClientProtocolException, ServerException, IOException {
        String url = this.parent.getHref() + "/" + this.getName() + "/" + id.toString();
        return this.getProxy().get(url, GlusterHook.class, ClusterGlusterHook.class);
    }

    @Override
    public ClusterGlusterHook getById(String id) throws ClientProtocolException, ServerException, IOException {
        String url = this.parent.getHref() + "/" + this.getName() + "/" + id;
        return this.getProxy().get(url, GlusterHook.class, ClusterGlusterHook.class);
    }

    public List<ClusterGlusterHook> list(Integer max) throws ClientProtocolException, ServerException, IOException {
        HttpHeaderBuilder headersBuilder = new HttpHeaderBuilder();
        List<Header> headers = headersBuilder.build();
        UrlBuilder urlBuilder = new UrlBuilder(this.parent.getHref() + "/" + this.getName());
        if (max != null) {
            urlBuilder.add("max", max, UrlParameterType.MATRIX);
        }
        String url = urlBuilder.build();
        return this.list(url, GlusterHooks.class, ClusterGlusterHook.class, headers);
    }
}

