/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk.web;

import java.util.concurrent.TimeUnit;
import org.apache.http.conn.ClientConnectionManager;

public class IdleConnectionMonitorThread
extends Thread {
    private final ClientConnectionManager connMgr;
    private volatile boolean shutdown;
    long waitTtl;
    long closeTtl;

    public IdleConnectionMonitorThread(ClientConnectionManager connMgr, long waitTtl, long closeTtl) {
        this.connMgr = connMgr;
        this.waitTtl = waitTtl;
        this.closeTtl = closeTtl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        try {
            while (!this.shutdown) {
                IdleConnectionMonitorThread idleConnectionMonitorThread = this;
                synchronized (idleConnectionMonitorThread) {
                    this.wait(this.waitTtl);
                    this.connMgr.closeExpiredConnections();
                    this.connMgr.closeIdleConnections(this.closeTtl, TimeUnit.SECONDS);
                }
            }
            return;
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        this.shutdown = true;
        IdleConnectionMonitorThread idleConnectionMonitorThread = this;
        synchronized (idleConnectionMonitorThread) {
            this.notifyAll();
        }
    }
}

