/*
 * Copyright oVirt Authors
 * SPDX-License-Identifier: Apache-2.0
*/

package org.ovirt.engine.api.v3.servers;

import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

import org.ovirt.engine.api.resource.InstanceTypesResource;
import org.ovirt.engine.api.v3.V3Server;
import org.ovirt.engine.api.v3.types.V3InstanceType;
import org.ovirt.engine.api.v3.types.V3InstanceTypes;

@Produces({"application/xml", "application/json"})
public class V3InstanceTypesServer extends V3Server<InstanceTypesResource> {
    public V3InstanceTypesServer(InstanceTypesResource delegate) {
        super(delegate);
    }

    @POST
    @Consumes({"application/xml", "application/json"})
    public Response add(V3InstanceType instanceType) {
        return adaptAdd(getDelegate()::add, instanceType);
    }

    @GET
    public V3InstanceTypes list() {
        return adaptList(getDelegate()::list);
    }

    @Path("{id}")
    public V3InstanceTypeServer getInstanceTypeResource(@PathParam("id") String id) {
        return new V3InstanceTypeServer(getDelegate().getInstanceTypeResource(id));
    }
}
