Name:      ovirt-imageio
Version:   2.1.0
Release:   1%{?dist}
Summary:   oVirt imageio

License:   GPLv2+
Url:       https://gerrit.ovirt.org/%{name}
Source0:   http://resources.ovirt.org/pub/ovirt-master-snapshot/src/%{name}/%{name}-%{version}.tar.gz

%global ovirtimg_user ovirtimg
%global srcname ovirt_imageio
%global logdir %{_localstatedir}/log/%{name}
%global admin_confdir %{_sysconfdir}/%{name}
%global vendor_confdir %{_prefix}/lib/%{name}

%description
Image data transfer on oVirt virtualization hosts.

%prep
%setup -q

%build
%py3_build

%install
%py3_install
install -D -m 0755 --directory %{buildroot}%{logdir}
# Create a dummy log file to make rpm happy during build
touch %{buildroot}%{logdir}/daemon.log
install -D -m 0755 --directory %{buildroot}%{vendor_confdir}/conf.d
install -D -m 0755 --directory %{buildroot}%{admin_confdir}/conf.d
install -D -m 0644 data/README %{buildroot}%{admin_confdir}
install -D -m 0644 data/%{name}.service %{buildroot}%{_unitdir}/%{name}.service

%clean
rm -rf $RPM_BUILD_ROOT


%package common
Summary:   oVirt imageio common resources

# NOTE: keep in sync with automation/build-artifacts.packages
BuildRequires: gcc
BuildRequires: python3-devel

# NOTE: keep in sync with automation/check.packages
Requires:  python3

%description common
Common resources used by oVirt imageio server and client

%files common
%license COPYING
%{python3_sitearch}/%{srcname}
%{python3_sitearch}/%{srcname}-*.egg-info
%exclude %{python3_sitearch}/%{srcname}/client


%package client
Summary:   oVirt imageio client library

# NOTE: keep in sync with automation/check.packages
Requires:  %{name}-common = %{version}-%{release}
Requires:  qemu-img

%description client
Python client library for accessing imageio server on oVirt hosts.

%files client
%{python3_sitearch}/%{srcname}/client


%package daemon
Summary:   oVirt imageio daemon

# NOTE: keep in sync with automation/build-artifacts.packages
BuildRequires: systemd

# NOTE: keep in sync with automation/check.packages
Requires:  %{name}-common = %{version}-%{release}
Requires:  python3-systemd

%description daemon
Daemon providing image transfer service on oVirt hosts.

%files daemon
%{_bindir}/%{name}
%{_unitdir}/%{name}.service
%dir %{admin_confdir}
%dir %{admin_confdir}/conf.d
%dir %{vendor_confdir}
%dir %{vendor_confdir}/conf.d
%{admin_confdir}/README
# The log directory should belong to the daemon so it can create log files.
# http://rpm.org/max-rpm-snapshot/s1-rpm-inside-files-list-directives.html#S3-RPM-INSIDE-FLIST-ATTR-DIRECTIVE
%dir %attr(755, %{ovirtimg_user}, %{ovirtimg_user}) %{logdir}
# The log files belongs to the package, so they will be removed with the package.
# http://rpm.org/max-rpm-snapshot/s1-rpm-inside-files-list-directives.html#S3-RPM-INSIDE-FLIST-GHOST-DIRECTIVE
%ghost %attr(644, %{ovirtimg_user}, %{ovirtimg_user}) %{logdir}/daemon.log*

# For more information about the systemd macros, see:
# https://fedoraproject.org/wiki/Packaging:Scriptlets#New_Packages
# For info on ordering of the scriplets, see:
# https://docs.fedoraproject.org/en-US/packaging-guidelines/Scriptlets/#ordering

%pre daemon
# Create a user and group if needed
if ! /usr/bin/getent passwd %{ovirtimg_user} >/dev/null; then
    /usr/sbin/useradd --system \
        --user-group \
        --shell /sbin/nologin \
        --home-dir /run/%{name} \
        --comment "oVirt imageio" \
        %{ovirtimg_user}
fi

%post daemon
# After installation, synchronize service state with preset files.
%systemd_post %{name}.service

%preun daemon
# Before uninstalling, stop and disable the service.
%systemd_preun %{name}.service

%postun daemon
# After upgrading, restart the service.
%systemd_postun_with_restart %{name}.service

%posttrans daemon
# At the end of the transaction, stop stale ovirt-imageio-daemon service.
# Needed only when upgrading from ovirt-imageio-daemon < 2.
if systemctl is-active ovirt-imageio-daemon.service >/dev/null; then
    echo "Stopping ovirt-imageio-daemon.service";
    systemctl stop ovirt-imageio-daemon.service
fi

%changelog

* Wed Oct 14 2020 Nir Soffer <nsoffer@redhat.com> 2.1.0-1
- Support upload and download snapshots #BZ1847090
- Remove python2 leftovers #BZ1862719
- Faster checkusms using zero hashing
- Report checksum configuration in client.checksum()
- Improve logging for easier debugging
- Improve client online help
- Silence output from qemu-img create
- Configurable buffer size per backend

* Wed Aug 5 2020 Nir Soffer <nsoffer@redhat.com> 2.0.10-1
- Support 3rd party certificates #BZ1862107
- Imageio low level API #BZ1855047
- Compute image checksums #BZ1787906
- Support transfer cancellation #BZ1524184
- Imporve error reporting in io.copy() #BZ1854550
- Create configuration directories

* Wed Jul 1 2020 Nir Soffer <nsoffer@redhat.com> 2.0.9-1
- Fix ipv6 regression in 2.0.8-1 #BZ1851707
- Fix preallocation on NFS 4.2 and GlusterFS #BZ1851256
- Support upload disk from ova #BZ1849981
- Report holes in zero extents

* Mon Jun 15 2020 Nir Soffer <nsoffer@redhat.com> 2.0.8-1
- Improve performance using multiple connections #BZ1591439
- Support ipv6 #BZ1805267
- Fix Cross-Site scripting vulnerabilities #BZ1757066

* Thu Jun 4 2020 Nir Soffer <nsoffer@redhat.com> 2.0.7-0
- Support showing parsed configuration #BZ1835719
- Improve performance when using small requests #BZ1836858
- Use proxy_url if transfer_url is not accessible #BZ1839400

* Wed May 13 2020 Nir Soffer <nsoffer@redhat.com> 2.0.6-0
- Introduce ovirt-imageio-client package
- Support drop-in confiugration #BZ1826679, #BZ1738729, #BZ1761960
- Make private modules private #BZ1818170
- Log detailed transfer stats #BZ1740489
- Support platform trusted CA

* Mon Apr 20 2020 Nir Soffer <nsoffer@redhat.com> 2.0.5-0
- Support closing connections for web clients

* Fri Apr 17 2020 Nir Soffer <nsoffer@redhat.com> 2.0.4-0
- Support starting as root
