# Copyright 2011-2017 Red Hat, Inc. and/or its affiliates.
#
#  Licensed under the Apache License, Version 2.0 (the "License");
#  you may not use this file except in compliance with the License.
#  You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
#  Unless required by applicable law or agreed to in writing, software
#  distributed under the License is distributed on an "AS IS" BASIS,
#  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#  See the License for the specific language governing permissions and
#  limitations under the License.

%global		package_version 4.3.0_beta
%global		package_name ovirt-iso-uploader
# Required users and groups
%global		vdsm_user vdsm
%global		vdsm_group kvm
%global _configure ../configure

%if 0%{?fedora} || 0%{?rhel} >= 8
%global with_python3 1
%else
%global with_python3 0
%endif

%if 0%{?rhel} >= 8
%global with_python2 0
%else
%global with_python2 1
%endif

Summary:	ISO Uploader for oVirt Engine
Name:		%{package_name}
Version:	4.3.0
Release:	0.1.beta%{?release_suffix}%{?dist}
License:	ASL 2.0
URL:		http://www.ovirt.org
Source0:	http://resources.ovirt.org/pub/src/%{package_name}/%{package_name}-%{package_version}.tar.gz

BuildArch:	noarch
Requires(pre):	shadow-utils
BuildRequires:	gettext


%if 0%{?with_python2}
BuildRequires:	python2-devel
Requires:		python2-%{name}
%endif

%if 0%{?with_python3}
BuildRequires:	python%{python3_pkgversion}-devel
%if 0%{!?with_python2}
Requires:		python%{python3_pkgversion}-%{name}
%endif
%endif

%description
ISO Uploader tool for oVirt Engine

%if 0%{?with_python2}
%package -n python2-%{name}
Summary:	%{summary}
%{?python_provide:%python_provide python2-%{name}}
Requires:	python
Requires:	python-ovirt-engine-sdk4 >= 4.0.0
Requires:	logrotate
Requires:	nfs-utils
Requires:	glusterfs-api

%description -n python2-%{name}
%{summary}.

%endif # with_python2

%if 0%{?with_python3}
%package -n python%{python3_pkgversion}-%{name}
Summary:	%{summary}
%{?python_provide:%python_provide python%{python3_pkgversion}-%{name}}
Requires:	python%{python3_pkgversion}
Requires:	python3-ovirt-engine-sdk4 >= 4.0.0
Requires:	logrotate
Requires:	nfs-utils
Requires:	glusterfs-api

%description -n python%{python3_pkgversion}-%{name}
%{summary}.

%endif # with_python3

%prep
%setup -q -n %{package_name}-%{package_version}
mkdir py2 py3

%build
%if 0%{?with_python2}
pushd py2
%configure PYTHON="%{__python2}" \
	--docdir="%{_docdir}/%{package_name}-%{version}" \
	--disable-python-syntax-check
make %{?_smp_mflags}
popd

%endif # with_python2

%if 0%{?with_python3}
pushd py3
%configure PYTHON="%{__python3}" \
	--docdir="%{_docdir}/%{package_name}-%{version}" \
	--disable-python-syntax-check
make %{?_smp_mflags}

popd
%endif # with_python3

%check
%if 0%{?with_python2}
make -C py2 check
%endif # with_python2

%if 0%{?with_python3}
make -C py3 check
%endif # with_python3

%pre
getent group %{vdsm_group} >/dev/null || \
	LC_ALL=C groupadd -g 36 -r %{vdsm_group}
getent passwd %{vdsm_user} >/dev/null || \
	LC_ALL=C useradd -r -u 36 -g %{vdsm_group} -d / \
		-s /sbin/nologin -c "Node Virtualization Manager" %{vdsm_user}

%install
rm -rf "%{buildroot}"
%if 0%{?with_python2}
make -C py2 %{?_smp_mflags} install DESTDIR="%{buildroot}"
%endif # with_python2

%if 0%{?with_python3}
make -C py3 %{?_smp_mflags} install DESTDIR="%{buildroot}"
%endif # with_python3

%files

%if 0%{?with_python2}
%files -n python2-%{name}

%doc AUTHORS
%license COPYING
%dir %{_localstatedir}/log/ovirt-engine/%{package_name}
%dir %{_sysconfdir}/ovirt-engine/isouploader.conf.d
%attr(0640, -, -) %config(noreplace) %{_sysconfdir}/ovirt-engine/isouploader.conf
%config(noreplace) %{_sysconfdir}/logrotate.d/%{package_name}
%{python2_sitelib}/ovirt_iso_uploader/
%{_bindir}/ovirt-iso-uploader
%{_bindir}/engine-iso-uploader
%{_mandir}/man8/*

%endif # with_python2

%if 0%{?with_python3}
%files -n python%{python3_pkgversion}-%{name}

%doc AUTHORS
%license COPYING
%dir %{_localstatedir}/log/ovirt-engine/%{package_name}
%dir %{_sysconfdir}/ovirt-engine/isouploader.conf.d
%attr(0640, -, -) %config(noreplace) %{_sysconfdir}/ovirt-engine/isouploader.conf
%config(noreplace) %{_sysconfdir}/logrotate.d/%{package_name}
%{python3_sitelib}/ovirt_iso_uploader/
%{_bindir}/ovirt-iso-uploader
%{_bindir}/engine-iso-uploader
%{_mandir}/man8/*

%endif # with_python3


%changelog
* Tue Nov 28 2017 Sandro Bonazzola <sbonazzo@redhat.com> - 4.1.0-1
- 4.1.0-1

* Thu Aug  4 2016 Sandro Bonazzola <sbonazzo@redhat.com> - 4.1.0-0.0.master
- 4.1.0-0.0.master

* Tue May 31 2016 Rafael Martins <rmartins@redhat.com> - 4.0.0-1
- 4.0.0-1

* Wed Aug  5 2015 Sandro Bonazzola <sbonazzo@redhat.com> - 4.0.0-0.0.master
- 4.0.0-0.0.master
