#
# ovirt-release -- repo files for oVirt projects
# Copyright (C) 2014-2017 Red Hat, Inc.
#
# This library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public
# License as published by the Free Software Foundation; either
# version 2.1 of the License, or (at your option) any later version.
#
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public
# License along with this library; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
#

%global	package_version 4.1.8_rc2
%global	package_name ovirt-release41
%global	ovirt_version 4.1
%global	ovirt_yum_repo http://resources.ovirt.org
%global	ovirt_repo_path_normal /pub/yum-repo/mirrorlist-ovirt-4.1-snapshot-
%global	ovirt_repo_path_static /pub/yum-repo/mirrorlist-ovirt-4.1-snapshot-static-
%global	repo_url_key mirrorlist
%define is_x86 %(test %{_arch} = x86_64 && echo 1 || echo 0)


Name:		%{package_name}
Version:	4.1.8
Release:	0.2.rc2%{?release_suffix}%{?dist}
Summary:	The oVirt repository configuration
Group:		System Environment/Base

License:	ASL 2.0
URL:		http://www.ovirt.org
Source0:	http://resources.ovirt.org/pub/ovirt-4.1/src/%{package_name}/%{package_name}-%{package_version}.tar.gz
Source1:	http://resources.ovirt.org/pub/keys/RPM-GPG-ovirt-v2

BuildArch:	noarch

BuildRequires:	automake
BuildRequires:	autoconf
Requires:	system-release
Requires:	tar

%description
This package contains the yum configuration for oVirt repositories

%global	host_node_release_file ovirt-release-host-node
%package -n ovirt-release-host-node
Summary:	The oVirt Node release file
Version:	4.1.8
Release:	0.2.rc2%{?release_suffix}%{?dist}
Group:		System Environment/Base
License:	GPLv2
URL:		http://www.ovirt.org
BuildArch:	noarch

BuildRequires:	systemd

Requires(post):	systemd
Requires(postun):	systemd

Requires:	cockpit
%if 0%{?rhel} || 0%{?fedora} >= 25
#cockpit-dashboard is not available in fedora 24
Requires:	cockpit-dashboard
Requires:	cockpit-networkmanager
%endif
Requires:	cockpit-ovirt-dashboard
Requires:	gdeploy
%if 0%{?rhel}
# We don't build ovirt-node for Fedora yet
Requires:	ovirt-node-ng-nodectl
%endif
Requires:	firewalld
Requires:	imgbased
Requires:	ipa-client
Requires:	rng-tools
Requires:	vdsm
Requires:	vdsm-gluster
Requires:	vdsm-hook-fcoe
Requires:	vdsm-hook-vhostmd
Requires:	vdsm-hook-openstacknet
Requires:	vdsm-hook-ethtool-options
Requires:	vdsm-hook-vfio-mdev
Requires:	vdsm-hook-vmfex-dev
Requires:	glusterfs-rdma
Requires:	ovirt-hosted-engine-setup
Requires:	postfix
Requires:	mailx
Requires:	dracut-fips
Requires:	screen
Requires:	sysstat
Requires:	tcpdump
Requires:	net-snmp
Requires:	net-snmp-utils
Requires:	python-ovirt-engine-sdk4
Requires:	ovirt-host

# Keep including ntpd, since older versions of node which are upgraded may
# still have a configuration for it instead of chronyd
Requires:   ntp

# Hack to incldue the passive NM config: https://bugzilla.redhat.com/1326798
Requires:	NetworkManager-config-server

# Additional packages for EFI support
# https://www.brianlane.com/creating-live-isos-with-livemedia-creator.html
# http://lorax.readthedocs.org/en/latest/livemedia-creator.html#kickstarts
# Architecture dependent dependencies
%if 0%{?is_x86}
Requires:	efibootmgr

%if 0%{?fedora}
Requires:   grub2-efi
%else
Requires:	grub2-efi-x64
%endif

Requires:	memtest86+
Requires:	shim
Requires:	syslinux
%endif

%description -n ovirt-release-host-node
oVirt Node distribution dependencies, presets and required settings.

%package -n ovirt-node-ng-image-update-placeholder
Summary:	The oVirt Node Image Update Placeholder
Version:	4.1.8
Release:	0.2.rc2%{?release_suffix}%{?placeholder_release_suffix}%{?dist}
Group:		System Environment/Base
License:	GPLv2
URL:		http://www.ovirt.org
BuildArch:	noarch

%description -n ovirt-node-ng-image-update-placeholder
A sub-package to be included into oVirt Node Next squashfs
image to allow upgrading itself

%package snapshot
Summary:	oVirt snapshot repository configuration
Group:		System Environment/Base
Requires:	system-release
Requires:	tar

%description snapshot
This package contains the yum configuration for oVirt snapshot repositories


%package pre
Summary:	oVirt pre-release repository configuration
Group:		System Environment/Base
Requires:	system-release
Requires:	tar

%description pre
This package contains the yum configuration for oVirt pre-release repositories


%prep
%setup -q -n "%{package_name}-%{package_version}"

%build
%configure \
	--with-ovirt-yum-repo=%{ovirt_yum_repo} \
	--with-repo-url-key=%{repo_url_key} \
	--with-repo-path-normal=%{ovirt_repo_path_normal} \
	--with-repo-path-static=%{ovirt_repo_path_static}
make "%{?_smp_mflags}"


%install
rm -rf "%{buildroot}"
%make_install
#Allow ghost files
install -d 755 "%{buildroot}%{_sysconfdir}/yum.repos.d"
install -d "%{buildroot}%{_sysconfdir}/pki/rpm-gpg"
install -m 644 "%{SOURCE1}" "%{buildroot}%{_sysconfdir}/pki/rpm-gpg/RPM-GPG-ovirt-%{ovirt_version}"
touch "%{buildroot}%{_sysconfdir}/yum.repos.d/ovirt-%{ovirt_version}.repo"
touch "%{buildroot}%{_sysconfdir}/yum.repos.d/ovirt-%{ovirt_version}-pre.repo"
touch "%{buildroot}%{_sysconfdir}/yum.repos.d/ovirt-%{ovirt_version}-snapshot.repo"
touch "%{buildroot}%{_sysconfdir}/yum.repos.d/ovirt-%{ovirt_version}-dependencies.repo"
cp -rl "%{buildroot}%{_datadir}/%{package_name}" "%{buildroot}%{_datadir}/%{package_name}-snapshot"
cp -rl "%{buildroot}%{_datadir}/%{package_name}" "%{buildroot}%{_datadir}/%{package_name}-pre"

install -d 755 "%{buildroot}/data/images/rhev"

%post

# Adjust repos as per dist and version
DIST=fc
#Fedora is good for both Fedora and Generic (and probably other based on Fedora)
#Handling EL exception only (for now)
DISTVER="$(rpm --eval "%%dist"|cut -c2-)"
ARCH="$(rpm --eval "%%_arch")"
if rpm --eval "%%dist" | grep -qFi 'el'; then
	DIST=el
fi

if [[ "${DISTVER::3}" == "el7" ]] ; then
	# On some systems [el7_1], take only 3 1st chars: ${var::3}
	install -m 644 "%{_datadir}/%{package_name}/ovirt-el7-${ARCH}-deps.repo" "%{_sysconfdir}/yum.repos.d/ovirt-%{ovirt_version}-dependencies.repo"
elif [[ "${DISTVER}" == "fc24" ]]; then
	install -m 644 "%{_datadir}/%{package_name}/ovirt-f24-deps.repo" "%{_sysconfdir}/yum.repos.d/ovirt-%{ovirt_version}-dependencies.repo"
fi

sed \
	-e "s/@DIST@/${DIST}/g; s/@URLKEY@/%{repo_url_key}/g" \
	<"%{_datadir}/%{package_name}/ovirt.repo" > "%{_sysconfdir}/yum.repos.d/ovirt-%{ovirt_version}.repo"

%post snapshot

# Adjust repos as per dist and version
DIST=fc
#Fedora is good for both Fedora and Generic (and probably other based on Fedora)
#Handling EL exception only (for now)
DISTVER="$(rpm --eval "%%dist"|cut -c2-)"
ARCH="$(rpm --eval "%%_arch")"
if rpm --eval "%%dist" | grep -qFi 'el'; then
	DIST=el
fi

if [[ "${DISTVER::3}" == "el7" ]] ; then
	# On some systems [el7_1], take only 3 1st chars: ${var::3}
	install -m 644 "%{_datadir}/%{package_name}-snapshot/ovirt-el7-${ARCH}-deps.repo" \
	"%{_sysconfdir}/yum.repos.d/ovirt-%{ovirt_version}-snapshot-dependencies.repo"
elif [[ "${DISTVER}" == "fc24" ]]; then
	install -m 644 "%{_datadir}/%{package_name}-snapshot/ovirt-f24-deps.repo" \
	"%{_sysconfdir}/yum.repos.d/ovirt-%{ovirt_version}-snapshot-dependencies.repo"
fi

sed \
	-e "s/@DIST@/${DIST}/g; s/@URLKEY@/%{repo_url_key}/g" \
	<"%{_datadir}/%{package_name}-snapshot/ovirt-snapshot.repo" > "%{_sysconfdir}/yum.repos.d/ovirt-%{ovirt_version}-snapshot.repo"

%post pre

# Adjust repos as per dist and version
DIST=fc
#Fedora is good for both Fedora and Generic (and probably other based on Fedora)
#Handling EL exception only (for now)
DISTVER="$(rpm --eval "%%dist"|cut -c2-)"
ARCH="$(rpm --eval "%%_arch")"
if rpm --eval "%%dist" | grep -qFi 'el'; then
	DIST=el
fi

if [[ "${DISTVER::3}" == "el7" ]] ; then
	# On some systems [el7_1], take only 3 1st chars: ${var::3}
	install -m 644 "%{_datadir}/%{package_name}-pre/ovirt-el7-${ARCH}-deps.repo" \
	"%{_sysconfdir}/yum.repos.d/ovirt-%{ovirt_version}-pre-dependencies.repo"
elif [[ "${DISTVER}" == "fc24" ]]; then
	install -m 644 "%{_datadir}/%{package_name}-pre/ovirt-f24-deps.repo" \
	"%{_sysconfdir}/yum.repos.d/ovirt-%{ovirt_version}-pre-dependencies.repo"
fi

sed \
	-e "s/@DIST@/${DIST}/g; s/@URLKEY@/%{repo_url_key}/g" \
	<"%{_datadir}/%{package_name}-pre/ovirt-pre.repo" > "%{_sysconfdir}/yum.repos.d/ovirt-%{ovirt_version}-pre.repo"

%files
%{_datadir}/%{package_name}/
%{_sysconfdir}/pki/rpm-gpg/RPM-GPG-ovirt-%{ovirt_version}
# We do not know what distribution we are installed at,
# we copy the actual files at post, but still wants this package to own them.
# ghost in this case solves that issue
%ghost %config(noreplace) %{_sysconfdir}/yum.repos.d/ovirt-%{ovirt_version}.repo
%ghost %config(noreplace) %{_sysconfdir}/yum.repos.d/ovirt-%{ovirt_version}-dependencies.repo


%files snapshot
%{_datadir}/%{package_name}-snapshot/
%ghost %config(noreplace) %{_sysconfdir}/yum.repos.d/ovirt-%{ovirt_version}-snapshot.repo
%ghost %config(noreplace) %{_sysconfdir}/yum.repos.d/ovirt-%{ovirt_version}-snapshot-dependencies.repo


%files pre
%{_datadir}/%{package_name}-pre/
%{_sysconfdir}/pki/rpm-gpg/RPM-GPG-ovirt-%{ovirt_version}
%ghost %config(noreplace) %{_sysconfdir}/yum.repos.d/ovirt-%{ovirt_version}.repo
%ghost %config(noreplace) %{_sysconfdir}/yum.repos.d/ovirt-%{ovirt_version}-pre.repo
%ghost %config(noreplace) %{_sysconfdir}/yum.repos.d/ovirt-%{ovirt_version}-dependencies.repo

%post -n ovirt-release-host-node
%define __default_units_wanted cockpit.socket sshd.service NetworkManager.service imgbase-clean-grub.service imgbase-motd.service imgbase-generate-iqn.service imgbase-config-vdsm.service rsyslog.service auditd.service
# Make the defualt services default requirements of the target
for UNIT in %{__default_units_wanted} ; do
	ln -fs ../$UNIT %{_unitdir}/multi-user.target.wants/$UNIT
done

#
# Create the common os-release file

# Import os-release to get some fields
# NAME, VERSION, ID, VERSION_ID, CPE_NAME
. /etc/os-release || :

install -d /usr/lib/os.release.d/
cat << EOF >> /usr/lib/os.release.d/%{host_node_release_file}
NAME="$NAME"
VERSION="$VERSION"
ID="$ID"
ID_LIKE="$ID_LIKE"
VERSION_ID="$VERSION_ID"
VARIANT="oVirt Node %{package_version}"
VARIANT_ID="ovirt-node"
PRETTY_NAME="oVirt Node %{package_version}"
ANSI_COLOR="$ANSI_COLOR"
CPE_NAME="$CPE_NAME"
HOME_URL="https://www.ovirt.org/"
BUG_REPORT_URL="https://bugzilla.redhat.com/"
EOF

# Only on installation
if [ $1 = 1 ]; then
	cp -p /etc/os-release /usr/lib/os.release.d/.host-node-previous-os-release
	ln -sf os.release.d/%{host_node_release_file} /usr/lib/os-release
	ln -sf ../usr/lib/os-release /etc/os-release
	source /etc/os-release
	ln -sf %{_prefix}/share/ovirt-release-host-node/branding %{_prefix}/share/cockpit/branding/$ID-ovirt-node
fi

# Firewalld - add all services required for host
firewall-offline-cmd --add-service=cockpit >/dev/null 2>&1
firewall-offline-cmd --add-service=vdsm >/dev/null 2>&1
firewall-offline-cmd --add-service=libvirt >/dev/null 2>&1
firewall-offline-cmd --add-service=libvirt-tls >/dev/null 2>&1
firewall-offline-cmd --add-service=ssh >/dev/null 2>&1
firewall-offline-cmd --add-service=glusterfs >/dev/null 2>&1
systemctl restart firewalld.service >/dev/null 2>&1

# Restarting cockpit to load the new branding data
systemctl restart cockpit.service >/dev/null 2>&1

# Only whitelist ovirt-node-ng-image-update and ovirt-engine-appliance
# set-enabled is needed to keep the repo enabled when post-processing
# the image
# The loop is required because sed -i does not work with multiple files
for REPO in %{_sysconfdir}/yum.repos.d/ovirt-*.repo;
do
	sed -i \
		-e "/name=/ a includepkgs=ovirt-node-ng-image-update ovirt-node-ng-image ovirt-engine-appliance" \
		-e "1 i # imgbased: set-enabled" \
	"$REPO"
done

#
# NGN TEMPORARY HACKS
# For each hack there must be a bug, and they must be removed at
# some point in time
# ===================

# =======================
# NGN TEMPORARY HACKS END
#

%postun -n ovirt-release-host-node
for UNIT in %{__default_units_wanted} ; do
	rm -f %{_unitdir}/multi-user.target.wants/$UNIT
done

# In case of uninstall the host-node pkg, return the previous os-release
if [ $1 = 0 ]; then
	rm -f %{_prefix}/share/cockpit/branding/*-ovirt-node
	rm -f /usr/lib/os-release /etc/os-release
	cp -pf /usr/lib/os.release.d/.host-node-previous-os-release /usr/lib/os-release
	ln -sf /usr/lib/os-release /etc/os-release
	rm -f /usr/lib/os.release.d/.host-node-previous-os-release
	firewall-offline-cmd --remove-service=cockpit >/dev/null 2>&1
	firewall-offline-cmd --remove-service=vdsm >/dev/null 2>&1
	firewall-offline-cmd --remove-service=libvirt >/dev/null 2>&1
	firewall-offline-cmd --remove-service=ssh >/dev/null 2>&1
	systemctl restart firewalld.service >/dev/null 2>&1
fi
# Restarting cockpit to reload the branding data
systemctl restart cockpit.service >/dev/null 2>&1

%files -n ovirt-node-ng-image-update-placeholder

%files -n ovirt-release-host-node
%ghost %attr(0644, root, root) %{_prefix}/lib/os.release.d/%{host_node_release_file}
%dir %{_prefix}/share/ovirt-release-host-node
%dir %{_prefix}/share/ovirt-release-host-node/branding
%{_presetdir}/98-ovirt-host-node.preset
%{_prefix}/share/ovirt-release-host-node/branding/logo.png
%{_prefix}/share/ovirt-release-host-node/branding/bg-login.png
%{_prefix}/share/ovirt-release-host-node/branding/favicon.ico
%{_prefix}/share/ovirt-release-host-node/branding/branding.css

# Add a folder for local datastores
%dir %attr(0755, 36, 36) /data/images/rhev

%changelog
* Wed Nov 22 2017 Lev Veyde <lveyde@redhat.com> - 4.1.8-0.2.rc2
- 4.1.8-0.2.rc2

* Wed Nov 15 2017 Lev Veyde <lveyde@redhat.com> - 4.1.8-0.1.rc1
- 4.1.8-0.1.rc1

* Tue Nov 07 2017 Lev Veyde <lveyde@redhat.com> - 4.1.7-1
- 4.1.7-1

* Thu Nov 02 2017 Lev Veyde <lveyde@redhat.com> - 4.1.7-0.6.rc6
- 4.1.7-0.6.rc6

* Tue Oct 31 2017 Lev Veyde <lveyde@redhat.com> - 4.1.7-0.5.rc5
- 4.1.7-0.5.rc5

* Wed Oct 18 2017 Ido Rosenzwig <irosenzw@redhat.com> - 4.1.7-0.4.rc4
- 4.1.7-0.4.rc4

* Tue Oct 10 2017 Sandro Bonazzola <sbonazzo@redhat.com> - 4.1.7-0.3.rc3
- 4.1.7-0.3.rc3

* Wed Sep 27 2017 Lev Veyde <lveyde@redhat.com> - 4.1.7-0.2.rc2
- 4.1.7-0.2.rc2

* Tue Sep 19 2017 Sandro Bonazzola <sbonazzo@redhat.com> - 4.1.7-0.1.rc1
- 4.1.7-0.1.rc1

* Mon Sep 18 2017 Sandro Bonazzola <sbonazzo@redhat.com> - 4.1.6-1
- 4.1.6-1

* Wed Sep 06 2017 Lev Veyde <lveyde@redhat.com> - 4.1.6-0.3.rc3
- 4.1.6-0.3.rc3

* Wed Aug 30 2017 Lev Veyde <lveyde@redhat.com> - 4.1.6-0.2.rc2
- 4.1.6-0.2.rc2

* Wed Aug 23 2017 Lev Veyde <lveyde@redhat.com> - 4.1.6-0.1.rc1
- 4.1.6-0.1.rc1

* Mon Aug 21 2017 Lev Veyde <lveyde@redhat.com> - 4.1.6-0.0.master
- 4.1.6-0.0.master

* Mon Aug 21 2017 Lev Veyde <lveyde@redhat.com> - 4.1.5-1
- 4.1.5

* Tue Aug 08 2017 Sandro Bonazzola <sbonazzo@redhat.com> - 4.1.5-0.3.rc3
- 4.1.5-0.3.rc3
- Resolves: BZ#1364083

* Wed Aug 02 2017 Lev Veyde <lveyde@redhat.com> - 4.1.5-0.2.rc1
- 4.1.5-0.2.rc1

* Thu Jul 27 2017 Lev Veyde <lveyde@redhat.com> - 4.1.5-0.1.rc1
- 4.1.5-0.1.rc1

* Thu Jul 27 2017 Lev Veyde <lveyde@redhat.com> - 4.1.4-1
- 4.1.4

* Tue Jul 18 2017 Sandro Bonazzola <sbonazzo@redhat.com> - 4.1.4-0.2.rc2
- 4.1.4-0.2.rc2

* Wed Jul 12 2017 Lev Veyde <lveyde@redhat.com> - 4.1.4-0.1.rc1
- 4.1.4-0.1.rc1

* Sun Jul 09 2017 Lev Veyde <lveyde@redhat.com> - 4.1.4-0.0.master
- 4.1.4-0.0.master

* Sun Jul 09 2017 Lev Veyde <lveyde@redhat.com> - 4.1.3-1
- 4.1.3-1

* Thu Jun 22 2017 Sandro Bonazzola <sbonazzo@redhat.com> - 4.1.3-0.3.rc3
- 4.1.3-0.3.rc3
- Resolves: BZ#1446167

* Fri Jun 16 2017 Sandro Bonazzola <sbonazzo@redhat.com> - 4.1.3-0.2.rc2
- 4.1.3-0.2.rc2

* Wed Jun  7 2017 Sandro Bonazzola <sbonazzo@redhat.com> - 4.1.3-0.1.rc1
- 4.1.3-0.1.rc1

* Tue May 23 2017 Sandro Bonazzola <sbonazzo@redhat.com> - 4.1.3-0.0.master
- 4.1.3-0.0.master

* Tue May 23 2017 Sandro Bonazzola <sbonazzo@redhat.com> - 4.1.2-1
- 4.1.2-1

* Fri May 12 2017 Sandro Bonazzola <sbonazzo@redhat.com> - 4.1.2-0.2.rc2
- 4.1.2-0.2.rc2

* Thu May  4 2017 Sandro Bonazzola <sbonazzo@redhat.com> - 4.1.2-0.1.rc1
- Resolves: BZ#1443965
- Resolves: BZ#1442335
- Updated gdeploy repositories

* Wed Mar 22 2017 Sandro Bonazzola <sbonazzo@redhat.com> - 4.1.2-0.0.master
- 4.1.2-0.0.master

* Wed Mar 22 2017 Sandro Bonazzola <sbonazzo@redhat.com> - 4.1.1-1
- 4.1.1

* Thu Mar 16 2017 Sandro Bonazzola <sbonazzo@redhat.com> - 4.1.1-0.5.rc3
- 4.1.1_rc3

* Thu Mar  9 2017 Sandro Bonazzola <sbonazzo@redhat.com> - 4.1.1-0.4.rc2
- Enabling imgbase-config-vdsm unit on node

* Fri Mar  3 2017 Sandro Bonazzola <sbonazzo@redhat.com> - 4.1.1-0.3.rc1
- Fix el7 deps repo

* Fri Mar  3 2017 Sandro Bonazzola <sbonazzo@redhat.com> - 4.1.1-0.2.rc1
- First 4.1.1 release candidate
- Move to SIGs released repos

* Thu Feb 16 2017 Sandro Bonazzola <sbonazzo@redhat.com> - 4.1.1-0.1.master
- Move Virt SIG repos from candidate to testing.
- Resolves: BZ#1418630 - gluster firewalld service should be added to the
  default firewall zone

* Fri Feb 03 2017 Simone Tiraboschi <stirabos@redhat.com> - 4.1.1-0.0.master
- Resolves: BZ#1411640 - [HC] - Include gdeploy package in oVirt Node

* Wed Jan 25 2017 Sandro Bonazzola <sbonazzo@redhat.com> - 4.1.0-1
- Split x86_64 and ppc64le dependencies for EL7 since they're on different
  repositories

* Wed Jan 18 2017 Sandro Bonazzola <sbonazzo@redhat.com> - 4.1.0-0.8.rc1
- node: add libvirt-tls to the firewalld config
- node: Add IQN randomization

* Wed Jan  4 2017 Rafael Martins <rmartins@redhat.com> - 4.1.0-0.7.master
- Add experimental repo
- el7: Add CentOS oVirt common candidate repo

* Fri Dec 16 2016 Sandro Bonazzola <sbonazzo@redhat.com> - 4.1.0-0.6.beta2
- Updated GPG key
- Resolves: BZ#1379763 - include screen by default on Node

* Thu Nov 24 2016 Sandro Bonazzola <sbonazzo@redhat.com> - 4.1.0-0.5.master
- Add virt-preview repo for Fedora
- Resolves: BZ#1398321
- Add a workaround for random IQN name generation rhbz#1393661

* Thu Nov 10 2016 Sandro Bonazzola <sbonazzo@redhat.com> - 4.1.0-0.4.master
- Add experimental repo
- el7: Add CentOS oVirt common candidate repo

* Fri Oct  7 2016 Sandro Bonazzola <sbonazzo@redhat.com> - 4.1.0-0.3.master
- Added CentOS OpsTool testing repo to dependencies repo for el7

* Thu Aug 11 2016 Sandro Bonazzola <sbonazzo@redhat.com> - 4.1.0-0.1.master
- Moved from GlusterFS 3.7 to GlusterFS 3.8
- Resolves: BZ#1366118

* Wed Jul 20 2016 Sandro Bonazzola <sbonazzo@redhat.com> - 4.1.0-0.0.master
- Moved from Fedora 23 to Fedora 24

* Sun Jun 19 2016 Fabian Deutsch <fdeutsch@redhat.com> - 4.0.0-0.7.master
- Fix repo enablement

* Wed Jun 15 2016 Fabian Deutsch <fdeutsch@redhat.com> - 4.0.0-0.6.master
- Preset imgbase-motd to enabled

* Tue Jun 14 2016 Fabian Deutsch <fdeutsch@redhat.com> - 4.0.0-0.5.master
- Enable oVirt repos after whitelisting

* Thu Jun 09 2016 Fabian Deutsch <fdeutsch@redhat.com> - 4.0.0-0.4.master
- Drop placeholder requirements

* Wed Mar 23 2016 Sandro Bonazzola <sbonazzo@redhat.com> - 4.0.0-0.3.master
- GlusterFS signing key changed

* Fri Mar 11 2016 Fabian Deutsch <fdeutsch@redhat.com> - 4.0.0-0.2.master
- Rename ovirt-release-master-host-node to ovirt-release-host-node

* Wed Mar  2 2016 Sandro Bonazzola <sbonazzo@redhat.com> - 4.0.0-0.1.master
- 4.0.0-0.1.master
- Drop Fedora 22 support

* Tue Jan 26 2016 Fabian Deutsch <fdeutsch@redhat.com> - 4.0.0-0.0.master
- Align package version ot the overall oVirt version
- Rename the placeholder package

* Thu Jan 14 2016 Douglas Schilling Landgraf <dougsland@redhat.com> - 002-0.6.master
- Added host-node sub-package requirements

* Wed Dec 23 2015 Sandro Bonazzola <sbonazzo@redhat.com> - 002-0.5.master
- Add CentOS Virt SIG oVirt 3.6 repo as dependency for EL7 including openvswitch
- Drop Fedora 21 support

* Wed Dec 09 2015 Ryan Barry <rbarry@redhat.com> - 002-0.4.master
- Add a host-node subpackage for next-gen node

* Wed Nov 11 2015 Sandro Bonazzola <sbonazzo@redhat.com> - 002-0.3.master
- Allow ovirt-guest-agent sub packages to be installed from EPEL

* Tue Nov 10 2015 Sandro Bonazzola <sbonazzo@redhat.com> - 002-0.2.master
- Updated Gluster repositories GPG key URL
- Added Fedora 23

* Fri Nov  6 2015 Sandro Bonazzola <sbonazzo@redhat.com> - 002-0.1.master
- Resolves: BZ#1278398

* Fri Sep 18 2015 Sandro Bonazzola <sbonazzo@redhat.com> - 002-0.0.master
- Bumped version to 002 for 4.0 release cycle
- Dropped EL 6 support
- Add centos-openstack-kilo repository for openvswitch package on EL7

* Tue Aug  4 2015 Sandro Bonazzola <sbonazzo@redhat.com> - 001-0.11.master
- Dropped Fedora 20

* Thu Jul  9 2015 Sandro Bonazzola <sbonazzo@redhat.com> - 001-0.10.master
- Added pyxattr and userspace-rcu to EPEL 6 repository for Gluster 3.7.2

* Fri May 22 2015 Sandro Bonazzola <sbonazzo@redhat.com> - 001-0.9.master
- Drop Gluster 3.7 Nightly repository since 3.7.0 GA is available
- Add VirtIO-Win Stable repository

* Mon Apr 27 2015 Max Kovgan <mkovgan@redhat.com> - 001-0.8.master
- add overrides to urls/paths serving the repositories

* Thu Apr 23 2015 Sandro Bonazzola <sbonazzo@redhat.com> - 001-0.7.master
- Add Fedora 22 support for 3.6.0
- Move GlusterFS Nightly to GlusterFS 3.7 Nightly
- Enable the whole virt-preview repo for Fedora 20 since also a newer qemu-kvm
  is now required.

* Fri Apr  3 2015 Sandro Bonazzola <sbonazzo@redhat.com> - 001-0.6.master
- Add userspace-rcu from EPEL, needed by Gluster 3.7

* Wed Mar 25 2015 Sandro Bonazzola <sbonazzo@redhat.com> - 001-0.5.master
- Enable GlusterFS Nightly on all distributions required for VDSM starting
  from https://gerrit.ovirt.org/39075

* Wed Feb  4 2015 Sandro Bonazzola <sbonazzo@redhat.com> - 001-0.4.master
- Enable virt-preview repository on Fedora 20

* Thu Dec 11 2014 Sandro Bonazzola <sbonazzo@redhat.com> - 001-0.3.master
- Use latest glusterfs also on Fedora
- Enable rpm gpg check on glusterfs rpms

* Mon Nov 10 2014 Sandro Bonazzola <sbonazzo@redhat.com> - 001-0.2.master
- Add EL7 support for 3.6.0

* Mon Oct 20 2014 Sandro Bonazzola <sbonazzo@redhat.com> - 001-0.1.master
- Add Fedora 21 support for 3.6.0
- Provide oVirt master development repositories
