#
# ovirt-release -- repo files for oVirt projects
# Copyright (C) 2014-2017 Red Hat, Inc.
#
# This library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public
# License as published by the Free Software Foundation; either
# version 2.1 of the License, or (at your option) any later version.
#
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public
# License along with this library; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
#

%global	package_version 4.2.0_rc2
%global	package_name ovirt-release42
%global	ovirt_version 4.2
%global	ovirt_yum_repo http://resources.ovirt.org
%global	ovirt_repo_path_normal /pub/yum-repo/mirrorlist-ovirt-4.2-snapshot-
%global	ovirt_repo_path_static /pub/yum-repo/mirrorlist-ovirt-4.2-snapshot-static-
%global	repo_url_key mirrorlist
%define is_x86 %(test %{_arch} = x86_64 && echo 1 || echo 0)


Name:		%{package_name}
Version:	4.2.0
Release:	0.6.rc2%{?release_suffix}%{?dist}
Summary:	The oVirt repository configuration
Group:		System Environment/Base

License:	ASL 2.0
URL:		http://www.ovirt.org
Source0:	http://resources.ovirt.org/pub/ovirt-4.2-snapshot/src/%{package_name}/%{package_name}-%{package_version}.tar.gz
Source1:	http://resources.ovirt.org/pub/keys/RPM-GPG-ovirt-v2

BuildArch:	noarch

BuildRequires:	automake
BuildRequires:	autoconf
Requires:	system-release
Requires:	tar

%description
This package contains the yum configuration for oVirt repositories

%global	host_node_release_file ovirt-release-host-node
%package -n ovirt-release-host-node
Summary:	The oVirt Node release file
Version:	4.2.0
Release:	0.6.rc2%{?release_suffix}%{?dist}
Group:		System Environment/Base
License:	GPLv2
URL:		http://www.ovirt.org
BuildArch:	noarch

BuildRequires:	systemd

Requires(post):	systemd
Requires(postun):	systemd

%if 0%{?rhel}
# We don't build ovirt-node for Fedora yet
Requires:	ovirt-node-ng-nodectl
%endif
Requires:	firewalld
Requires:	gdeploy
Requires:	imgbased
Requires:	ovirt-host
Requires:	python-ovirt-engine-sdk4
Requires:	vdsm-gluster

# Hack for avoiding add host failures due to missing m2crypto on node.
# VDSM removed m2crypto as dependency in https://gerrit.ovirt.org/#/c/76027/
# but it's still needed by ovirt-host-deploy runtime for certificates
# enrollment.
# Change requested here: https://bugzilla.redhat.com/1464199
Requires:	m2crypto

# Additional packages for EFI support
# https://www.brianlane.com/creating-live-isos-with-livemedia-creator.html
# http://lorax.readthedocs.org/en/latest/livemedia-creator.html#kickstarts
# Architecture dependent dependencies
%if 0%{?is_x86}
Requires:	efibootmgr

%if 0%{?fedora}
Requires:   grub2-efi
%else
Requires:	grub2-efi-x64
%endif

Requires:	memtest86+
Requires:	shim
Requires:	syslinux
%endif

%description -n ovirt-release-host-node
oVirt Node distribution dependencies, presets and required settings.

%package -n ovirt-node-ng-image-update-placeholder
Summary:	The oVirt Node Image Update Placeholder
Version:	4.2.0
Release:	0.6.rc2%{?release_suffix}%{?placeholder_release_suffix}%{?dist}
Group:		System Environment/Base
License:	GPLv2
URL:		http://www.ovirt.org
BuildArch:	noarch

%description -n ovirt-node-ng-image-update-placeholder
A sub-package to be included into oVirt Node Next squashfs
image to allow upgrading itself

%package tested
Summary:	oVirt tested repository configuration
Group:		System Environment/Base
Requires:	system-release
Requires:	tar

%description tested
This package contains the yum configuration for oVirt tested repositories

%package snapshot
Summary:	oVirt snapshot repository configuration
Group:		System Environment/Base
Requires:	system-release
Requires:	tar

%description snapshot
This package contains the yum configuration for oVirt snapshot repositories


%package pre
Summary:	oVirt pre-release repository configuration
Group:		System Environment/Base
Requires:	system-release
Requires:	tar

%description pre
This package contains the yum configuration for oVirt pre-release repositories


%prep
%setup -q -n "%{package_name}-%{package_version}"

%build
%configure \
	--with-ovirt-yum-repo=%{ovirt_yum_repo} \
	--with-repo-url-key=%{repo_url_key} \
	--with-repo-path-normal=%{ovirt_repo_path_normal} \
	--with-repo-path-static=%{ovirt_repo_path_static}
make "%{?_smp_mflags}"


%install
rm -rf "%{buildroot}"
%make_install
#Allow ghost files
install -d 755 "%{buildroot}%{_sysconfdir}/yum.repos.d"
install -d "%{buildroot}%{_sysconfdir}/pki/rpm-gpg"
install -m 644 "%{SOURCE1}" "%{buildroot}%{_sysconfdir}/pki/rpm-gpg/RPM-GPG-ovirt-%{ovirt_version}"
touch "%{buildroot}%{_sysconfdir}/yum.repos.d/ovirt-%{ovirt_version}.repo"
touch "%{buildroot}%{_sysconfdir}/yum.repos.d/ovirt-%{ovirt_version}-pre.repo"
touch "%{buildroot}%{_sysconfdir}/yum.repos.d/ovirt-%{ovirt_version}-tested.repo"
touch "%{buildroot}%{_sysconfdir}/yum.repos.d/ovirt-%{ovirt_version}-snapshot.repo"
touch "%{buildroot}%{_sysconfdir}/yum.repos.d/ovirt-%{ovirt_version}-dependencies.repo"
cp -rl "%{buildroot}%{_datadir}/%{package_name}" "%{buildroot}%{_datadir}/%{package_name}-snapshot"
cp -rl "%{buildroot}%{_datadir}/%{package_name}" "%{buildroot}%{_datadir}/%{package_name}-pre"
cp -rl "%{buildroot}%{_datadir}/%{package_name}" "%{buildroot}%{_datadir}/%{package_name}-tested"

install -d 755 "%{buildroot}/data/images/rhev"

%post

# Adjust repos as per dist and version
DIST=fc
#Fedora is good for both Fedora and Generic (and probably other based on Fedora)
#Handling EL exception only (for now)
DISTVER="$(rpm --eval "%%dist"|cut -c2-)"
ARCH="$(rpm --eval "%%_arch")"
if rpm --eval "%%dist" | grep -qFi 'el'; then
	DIST=el
fi

if [[ "${DISTVER::3}" == "el7" ]] ; then
	# On some systems [el7_1], take only 3 1st chars: ${var::3}
	install -m 644 "%{_datadir}/%{package_name}/ovirt-el7-${ARCH}-deps.repo" "%{_sysconfdir}/yum.repos.d/ovirt-%{ovirt_version}-dependencies.repo"
elif [[ "${DISTVER}" == "fc25" ]]; then
	install -m 644 "%{_datadir}/%{package_name}/ovirt-f25-deps.repo" "%{_sysconfdir}/yum.repos.d/ovirt-%{ovirt_version}-dependencies.repo"
elif [[ "${DISTVER}" == "fc26" ]]; then
	install -m 644 "%{_datadir}/%{package_name}/ovirt-f26-deps.repo" "%{_sysconfdir}/yum.repos.d/ovirt-%{ovirt_version}-dependencies.repo"
elif [[ "${DISTVER}" == "fc27" ]]; then
	install -m 644 "%{_datadir}/%{package_name}/ovirt-f27-deps.repo" "%{_sysconfdir}/yum.repos.d/ovirt-%{ovirt_version}-dependencies.repo"
fi

sed \
	-e "s/@DIST@/${DIST}/g; s/@URLKEY@/%{repo_url_key}/g" \
	<"%{_datadir}/%{package_name}/ovirt.repo" > "%{_sysconfdir}/yum.repos.d/ovirt-%{ovirt_version}.repo"

%post snapshot

# Adjust repos as per dist and version
DIST=fc
#Fedora is good for both Fedora and Generic (and probably other based on Fedora)
#Handling EL exception only (for now)
DISTVER="$(rpm --eval "%%dist"|cut -c2-)"
ARCH="$(rpm --eval "%%_arch")"
if rpm --eval "%%dist" | grep -qFi 'el'; then
	DIST=el
fi

if [[ "${DISTVER::3}" == "el7" ]] ; then
	# On some systems [el7_1], take only 3 1st chars: ${var::3}
	install -m 644 "%{_datadir}/%{package_name}-snapshot/ovirt-el7-${ARCH}-deps.repo" \
	"%{_sysconfdir}/yum.repos.d/ovirt-%{ovirt_version}-snapshot-dependencies.repo"
elif [[ "${DISTVER}" == "fc25" ]]; then
	install -m 644 "%{_datadir}/%{package_name}-snapshot/ovirt-f25-deps.repo" \
	"%{_sysconfdir}/yum.repos.d/ovirt-%{ovirt_version}-snapshot-dependencies.repo"
elif [[ "${DISTVER}" == "fc26" ]]; then
	install -m 644 "%{_datadir}/%{package_name}-snapshot/ovirt-f26-deps.repo" \
	"%{_sysconfdir}/yum.repos.d/ovirt-%{ovirt_version}-snapshot-dependencies.repo"
fi

sed \
	-e "s/@DIST@/${DIST}/g; s/@URLKEY@/%{repo_url_key}/g" \
	<"%{_datadir}/%{package_name}-snapshot/ovirt-snapshot.repo" > "%{_sysconfdir}/yum.repos.d/ovirt-%{ovirt_version}-snapshot.repo"

%post tested

# Adjust repos as per dist and version
DIST=fc
#Fedora is good for both Fedora and Generic (and probably other based on Fedora)
#Handling EL exception only (for now)
DISTVER="$(rpm --eval "%%dist"|cut -c2-)"
ARCH="$(rpm --eval "%%_arch")"
if rpm --eval "%%dist" | grep -qFi 'el'; then
	DIST=el
fi

if [[ "${DISTVER::3}" == "el7" ]] ; then
	# On some systems [el7_1], take only 3 1st chars: ${var::3}
	install -m 644 "%{_datadir}/%{package_name}-tested/ovirt-el7-${ARCH}-deps.repo" \
	"%{_sysconfdir}/yum.repos.d/ovirt-%{ovirt_version}-dependencies.repo"
elif [[ "${DISTVER}" == "fc25" ]]; then
	install -m 644 "%{_datadir}/%{package_name}-tested/ovirt-f25-deps.repo" \
	"%{_sysconfdir}/yum.repos.d/ovirt-%{ovirt_version}-dependencies.repo"
elif [[ "${DISTVER}" == "fc26" ]]; then
	install -m 644 "%{_datadir}/%{package_name}-tested/ovirt-f26-deps.repo" \
	"%{_sysconfdir}/yum.repos.d/ovirt-%{ovirt_version}-dependencies.repo"
elif [[ "${DISTVER}" == "fc27" ]]; then
	install -m 644 "%{_datadir}/%{package_name}-tested/ovirt-f27-deps.repo" \
	"%{_sysconfdir}/yum.repos.d/ovirt-%{ovirt_version}-dependencies.repo"
fi

sed \
	-e "s/@DIST@/${DIST}/g; s/@URLKEY@/%{repo_url_key}/g" \
	<"%{_datadir}/%{package_name}-tested/ovirt-tested.repo" > "%{_sysconfdir}/yum.repos.d/ovirt-%{ovirt_version}-tested.repo"

%post pre

# Adjust repos as per dist and version
DIST=fc
#Fedora is good for both Fedora and Generic (and probably other based on Fedora)
#Handling EL exception only (for now)
DISTVER="$(rpm --eval "%%dist"|cut -c2-)"
ARCH="$(rpm --eval "%%_arch")"
if rpm --eval "%%dist" | grep -qFi 'el'; then
	DIST=el
fi

if [[ "${DISTVER::3}" == "el7" ]] ; then
	# On some systems [el7_1], take only 3 1st chars: ${var::3}
	install -m 644 "%{_datadir}/%{package_name}-pre/ovirt-el7-${ARCH}-deps.repo" \
	"%{_sysconfdir}/yum.repos.d/ovirt-%{ovirt_version}-pre-dependencies.repo"
elif [[ "${DISTVER}" == "fc25" ]]; then
	install -m 644 "%{_datadir}/%{package_name}-pre/ovirt-f25-deps.repo" \
	"%{_sysconfdir}/yum.repos.d/ovirt-%{ovirt_version}-pre-dependencies.repo"
elif [[ "${DISTVER}" == "fc26" ]]; then
	install -m 644 "%{_datadir}/%{package_name}-pre/ovirt-f26-deps.repo" \
	"%{_sysconfdir}/yum.repos.d/ovirt-%{ovirt_version}-pre-dependencies.repo"
fi

sed \
	-e "s/@DIST@/${DIST}/g; s/@URLKEY@/%{repo_url_key}/g" \
	<"%{_datadir}/%{package_name}-pre/ovirt-pre.repo" > "%{_sysconfdir}/yum.repos.d/ovirt-%{ovirt_version}-pre.repo"

%files
%{_datadir}/%{package_name}/
%{_sysconfdir}/pki/rpm-gpg/RPM-GPG-ovirt-%{ovirt_version}
# We do not know what distribution we are installed at,
# we copy the actual files at post, but still wants this package to own them.
# ghost in this case solves that issue
%ghost %config(noreplace) %{_sysconfdir}/yum.repos.d/ovirt-%{ovirt_version}.repo
%ghost %config(noreplace) %{_sysconfdir}/yum.repos.d/ovirt-%{ovirt_version}-dependencies.repo

%files snapshot
%{_datadir}/%{package_name}-snapshot/
%ghost %config(noreplace) %{_sysconfdir}/yum.repos.d/ovirt-%{ovirt_version}-snapshot.repo
%ghost %config(noreplace) %{_sysconfdir}/yum.repos.d/ovirt-%{ovirt_version}-snapshot-dependencies.repo

%files pre
%{_datadir}/%{package_name}-pre/
%{_sysconfdir}/pki/rpm-gpg/RPM-GPG-ovirt-%{ovirt_version}
%ghost %config(noreplace) %{_sysconfdir}/yum.repos.d/ovirt-%{ovirt_version}.repo
%ghost %config(noreplace) %{_sysconfdir}/yum.repos.d/ovirt-%{ovirt_version}-pre.repo
%ghost %config(noreplace) %{_sysconfdir}/yum.repos.d/ovirt-%{ovirt_version}-dependencies.repo

%files tested
%{_datadir}/%{package_name}-tested/
%ghost %config(noreplace) %{_sysconfdir}/yum.repos.d/ovirt-%{ovirt_version}-tested.repo
%ghost %config(noreplace) %{_sysconfdir}/yum.repos.d/ovirt-%{ovirt_version}-dependencies.repo

%post -n ovirt-release-host-node
%define __default_units_wanted cockpit.socket sshd.service NetworkManager.service imgbase-clean-grub.service imgbase-motd.service imgbase-generate-iqn.service imgbase-config-vdsm.service rsyslog.service auditd.service
# Make the defualt services default requirements of the target
for UNIT in %{__default_units_wanted} ; do
	ln -fs ../$UNIT %{_unitdir}/multi-user.target.wants/$UNIT
done

#
# Create the common os-release file

# Import os-release to get some fields
# NAME, VERSION, ID, VERSION_ID, CPE_NAME
. /etc/os-release || :

install -d /usr/lib/os.release.d/
cat << EOF >> /usr/lib/os.release.d/%{host_node_release_file}
NAME="$NAME"
VERSION="$VERSION"
ID="$ID"
ID_LIKE="$ID_LIKE"
VERSION_ID="$VERSION_ID"
VARIANT="oVirt Node %{package_version}"
VARIANT_ID="ovirt-node"
PRETTY_NAME="oVirt Node %{package_version}"
ANSI_COLOR="$ANSI_COLOR"
CPE_NAME="$CPE_NAME"
HOME_URL="https://www.ovirt.org/"
BUG_REPORT_URL="https://bugzilla.redhat.com/"
EOF

# Only on installation
if [ $1 = 1 ]; then
	cp -p /etc/os-release /usr/lib/os.release.d/.host-node-previous-os-release
	ln -sf os.release.d/%{host_node_release_file} /usr/lib/os-release
	ln -sf ../usr/lib/os-release /etc/os-release
	source /etc/os-release
	ln -sf %{_prefix}/share/ovirt-release-host-node/branding %{_prefix}/share/cockpit/branding/$ID-ovirt-node
fi

# Firewalld - add all services required for host
firewall-offline-cmd --add-service=cockpit >/dev/null 2>&1
firewall-offline-cmd --add-service=vdsm >/dev/null 2>&1
firewall-offline-cmd --add-service=libvirt >/dev/null 2>&1
firewall-offline-cmd --add-service=libvirt-tls >/dev/null 2>&1
firewall-offline-cmd --add-service=ssh >/dev/null 2>&1
firewall-offline-cmd --add-service=glusterfs >/dev/null 2>&1
systemctl restart firewalld.service >/dev/null 2>&1

# Restarting cockpit to load the new branding data
systemctl restart cockpit.service >/dev/null 2>&1

# Only whitelist ovirt-node-ng-image-update and ovirt-engine-appliance
# set-enabled is needed to keep the repo enabled when post-processing
# the image
# The loop is required because sed -i does not work with multiple files
for REPO in %{_sysconfdir}/yum.repos.d/ovirt-*.repo;
do
	sed -i \
		-e "/name=/ a includepkgs=ovirt-node-ng-image-update ovirt-node-ng-image ovirt-engine-appliance" \
		-e "1 i # imgbased: set-enabled" \
	"$REPO"
done

#
# NGN TEMPORARY HACKS
# For each hack there must be a bug, and they must be removed at
# some point in time
# ===================

# =======================
# NGN TEMPORARY HACKS END
#

%postun -n ovirt-release-host-node
for UNIT in %{__default_units_wanted} ; do
	rm -f %{_unitdir}/multi-user.target.wants/$UNIT
done

# In case of uninstall the host-node pkg, return the previous os-release
if [ $1 = 0 ]; then
	rm -f %{_prefix}/share/cockpit/branding/*-ovirt-node
	rm -f /usr/lib/os-release /etc/os-release
	cp -pf /usr/lib/os.release.d/.host-node-previous-os-release /usr/lib/os-release
	ln -sf /usr/lib/os-release /etc/os-release
	rm -f /usr/lib/os.release.d/.host-node-previous-os-release
	firewall-offline-cmd --remove-service=cockpit >/dev/null 2>&1
	firewall-offline-cmd --remove-service=vdsm >/dev/null 2>&1
	firewall-offline-cmd --remove-service=libvirt >/dev/null 2>&1
	firewall-offline-cmd --remove-service=ssh >/dev/null 2>&1
	systemctl restart firewalld.service >/dev/null 2>&1
fi
# Restarting cockpit to reload the branding data
systemctl restart cockpit.service >/dev/null 2>&1

%files -n ovirt-node-ng-image-update-placeholder

%files -n ovirt-release-host-node
%ghost %attr(0644, root, root) %{_prefix}/lib/os.release.d/%{host_node_release_file}
%dir %{_prefix}/share/ovirt-release-host-node
%dir %{_prefix}/share/ovirt-release-host-node/branding
%{_presetdir}/98-ovirt-host-node.preset
%{_prefix}/share/ovirt-release-host-node/branding/logo.png
%{_prefix}/share/ovirt-release-host-node/branding/bg-login.png
%{_prefix}/share/ovirt-release-host-node/branding/favicon.ico
%{_prefix}/share/ovirt-release-host-node/branding/branding.css

# Add a folder for local datastores
%dir %attr(0755, 36, 36) /data/images/rhev

%changelog
* Tue Dec 12 2017 Sandro Bonazzola <sbonazzo@redhat.com> - 4.2.0-0.5.rc2
- 4.2 RC2

* Mon Dec 04 2017 Sandro Bonazzola <sbonazzo@redhat.com> - 4.2.0-0.4.rc1
- 4.2 RC1

* Wed Nov 15 2017 Sandro Bonazzola <sbonazzo@redhat.com> - 4.2.0-0.3.beta
- Beta refresh

* Mon Oct 30 2017 Sandro Bonazzola <sbonazzo@redhat.com> - 4.2.0-0.2.beta
- Beta release

* Mon Oct 09 2017 Sandro Bonazzola <sbonazzo@redhat.com> - 4.2.0-0.1.master
- Add Fedora 27 support
- Add ovirt-cockpit-sso repo

* Mon Sep 04 2017 Sandro Bonazzola <sbonazzo@redhat.com> - 4.2.0-0.0.master
- Initial import
