/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.duplicates;

import com.puppycrawl.tools.checkstyle.api.AbstractFileSetCheck;
import com.puppycrawl.tools.checkstyle.api.MessageDispatcher;
import com.puppycrawl.tools.checkstyle.api.Utils;
import com.puppycrawl.tools.checkstyle.checks.duplicates.ChecksumInfo;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import org.apache.commons.collections.MultiHashMap;
import org.apache.commons.collections.MultiMap;
import org.apache.commons.collections.ReferenceMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class StrictDuplicateCodeCheck
extends AbstractFileSetCheck {
    private static final int BIG_PRIME = 317;
    private static final Log LOG = LogFactory.getLog(StrictDuplicateCodeCheck.class);
    static final int IGNORE = Integer.MIN_VALUE;
    private static final int DEFAULT_MIN_DUPLICATE_LINES = 12;
    private int mMin = 12;
    private String mBasedir;
    private int[][] mLineBlockChecksums;
    private ChecksumInfo[] mChecksumInfo;
    private File[] mFiles;
    private Map mTrimmedLineCache = new ReferenceMap();
    private int mDuplicates;

    public void setMin(int aMin) {
        if (aMin < 1) {
            throw new IllegalArgumentException("min must be 1 or higher");
        }
        this.mMin = aMin;
    }

    public void setBasedir(String aBasedir) {
        this.mBasedir = aBasedir;
    }

    public synchronized void process(File[] aFiles) {
        long start = System.currentTimeMillis();
        this.mDuplicates = 0;
        this.mFiles = this.filter(aFiles);
        this.mLineBlockChecksums = new int[this.mFiles.length][];
        this.mChecksumInfo = new ChecksumInfo[this.mFiles.length];
        if (LOG.isDebugEnabled()) {
            LOG.debug("Reading " + this.mFiles.length + " input files");
        }
        for (int i = 0; i < this.mFiles.length; ++i) {
            File file = this.mFiles[i];
            try {
                String[] lines = this.getTrimmedLines(file);
                ChecksumGenerator transformer = this.findChecksumGenerator(file);
                this.mLineBlockChecksums[i] = transformer.convertLines(lines);
                continue;
            }
            catch (IOException ex) {
                LOG.error("Cannot access " + file + " (" + ex.getMessage() + "), ignoring", ex);
                this.mLineBlockChecksums = new int[0][0];
            }
        }
        this.fillSortedRelevantChecksums();
        long endReading = System.currentTimeMillis();
        this.findDuplicates();
        long endSearching = System.currentTimeMillis();
        this.dumpStats(start, endReading, endSearching);
        this.mLineBlockChecksums = null;
        this.mChecksumInfo = null;
    }

    private ChecksumGenerator findChecksumGenerator(File aFile) {
        if (aFile.getName().endsWith(".java")) {
            return new JavaChecksumGenerator();
        }
        return new TextfileChecksumGenerator();
    }

    private void dumpStats(long aStart, long aEndReading, long aEndSearching) {
        if (LOG.isDebugEnabled()) {
            long initTime = aEndReading - aStart;
            long workTime = aEndSearching - aEndReading;
            LOG.debug("files = " + this.mFiles.length);
            LOG.debug("duplicates = " + this.mDuplicates);
            LOG.debug("Runtime = " + initTime + " + " + workTime);
        }
    }

    private void fillSortedRelevantChecksums() {
        for (int i = 0; i < this.mLineBlockChecksums.length; ++i) {
            int[] checksums = this.mLineBlockChecksums[i];
            this.mChecksumInfo[i] = new ChecksumInfo(checksums);
        }
    }

    private void findDuplicates() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Analysis phase");
        }
        int len = this.mFiles.length;
        for (int i = 0; i < len; ++i) {
            String path = this.mFiles[i].getPath();
            this.getMessageCollector().reset();
            MessageDispatcher dispatcher = this.getMessageDispatcher();
            dispatcher.fireFileStarted(path);
            for (int j = 0; j <= i; ++j) {
                this.findDuplicatesInFiles(i, j);
            }
            this.fireErrors(path);
            dispatcher.fireFileFinished(path);
        }
    }

    private void findDuplicatesInFiles(int aI, int aJ) {
        ChecksumInfo iChecksumInfo = this.mChecksumInfo[aI];
        ChecksumInfo jChecksumInfo = this.mChecksumInfo[aJ];
        if (!iChecksumInfo.hasChecksumOverlapsWith(jChecksumInfo)) {
            return;
        }
        int[] iLineBlockChecksums = this.mLineBlockChecksums[aI];
        int iBlockCount = iLineBlockChecksums.length;
        MultiHashMap ignorePairs = new MultiHashMap();
        for (int iLine = 0; iLine < iBlockCount; ++iLine) {
            int iSum = iLineBlockChecksums[iLine];
            int[] jLines = jChecksumInfo.findLinesWithChecksum(iSum);
            if (jLines.length <= 0) continue;
            this.findDuplicateFromLine(aI, aJ, iLine, jLines, ignorePairs);
        }
    }

    private void findDuplicateFromLine(int aI, int aJ, int aILine, int[] aJLines, MultiMap aIgnore) {
        int[] iCheckSums = this.mLineBlockChecksums[aI];
        int[] jCheckSums = this.mLineBlockChecksums[aJ];
        long checkSum = iCheckSums[aILine];
        Integer iLine = new Integer(aILine);
        for (int jLineIdx = 0; jLineIdx < aJLines.length; ++jLineIdx) {
            int duplicateLines;
            Collection ignoreEntries;
            int jLine = aJLines[jLineIdx];
            if (aI == aJ && aILine >= jLine || (long)jCheckSums[jLine] != checkSum || (ignoreEntries = (Collection)aIgnore.get(iLine)) != null && ignoreEntries.contains(new Integer(jLine)) || (duplicateLines = this.verifiyDuplicateLines(aI, aJ, aILine, jLine)) < this.mMin) continue;
            this.reportDuplicate(duplicateLines, aILine, this.mFiles[aJ], jLine);
            int extend = duplicateLines - this.mMin;
            for (int i = 0; i < extend; ++i) {
                int offset = i + 1;
                aIgnore.put(new Integer(aILine + offset), new Integer(jLine + offset));
            }
        }
    }

    private int verifiyDuplicateLines(int aI, int aJ, int aIStartLine, int aJStartLine) {
        File iFile = this.mFiles[aI];
        File jFile = this.mFiles[aJ];
        try {
            String[] iLines = this.getTrimmedLines(iFile);
            String[] jLines = this.getTrimmedLines(jFile);
            int verified = 0;
            int i = aIStartLine;
            int j = aJStartLine;
            while (i < iLines.length && j < jLines.length && iLines[i++].equals(jLines[j++])) {
                ++verified;
            }
            return verified;
        }
        catch (IOException ex) {
            LOG.error("Unable to verify potential duplicate for " + iFile + " and " + jFile, ex);
            return 0;
        }
    }

    private String[] getTrimmedLines(File aFile) throws IOException {
        String path = aFile.getPath();
        String[] cachedLines = (String[])this.mTrimmedLineCache.get(path);
        if (cachedLines != null) {
            return cachedLines;
        }
        String charset = this.getCharset();
        String[] lines = this.getTrimmed(Utils.getLines(path, charset));
        this.mTrimmedLineCache.put(path, lines);
        return lines;
    }

    private String[] getTrimmed(String[] aLines) {
        String[] ret = new String[aLines.length];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = aLines[i].trim();
        }
        return ret;
    }

    private void reportDuplicate(int aEquivalent, int aILine, File aJFile, int aJLine) {
        Integer dupLines = new Integer(aEquivalent);
        Integer startLine = new Integer(aJLine + 1);
        String fileName = Utils.getStrippedFileName(this.mBasedir, aJFile.getPath());
        this.log(aILine + 1, "duplicates.lines", new Object[]{dupLines, fileName, startLine});
        ++this.mDuplicates;
    }

    private class JavaChecksumGenerator
    extends TextfileChecksumGenerator {
        private JavaChecksumGenerator() {
        }

        protected int calcChecksum(String aLine) {
            if (aLine.startsWith("import ")) {
                return Integer.MIN_VALUE;
            }
            return super.calcChecksum(aLine);
        }
    }

    private class TextfileChecksumGenerator
    implements ChecksumGenerator {
        private TextfileChecksumGenerator() {
        }

        public int[] convertLines(String[] aOriginalLines) {
            int lineCount = aOriginalLines.length;
            long[] checkSums = new long[lineCount];
            for (int i = 0; i < lineCount; ++i) {
                String line = aOriginalLines[i];
                checkSums[i] = this.calcChecksum(line);
            }
            int retLen = Math.max(0, lineCount - StrictDuplicateCodeCheck.this.mMin + 1);
            int[] ret = new int[retLen];
            for (int i = 0; i < retLen; ++i) {
                int blockChecksum = 0;
                boolean onlyEmptyLines = true;
                for (int j = 0; j < StrictDuplicateCodeCheck.this.mMin; ++j) {
                    long checksum;
                    if (aOriginalLines[i + j].length() > 0) {
                        onlyEmptyLines = false;
                    }
                    if ((checksum = checkSums[i + j]) == Integer.MIN_VALUE) {
                        blockChecksum = Integer.MIN_VALUE;
                        break;
                    }
                    blockChecksum = (int)((long)blockChecksum + (long)((j + 1) * 317) * checksum);
                }
                ret[i] = onlyEmptyLines ? Integer.MIN_VALUE : blockChecksum;
            }
            return ret;
        }

        protected int calcChecksum(String aLine) {
            int hashCode = aLine.hashCode();
            if (hashCode == Integer.MIN_VALUE) {
                return 0x3FFFFFFF;
            }
            return hashCode;
        }
    }

    private static interface ChecksumGenerator {
        public int[] convertLines(String[] var1);
    }
}

