/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.imports;

import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FullIdent;
import com.puppycrawl.tools.checkstyle.checks.imports.ImportOrderOption;
import com.puppycrawl.tools.checkstyle.utils.CommonUtils;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.beanutils.ConversionException;

public class ImportOrderCheck
extends AbstractCheck {
    public static final String MSG_SEPARATION = "import.separation";
    public static final String MSG_ORDERING = "import.ordering";
    private static final String WILDCARD_GROUP_NAME = "*";
    private static final Pattern[] EMPTY_PATTERN_ARRAY = new Pattern[0];
    private Pattern[] groups = EMPTY_PATTERN_ARRAY;
    private boolean separated;
    private boolean ordered = true;
    private boolean caseSensitive = true;
    private int lastGroup;
    private int lastImportLine;
    private String lastImport;
    private boolean lastImportStatic;
    private boolean beforeFirstImport;
    private boolean sortStaticImportsAlphabetically;
    private ImportOrderOption option = ImportOrderOption.UNDER;

    public void setOption(String optionStr) {
        try {
            this.option = ImportOrderOption.valueOf(optionStr.trim().toUpperCase(Locale.ENGLISH));
        }
        catch (IllegalArgumentException iae) {
            throw new ConversionException("unable to parse " + optionStr, (Throwable)iae);
        }
    }

    public void setGroups(String ... packageGroups) {
        this.groups = new Pattern[packageGroups.length];
        for (int i = 0; i < packageGroups.length; ++i) {
            Pattern grp;
            String pkg = packageGroups[i];
            StringBuilder pkgBuilder = new StringBuilder(pkg);
            if (WILDCARD_GROUP_NAME.equals(pkg)) {
                grp = Pattern.compile("");
            } else if (CommonUtils.startsWithChar(pkg, '/')) {
                if (!CommonUtils.endsWithChar(pkg, '/')) {
                    throw new IllegalArgumentException("Invalid group");
                }
                pkg = pkg.substring(1, pkg.length() - 1);
                grp = Pattern.compile(pkg);
            } else {
                if (!CommonUtils.endsWithChar(pkg, '.')) {
                    pkgBuilder.append('.');
                }
                grp = Pattern.compile("^" + Pattern.quote(pkgBuilder.toString()));
            }
            this.groups[i] = grp;
        }
    }

    public void setOrdered(boolean ordered) {
        this.ordered = ordered;
    }

    public void setSeparated(boolean separated) {
        this.separated = separated;
    }

    public void setCaseSensitive(boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
    }

    public void setSortStaticImportsAlphabetically(boolean sortAlphabetically) {
        this.sortStaticImportsAlphabetically = sortAlphabetically;
    }

    @Override
    public int[] getDefaultTokens() {
        return this.getAcceptableTokens();
    }

    @Override
    public int[] getAcceptableTokens() {
        return new int[]{30, 152};
    }

    @Override
    public int[] getRequiredTokens() {
        return new int[]{30};
    }

    @Override
    public void beginTree(DetailAST rootAST) {
        this.lastGroup = Integer.MIN_VALUE;
        this.lastImportLine = Integer.MIN_VALUE;
        this.lastImport = "";
        this.lastImportStatic = false;
        this.beforeFirstImport = true;
    }

    @Override
    public void visitToken(DetailAST ast) {
        boolean isLastImportAndNonStatic;
        boolean isStatic;
        FullIdent ident;
        if (ast.getType() == 30) {
            ident = FullIdent.createFullIdentBelow(ast);
            isStatic = false;
        } else {
            ident = FullIdent.createFullIdent(ast.getFirstChild().getNextSibling());
            isStatic = true;
        }
        boolean isStaticAndNotLastImport = isStatic && !this.lastImportStatic;
        boolean bl = isLastImportAndNonStatic = this.lastImportStatic && !isStatic;
        if (this.option == ImportOrderOption.TOP) {
            if (isLastImportAndNonStatic) {
                this.lastGroup = Integer.MIN_VALUE;
                this.lastImport = "";
            }
            this.doVisitToken(ident, isStatic, isStaticAndNotLastImport);
        } else if (this.option == ImportOrderOption.BOTTOM) {
            if (isStaticAndNotLastImport) {
                this.lastGroup = Integer.MIN_VALUE;
                this.lastImport = "";
            }
            this.doVisitToken(ident, isStatic, isLastImportAndNonStatic);
        } else if (this.option == ImportOrderOption.ABOVE) {
            this.doVisitToken(ident, isStatic, isStaticAndNotLastImport);
        } else if (this.option == ImportOrderOption.UNDER) {
            this.doVisitToken(ident, isStatic, isLastImportAndNonStatic);
        } else if (this.option == ImportOrderOption.INFLOW) {
            this.doVisitToken(ident, isStatic, true);
        } else {
            throw new IllegalStateException("Unexpected option for static imports: " + (Object)((Object)this.option));
        }
        this.lastImportLine = ast.findFirstToken(45).getLineNo();
        this.lastImportStatic = isStatic;
        this.beforeFirstImport = false;
    }

    private void doVisitToken(FullIdent ident, boolean isStatic, boolean previous) {
        String name = ident.getText();
        int groupIdx = this.getGroupNumber(name);
        int line = ident.getLineNo();
        if (groupIdx == this.lastGroup || !this.beforeFirstImport && this.isAlphabeticallySortableStaticImport(isStatic)) {
            this.doVisitTokenInSameGroup(isStatic, previous, name, line);
        } else if (groupIdx > this.lastGroup) {
            if (!this.beforeFirstImport && this.separated && line - this.lastImportLine < 2) {
                this.log(line, MSG_SEPARATION, name);
            }
        } else {
            this.log(line, MSG_ORDERING, name);
        }
        this.lastGroup = groupIdx;
        this.lastImport = name;
    }

    private boolean isAlphabeticallySortableStaticImport(boolean isStatic) {
        return isStatic && this.sortStaticImportsAlphabetically && (this.option == ImportOrderOption.TOP || this.option == ImportOrderOption.BOTTOM);
    }

    private void doVisitTokenInSameGroup(boolean isStatic, boolean previous, String name, int line) {
        if (this.ordered) {
            if (this.option == ImportOrderOption.INFLOW) {
                if (ImportOrderCheck.compare(this.lastImport, name, this.caseSensitive) > 0) {
                    this.log(line, MSG_ORDERING, name);
                }
            } else {
                boolean shouldFireError;
                boolean bl = shouldFireError = previous || this.lastImportStatic == isStatic && ImportOrderCheck.compare(this.lastImport, name, this.caseSensitive) > 0;
                if (shouldFireError) {
                    this.log(line, MSG_ORDERING, name);
                }
            }
        }
    }

    private int getGroupNumber(String name) {
        int bestIndex = this.groups.length;
        int bestLength = -1;
        int bestPos = 0;
        for (int i = 0; i < this.groups.length; ++i) {
            Matcher matcher = this.groups[i].matcher(name);
            while (matcher.find()) {
                int length = matcher.end() - matcher.start();
                if (length <= bestLength && (length != bestLength || matcher.start() >= bestPos)) continue;
                bestIndex = i;
                bestLength = length;
                bestPos = matcher.start();
            }
        }
        return bestIndex;
    }

    private static int compare(String string1, String string2, boolean caseSensitive) {
        int result = caseSensitive ? string1.compareTo(string2) : string1.compareToIgnoreCase(string2);
        return result;
    }
}

