/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.utils;

import com.google.common.collect.Lists;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FullIdent;
import com.puppycrawl.tools.checkstyle.utils.CommonUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

public final class CheckUtils {
    private static final int BASE_8 = 8;
    private static final int BASE_10 = 10;
    private static final int BASE_16 = 16;
    private static final int SETTER_GETTER_MAX_CHILDREN = 7;
    private static final int SETTER_BODY_SIZE = 3;
    private static final int GETTER_BODY_SIZE = 2;
    private static final Pattern UNDERSCORE_PATTERN = Pattern.compile("_");
    private static final Pattern SETTER_PATTERN = Pattern.compile("^set[A-Z].*");
    private static final Pattern GETTER_PATTERN = Pattern.compile("^(is|get)[A-Z].*");

    private CheckUtils() {
    }

    public static FullIdent createFullType(DetailAST typeAST) {
        DetailAST arrayDeclaratorAST = typeAST.findFirstToken(17);
        FullIdent fullType = arrayDeclaratorAST == null ? CheckUtils.createFullTypeNoArrays(typeAST) : CheckUtils.createFullTypeNoArrays(arrayDeclaratorAST);
        return fullType;
    }

    public static boolean isEqualsMethod(DetailAST ast) {
        boolean equalsMethod = false;
        if (ast.getType() == 9) {
            DetailAST nameNode;
            String name;
            boolean staticOrAbstract;
            DetailAST modifiers = ast.findFirstToken(5);
            boolean bl = staticOrAbstract = modifiers.branchContains(64) || modifiers.branchContains(40);
            if (!staticOrAbstract && "equals".equals(name = (nameNode = ast.findFirstToken(58)).getText())) {
                DetailAST paramsNode = ast.findFirstToken(20);
                equalsMethod = paramsNode.getChildCount() == 1;
            }
        }
        return equalsMethod;
    }

    public static boolean isElseIf(DetailAST ast) {
        DetailAST parentAST = ast.getParent();
        return ast.getType() == 83 && (CheckUtils.isElse(parentAST) || CheckUtils.isElseWithCurlyBraces(parentAST));
    }

    private static boolean isElse(DetailAST ast) {
        return ast.getType() == 92;
    }

    private static boolean isElseWithCurlyBraces(DetailAST ast) {
        return ast.getType() == 7 && ast.getChildCount() == 2 && CheckUtils.isElse(ast.getParent());
    }

    private static FullIdent createFullTypeNoArrays(DetailAST typeAST) {
        return FullIdent.createFullIdent(typeAST.getFirstChild());
    }

    public static double parseDouble(String text, int type) {
        String txt = UNDERSCORE_PATTERN.matcher(text).replaceAll("");
        double result = 0.0;
        switch (type) {
            case 140: 
            case 142: {
                result = Double.parseDouble(txt);
                break;
            }
            case 137: 
            case 141: {
                int radix = 10;
                if (txt.startsWith("0x") || txt.startsWith("0X")) {
                    radix = 16;
                    txt = txt.substring(2);
                } else if (txt.charAt(0) == '0') {
                    radix = 8;
                    txt = txt.substring(1);
                }
                if (CommonUtils.endsWithChar(txt, 'L') || CommonUtils.endsWithChar(txt, 'l')) {
                    txt = txt.substring(0, txt.length() - 1);
                }
                if (txt.isEmpty()) break;
                if (type == 137) {
                    result = CheckUtils.parseInt(txt, radix);
                    break;
                }
                result = CheckUtils.parseLong(txt, radix);
                break;
            }
        }
        return result;
    }

    private static int parseInt(String text, int radix) {
        int result = 0;
        int max = text.length();
        for (int i = 0; i < max; ++i) {
            int digit = Character.digit(text.charAt(i), radix);
            result *= radix;
            result += digit;
        }
        return result;
    }

    private static long parseLong(String text, int radix) {
        long result = 0L;
        int max = text.length();
        for (int i = 0; i < max; ++i) {
            int digit = Character.digit(text.charAt(i), radix);
            result *= (long)radix;
            result += (long)digit;
        }
        return result;
    }

    public static DetailAST getFirstNode(DetailAST node) {
        DetailAST currentNode = node;
        for (DetailAST child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
            DetailAST newNode = CheckUtils.getFirstNode(child);
            if (newNode.getLineNo() >= currentNode.getLineNo() && (newNode.getLineNo() != currentNode.getLineNo() || newNode.getColumnNo() >= currentNode.getColumnNo())) continue;
            currentNode = newNode;
        }
        return currentNode;
    }

    public static List<String> getTypeParameterNames(DetailAST node) {
        DetailAST typeParameters = node.findFirstToken(165);
        ArrayList typeParameterNames = Lists.newArrayList();
        if (typeParameters != null) {
            DetailAST typeParam = typeParameters.findFirstToken(166);
            typeParameterNames.add(typeParam.findFirstToken(58).getText());
            for (DetailAST sibling = typeParam.getNextSibling(); sibling != null; sibling = sibling.getNextSibling()) {
                if (sibling.getType() != 166) continue;
                typeParameterNames.add(sibling.findFirstToken(58).getText());
            }
        }
        return typeParameterNames;
    }

    public static List<DetailAST> getTypeParameters(DetailAST node) {
        DetailAST typeParameters = node.findFirstToken(165);
        ArrayList typeParams = Lists.newArrayList();
        if (typeParameters != null) {
            DetailAST typeParam = typeParameters.findFirstToken(166);
            typeParams.add(typeParam);
            for (DetailAST sibling = typeParam.getNextSibling(); sibling != null; sibling = sibling.getNextSibling()) {
                if (sibling.getType() != 166) continue;
                typeParams.add(sibling);
            }
        }
        return typeParams;
    }

    public static boolean isSetterMethod(DetailAST ast) {
        boolean setterMethod = false;
        if (ast.getType() == 9 && ast.getChildCount() == 7) {
            DetailAST slist;
            boolean singleParam;
            DetailAST type = ast.findFirstToken(13);
            String name = type.getNextSibling().getText();
            boolean matchesSetterFormat = SETTER_PATTERN.matcher(name).matches();
            boolean voidReturnType = type.getChildCount(49) > 0;
            DetailAST params = ast.findFirstToken(20);
            boolean bl = singleParam = params.getChildCount(21) == 1;
            if (matchesSetterFormat && voidReturnType && singleParam && (slist = ast.findFirstToken(7)) != null && slist.getChildCount() == 3) {
                DetailAST expr = slist.getFirstChild();
                setterMethod = expr.getFirstChild().getType() == 80;
            }
        }
        return setterMethod;
    }

    public static boolean isGetterMethod(DetailAST ast) {
        boolean getterMethod = false;
        if (ast.getType() == 9 && ast.getChildCount() == 7) {
            DetailAST slist;
            boolean noParams;
            DetailAST type = ast.findFirstToken(13);
            String name = type.getNextSibling().getText();
            boolean matchesGetterFormat = GETTER_PATTERN.matcher(name).matches();
            boolean noVoidReturnType = type.getChildCount(49) == 0;
            DetailAST params = ast.findFirstToken(20);
            boolean bl = noParams = params.getChildCount(21) == 0;
            if (matchesGetterFormat && noVoidReturnType && noParams && (slist = ast.findFirstToken(7)) != null && slist.getChildCount() == 2) {
                DetailAST expr = slist.getFirstChild();
                getterMethod = expr.getType() == 88;
            }
        }
        return getterMethod;
    }

    public static boolean isNonVoidMethod(DetailAST methodDefAst) {
        DetailAST typeAST;
        boolean returnValue = false;
        if (methodDefAst.getType() == 9 && (typeAST = methodDefAst.findFirstToken(13)).findFirstToken(49) == null) {
            returnValue = true;
        }
        return returnValue;
    }
}

