/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks;

import com.google.common.base.Optional;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import com.google.common.io.Closeables;
import com.google.common.io.Files;
import com.puppycrawl.tools.checkstyle.api.AbstractFileSetCheck;
import com.puppycrawl.tools.checkstyle.api.LocalizedMessage;
import com.puppycrawl.tools.checkstyle.api.MessageDispatcher;
import com.puppycrawl.tools.checkstyle.utils.CommonUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TranslationCheck
extends AbstractFileSetCheck {
    public static final String MSG_KEY = "translation.missingKey";
    public static final String MSG_KEY_MISSING_TRANSLATION_FILE = "translation.missingTranslationFile";
    private static final String TRANSLATION_BUNDLE = "com.puppycrawl.tools.checkstyle.checks.messages";
    private static final String WRONG_LANGUAGE_CODE_KEY = "translation.wrongLanguageCode";
    private static final Log LOG = LogFactory.getLog(TranslationCheck.class);
    private static final String DEFAULT_TRANSLATION_REGEXP = "^.+\\..+$";
    private static final Pattern LANGUAGE_COUNTRY_VARIANT_PATTERN = CommonUtils.createPattern("^.+\\_[a-z]{2}\\_[A-Z]{2}\\_[A-Za-z]+\\..+$");
    private static final Pattern LANGUAGE_COUNTRY_PATTERN = CommonUtils.createPattern("^.+\\_[a-z]{2}\\_[A-Z]{2}\\..+$");
    private static final Pattern LANGUAGE_PATTERN = CommonUtils.createPattern("^.+\\_[a-z]{2}\\..+$");
    private static final String DEFAULT_TRANSLATION_FILE_NAME_FORMATTER = "%s.%s";
    private static final String FILE_NAME_WITH_LANGUAGE_CODE_FORMATTER = "%s_%s.%s";
    private static final String REGEXP_FORMAT_TO_CHECK_REQUIRED_TRANSLATIONS = "^%1$s\\_%2$s(\\_[A-Z]{2})?\\.%3$s$|^%1$s\\_%2$s\\_[A-Z]{2}\\_[A-Za-z]+\\.%3$s$";
    private static final String REGEXP_FORMAT_TO_CHECK_DEFAULT_TRANSLATIONS = "^%s\\.%s$";
    private final Set<File> filesToProcess = Sets.newHashSet();
    private Pattern baseNamePattern;
    private Set<String> requiredTranslations = Sets.newHashSet();

    public TranslationCheck() {
        this.setFileExtensions("properties");
        this.baseNamePattern = CommonUtils.createPattern("^messages.*$");
    }

    public void setBaseName(String baseName) {
        this.baseNamePattern = CommonUtils.createPattern(baseName);
    }

    public void setRequiredTranslations(String ... translationCodes) {
        this.requiredTranslations = Sets.newHashSet(translationCodes);
        this.validateUserSpecifiedLanguageCodes(this.requiredTranslations);
    }

    private void validateUserSpecifiedLanguageCodes(Set<String> languageCodes) {
        for (String code : languageCodes) {
            if (TranslationCheck.isValidLanguageCode(code)) continue;
            LocalizedMessage msg = new LocalizedMessage(0, TRANSLATION_BUNDLE, WRONG_LANGUAGE_CODE_KEY, new Object[]{code}, this.getId(), this.getClass(), null);
            String exceptionMessage = String.format(Locale.ROOT, "%s [%s]", msg.getMessage(), TranslationCheck.class.getSimpleName());
            throw new IllegalArgumentException(exceptionMessage);
        }
    }

    private static boolean isValidLanguageCode(String userSpecifiedLanguageCode) {
        Locale[] locales;
        boolean valid = false;
        for (Locale locale : locales = Locale.getAvailableLocales()) {
            if (!userSpecifiedLanguageCode.equals(locale.toString())) continue;
            valid = true;
            break;
        }
        return valid;
    }

    @Override
    public void beginProcessing(String charset) {
        super.beginProcessing(charset);
        this.filesToProcess.clear();
    }

    @Override
    protected void processFiltered(File file, List<String> lines) {
        this.filesToProcess.add(file);
    }

    @Override
    public void finishProcessing() {
        super.finishProcessing();
        Set<ResourceBundle> bundles = TranslationCheck.groupFilesIntoBundles(this.filesToProcess, this.baseNamePattern);
        for (ResourceBundle currentBundle : bundles) {
            this.checkExistenceOfDefaultTranslation(currentBundle);
            this.checkExistenceOfRequiredTranslations(currentBundle);
            this.checkTranslationKeys(currentBundle);
        }
    }

    private void checkExistenceOfDefaultTranslation(ResourceBundle bundle) {
        Optional<String> fileName = TranslationCheck.getMissingFileName(bundle, null);
        if (fileName.isPresent()) {
            this.logMissingTranslation(bundle.getPath(), fileName.get());
        }
    }

    private void checkExistenceOfRequiredTranslations(ResourceBundle bundle) {
        for (String languageCode : this.requiredTranslations) {
            Optional<String> fileName = TranslationCheck.getMissingFileName(bundle, languageCode);
            if (!fileName.isPresent()) continue;
            this.logMissingTranslation(bundle.getPath(), fileName.get());
        }
    }

    private static Optional<String> getMissingFileName(ResourceBundle bundle, String languageCode) {
        String fileNameRegexp;
        boolean searchForDefaultTranslation;
        String extension = bundle.getExtension();
        String baseName = bundle.getBaseName();
        if (languageCode == null) {
            searchForDefaultTranslation = true;
            fileNameRegexp = String.format(Locale.ROOT, REGEXP_FORMAT_TO_CHECK_DEFAULT_TRANSLATIONS, baseName, extension);
        } else {
            searchForDefaultTranslation = false;
            fileNameRegexp = String.format(Locale.ROOT, REGEXP_FORMAT_TO_CHECK_REQUIRED_TRANSLATIONS, baseName, languageCode, extension);
        }
        Optional<String> missingFileName = Optional.absent();
        if (!bundle.containsFile(fileNameRegexp)) {
            missingFileName = searchForDefaultTranslation ? Optional.of(String.format(Locale.ROOT, DEFAULT_TRANSLATION_FILE_NAME_FORMATTER, baseName, extension)) : Optional.of(String.format(Locale.ROOT, FILE_NAME_WITH_LANGUAGE_CODE_FORMATTER, baseName, languageCode, extension));
        }
        return missingFileName;
    }

    private void logMissingTranslation(String filePath, String fileName) {
        MessageDispatcher dispatcher = this.getMessageDispatcher();
        dispatcher.fireFileStarted(filePath);
        this.log(0, MSG_KEY_MISSING_TRANSLATION_FILE, fileName);
        this.fireErrors(filePath);
        dispatcher.fireFileFinished(filePath);
    }

    private static Set<ResourceBundle> groupFilesIntoBundles(Set<File> files, Pattern baseNameRegexp) {
        HashSet<ResourceBundle> resourceBundles = Sets.newHashSet();
        for (File currentFile : files) {
            String fileName = currentFile.getName();
            String baseName = TranslationCheck.extractBaseName(fileName);
            Matcher baseNameMatcher = baseNameRegexp.matcher(baseName);
            if (!baseNameMatcher.matches()) continue;
            String extension = Files.getFileExtension(fileName);
            String path = TranslationCheck.getPath(currentFile.getAbsolutePath());
            ResourceBundle newBundle = new ResourceBundle(baseName, path, extension);
            Optional<ResourceBundle> bundle = TranslationCheck.findBundle(resourceBundles, newBundle);
            if (bundle.isPresent()) {
                bundle.get().addFile(currentFile);
                continue;
            }
            newBundle.addFile(currentFile);
            resourceBundles.add(newBundle);
        }
        return resourceBundles;
    }

    private static Optional<ResourceBundle> findBundle(Set<ResourceBundle> bundles, ResourceBundle targetBundle) {
        Optional<ResourceBundle> result = Optional.absent();
        for (ResourceBundle currentBundle : bundles) {
            if (!targetBundle.getBaseName().equals(currentBundle.getBaseName()) || !targetBundle.getExtension().equals(currentBundle.getExtension()) || !targetBundle.getPath().equals(currentBundle.getPath())) continue;
            result = Optional.of(currentBundle);
            break;
        }
        return result;
    }

    private static String extractBaseName(String fileName) {
        Matcher languageCountryVariantMatcher = LANGUAGE_COUNTRY_VARIANT_PATTERN.matcher(fileName);
        Matcher languageCountryMatcher = LANGUAGE_COUNTRY_PATTERN.matcher(fileName);
        Matcher languageMatcher = LANGUAGE_PATTERN.matcher(fileName);
        String regexp = languageCountryVariantMatcher.matches() ? LANGUAGE_COUNTRY_VARIANT_PATTERN.pattern() : (languageCountryMatcher.matches() ? LANGUAGE_COUNTRY_PATTERN.pattern() : (languageMatcher.matches() ? LANGUAGE_PATTERN.pattern() : DEFAULT_TRANSLATION_REGEXP));
        String removePattern = regexp.substring("^.+".length(), regexp.length());
        return fileName.replaceAll(removePattern, "");
    }

    private static String getPath(String fileNameWithPath) {
        return fileNameWithPath.substring(0, fileNameWithPath.lastIndexOf(File.separator));
    }

    private void checkTranslationKeys(ResourceBundle bundle) {
        Set<File> filesInBundle = bundle.getFiles();
        if (filesInBundle.size() > 1) {
            HashSet<String> allTranslationKeys = Sets.newHashSet();
            HashMultimap<File, String> filesAssociatedWithKeys = HashMultimap.create();
            for (File currentFile : filesInBundle) {
                Set<String> keysInCurrentFile = this.getTranslationKeys(currentFile);
                allTranslationKeys.addAll(keysInCurrentFile);
                filesAssociatedWithKeys.putAll(currentFile, keysInCurrentFile);
            }
            this.checkFilesForConsistencyRegardingTheirKeys(filesAssociatedWithKeys, allTranslationKeys);
        }
    }

    private void checkFilesForConsistencyRegardingTheirKeys(SetMultimap<File, String> fileKeys, Set<String> keysThatMustExist) {
        for (File currentFile : fileKeys.keySet()) {
            MessageDispatcher dispatcher = this.getMessageDispatcher();
            String path = currentFile.getPath();
            dispatcher.fireFileStarted(path);
            Set<String> currentFileKeys = fileKeys.get(currentFile);
            Sets.SetView<String> missingKeys = Sets.difference(keysThatMustExist, currentFileKeys);
            if (!missingKeys.isEmpty()) {
                for (Object e : missingKeys) {
                    this.log(0, MSG_KEY, e);
                }
            }
            this.fireErrors(path);
            dispatcher.fireFileFinished(path);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<String> getTranslationKeys(File file) {
        Set<String> keys = Sets.newHashSet();
        FileInputStream inStream = null;
        try {
            inStream = new FileInputStream(file);
            Properties translations = new Properties();
            translations.load(inStream);
            keys = translations.stringPropertyNames();
        }
        catch (IOException ex) {
            try {
                this.logIoException(ex, file);
            }
            catch (Throwable throwable) {
                Closeables.closeQuietly(inStream);
                throw throwable;
            }
            Closeables.closeQuietly(inStream);
        }
        Closeables.closeQuietly(inStream);
        return keys;
    }

    private void logIoException(IOException exception, File file) {
        Object[] args = null;
        String key = "general.fileNotFound";
        if (!(exception instanceof FileNotFoundException)) {
            args = new String[]{exception.getMessage()};
            key = "general.exception";
        }
        LocalizedMessage message = new LocalizedMessage(0, "com.puppycrawl.tools.checkstyle.messages", key, args, this.getId(), this.getClass(), null);
        TreeSet<LocalizedMessage> messages = Sets.newTreeSet();
        messages.add(message);
        this.getMessageDispatcher().fireErrors(file.getPath(), messages);
        LOG.debug("IOException occurred.", exception);
    }

    private static class ResourceBundle {
        private final String baseName;
        private final String extension;
        private final String path;
        private final Set<File> files;

        ResourceBundle(String baseName, String path, String extension) {
            this.baseName = baseName;
            this.path = path;
            this.extension = extension;
            this.files = Sets.newHashSet();
        }

        public String getBaseName() {
            return this.baseName;
        }

        public String getPath() {
            return this.path;
        }

        public String getExtension() {
            return this.extension;
        }

        public Set<File> getFiles() {
            return Collections.unmodifiableSet(this.files);
        }

        public void addFile(File file) {
            this.files.add(file);
        }

        public boolean containsFile(String fileNameRegexp) {
            boolean containsFile = false;
            for (File currentFile : this.files) {
                if (!Pattern.matches(fileNameRegexp, currentFile.getName())) continue;
                containsFile = true;
                break;
            }
            return containsFile;
        }
    }
}

